/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Box;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxInfo;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Utils;
import java.io.IOException;
import java.util.ArrayList;

public class FileTypeBox
extends Jpeg2000Box {
    private long brand;
    private long minorVersion;
    private ArrayList<Long> compatibilityList;

    FileTypeBox(Jpeg2000BoxInfo boxInfo) {
        this.boxInfo = boxInfo;
    }

    public long getBrand() throws IOException {
        this.lazilyPopulateFields();
        return this.brand;
    }

    public long getMinorVersion() throws IOException {
        this.lazilyPopulateFields();
        return this.minorVersion;
    }

    public ArrayList<Long> getCompatibilityList() throws IOException {
        this.lazilyPopulateFields();
        return this.compatibilityList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void lazilyPopulateFields() throws IOException {
        InputByteStream boxContents = this.boxInfo.getBoxContents();
        if (boxContents == null) {
            return;
        }
        try {
            this.brand = Jpeg2000Utils.bytesToLong(boxContents, 4);
            this.minorVersion = Jpeg2000Utils.bytesToLong(boxContents, 4);
            if (boxContents.bytesAvailable() > 0L) {
                this.compatibilityList = new ArrayList();
            }
            while (boxContents.bytesAvailable() > 0L) {
                this.compatibilityList.add(Jpeg2000Utils.bytesToLong(boxContents, 4));
            }
        }
        finally {
            this.boxInfo.clearContents();
        }
    }

    @Override
    protected void close() throws IOException {
        this.boxInfo.clearContents();
    }
}

