/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Box;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxInfo;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Utils;
import java.io.IOException;

public class ReaderRequirementsBox
extends Jpeg2000Box {
    private int maskLength;
    private long fullyUnderstandAspectsMask;
    private long decodeCompletelyMask;
    private int numberOfStandardFlags;
    private int[] standardFlagsList;
    private long[] standardMasksList;
    private int numberOfVendorFeatures;
    private InputByteStream[] vendorFeaturesList;
    private long[] vendorMaksList;

    ReaderRequirementsBox(Jpeg2000BoxInfo boxInfo) {
        this.boxInfo = boxInfo;
    }

    public int getMaskLength() throws IOException {
        this.lazilyPopulateFields();
        return this.maskLength;
    }

    public long getFullyUnderstandAspectsMask() throws IOException {
        this.lazilyPopulateFields();
        return this.fullyUnderstandAspectsMask;
    }

    public long getDecodeCompletelyMask() throws IOException {
        this.lazilyPopulateFields();
        return this.decodeCompletelyMask;
    }

    public int getNumberOfStandardFlags() throws IOException {
        this.lazilyPopulateFields();
        return this.numberOfStandardFlags;
    }

    public int[] getStandardFlagsList() throws IOException {
        this.lazilyPopulateFields();
        return this.standardFlagsList;
    }

    public long[] getStandardMasksList() throws IOException {
        this.lazilyPopulateFields();
        return this.standardMasksList;
    }

    public int getNumberOfVendorFeatures() throws IOException {
        this.lazilyPopulateFields();
        return this.numberOfVendorFeatures;
    }

    public InputByteStream[] getVendorFeaturesList() throws IOException {
        this.lazilyPopulateFields();
        return this.vendorFeaturesList;
    }

    public long[] getVendorMaksList() throws IOException {
        this.lazilyPopulateFields();
        return this.vendorMaksList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void lazilyPopulateFields() throws IOException {
        InputByteStream boxContents = this.boxInfo.getBoxContents();
        if (boxContents == null) {
            return;
        }
        try {
            int i;
            this.maskLength = Jpeg2000Utils.bytesToInteger(boxContents, 1);
            this.fullyUnderstandAspectsMask = Jpeg2000Utils.bytesToLong(boxContents, this.maskLength);
            this.decodeCompletelyMask = Jpeg2000Utils.bytesToLong(boxContents, this.maskLength);
            this.numberOfStandardFlags = Jpeg2000Utils.bytesToInteger(boxContents, 2);
            this.standardFlagsList = new int[this.numberOfStandardFlags];
            this.standardMasksList = new long[this.numberOfStandardFlags];
            for (i = 0; i < this.numberOfStandardFlags; ++i) {
                this.standardFlagsList[i] = Jpeg2000Utils.bytesToInteger(boxContents, 2);
                this.standardMasksList[i] = Jpeg2000Utils.bytesToLong(boxContents, this.maskLength);
            }
            this.numberOfVendorFeatures = Jpeg2000Utils.bytesToInteger(boxContents, 2);
            this.vendorFeaturesList = new InputByteStream[this.numberOfVendorFeatures];
            this.vendorMaksList = new long[this.numberOfVendorFeatures];
            for (i = 0; i < this.numberOfVendorFeatures; ++i) {
                this.vendorFeaturesList[i] = boxContents.slice(boxContents.getPosition(), 16L);
                boxContents.seek(boxContents.getPosition() + 16L);
                this.vendorMaksList[i] = Jpeg2000Utils.bytesToLong(boxContents, this.maskLength);
            }
        }
        finally {
            this.boxInfo.clearContents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close() throws IOException {
        IOException exceptionOccured = null;
        try {
            for (int i = 0; i < this.numberOfVendorFeatures; ++i) {
                try {
                    if (this.vendorFeaturesList[i] == null) continue;
                    this.vendorFeaturesList[i].close();
                    continue;
                }
                catch (IOException e) {
                    exceptionOccured = e;
                }
            }
            if (exceptionOccured != null) {
                throw exceptionOccured;
            }
        }
        finally {
            this.boxInfo.clearContents();
        }
    }
}

