/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.services.ap.AppearanceAttributes;
import com.adobe.internal.pdftoolkit.services.ap.StyleAttributes;
import com.adobe.internal.pdftoolkit.services.rcg.RCGAlignment;
import com.adobe.internal.pdftoolkit.services.rcg.RCGOptions;
import com.adobe.internal.pdftoolkit.services.rcg.impl.RichTextHandler;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOM;
import com.adobe.xfa.Element;
import com.adobe.xfa.Measurement;
import com.adobe.xfa.Node;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.content.ExDataValue;
import com.adobe.xfa.content.TextValue;
import com.adobe.xfa.template.containers.Field;
import com.adobe.xfa.template.ui.UI;
import java.util.Arrays;

public class XFAAttributesUtils {
    public static boolean allowNeutral(Field oField, XFADOM xfaDom) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFUnableToCompleteOperationException, PDFFontException {
        Element oCheckButton;
        UI oUI;
        return oField != null && (oUI = (UI)oField.peekElement(XFA.UITAG, false, 0)) != null && (oCheckButton = oUI.getUIElement(true)) != null && oCheckButton.isSameClass(XFA.CHECKBUTTONTAG) && oCheckButton.getEnum(XFA.ALLOWNEUTRALTAG) == 0x40040001;
    }

    public static Field getXFAField(XFADOM xfaDom, PDFField field) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFUnableToCompleteOperationException, PDFFontException {
        Node xfaNode = null;
        if (xfaDom != null) {
            if (xfaDom.formModelExists()) {
                ProtoableNode formNodeproto;
                xfaNode = xfaDom.getFormModel().resolveNode(field.getQualifiedName());
                if (xfaNode instanceof ProtoableNode && (formNodeproto = ((ProtoableNode)xfaNode).getProto()) instanceof Field) {
                    return (Field)formNodeproto;
                }
                if (xfaNode instanceof Field) {
                    return (Field)xfaNode;
                }
            }
            if (xfaNode == null && (xfaNode = xfaDom.getTemplateModel().resolveNode(field.getQualifiedName())) instanceof Field) {
                return (Field)xfaNode;
            }
        }
        return null;
    }

    static void ATSCaptionTextAttributesFromXFAField(AppearanceAttributes attrs, Field oField) {
        Element oCaption = oField.peekElement(XFA.CAPTIONTAG, true, 0);
        Element oFont = oCaption.peekElement(XFA.FONTTAG, true, 0);
        XFAAttributesUtils.ReadATSAttributesFromFontElement(attrs, oFont);
        Element oPara = oCaption.peekElement(XFA.PARATAG, true, 0);
        XFAAttributesUtils.ReadATSAttributesFromParaElement(attrs, oPara);
    }

    static void ATSGetCaptionMarginFromXFAField(Field oField, AppearanceAttributes attrs) throws PDFInvalidParameterException {
        RCGOptions rcgOptions = attrs.getRcgOptions();
        Element oMargins = oField.peekElement(XFA.MARGINTAG, true, 0);
        Measurement oMeasure = (Measurement)oMargins.getAttribute(XFA.LEFTINSETTAG);
        double paddingValue = oMeasure.getValueAsUnit(0x3C0000);
        rcgOptions.setPaddingLeft(paddingValue);
        oMeasure = (Measurement)oMargins.getAttribute(XFA.TOPINSETTAG);
        paddingValue = oMeasure.getValueAsUnit(0x3C0000);
        rcgOptions.setPaddingTop(paddingValue);
        oMeasure = (Measurement)oMargins.getAttribute(XFA.RIGHTINSETTAG);
        paddingValue = oMeasure.getValueAsUnit(0x3C0000);
        rcgOptions.setPaddingRight(paddingValue);
        oMeasure = (Measurement)oMargins.getAttribute(XFA.BOTTOMINSETTAG);
        paddingValue = oMeasure.getValueAsUnit(0x3C0000);
        rcgOptions.setPaddingBottom(paddingValue);
    }

    static void ReadATSAttributesFromFontElement(AppearanceAttributes attrs, Element oFont) {
        StyleAttributes styleAttributes = attrs.getStyleAttributes();
        boolean bFullUnderline = oFont.getEnum(XFA.UNDERLINEPERIODTAG) == 0x130000;
        int eUnderLine = oFont.getEnum(XFA.UNDERLINETAG);
        if (eUnderLine == 0x120001) {
            styleAttributes.setTextDecorationUnderline(bFullUnderline ? "underline" : "word");
        } else if (eUnderLine == 0x120002) {
            styleAttributes.setTextDecorationUnderline(bFullUnderline ? "double" : "double word");
        }
        int eLineThrough = oFont.getEnum(XFA.LINETHROUGHTAG);
        if (eLineThrough == 786433) {
            styleAttributes.setTextDecorationStrikeThrough("line-through");
        } else if (eLineThrough == 786434) {
            styleAttributes.setTextDecorationStrikeThrough("double-line-through");
        }
        if (oFont.isPropertySpecified(XFA.BASELINESHIFTTAG, true, 0)) {
            Measurement oMeasure = (Measurement)oFont.getAttribute(XFA.BASELINESHIFTTAG);
            styleAttributes.setBaselineShift(Double.valueOf(oMeasure.getValueAsUnit(0x3C0000)).toString());
        }
    }

    static void ReadATSAttributesFromParaElement(AppearanceAttributes attrs, Element oPara) {
        double value;
        StyleAttributes styleAttributes = attrs.getStyleAttributes();
        RCGOptions options = attrs.getRcgOptions();
        int hAlignVal = oPara.getEnum(XFA.HALIGNTAG);
        switch (hAlignVal) {
            case 0x160000: {
                styleAttributes.setTextAlignment(0);
                break;
            }
            case 0x160001: {
                styleAttributes.setTextAlignment(1);
                break;
            }
            case 1441794: {
                styleAttributes.setTextAlignment(2);
                break;
            }
            case 1441795: {
                styleAttributes.setTextAlignment(3);
                break;
            }
            case 1441796: {
                styleAttributes.setTextAlignment(4);
            }
        }
        int vAlignVal = oPara.getEnum(XFA.VALIGNTAG);
        switch (vAlignVal) {
            case 0x3E0000: {
                options.setVerticalAlignment(RCGAlignment.Top);
                break;
            }
            case 4063234: {
                options.setVerticalAlignment(RCGAlignment.Bottom);
                break;
            }
            case 4063233: {
                options.setVerticalAlignment(RCGAlignment.Middle);
                break;
            }
        }
        if (oPara.isPropertySpecified(XFA.LINEHEIGHTTAG, true, 0)) {
            value = ((Measurement)oPara.getAttribute(XFA.LINEHEIGHTTAG)).getValueAsUnit(0x3C0000);
            styleAttributes.setLineHeight(String.valueOf(value));
        }
        if (oPara.isPropertySpecified(XFA.MARGINLEFTTAG, true, 0)) {
            value = ((Measurement)oPara.getAttribute(XFA.MARGINLEFTTAG)).getValueAsUnit(0x3C0000);
            styleAttributes.setLeftIndent(String.valueOf(value));
        }
        if (oPara.isPropertySpecified(XFA.MARGINRIGHTTAG, true, 0)) {
            value = ((Measurement)oPara.getAttribute(XFA.MARGINRIGHTTAG)).getValueAsUnit(0x3C0000);
            styleAttributes.setRightIndent(String.valueOf(value));
        }
        if (oPara.isPropertySpecified(XFA.TEXTINDENTTAG, true, 0)) {
            value = ((Measurement)oPara.getAttribute(XFA.TEXTINDENTTAG)).getValueAsUnit(0x3C0000);
            styleAttributes.setTextIndent(String.valueOf(value));
        }
        if (oPara.isPropertySpecified(XFA.SPACEABOVETAG, true, 0)) {
            value = ((Measurement)oPara.getAttribute(XFA.SPACEABOVETAG)).getValueAsUnit(0x3C0000);
            styleAttributes.setSpaceBefore(String.valueOf(value));
        }
        if (oPara.isPropertySpecified(XFA.SPACEBELOWTAG, true, 0)) {
            value = ((Measurement)oPara.getAttribute(XFA.SPACEBELOWTAG)).getValueAsUnit(0x3C0000);
            styleAttributes.setSpaceAfter(String.valueOf(value));
        }
    }

    static String GetXFACaption(Field oField, AppearanceAttributes attrs) throws PDFInvalidParameterException {
        Node oCaptionContent;
        Element oCaptionValue;
        String sCaption = null;
        Element oCaption = oField.peekElement(XFA.CAPTIONTAG, true, 0);
        if (oCaption != null && (oCaptionValue = oCaption.peekElement(XFA.VALUETAG, true, 0)) != null && (oCaptionContent = oCaptionValue.getOneOfChild(true, true)) != null) {
            if (oCaptionContent.isSameClass(XFA.EXDATATAG)) {
                sCaption = ((ExDataValue)oCaptionContent).getValue(true, false, false);
                attrs.setRichText(true);
            } else {
                sCaption = ((TextValue)oCaptionContent).getValue();
                if (sCaption != null) {
                    sCaption = RichTextHandler.convertString2RichText(Arrays.asList(sCaption));
                    attrs.setRichText(false);
                }
            }
        }
        return sCaption;
    }
}

