/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.fontresources;

import com.adobe.fontengine.FontEngineException;
import com.adobe.fontengine.font.Base14;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.fontmanagement.FontLoader;
import com.adobe.fontengine.fontmanagement.FontResolutionPriority;
import com.adobe.fontengine.fontmanagement.MemoryFont;
import com.adobe.fontengine.fontmanagement.postscript.PostscriptFontDescription;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosCloneMgr;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.fontset.impl.PDFFontSetImpl;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionaryMap;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontFactory;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontFile;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType0;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.StandardFontUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.services.fontresources.PDFSimpleFontValuesAccessorImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public final class PDFFontSetUtil {
    private PDFFontSetUtil() {
    }

    private static Font loadFontFauxed(FontLoader loader, PDFDocument doc, PDFFont pdfFont, PDFFontDescriptor fontDescr) throws PDFFontException {
        try {
            PDFSimpleFontValuesAccessorImpl fontAccessor = new PDFSimpleFontValuesAccessorImpl(doc, (PDFFontSimple)pdfFont, fontDescr);
            return loader.load(fontAccessor);
        }
        catch (InvalidFontException e) {
            return null;
        }
        catch (UnsupportedFontException e) {
            return null;
        }
    }

    private static Font loadFontFromFile(FontLoader fontLoader, PDFFontFile pdfFontFile) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        InputByteStream fontByteStream = null;
        InputStream fontStream = null;
        try {
            fontByteStream = pdfFontFile.getStream();
            long fontStreamLength = fontByteStream.length();
            fontStream = fontByteStream.toInputStream();
            Font embeddedPDFFont = fontLoader.load(fontStream, (int)fontStreamLength, true);
            fontByteStream.close();
            fontByteStream = null;
            Font font = embeddedPDFFont;
            return font;
        }
        catch (FontLoadingException e) {
            Font font = null;
            return font;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        finally {
            PDFIOException f = null;
            if (fontByteStream != null) {
                try {
                    fontByteStream.close();
                }
                catch (IOException e) {
                    f = new PDFIOException(e);
                }
            }
            if (fontStream != null) {
                try {
                    fontStream.close();
                }
                catch (IOException e) {
                    throw new PDFIOException(e);
                }
            }
            if (f != null) {
                throw f;
            }
        }
    }

    public static Font[] loadFontsFromPDF(PDFDocument doc, Locale locale, HashMap afePDFFontMap) throws PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException {
        PDFResources resourceDictionary;
        ArrayList<Font> fonts = new ArrayList<Font>();
        FontLoader fontLoader = new FontLoader();
        HashSet<ASName> streamsToCopy = new HashSet<ASName>();
        streamsToCopy.add(ASName.k_ToUnicode);
        CosCloneMgr cloneManager = new CosCloneMgr(doc.getCosDocument(), streamsToCopy);
        PDFCosDictionaryMap resourceFonts = null;
        PDFInteractiveForm acroForm = doc.getInteractiveForm();
        if (acroForm != null && (resourceDictionary = acroForm.getResources()) != null) {
            resourceFonts = resourceDictionary.getFontMap();
        }
        if (resourceFonts != null) {
            Set<ASName> fontsKeySet = resourceFonts.keySet();
            Iterator<ASName> fontsKeyIterator = fontsKeySet.iterator();
            while (fontsKeyIterator.hasNext()) {
                PDFFontDescriptor pdfFontDescriptor;
                PDFFont pdfFont = ((PDFFontMap)resourceFonts).get(fontsKeyIterator.next());
                Font embeddableFont = null;
                if (pdfFont instanceof PDFFontType0) {
                    pdfFontDescriptor = ((PDFFontType0)pdfFont).getDescendantFont().getFontDescriptor();
                } else {
                    if (!(pdfFont instanceof PDFFontSimple)) continue;
                    pdfFontDescriptor = ((PDFFontSimple)pdfFont).getFontDescriptor();
                }
                if (pdfFontDescriptor == null) continue;
                PDFFontFile pdfFontFile = PDFFontUtils.getFontFileFromFontDescriptor(pdfFontDescriptor);
                if (pdfFontFile == null) {
                    if (pdfFont instanceof PDFFontSimple) {
                        if (StandardFontUtils.getBase14Font(pdfFont.getBaseFont().asString(), false) != null) continue;
                        embeddableFont = PDFFontSetUtil.loadFontFauxed(fontLoader, doc, pdfFont, pdfFontDescriptor);
                        if (afePDFFontMap != null) {
                            afePDFFontMap.put(embeddableFont, PDFFontFactory.getInstance(cloneManager.shallowClone(pdfFont.getCosObject())));
                        }
                    }
                    if (embeddableFont == null) continue;
                }
                if (pdfFontFile != null) {
                    embeddableFont = PDFFontSetUtil.loadFontFromFile(fontLoader, pdfFontFile);
                }
                if (embeddableFont == null) continue;
                fonts.add(embeddableFont);
            }
        }
        Font[] fontArray = new Font[]{};
        return fonts.toArray(fontArray);
    }

    private static PDFFontSet buildPDFFontSet(PDFFontSetImpl original, PDFDocument doc, Locale locale, HashMap afePDFFontMap) throws PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException {
        PDFFontSetImpl pdfFontSet = new PDFFontSetImpl(original);
        if (locale == null) {
            locale = PDFDocument.ROOT_LOCALE;
        }
        pdfFontSet.setResolutionPriority(FontResolutionPriority.LAST);
        try {
            Font[] base14Fonts = StandardFontUtils.getBase14Fonts();
            for (int idxFont = 0; idxFont < base14Fonts.length; ++idxFont) {
                pdfFontSet.getCSS20FontSet().addFont(base14Fonts[idxFont]);
                pdfFontSet.getPSFontSet().addFont(new PostscriptFontDescription(base14Fonts[idxFont].getPDFFontDescription().getBase14Name()), base14Fonts[idxFont]);
            }
            if (!pdfFontSet.hasRootFallback()) {
                pdfFontSet.addFallbackFont(PDFDocument.ROOT_LOCALE, Base14.courierRegular);
            }
            if (original == null || original.getCSS20FontSet().isEmpty()) {
                pdfFontSet.getCSS20FontSet().setFallbackFonts(pdfFontSet.getFallbackFontSet());
            }
        }
        catch (FontEngineException e) {
            throw new RuntimeException("Internal error with built-in base 14 font.", e);
        }
        Font[] pdfFonts = PDFFontSetUtil.loadFontsFromPDF(doc, locale, afePDFFontMap);
        for (int i = 0; i < pdfFonts.length; ++i) {
            Font pdfFont = pdfFonts[i];
            if (pdfFont instanceof MemoryFont) {
                try {
                    Font fontToCheck;
                    String psName = pdfFont.getPDFFontDescription().getPostscriptName();
                    if (psName == null || (fontToCheck = pdfFontSet.getPSFont(psName, locale, false)) != null) continue;
                    pdfFontSet.addFont(pdfFont);
                    continue;
                }
                catch (InvalidFontException e) {
                    throw new PDFFontException(e);
                }
                catch (UnsupportedFontException e) {
                    throw new PDFFontException(e);
                }
                catch (FontLoadingException e) {
                    throw new PDFFontException(e);
                }
            }
            pdfFontSet.addFont(pdfFont);
        }
        return pdfFontSet;
    }

    public static PDFFontSet buildWorkingFontSet(PDFDocument pdfDoc, PDFFontSet fontSet, Locale locale, HashMap afePDFFontMap) throws PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException {
        if (fontSet == null) {
            return PDFFontSetUtil.buildPDFFontSet((PDFFontSetImpl)fontSet, pdfDoc, locale, afePDFFontMap);
        }
        if (fontSet instanceof PDFFontSetImpl) {
            return PDFFontSetUtil.buildPDFFontSet((PDFFontSetImpl)fontSet, pdfDoc, locale, afePDFFontMap);
        }
        return null;
    }
}

