/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.javascript;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionJavaScript;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmark;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmarkNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmarkRoot;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFBookmarkUtils;
import com.adobe.internal.pdftoolkit.services.javascript.Doc;
import com.adobe.internal.pdftoolkit.services.javascript.JavaScriptException;
import com.adobe.internal.pdftoolkit.services.javascript.JavaScriptHandler;
import com.adobe.internal.pdftoolkit.services.javascript.UnsupportedJavaScriptFeatureException;
import com.adobe.internal.pdftoolkit.services.javascript.model.ESObject;
import com.adobe.internal.pdftoolkit.services.javascript.model.Function;
import com.adobe.internal.pdftoolkit.services.javascript.model.Param;
import com.adobe.internal.pdftoolkit.services.javascript.model.Property;
import com.adobe.internal.pdftoolkit.services.javascript.model.ScriptTable;
import com.adobe.internal.pdftoolkit.services.javascript.params.BookmarkParams;
import java.util.ArrayList;
import java.util.HashMap;
import org.mozilla.javascript.Scriptable;

public class Bookmark
extends ESObject {
    protected static final ScriptTable scriptTable = new ScriptTable("Bookmark.class", (HashMap)new HashMap<String, Function>(7){
        private static final long serialVersionUID = 1L;
        {
            this.put("createChild", new Function(Bookmark.class, "createChild", Param.Type.Object, BookmarkParams.createChild, 3, false, false));
            this.put("execute", new Function(Bookmark.class, "execute", Param.Type.Object, BookmarkParams.execute, 1, true, false));
            this.put("insertChild", new Function(Bookmark.class, "insertChild", Param.Type.Object, BookmarkParams.insertChild, 2, false, false));
            this.put("remove", new Function(Bookmark.class, "remove", Param.Type.Object, BookmarkParams.remove, 0, false, false));
            this.put("setAction", new Function(Bookmark.class, "setAction", Param.Type.Object, BookmarkParams.setAction, 1, false, false));
            this.put("toString", new Function(Bookmark.class, "toString", Param.Type.Object, BookmarkParams.toString, 0, true, false));
            this.put("valueOf", new Function(Bookmark.class, "valueOf", Param.Type.Object, BookmarkParams.valueOf, 0, true, false));
        }
    }, (HashMap)new HashMap<String, Property>(7){
        private static final long serialVersionUID = 1L;
        {
            this.put("name", new Property(Bookmark.class, "name", "getName", "setName", BookmarkParams.name, false, false));
            this.put("parent", new Property(Bookmark.class, "parent", "getParent", null, null, false, false));
            this.put("style", new Property(Bookmark.class, "style", "getStyle", "setStyle", BookmarkParams.style, false, false));
            this.put("children", new Property(Bookmark.class, "children", "getChildren", null, null, false, false));
            this.put("open", new Property(Bookmark.class, "open", "getOpen", "setOpen", BookmarkParams.open, true, true));
            this.put("doc", new Property(Bookmark.class, "doc", "getDoc", null, null, false, false));
            this.put("color", new Property(Bookmark.class, "color", "getColor", "setColor", BookmarkParams.color, false, true));
        }
    });
    private static final long serialVersionUID = -1483789133307037224L;
    PDFBookmarkNode bRoot;
    static final String className = "Bookmark";

    public Object get(String name, Scriptable start) {
        return super.get(name, start);
    }

    protected ScriptTable getScriptTable() {
        return scriptTable;
    }

    public Bookmark() {
    }

    public Bookmark(Object o) {
        if (o instanceof PDFBookmark) {
            this.bRoot = (PDFBookmarkNode)o;
        }
    }

    public String getClassName() {
        return className;
    }

    public Object getChildren() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptException {
        PDFBookmark bmTemp;
        ArrayList<Bookmark> aList = new ArrayList<Bookmark>();
        int nObjects = 0;
        for (bmTemp = this.bRoot.getFirstKid(); bmTemp != null; bmTemp = bmTemp.getNext()) {
            ++nObjects;
        }
        for (int i = 0; i < nObjects; ++i) {
            bmTemp = i == 0 ? this.bRoot.getFirstKid() : bmTemp.getNext();
            Bookmark bmark = (Bookmark)ESObject.create((Scriptable)this.getParentScope(), (boolean)true, (String)className, (boolean)false, null);
            bmark.setBRoot(bmTemp);
            aList.add(bmark);
        }
        Bookmark[] arr = new Bookmark[aList.size()];
        for (int i = 0; i < aList.size(); ++i) {
            arr[i] = (Bookmark)((Object)aList.get(i));
        }
        return arr;
    }

    public double[] getColor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.bRoot instanceof PDFBookmark) {
            return ((PDFBookmark)this.bRoot).getColor();
        }
        return null;
    }

    public void setColor(Object value) {
        throw new UnsupportedJavaScriptFeatureException("Unimplemented JavaScript evaluation feature");
    }

    public Doc getDoc() throws JavaScriptException {
        return JavaScriptHandler.getRegisteredInstance(this.bRoot.getPDFDocument()).getDocLevelScope();
    }

    public Object getName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.bRoot instanceof PDFBookmark) {
            return ((PDFBookmark)this.bRoot).getTitle();
        }
        if (this.bRoot instanceof PDFBookmarkRoot) {
            return this.bRoot.getFirstKid().getTitle();
        }
        return null;
    }

    public void setName(String value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.bRoot instanceof PDFBookmark) {
            ((PDFBookmark)this.bRoot).setTitle(value);
        }
    }

    public Object getOpen() {
        throw new UnsupportedJavaScriptFeatureException("Unimplemented JavaScript evaluation feature # open");
    }

    public void setOpen(Object value) {
        throw new UnsupportedJavaScriptFeatureException("Unimplemented JavaScript evaluation feature # open");
    }

    public Object getParent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.bRoot instanceof PDFBookmark) {
            return ((PDFBookmark)this.bRoot).getParent();
        }
        return null;
    }

    public int getStyle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.bRoot instanceof PDFBookmark) {
            return ((PDFBookmark)this.bRoot).getStyles();
        }
        return 0;
    }

    public void setStyle(Integer value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.bRoot instanceof PDFBookmark) {
            ((PDFBookmark)this.bRoot).setStyles(value);
        }
    }

    public void createChild(String name, String expression, Integer nIndex) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptException {
        PDFBookmark bookMark = PDFBookmark.newInstance(this.bRoot.getPDFDocument(), name);
        Bookmark[] children = (Bookmark[])this.getChildren();
        if (children.length > 0 && nIndex > 0) {
            PDFBookmark bm = (PDFBookmark)children[nIndex.intValue()].bRoot;
            PDFBookmarkUtils.insertAfterKid(bm, bookMark, this.bRoot);
            bookMark.setAction(PDFActionJavaScript.newInstance(bm.getPDFDocument(), PDFText.newInstance(bm.getPDFDocument(), expression)));
        } else {
            PDFBookmarkUtils.insertAfterKid(null, bookMark, this.bRoot);
            bookMark.setAction(PDFActionJavaScript.newInstance(this.bRoot.getPDFDocument(), PDFText.newInstance(this.bRoot.getPDFDocument(), expression)));
        }
    }

    public Object execute(Object arg1) {
        throw new UnsupportedJavaScriptFeatureException("Unimplemented JavaScript evaluation feature");
    }

    public void insertChild(Bookmark bookMark, Integer nIndex) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<PDFBookmark> children = ((PDFBookmark)this.bRoot).getChildren();
        PDFBookmark bm = children.get(nIndex);
        PDFBookmarkUtils.insertAfterKid(bm, (PDFBookmark)bookMark.bRoot, this.bRoot);
    }

    public void remove() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ((PDFBookmark)this.bRoot).delete();
    }

    public void setAction(String expression) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFBookmark bm = (PDFBookmark)this.bRoot;
        bm.setAction(PDFActionJavaScript.newInstance(bm.getPDFDocument(), PDFText.newInstance(bm.getPDFDocument(), expression)));
    }

    public String toString() {
        throw new UnsupportedJavaScriptFeatureException("Unimplemented JavaScript evaluation feature");
    }

    public Object valueOf() {
        throw new UnsupportedJavaScriptFeatureException("Unimplemented JavaScript evaluation feature");
    }

    public PDFBookmarkNode getBRoot() {
        return this.bRoot;
    }

    public void setBRoot(PDFBookmarkNode root) {
        this.bRoot = root;
    }
}

