/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.javascript;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFBuildData;
import com.adobe.internal.pdftoolkit.services.javascript.BuildInfo;
import com.adobe.internal.pdftoolkit.services.javascript.model.ESObject;
import com.adobe.internal.pdftoolkit.services.javascript.model.Function;
import com.adobe.internal.pdftoolkit.services.javascript.model.Property;
import com.adobe.internal.pdftoolkit.services.javascript.model.ScriptTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public abstract class BuildData
extends ESObject {
    protected static final ScriptTable scriptTable = new ScriptTable("BuildData.class", (HashMap)new HashMap<String, Function>(0){
        private static final long serialVersionUID = 1L;
    }, (HashMap)new HashMap<String, Property>(0){
        private static final long serialVersionUID = 1L;
    });
    private static final long serialVersionUID = -6248290078411296333L;
    private PDFBuildData buildDataDict = null;

    public Object get(String name, Scriptable start) {
        return super.get(name, start);
    }

    protected ScriptTable getScriptTable() {
        return scriptTable;
    }

    Object getName() {
        try {
            String str = this.buildDataDict.getName();
            if (str == null) {
                return Undefined.instance;
            }
            return str;
        }
        catch (PDFInvalidDocumentException e) {
            throw new IllegalArgumentException("PDF document is invalid", e);
        }
        catch (PDFIOException e) {
            throw new RuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    Object getDate() {
        try {
            String str = this.buildDataDict.getDate();
            if (str == null) {
                return Undefined.instance;
            }
            return str;
        }
        catch (PDFInvalidDocumentException e) {
            throw new IllegalArgumentException("PDF document is invalid", e);
        }
        catch (PDFIOException e) {
            throw new RuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    Object getPreRelease() {
        try {
            Boolean preRelease = this.buildDataDict.getPreRelease();
            if (preRelease != null) {
                return preRelease;
            }
            return Undefined.instance;
        }
        catch (PDFInvalidDocumentException e) {
            throw new IllegalArgumentException("PDF document is invalid", e);
        }
        catch (PDFIOException e) {
            throw new RuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    Object getOS() {
        try {
            String[] os = this.buildDataDict.getOS();
            if (os != null && os.length > 0) {
                Scriptable scope = this.getParentScope();
                ArrayList<String> val = new ArrayList<String>();
                val.addAll(Arrays.asList(os));
                return Context.getCurrentContext().newArray(scope, val.toArray());
            }
        }
        catch (PDFInvalidDocumentException e) {
            throw new IllegalArgumentException("PDF document is invalid", e);
        }
        catch (PDFIOException e) {
            throw new RuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new RuntimeException(e);
        }
        return Undefined.instance;
    }

    Object getR() {
        try {
            String str = this.buildDataDict.getRevNumber();
            if (str == null) {
                return Undefined.instance;
            }
            return BuildInfo.convert(str);
        }
        catch (PDFInvalidDocumentException e) {
            throw new IllegalArgumentException("PDF document is invalid", e);
        }
        catch (PDFIOException e) {
            throw new RuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    Object getNonEFontNoWarn() {
        try {
            Boolean fontnowarnFlag = this.buildDataDict.getNonEFontNoWarn();
            if (fontnowarnFlag != null) {
                return fontnowarnFlag;
            }
            return Undefined.instance;
        }
        catch (PDFInvalidDocumentException e) {
            throw new IllegalArgumentException("PDF document is invalid", e);
        }
        catch (PDFIOException e) {
            throw new RuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    Object getTrustedMode() {
        try {
            Boolean tmode = this.buildDataDict.getTrustedMode();
            if (tmode != null) {
                return tmode;
            }
            return Undefined.instance;
        }
        catch (PDFInvalidDocumentException e) {
            throw new IllegalArgumentException("PDF document is invalid", e);
        }
        catch (PDFIOException e) {
            throw new RuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    Object getV() {
        try {
            String str = this.buildDataDict.getV();
            if (str == null) {
                return Undefined.instance;
            }
            return BuildInfo.convert(str);
        }
        catch (PDFInvalidDocumentException e) {
            throw new IllegalArgumentException("PDF document is invalid", e);
        }
        catch (PDFIOException e) {
            throw new RuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract String getClassName();

    void setBuildData(PDFBuildData buildDataDict) {
        this.buildDataDict = buildDataDict;
    }

    PDFBuildData getBuildData() {
        return this.buildDataDict;
    }
}

