/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.javascript;

import com.adobe.internal.pdftoolkit.core.credentials.impl.utils.CertUtils;
import com.adobe.internal.pdftoolkit.core.util.ByteOps;
import com.adobe.internal.pdftoolkit.services.javascript.RDN;
import com.adobe.internal.pdftoolkit.services.javascript.Rights;
import com.adobe.internal.pdftoolkit.services.javascript.Usage;
import com.adobe.internal.pdftoolkit.services.javascript.model.ESObject;
import com.adobe.internal.pdftoolkit.services.javascript.model.Function;
import com.adobe.internal.pdftoolkit.services.javascript.model.Property;
import com.adobe.internal.pdftoolkit.services.javascript.model.ScriptTable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class Certificate
extends ESObject {
    protected static final ScriptTable scriptTable = new ScriptTable("Certificate.class", (HashMap)new HashMap<String, Function>(0){
        private static final long serialVersionUID = 1L;
    }, (HashMap)new HashMap<String, Property>(14){
        private static final long serialVersionUID = 1L;
        {
            this.put(Certificate.binary, new Property(Certificate.class, Certificate.binary, "getBinary", null, null, false, false));
            this.put("ubRights", new Property(Certificate.class, "ubRights", "getUbRights", null, null, false, false));
            this.put("usage", new Property(Certificate.class, "usage", "getUsage", null, null, false, false));
            this.put("keyUsage", new Property(Certificate.class, "keyUsage", "getKeyUsage", null, null, false, false));
            this.put("mD5Hash", new Property(Certificate.class, "mD5Hash", "getMD5Hash", null, null, false, false));
            this.put("privateKeyValidityEnd", new Property(Certificate.class, "privateKeyValidityEnd", "getPrivateKeyValidityEnd", null, null, false, false));
            this.put("validityEnd", new Property(Certificate.class, "validityEnd", "getValidityEnd", null, null, false, false));
            this.put(Certificate.subjectCNStr, new Property(Certificate.class, Certificate.subjectCNStr, "getSubjectCN", null, null, false, false));
            this.put(Certificate.serialNumberStr, new Property(Certificate.class, Certificate.serialNumberStr, "getSerialNumber", null, null, false, false));
            this.put("sHA1Hash", new Property(Certificate.class, "sHA1Hash", "getSHA1Hash", null, null, false, false));
            this.put("privateKeyValidityStart", new Property(Certificate.class, "privateKeyValidityStart", "getPrivateKeyValidityStart", null, null, false, false));
            this.put("subjectDN", new Property(Certificate.class, "subjectDN", "getSubjectDN", null, null, false, false));
            this.put("issuerDN", new Property(Certificate.class, "issuerDN", "getIssuerDN", null, null, false, false));
            this.put("validityStart", new Property(Certificate.class, "validityStart", "getValidityStart", null, null, false, false));
        }
    });
    private static final long serialVersionUID = -2751069164807460820L;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss 'GMT'Z");
    static final String className = "Certificate";
    private static final String binary = "binary";
    private static final String md5Hash = "MD5Hash";
    private static final String sha1HashStr = "SHA1Hash";
    private static final String serialNumberStr = "serialNumber";
    private static final String subjectCNStr = "subjectCN";
    private static final String nameAtBirthStr = "nameAtBirth";
    private static final String certDERBytes = "derBytes";
    private X509Certificate x509Certificate = null;
    private Map<String, String> dnMap = new HashMap<String, String>();
    private HashMap<String, Object> certificateMap = new HashMap();
    private static final String privateKeyUsagePeriodOID = "2.5.29.16";
    private static final Set<String> certificateDNSet = new HashSet<String>();
    private static final String[] jsKeyUsages;

    public Object get(String name, Scriptable start) {
        return super.get(name, start);
    }

    protected ScriptTable getScriptTable() {
        return scriptTable;
    }

    public String getClassName() {
        return className;
    }

    public String getBinary() {
        String certBinary = (String)this.certificateMap.get(binary);
        if (certBinary != null) {
            return certBinary;
        }
        byte[] certbyte = this.getDEREncoding();
        if (certbyte != null) {
            certBinary = ByteOps.getHexString(certbyte);
        }
        if (certBinary != null) {
            this.certificateMap.put(binary, certBinary);
        }
        return certBinary;
    }

    public Object getIssuerDN() {
        this.certficateDN(this.x509Certificate.getIssuerX500Principal().getName());
        if (this.dnMap != null) {
            RDN rdn = (RDN)ESObject.create((Scriptable)this.getParentScope(), (boolean)true, (String)"RDN", (boolean)false, null);
            rdn.setRDNMap(this.dnMap);
            return rdn;
        }
        return Undefined.instance;
    }

    public Object getKeyUsage() {
        ArrayList<String> valList = new ArrayList<String>();
        boolean[] keyUsages = this.x509Certificate.getKeyUsage();
        if (keyUsages != null) {
            for (int i = 0; i < 9; ++i) {
                if (!keyUsages[i]) continue;
                valList.add(jsKeyUsages[i]);
            }
        }
        Scriptable scope = this.getParentScope();
        return Context.getCurrentContext().newArray(scope, valList.toArray());
    }

    public String getMD5Hash() {
        String certMD5Hash = (String)this.certificateMap.get(md5Hash);
        if (certMD5Hash != null) {
            return certMD5Hash;
        }
        MessageDigest md5Digest = null;
        try {
            md5Digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] certbyte = this.getDEREncoding();
        if (certbyte != null) {
            certMD5Hash = ByteOps.getHexString(md5Digest.digest(certbyte));
        }
        if (certMD5Hash != null) {
            this.certificateMap.put(md5Hash, certMD5Hash);
        }
        return certMD5Hash;
    }

    public Object getPrivateKeyValidityEnd() {
        Date privateKeyValidityEnd = this.getPrivateKeyDate(false);
        if (privateKeyValidityEnd != null) {
            return this.dateFormat.format(privateKeyValidityEnd);
        }
        return Undefined.instance;
    }

    public Object getPrivateKeyValidityStart() {
        Date privateKeyValidityStart = this.getPrivateKeyDate(true);
        if (privateKeyValidityStart != null) {
            return this.dateFormat.format(privateKeyValidityStart);
        }
        return Undefined.instance;
    }

    public String getSHA1Hash() {
        String sha1Hash = (String)this.certificateMap.get(sha1HashStr);
        if (sha1Hash != null) {
            return sha1Hash;
        }
        MessageDigest sha1Digest = null;
        try {
            sha1Digest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] certbyte = this.getDEREncoding();
        if (certbyte != null) {
            sha1Hash = ByteOps.getHexString(sha1Digest.digest(certbyte));
        }
        if (sha1Hash != null) {
            this.certificateMap.put(sha1HashStr, sha1Hash);
        }
        return sha1Hash;
    }

    public String getSerialNumber() {
        String serialNumber = (String)this.certificateMap.get(serialNumberStr);
        if (serialNumber != null) {
            return serialNumber;
        }
        serialNumber = ByteOps.getHexString(this.x509Certificate.getSerialNumber().toByteArray());
        if (serialNumber != null) {
            this.certificateMap.put(serialNumberStr, serialNumber);
        }
        return serialNumber;
    }

    public String getSubjectCN() {
        String subjectCN = (String)this.certificateMap.get(subjectCNStr);
        if (subjectCN != null) {
            return subjectCN;
        }
        subjectCN = CertUtils.getCommonSubjectName(this.x509Certificate);
        this.certificateMap.put(subjectCNStr, subjectCN);
        return subjectCN;
    }

    public Object getSubjectDN() {
        this.certficateDN(this.x509Certificate.getSubjectX500Principal().getName());
        if (this.dnMap != null) {
            RDN rdn = (RDN)ESObject.create((Scriptable)this.getParentScope(), (boolean)true, (String)"RDN", (boolean)false, null);
            rdn.setRDNMap(this.dnMap);
            return rdn;
        }
        return Undefined.instance;
    }

    public Rights getUbRights() {
        String ubiquityOIDIdentifier = "1.2.840.113583.1.1.7.1";
        Rights jsRights = (Rights)ESObject.create((Scriptable)this.getParentScope(), (boolean)true, (String)"Rights", (boolean)false, null);
        jsRights.setupRights(this.x509Certificate.getExtensionValue("1.2.840.113583.1.1.7.1"));
        return jsRights;
    }

    public Usage getUsage() {
        Usage jsUsage = (Usage)ESObject.create((Scriptable)this.getParentScope(), (boolean)true, (String)"Usage", (boolean)false, null);
        boolean isValid = true;
        try {
            this.x509Certificate.checkValidity();
        }
        catch (CertificateExpiredException e) {
            isValid = false;
        }
        catch (CertificateNotYetValidException e) {
            isValid = false;
        }
        jsUsage.setX509V3Extensions(this.x509Certificate, !this.x509Certificate.getSigAlgOID().equals("1.2.840.113549.1.1.1"), isValid);
        return jsUsage;
    }

    public Object getValidityEnd() {
        Date validityEnd = this.x509Certificate.getNotAfter();
        return this.dateFormat.format(validityEnd);
    }

    public Object getValidityStart() {
        Date validityStart = this.x509Certificate.getNotBefore();
        return this.dateFormat.format(validityStart);
    }

    void setCertificate(byte[] certificate) {
        if (certificate != null) {
            this.certificateMap.put(certDERBytes, certificate);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(certificate);
            try {
                this.x509Certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(inputStream);
            }
            catch (CertificateException e) {
                throw new RuntimeException("Can not able to create the X509Certificate", e);
            }
            finally {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    byte[] getDEREncoding() {
        return (byte[])this.certificateMap.get(certDERBytes);
    }

    private void certficateDN(String xName) {
        LdapName ldapName;
        try {
            ldapName = new LdapName(xName);
        }
        catch (InvalidNameException e) {
            throw new IllegalArgumentException("Certificate DN is incorrectly formatted", e);
        }
        for (Rdn certDN : ldapName.getRdns()) {
            String key = certDN.getType();
            if (key == null || (key = Certificate.containsIgnoreCase(key)) == null) continue;
            this.dnMap.put(key, certDN.getValue().toString());
        }
        String nameAtBirth = null;
        String nextToken = null;
        String nameAtBirthOid = "1.3.36.8.3.14";
        StringTokenizer st = new StringTokenizer(xName, ",");
        block3: while (st.hasMoreTokens()) {
            String token = st.nextToken();
            StringTokenizer strtoken = new StringTokenizer(token, "=");
            while (strtoken.hasMoreTokens()) {
                nextToken = strtoken.nextToken();
                if (!nextToken.matches(nameAtBirthStr) && !nextToken.matches(nameAtBirthOid)) continue;
                nameAtBirth = strtoken.nextToken();
                continue block3;
            }
        }
        if (nameAtBirth != null) {
            this.dnMap.put(nameAtBirthStr, nameAtBirth);
        }
    }

    private static String containsIgnoreCase(String val) {
        Iterator<String> itr = certificateDNSet.iterator();
        String cur = null;
        while (itr.hasNext()) {
            cur = itr.next();
            if (!cur.equalsIgnoreCase(val)) continue;
            return cur;
        }
        return null;
    }

    private Date getPrivateKeyDate(boolean start) {
        Date requiredData;
        block6: {
            requiredData = null;
            try {
                byte[] privateKeyUsageEncoded = this.x509Certificate.getExtensionValue(privateKeyUsagePeriodOID);
                if (privateKeyUsageEncoded == null) break block6;
                SimpleDateFormat dateFormat1 = new SimpleDateFormat("yyyyMMddHHmmss");
                dateFormat1.setTimeZone(TimeZone.getTimeZone("GMT"));
                for (int i = 2; i < privateKeyUsageEncoded.length; ++i) {
                    if ((privateKeyUsageEncoded[i] != -128 || !start) && (privateKeyUsageEncoded[i] != -127 || start)) continue;
                    int len = Certificate.toInt(privateKeyUsageEncoded[i + 1]);
                    String dateStr = new String(privateKeyUsageEncoded, i + 2, len);
                    try {
                        requiredData = dateFormat1.parse(dateStr);
                    }
                    catch (ParseException e) {
                        SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyMMddHHmmss");
                        dateFormat2.setTimeZone(TimeZone.getTimeZone("GMT"));
                        requiredData = dateFormat2.parse(dateStr);
                    }
                    i += len;
                }
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Encoding exception when extracting the bytes of the signing certificate", e);
            }
        }
        if (start) {
            return requiredData != null ? requiredData : this.x509Certificate.getNotBefore();
        }
        return requiredData != null ? requiredData : this.x509Certificate.getNotAfter();
    }

    static int toInt(byte b) {
        return b < 0 ? 256 + b : b;
    }

    static {
        certificateDNSet.add("businessCategory");
        certificateDNSet.add("cn");
        certificateDNSet.add("c");
        certificateDNSet.add("countryOfCitizenship");
        certificateDNSet.add("countryOfResidence");
        certificateDNSet.add("dateOfBirth");
        certificateDNSet.add("dc");
        certificateDNSet.add("dnQualifier");
        certificateDNSet.add("e");
        certificateDNSet.add("gender");
        certificateDNSet.add("generationQualifier");
        certificateDNSet.add("givenName");
        certificateDNSet.add("initials");
        certificateDNSet.add("l");
        certificateDNSet.add("name");
        certificateDNSet.add("o");
        certificateDNSet.add("ou");
        certificateDNSet.add("placeOfBirth");
        certificateDNSet.add("postalAddress");
        certificateDNSet.add("postalCode");
        certificateDNSet.add("pseudonym");
        certificateDNSet.add(serialNumberStr);
        certificateDNSet.add("sn");
        certificateDNSet.add("st");
        certificateDNSet.add("street");
        certificateDNSet.add("title");
        jsKeyUsages = new String[]{"kDigitalSignature", "kNonRepudiation", "kKeyEncipherment", "kDataEncipherment", "kKeyAgreement", "kKeyCertSign", "kCRLSign", "kEncipherOnly", "kDecipherOnly"};
    }
}

