/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.javascript;

import com.adobe.internal.pdftoolkit.services.javascript.JSExecuteOptions;
import com.adobe.internal.pdftoolkit.services.javascript.security.JSSecurityController;
import java.lang.reflect.Method;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.SecurityController;

public class GibsonContextFactory
extends ContextFactory {
    JSSecurityController controller = null;
    JSExecuteOptions executeOptions = null;
    private static final String[] names = new String[]{"org.mozilla.javascript.EvaluatorException", "java.lang.Object", "java.io.PrintStream", "com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm"};

    protected Context makeContext() {
        GibsonStoppableContext cx = new GibsonStoppableContext(this);
        cx.setClassShutter(new MethodShutter());
        if (this.controller != null) {
            cx.setSecurityController((SecurityController)this.controller);
        }
        cx.setOptimizationLevel(-1);
        if (this.executeOptions != null) {
            cx.setInstructionObserverThreshold(this.executeOptions.getInstructionCount());
        } else {
            cx.setInstructionObserverThreshold(1000);
        }
        cx.getWrapFactory().setJavaPrimitiveWrap(false);
        return cx;
    }

    public void setSecurityController(JSSecurityController SecController) {
        this.controller = SecController;
    }

    public void setExecuteOptions(JSExecuteOptions ops) {
        this.executeOptions = ops;
    }

    public boolean hasFeature(Context cx, int featureIndex) {
        switch (featureIndex) {
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 7: {
                return true;
            }
        }
        return super.hasFeature(cx, featureIndex);
    }

    public void interruptScript() {
        GibsonStoppableContext mcx = (GibsonStoppableContext)Context.getCurrentContext();
        mcx.stopScript = true;
    }

    protected void observeInstructionCount(Context cx, int instructionCount) {
        GibsonStoppableContext mcx = (GibsonStoppableContext)cx;
        if (mcx.stopScript) {
            throw new ThreadDeath();
        }
        long currentTime = System.currentTimeMillis();
        int tSec = 10;
        if (this.executeOptions != null) {
            tSec = this.executeOptions.getScriptTimeOutInterval();
        }
        if (currentTime - mcx.startTime > (long)(tSec * 1000)) {
            throw new ThreadDeath();
        }
    }

    protected Object doTopCall(Callable callable, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        GibsonStoppableContext mcx = (GibsonStoppableContext)cx;
        mcx.startTime = System.currentTimeMillis();
        return super.doTopCall(callable, (Context)mcx, scope, thisObj, args);
    }

    static class MethodShutter
    implements ClassShutter {
        MethodShutter() {
        }

        public boolean visibleToScripts(String className) {
            for (int i = 0; i < names.length; ++i) {
                if (!className.startsWith(names[i])) continue;
                return true;
            }
            return false;
        }

        public boolean visibleToScripts(Method method) {
            String className = method.getDeclaringClass().getCanonicalName();
            String methodName = method.getName();
            if ("length".equals(methodName) && "java.lang.Object".equals(className)) {
                return true;
            }
            return "println".equals(methodName) && "java.io.PrintStream".equals(className);
        }
    }

    public static class GibsonStoppableContext
    extends Context {
        long startTime;
        boolean stopScript;

        public GibsonStoppableContext(GibsonContextFactory gibsonContextFactory) {
            super((ContextFactory)gibsonContextFactory);
        }
    }
}

