/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.javascript;

import com.adobe.internal.pdftoolkit.services.impl.ServicesUtil;
import com.adobe.internal.pdftoolkit.services.javascript.Util;
import com.adobe.internal.pdftoolkit.services.javascript.model.ESObject;
import com.adobe.internal.pdftoolkit.services.javascript.model.Function;
import com.adobe.internal.pdftoolkit.services.javascript.model.JSUtils;
import com.adobe.internal.pdftoolkit.services.javascript.model.Property;
import com.adobe.internal.pdftoolkit.services.javascript.model.ScriptTable;
import com.adobe.internal.pdftoolkit.services.javascript.params.SpanParams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Delegator;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class Span
extends ESObject {
    protected static final ScriptTable scriptTable = new ScriptTable("Span.class", (HashMap)new HashMap<String, Function>(0){
        private static final long serialVersionUID = 1L;
    }, (HashMap)new HashMap<String, Property>(12){
        private static final long serialVersionUID = 1L;
        {
            this.put("subscript", new Property(Span.class, "subscript", "getSubscript", "setSubscript", SpanParams.subscript, false, false));
            this.put("text", new Property(Span.class, "text", "getText", "setText", SpanParams.text, false, false));
            this.put("alignment", new Property(Span.class, "alignment", "getAlignment", "setAlignment", SpanParams.alignment, false, false));
            this.put("textColor", new Property(Span.class, "textColor", "getTextColor", "setTextColor", SpanParams.textColor, false, false));
            this.put("fontFamily", new Property(Span.class, "fontFamily", "getFontFamily", "setFontFamily", SpanParams.fontFamily, false, false));
            this.put("strikethrough", new Property(Span.class, "strikethrough", "getStrikethrough", "setStrikethrough", SpanParams.strikethrough, false, false));
            this.put("fontStyle", new Property(Span.class, "fontStyle", "getFontStyle", "setFontStyle", SpanParams.fontStyle, false, false));
            this.put("underline", new Property(Span.class, "underline", "getUnderline", "setUnderline", SpanParams.underline, false, false));
            this.put("textSize", new Property(Span.class, "textSize", "getTextSize", "setTextSize", SpanParams.textSize, false, false));
            this.put("fontWeight", new Property(Span.class, "fontWeight", "getFontWeight", "setFontWeight", SpanParams.fontWeight, false, false));
            this.put("superscript", new Property(Span.class, "superscript", "getSuperscript", "setSuperscript", SpanParams.superscript, false, false));
            this.put("fontStretch", new Property(Span.class, "fontStretch", "getFontStretch", "setFontStretch", SpanParams.fontStretch, false, false));
        }
    });
    private static final long serialVersionUID = 5626537037326356660L;
    static final String className = "Span";
    private HashMap<String, String> span = new HashMap();
    private String[] fontFamily = null;
    private Boolean subscript = null;
    private Boolean superscript = null;
    private Boolean textDecorationValue = null;
    private Boolean underline = null;

    public Object get(String name, Scriptable start) {
        return super.get(name, start);
    }

    protected ScriptTable getScriptTable() {
        return scriptTable;
    }

    public String getClassName() {
        return className;
    }

    public Object getAlignment() {
        String alignment = this.span.get("text-align");
        if (alignment != null) {
            return alignment;
        }
        return Undefined.instance;
    }

    public void setAlignment(String alignment) {
        this.span.put("text-align", alignment);
    }

    public Object getFontFamily() {
        String family = this.span.get("font-family");
        if (family != null) {
            this.fontFamily = family.split(",");
        }
        if (this.fontFamily != null && this.fontFamily.length > 0) {
            ArrayList<String> jsFontFamily = new ArrayList<String>();
            Scriptable scope = this.getParentScope();
            jsFontFamily.addAll(Arrays.asList(this.fontFamily));
            Scriptable array = Context.getCurrentContext().newArray(scope, jsFontFamily.toArray());
            return new Delegator(array){

                public void put(int index, Scriptable start, Object value) {
                    Span.access$002(Span.this, Util.processDelegator(Span.this.fontFamily, index, value));
                    Span.this.convertIntoFontFamily(Span.this.fontFamily);
                }
            };
        }
        return Undefined.instance;
    }

    public void setFontFamily(Object fontFamily) {
        if (fontFamily instanceof Delegator) {
            Delegator delegator = (Delegator)fontFamily;
            this.setFontFamilyInternal(delegator.getDelegee());
        } else {
            this.setFontFamilyInternal(fontFamily);
        }
    }

    public Object getFontStretch() {
        String fontStretch = this.span.get("font-stretch");
        if (fontStretch != null) {
            return fontStretch;
        }
        return "normal";
    }

    public void setFontStretch(String fontStretch) {
        this.span.put("font-stretch", fontStretch);
    }

    public Object getFontStyle() {
        String fontStyle = this.span.get("font-style");
        if (fontStyle != null) {
            return fontStyle;
        }
        return "normal";
    }

    public void setFontStyle(String fontStyle) {
        this.span.put("font-style", fontStyle);
    }

    public Object getFontWeight() {
        String fontWeightValue = this.span.get("font-weight");
        if (fontWeightValue != null) {
            if (fontWeightValue.equalsIgnoreCase("bold")) {
                return 700;
            }
            if (fontWeightValue.equalsIgnoreCase("normal")) {
                return 400;
            }
            return Double.valueOf(fontWeightValue);
        }
        return Undefined.instance;
    }

    public void setFontWeight(Object fontWeight) {
        String weight = fontWeight.toString();
        if (weight.contains(".0")) {
            weight = weight.substring(0, weight.length() - 2);
        }
        this.span.put("font-weight", weight);
    }

    public Object getStrikethrough() {
        if (this.textDecorationValue != null) {
            return this.textDecorationValue;
        }
        String strikethrough = this.span.get("text-decoration");
        if (strikethrough != null) {
            if (strikethrough.contains("line-through")) {
                return true;
            }
            if (Boolean.getBoolean(strikethrough)) {
                return strikethrough;
            }
        }
        return Undefined.instance;
    }

    public void setStrikethrough(Object strikethrough) {
        Boolean isStrikethroughe = (Boolean)Context.jsToJava((Object)strikethrough, Boolean.class);
        if (isStrikethroughe != null) {
            this.textDecorationValue = isStrikethroughe;
        }
    }

    public Object getSubscript() {
        if (this.subscript != null) {
            return this.subscript;
        }
        String subscript = this.span.get("vertical-align");
        if (subscript != null && subscript.substring(0, subscript.length() - 2).contains("-")) {
            this.subscript = true;
            return this.subscript;
        }
        return Undefined.instance;
    }

    public void setSubscript(Object subscript) {
        Boolean isSubscript = (Boolean)Context.jsToJava((Object)subscript, Boolean.class);
        if (isSubscript != null) {
            this.subscript = isSubscript;
        }
    }

    public Object getSuperscript() {
        if (this.superscript != null) {
            return this.superscript;
        }
        String superscript = this.span.get("vertical-align");
        if (superscript != null && superscript.substring(0, superscript.length() - 2).contains("+")) {
            this.superscript = true;
            return this.superscript;
        }
        return Undefined.instance;
    }

    public void setSuperscript(Boolean superscript) {
        Boolean isSuperscript = (Boolean)Context.jsToJava((Object)superscript, Boolean.class);
        if (isSuperscript != null) {
            this.superscript = isSuperscript;
        }
    }

    public Object getText() {
        String text = this.span.get("text");
        if (text != null) {
            return text;
        }
        return Undefined.instance;
    }

    public void setText(String text) {
        this.span.put("text", text);
    }

    public Object getTextColor() {
        String textColor = this.span.get("color");
        if (textColor != null) {
            String[] color = new String[4];
            ArrayList<String> textColorArray = new ArrayList<String>();
            color = this.parseTextColor(textColor, color);
            Scriptable scope = this.getParentScope();
            if (color != null) {
                textColorArray.addAll(Arrays.asList(color));
                Scriptable array = Context.getCurrentContext().newArray(scope, textColorArray.toArray());
                return new Delegator(array){

                    public void put(int index, Scriptable start, Object value) {
                        String textColorValue = (String)Span.this.span.get("color");
                        if (textColorValue != null) {
                            String[] colorArray = new String[4];
                            if ((colorArray = Span.this.parseTextColor(textColorValue, colorArray)) != null) {
                                colorArray[index] = (String)value;
                                Span.this.convertIntoHexColor(colorArray);
                            }
                        }
                    }
                };
            }
        }
        return Undefined.instance;
    }

    public void setTextColor(Object textColor) {
        if (textColor instanceof Delegator) {
            Delegator delegator = (Delegator)textColor;
            this.setTextColorInternal(delegator.getDelegee());
        } else {
            this.setTextColorInternal(textColor);
        }
    }

    public Object getTextSize() {
        String textSize = this.span.get("font-size");
        if (textSize != null) {
            return Double.valueOf(textSize.substring(0, textSize.length() - 2));
        }
        return Undefined.instance;
    }

    public void setTextSize(Object textSize) {
        this.span.put("font-size", textSize.toString() + "pt");
    }

    public Object getUnderline() {
        if (this.underline != null) {
            return this.underline;
        }
        String underline = this.span.get("text-decoration");
        if (underline != null) {
            if (underline.contains("underline")) {
                return "underline";
            }
            return underline;
        }
        return Undefined.instance;
    }

    public void setUnderline(Object underline) {
        Boolean isUnderline = (Boolean)Context.jsToJava((Object)underline, Boolean.class);
        if (isUnderline != null) {
            this.underline = isUnderline;
        }
    }

    void setSpan(HashMap<String, String> span) {
        this.span = span;
    }

    public HashMap<String, String> getSpan() {
        this.span = ServicesUtil.finalizeSpanMap(this.span, (Boolean)this.textDecorationValue, (Boolean)this.underline, (Boolean)this.superscript, (Boolean)this.subscript);
        return this.span;
    }

    private void setFontFamilyInternal(Object fontFamily) {
        if (fontFamily instanceof NativeArray) {
            NativeArray arr = (NativeArray)fontFamily;
            try {
                Object[] jsInput = (Object[])JSUtils.scriptableToJava((ScriptableObject)arr, (Context)Context.getCurrentContext());
                String[] inInput = null;
                inInput = new String[jsInput.length];
                for (int i = 0; i < jsInput.length; ++i) {
                    inInput[i] = (String)jsInput[i];
                }
                this.convertIntoFontFamily(inInput);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void convertIntoFontFamily(String[] fontFamily) {
        if (fontFamily.length > 0) {
            StringBuilder fontFamilyString = new StringBuilder("");
            for (int i = 0; i < fontFamily.length - 1; ++i) {
                fontFamilyString.append(fontFamily[i]).append(",");
            }
            fontFamilyString.append(fontFamily[fontFamily.length - 1]);
            this.span.put("font-family", fontFamilyString.toString());
        }
    }

    private String[] parseHexColor(String textColor, String[] colorArray) {
        if (textColor.length() == 7) {
            Integer firstComponent = Integer.parseInt(textColor.substring(1, 3), 16);
            colorArray[1] = String.valueOf(firstComponent.doubleValue() / 255.0);
            Integer secondComponent = Integer.parseInt(textColor.substring(3, 5), 16);
            colorArray[2] = String.valueOf(secondComponent.doubleValue() / 255.0);
            Integer thirdComponent = Integer.parseInt(textColor.substring(5, 7), 16);
            colorArray[3] = String.valueOf(thirdComponent.doubleValue() / 255.0);
            return colorArray;
        }
        return null;
    }

    private String[] parseDecimalColor(String textColor, String[] colorArray) {
        String[] rgb = (textColor = textColor.substring(4, textColor.length() - 1)).split(",");
        if (rgb != null && rgb.length == 3) {
            Integer firstComponent = Integer.parseInt(rgb[0], 10);
            colorArray[1] = String.valueOf(firstComponent.doubleValue() / 255.0);
            Integer secondComponent = Integer.parseInt(rgb[1], 10);
            colorArray[2] = String.valueOf(secondComponent.doubleValue() / 255.0);
            Integer thirdComponent = Integer.parseInt(rgb[2], 10);
            colorArray[3] = String.valueOf(thirdComponent.doubleValue() / 255.0);
            return colorArray;
        }
        return null;
    }

    private void convertIntoHexColor(String[] colorArray) {
        StringBuilder builder = new StringBuilder("#");
        for (int i = 1; i <= 3; ++i) {
            Double component = Double.parseDouble(colorArray[i]) * 255.0;
            String hexValue = Integer.toString(component.intValue(), 16).toUpperCase();
            if (hexValue.length() < 2) {
                builder.append("0");
            }
            builder.append(hexValue);
        }
        this.span.put("color", builder.toString());
    }

    private String[] parseTextColor(String textColorValue, String[] colorArray) {
        colorArray[0] = "RGB";
        char ch = textColorValue.charAt(0);
        switch (ch) {
            case '#': {
                colorArray = this.parseHexColor(textColorValue, colorArray);
                return colorArray;
            }
            case 'r': {
                colorArray = this.parseDecimalColor(textColorValue, colorArray);
                return colorArray;
            }
        }
        throw new RuntimeException("Color is neither in decimal format nor in Hex format");
    }

    private void setTextColorInternal(Object textColor) {
        if (textColor instanceof NativeArray) {
            NativeArray arr = (NativeArray)textColor;
            try {
                Object[] jsInput = (Object[])JSUtils.scriptableToJava((ScriptableObject)arr, (Context)Context.getCurrentContext());
                String[] inInput = null;
                inInput = new String[jsInput.length];
                for (int i = 0; i < jsInput.length; ++i) {
                    inInput[i] = (String)jsInput[i];
                }
                this.convertIntoHexColor(inInput);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static /* synthetic */ String[] access$002(Span x0, String[] x1) {
        x0.fontFamily = x1;
        return x1;
    }
}

