/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.javascript;

import com.adobe.internal.pdftoolkit.services.javascript.model.ESObject;
import com.adobe.internal.pdftoolkit.services.javascript.model.Function;
import com.adobe.internal.pdftoolkit.services.javascript.model.Property;
import com.adobe.internal.pdftoolkit.services.javascript.model.ScriptTable;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import org.mozilla.javascript.Scriptable;

public class Usage
extends ESObject {
    protected static final ScriptTable scriptTable = new ScriptTable("Usage.class", (HashMap)new HashMap<String, Function>(0){
        private static final long serialVersionUID = 1L;
    }, (HashMap)new HashMap<String, Property>(2){
        private static final long serialVersionUID = 1L;
        {
            this.put("endUserEncryption", new Property(Usage.class, "endUserEncryption", "getEndUserEncryption", null, null, false, false));
            this.put("endUserSigning", new Property(Usage.class, "endUserSigning", "getEndUserSigning", null, null, false, false));
        }
    });
    private static final long serialVersionUID = -2104270120234779375L;
    private X509Certificate x509Cert = null;
    static final String className = "Usage";
    private boolean isValid;
    private boolean isInvalidAlgorithm;
    private static String kMSFileRecoveryOID = "1.3.6.1.4.1.311.10.3.4.1";
    private static String kMSEFSOID = "1.3.6.1.4.1.311.10.3.4";
    private static String kAnyExtendedKeyUsageOID = "2.5.29.37.0";
    static final String kRSAEncryptionOID = "1.2.840.113549.1.1.1";

    public Object get(String name, Scriptable start) {
        return super.get(name, start);
    }

    protected ScriptTable getScriptTable() {
        return scriptTable;
    }

    public String getClassName() {
        return className;
    }

    public boolean getEndUserSigning() {
        if (!this.isValid) {
            return false;
        }
        return this.isUserSigning();
    }

    public boolean getEndUserEncryption() {
        if (!this.isValid) {
            return false;
        }
        return this.isUserEncryption();
    }

    void setX509V3Extensions(X509Certificate x509Cert, boolean isInvalidAlgorithm, boolean isValid) {
        if (x509Cert != null) {
            this.x509Cert = x509Cert;
        }
        this.isValid = isValid;
        this.isInvalidAlgorithm = isInvalidAlgorithm;
    }

    private boolean getBasicConstraints() {
        return this.x509Cert.getBasicConstraints() == -1;
    }

    private boolean isUserEncryption() {
        if (!this.getBasicConstraints()) {
            return false;
        }
        try {
            boolean[] keyUsage = this.x509Cert.getKeyUsage();
            if (!(keyUsage == null || keyUsage[2] || keyUsage[3] || keyUsage[4])) {
                return false;
            }
            List<String> extendedKeyUsage = this.x509Cert.getExtendedKeyUsage();
            if (extendedKeyUsage != null && extendedKeyUsage.contains(kAnyExtendedKeyUsageOID)) {
                return true;
            }
            if (keyUsage == null && extendedKeyUsage != null && (extendedKeyUsage.contains(kMSFileRecoveryOID) || extendedKeyUsage.contains(kMSEFSOID))) {
                return false;
            }
            if (this.isInvalidAlgorithm) {
                return false;
            }
        }
        catch (CertificateParsingException e) {
            return false;
        }
        return true;
    }

    private boolean isUserSigning() {
        if (!this.getBasicConstraints()) {
            return false;
        }
        return this.checkKeyUsage(0);
    }

    private boolean checkKeyUsage(int checkIndex) {
        boolean[] keyUsages = this.x509Cert.getKeyUsage();
        if (keyUsages != null) {
            return keyUsages[checkIndex];
        }
        return true;
    }
}

