/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.javascript;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.services.javascript.Console;
import com.adobe.internal.pdftoolkit.services.javascript.Doc;
import com.adobe.internal.pdftoolkit.services.javascript.JavaScriptHandler;
import com.adobe.internal.pdftoolkit.services.javascript.ReadStream;
import com.adobe.internal.pdftoolkit.services.javascript.UnsupportedJavaScriptFeatureException;
import com.adobe.internal.pdftoolkit.services.javascript.model.ESObject;
import com.adobe.internal.pdftoolkit.services.javascript.model.Function;
import com.adobe.internal.pdftoolkit.services.javascript.model.JSUtils;
import com.adobe.internal.pdftoolkit.services.javascript.model.Param;
import com.adobe.internal.pdftoolkit.services.javascript.model.Property;
import com.adobe.internal.pdftoolkit.services.javascript.model.ScriptTable;
import com.adobe.internal.pdftoolkit.services.javascript.params.UtilParams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class Util
extends ESObject {
    protected static final ScriptTable scriptTable = new ScriptTable("Util.class", (HashMap)new HashMap<String, Function>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("crackURL", new Function(Util.class, "crackURL", Param.Type.Object, UtilParams.crackURL, 1, true, false));
            this.put("iconStreamFromIcon", new Function(Util.class, "iconStreamFromIcon", Param.Type.Object, UtilParams.iconStreamFromIcon, 1, true, false));
            this.put("printf", new Function(Util.class, "printf", Param.Type.String, UtilParams.printf, 2, false, false));
            this.put("printd", new Function(Util.class, "printd", Param.Type.String, UtilParams.printd, 3, false, false));
            this.put("printx", new Function(Util.class, "printx", Param.Type.String, UtilParams.printx, 2, false, false));
            this.put("scand", new Function(Util.class, "scand", Param.Type.Object, UtilParams.scand, 2, false, false));
            this.put("spansToXML", new Function(Util.class, "spansToXML", Param.Type.Object, UtilParams.spansToXML, 1, true, false));
            this.put("streamFromString", new Function(Util.class, "streamFromString", Param.Type.Object, UtilParams.streamFromString, 2, false, false));
            this.put("stringFromStream", new Function(Util.class, "stringFromStream", Param.Type.String, UtilParams.stringFromStream, 2, false, false));
            this.put("xmlToSpans", new Function(Util.class, "xmlToSpans", Param.Type.Object, UtilParams.xmlToSpans, 1, true, false));
        }
    }, (HashMap)new HashMap<String, Property>(0){
        private static final long serialVersionUID = 1L;
    });
    private static final long serialVersionUID = -8788357906110981300L;
    static final String className = "Util";

    public Object get(String name, Scriptable start) {
        return super.get(name, start);
    }

    protected ScriptTable getScriptTable() {
        return scriptTable;
    }

    public String getClassName() {
        return className;
    }

    public void crackURL(Object cURL) {
        throw new UnsupportedJavaScriptFeatureException(" Unimplemented javascript execution feature # crackURL ");
    }

    public void iconStreamFromIcon(Object oIcon) {
        throw new UnsupportedJavaScriptFeatureException(" Unimplemented javascript execution feature # iconStreamFromIcon ");
    }

    public String printf(String cFormat, String cSource) {
        String formatedStr = cSource;
        boolean paddingAsZero = false;
        boolean setPrecision = false;
        boolean showalternate = false;
        boolean nDecSep = false;
        boolean nFlags = false;
        boolean weird = false;
        boolean showSign = false;
        NumberFormat formatter = NumberFormat.getInstance();
        formatter = new DecimalFormat("######");
        formatter.setMaximumFractionDigits(0);
        formatter.setMinimumFractionDigits(0);
        char[] arr = cFormat.toCharArray();
        block6: for (int k = 0; k < arr.length; ++k) {
            char formatChar = arr[k];
            if (formatChar == '%') {
                if ((formatChar = arr[++k]) == ',') {
                    DecimalFormatSymbols unusualSymbols;
                    if ((formatChar = arr[++k]) == '0') {
                        formatter = new DecimalFormat("#,###.###");
                        formatedStr = formatter.format(Double.parseDouble(cSource));
                        nDecSep = true;
                        formatChar = arr[++k];
                    }
                    if (formatChar == '1') {
                        formatter = new DecimalFormat("####.###");
                        formatedStr = formatter.format(Double.parseDouble(cSource));
                        nDecSep = true;
                        formatChar = arr[++k];
                    }
                    if (formatChar == '2') {
                        unusualSymbols = new DecimalFormatSymbols(((Doc)this.getParentScope()).getActiveDocument().getCosDocument().getOptions().getDocLocale());
                        unusualSymbols.setDecimalSeparator(',');
                        setPrecision = true;
                        unusualSymbols.setGroupingSeparator('.');
                        formatter = new DecimalFormat("#,###.###", unusualSymbols);
                        formatedStr = formatter.format(Double.parseDouble(cSource));
                        nDecSep = true;
                        weird = true;
                        formatChar = arr[++k];
                    }
                    if (formatChar == '3') {
                        unusualSymbols = new DecimalFormatSymbols(((Doc)this.getParentScope()).getActiveDocument().getCosDocument().getOptions().getDocLocale());
                        unusualSymbols.setDecimalSeparator(',');
                        setPrecision = true;
                        formatter = new DecimalFormat("#######", unusualSymbols);
                        formatedStr = formatter.format(new Double(cSource));
                        nDecSep = true;
                        formatChar = arr[++k];
                    }
                }
                if (formatChar == '0') {
                    paddingAsZero = true;
                    nFlags = true;
                    formatChar = arr[++k];
                }
                if (formatChar == ' ') {
                    paddingAsZero = false;
                    nFlags = true;
                    formatChar = arr[++k];
                }
                if (formatChar == '+') {
                    showSign = true;
                    if (new Double(cSource).compareTo(new Double(0.0)) < 0) {
                        ((DecimalFormat)formatter).setPositivePrefix("-");
                    }
                    if (new Double(cSource).compareTo(new Double(0.0)) > 0) {
                        ((DecimalFormat)formatter).setPositivePrefix("+");
                    }
                    nFlags = true;
                    formatChar = arr[++k];
                }
                if (formatChar == '#') {
                    showalternate = true;
                    nFlags = true;
                    formatChar = arr[++k];
                }
            }
            if (nDecSep || nFlags) {
                String nWidth = "";
                int c = cFormat.indexOf(46);
                if (c != -1 && c > k) {
                    setPrecision = true;
                    char[] numForm = new char[c - k];
                    System.arraycopy(arr, k, numForm, 0, c - k);
                    nWidth = new String(numForm);
                }
                if (nWidth != null && nWidth.length() > 0) {
                    int width = Integer.parseInt(nWidth);
                    if (setPrecision) {
                        --width;
                    }
                    if (showSign) {
                        --width;
                    }
                    formatter.setMinimumIntegerDigits(width);
                }
                formatChar = arr[c];
                k = c;
                nFlags = false;
                nDecSep = false;
            }
            if (formatChar == '.') {
                formatChar = arr[++k];
                setPrecision = true;
            }
            if (Character.isDigit(formatChar)) {
                Character c = Character.valueOf(formatChar);
                String s = c.toString();
                int i = Integer.parseInt(s);
                if (setPrecision) {
                    formatter.setMinimumFractionDigits(i);
                    formatter.setMaximumFractionDigits(i);
                } else {
                    formatter.setMinimumIntegerDigits(i);
                }
            }
            switch (formatChar) {
                case 'd': {
                    formatedStr = formatter.format(new Double(cSource).intValue());
                    if (paddingAsZero) continue block6;
                    formatedStr = this.replaceLeadingZeros(formatedStr, weird);
                    continue block6;
                }
                case 'x': {
                    formatedStr = Integer.toHexString(Integer.parseInt(cSource));
                    continue block6;
                }
                case 's': {
                    formatedStr = cSource;
                    continue block6;
                }
                case 'f': {
                    if (showalternate) {
                        ((DecimalFormat)formatter).setDecimalSeparatorAlwaysShown(true);
                    }
                    formatedStr = formatter.format(new Double(cSource));
                    if (paddingAsZero) continue block6;
                    formatedStr = this.replaceLeadingZeros(formatedStr, weird);
                }
            }
        }
        return formatedStr;
    }

    public String printd(String format, Object dateStr, Object bXFAPicture) throws PDFInvalidParameterException {
        SimpleDateFormat formatter = (SimpleDateFormat)DateFormat.getDateTimeInstance();
        if (format.length() == 1 && ("0".equals(format) || "1".equals(format) || "2".equals(format))) {
            if (Integer.parseInt(format) == 0) {
                formatter = new SimpleDateFormat("G:yyyyMMddHHmmssZ");
            }
            if (Integer.parseInt(format) == 1) {
                formatter = new SimpleDateFormat("G:yyyyMMddHHmmssZ");
            }
            if (Integer.parseInt(format) == 2) {
                formatter = new SimpleDateFormat("yyyy/MM/dd  HH:mm:ss a", ((Doc)this.getParentScope()).getActiveDocument().getCosDocument().getOptions().getDocLocale());
            }
        } else {
            StringBuilder bs = new StringBuilder();
            if (this.contains(format, "dddd")) {
                format = this.replace("dddd", "EEEE", format);
            } else if (this.contains(format, "ddd")) {
                format = this.replace("ddd", "EEE", format);
            }
            for (int i = 0; i < format.length(); ++i) {
                if (format.charAt(i) == 'm') {
                    bs.append(Character.toUpperCase(format.charAt(i)));
                    continue;
                }
                if (format.charAt(i) == 'M') {
                    bs.append(Character.toLowerCase(format.charAt(i)));
                    continue;
                }
                if (format.charAt(i) == 't') {
                    bs.append('a');
                    continue;
                }
                bs.append(format.charAt(i));
            }
            try {
                formatter = new SimpleDateFormat(bs.toString(), ((Doc)this.getParentScope()).getActiveDocument().getCosDocument().getOptions().getDocLocale());
            }
            catch (IllegalArgumentException e) {
                throw new PDFInvalidParameterException(" The Date format " + bs.toString() + " contains illegeal characters", e);
            }
        }
        if (dateStr != null) {
            Date date = (Date)Context.jsToJava((Object)dateStr, Date.class);
            String s = formatter.format(date);
            if (this.contains(format, "t") && !this.contains(format, "tt") && (this.contains(s, "AM") || this.contains(s, "PM"))) {
                s = this.replace("AM", "a", s);
                s = this.replace("PM", "p", s);
            }
            return s;
        }
        return null;
    }

    public String replaceLeadingZeros(String str, boolean weird) {
        if (str == null) {
            return null;
        }
        char[] chars = str.toCharArray();
        for (int index = 0; index < str.length() - 1; ++index) {
            if (chars[index] == '+' || chars[index] == '-') {
                chars[index] = chars[index];
                continue;
            }
            if (chars[index + 1] == '.' && !weird || chars[index + 1] == ',' && weird || chars[index] != '0' && chars[index] != '.' && chars[index] != ',') break;
            chars[index] = 32;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(chars);
        if (sb.charAt(0) == '+' || sb.charAt(0) == '-') {
            return this.moveSign(sb);
        }
        return sb.toString();
    }

    private String moveSign(StringBuilder sb) {
        StringBuilder sb1 = new StringBuilder();
        boolean signed = false;
        if (sb.charAt(0) == '+' || sb.charAt(0) == '-') {
            char sign = sb.charAt(0);
            for (int i = 0; i < sb.length(); ++i) {
                if (sb.charAt(i) == '+' || sb.charAt(i) == '-') continue;
                if (sb.charAt(i) == ' ') {
                    sb1.append(sb.charAt(i));
                    continue;
                }
                if (!signed) {
                    sb1.append(sign);
                }
                signed = true;
                sb1.append(sb.charAt(i));
            }
        }
        return sb1.toString();
    }

    public String printx(String cFormat, String cSource) {
        StringBuilder sBuff = new StringBuilder();
        boolean formatPresent = false;
        char[] arr = cFormat.toCharArray();
        int fp = 0;
        int ct = 0;
        int j = 0;
        block11: for (int k = 0; k < arr.length && j < cSource.length(); ++j, ++k) {
            char formatChar = arr[k];
            if (formatPresent) {
                j = k - fp;
            }
            switch (formatChar) {
                case '?': {
                    if (sBuff.length() == cSource.length()) continue block11;
                    sBuff.append(cSource.charAt(j));
                    continue block11;
                }
                case 'X': {
                    int x;
                    for (x = j; x < cSource.length() && Character.isLetterOrDigit(cSource.charAt(x)); ++x) {
                        ++ct;
                    }
                    if (!Character.isLetterOrDigit(cSource.charAt(j))) continue block11;
                    sBuff.append(cSource.charAt(j));
                    continue block11;
                }
                case '9': {
                    int x;
                    for (x = j; x < cSource.length() && !Character.isDigit(cSource.charAt(x)); ++x) {
                        ++ct;
                    }
                    if (!Character.isDigit(cSource.charAt(j))) continue block11;
                    sBuff.append(cSource.charAt(j));
                    continue block11;
                }
                case 'A': {
                    int x;
                    for (x = j; x < cSource.length() && Character.isLetter(cSource.charAt(x)); ++x) {
                        ++ct;
                    }
                    if (!Character.isLetter(cSource.charAt(j))) continue block11;
                    sBuff.append(cSource.charAt(j));
                    continue block11;
                }
                case '*': {
                    int x;
                    for (x = ct; x < cSource.length(); ++x) {
                        sBuff.append(cSource.charAt(x));
                    }
                    continue block11;
                }
                case '\\': {
                    ++k;
                    sBuff.append(cSource.charAt(j));
                    continue block11;
                }
                case '=': {
                    sBuff.append(cSource.charAt(j));
                    continue block11;
                }
                case '<': {
                    int x;
                    for (x = j; x < cSource.length() && x + 1 < cSource.length() && cFormat.charAt(x + 1) != '='; ++x) {
                        sBuff.append(Character.toLowerCase(cSource.charAt(x)));
                    }
                    continue block11;
                }
                case '>': {
                    int x;
                    for (x = j; x < cSource.length(); ++x) {
                        if (cFormat.charAt(x) == '=') {
                            j = x;
                            continue block11;
                        }
                        sBuff.append(Character.toUpperCase(cSource.charAt(x)));
                    }
                    continue block11;
                }
                default: {
                    sBuff.append(formatChar);
                    formatPresent = true;
                    ++fp;
                }
            }
        }
        return sBuff.toString();
    }

    public Object scand(String format, String dateStr) {
        Scriptable scope = this.getParentScope();
        org.mozilla.javascript.Function scand = (org.mozilla.javascript.Function)scope.get("AFParseDateEx", scope);
        return scand.call(Context.getCurrentContext(), scope, null, new Object[]{dateStr, format});
    }

    public void spansToXML(Object arg2) {
        throw new UnsupportedJavaScriptFeatureException(" Unimplemented javascript execution feature # spansToXML ");
    }

    public ReadStream streamFromString(String cString, String charSet) {
        ReadStream rs = new ReadStream();
        if (charSet == null) {
            charSet = "UTF-8";
        }
        if (charSet.equalsIgnoreCase("utf-8")) {
            charSet = "UTF-8";
        }
        try {
            ByteArrayInputStream Bis1 = new ByteArrayInputStream(cString.getBytes(charSet));
            rs.setReadstream(Bis1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 unsupported??", e);
        }
        return rs;
    }

    public String stringFromStream(ReadStream stream, String charset) throws PDFInvalidDocumentException {
        try {
            int n;
            ByteArrayInputStream Bis1 = stream.getReadstream();
            StringBuilder out = new StringBuilder();
            byte[] b = new byte[4096];
            while ((n = Bis1.read(b)) != -1) {
                out.append(new String(b, 0, n));
            }
            return out.toString();
        }
        catch (IOException e) {
            throw new PDFInvalidDocumentException(e);
        }
    }

    public void xmlToSpans(Object xml) {
        throw new UnsupportedJavaScriptFeatureException(" Unimplemented javascript execution feature # xmlToSpans ");
    }

    public boolean contains(String original, CharSequence s) {
        return original.indexOf(s.toString()) > -1;
    }

    public String replace(CharSequence target, CharSequence replacement, String format) {
        return Pattern.compile(target.toString(), 2).matcher(format).replaceAll(replacement.toString());
    }

    public Console getConsole() {
        return (Console)((Object)this.getParentScope().get("console", this.getParentScope()));
    }

    static String[] inputValidation(Object input) {
        int i;
        Object jsInput;
        String[] inInput = null;
        if (input instanceof Scriptable) {
            jsInput = Context.getCurrentContext().getElements((Scriptable)input);
            inInput = new String[((Object[])jsInput).length];
            for (i = 0; i < ((Object)jsInput).length; ++i) {
                inInput[i] = (String)jsInput[i];
            }
        }
        if (inInput == null) {
            jsInput = String.valueOf(input);
            inInput = new String[((String)jsInput).length()];
            for (i = 0; i < ((String)jsInput).length(); ++i) {
                inInput[i] = ((String)jsInput).substring(i, i + 1);
            }
        }
        return inInput;
    }

    static String[] processDelegator(String[] input, int index, Object value) {
        if (input != null) {
            if (index >= input.length) {
                String[] inputArray = new String[index + 1];
                System.arraycopy(input, 0, inputArray, 0, input.length);
                inputArray[index] = (String)value;
                return inputArray;
            }
            input[index] = (String)value;
            return input;
        }
        return null;
    }

    static String getJavaScriptArray(Object value, JavaScriptHandler javaScriptHandler) {
        int i;
        NativeArray nativeArray = (NativeArray)value;
        Object[] propertyArray = null;
        try {
            propertyArray = (Object[])JSUtils.scriptableToJava((ScriptableObject)nativeArray, (Context)Context.getCurrentContext());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        StringBuilder property = new StringBuilder("");
        for (i = 0; i < propertyArray.length - 1; ++i) {
            property.append(propertyArray[i].toString()).append(",");
        }
        property.append(propertyArray[i].toString());
        return property.toString();
    }
}

