/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.javascript;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.services.javascript.Color;
import com.adobe.internal.pdftoolkit.services.javascript.Doc;
import com.adobe.internal.pdftoolkit.services.javascript.EventObject;
import com.adobe.internal.pdftoolkit.services.javascript.JavaScriptHandler;
import com.adobe.internal.pdftoolkit.services.javascript.model.ESObject;
import com.adobe.internal.pdftoolkit.services.javascript.model.Function;
import com.adobe.internal.pdftoolkit.services.javascript.model.JSUtils;
import com.adobe.internal.pdftoolkit.services.javascript.model.Param;
import com.adobe.internal.pdftoolkit.services.javascript.model.Property;
import com.adobe.internal.pdftoolkit.services.javascript.model.ScriptTable;
import com.adobe.internal.pdftoolkit.services.javascript.model.manual.XFAFieldParams;
import com.adobe.internal.pdftoolkit.services.xfa.form.DocumentContext;
import com.adobe.internal.pdftoolkit.services.xfa.form.Utils;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Bool;
import com.adobe.xfa.Element;
import com.adobe.xfa.EnumValue;
import com.adobe.xfa.Int;
import com.adobe.xfa.Measurement;
import com.adobe.xfa.Model;
import com.adobe.xfa.Node;
import com.adobe.xfa.NodeList;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.content.ExDataValue;
import com.adobe.xfa.content.TextValue;
import com.adobe.xfa.form.FormField;
import com.adobe.xfa.layout.AcroFormLayout;
import com.adobe.xfa.layout.LayoutNode;
import com.adobe.xfa.service.renderer.FormUtils;
import com.adobe.xfa.template.Items;
import com.adobe.xfa.template.Value;
import com.adobe.xfa.template.containers.ExclGroup;
import com.adobe.xfa.template.containers.Field;
import com.adobe.xfa.template.containers.Rotate;
import com.adobe.xfa.template.ui.DateTimeEdit;
import com.adobe.xfa.template.ui.TextEdit;
import com.adobe.xfa.template.ui.UI;
import com.adobe.xfa.ut.Angle;
import com.adobe.xfa.ut.UnitSpan;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class XFAField
extends ESObject {
    protected static final ScriptTable scriptTable = new ScriptTable("XFAField.class", (HashMap)new HashMap<String, Function>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("clear", new Function(XFAField.class, "clear", Param.Type.Object, XFAFieldParams.clear, 0, false, false));
            this.put("clearItems", new Function(XFAField.class, "clearItems", Param.Type.Object, XFAFieldParams.clearItems, 0, false, false));
            this.put("deleteItemAt", new Function(XFAField.class, "deleteItemAt", Param.Type.Object, XFAFieldParams.deleteItemAt, 1, false, false));
            this.put("getItemAt", new Function(XFAField.class, "getItemAt", Param.Type.Object, XFAFieldParams.getItemAt, 2, false, false));
            this.put("insertItemAt", new Function(XFAField.class, "insertItemAt", Param.Type.Object, XFAFieldParams.insertItemAt, 3, false, false));
            this.put("isBoxChecked", new Function(XFAField.class, "isBoxChecked", Param.Type.Object, XFAFieldParams.isBoxChecked, 1, false, false));
            this.put("isDefaultChecked", new Function(XFAField.class, "isDefaultChecked", Param.Type.Object, XFAFieldParams.isDefaultChecked, 1, false, false));
            this.put("setFocus", new Function(XFAField.class, "setFocus", Param.Type.Object, XFAFieldParams.setFocus, 0, false, false));
            this.put("setItems", new Function(XFAField.class, "setItems", Param.Type.Object, XFAFieldParams.setItems, 1, false, false));
        }
    }, (HashMap)new HashMap<String, Property>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("rotation", new Property(XFAField.class, "rotation", "getRotation", "setRotation", XFAFieldParams.rotation, false, false));
            this.put("alignment", new Property(XFAField.class, "alignment", "getAlignment", "setAlignment", XFAFieldParams.alignment, false, false));
            this.put("numItems", new Property(XFAField.class, "numItems", "getNumItems", null, null, false, false));
            this.put("strokeColor", new Property(XFAField.class, "strokeColor", "getStrokeColor", "setStrokeColor", XFAFieldParams.strokeColor, false, false));
            this.put("multiline", new Property(XFAField.class, "multiline", "getMultiline", "setMultiline", XFAFieldParams.multiline, false, false));
            this.put("comb", new Property(XFAField.class, "comb", "getComb", "setComb", XFAFieldParams.comb, false, false));
            this.put("lineWidth", new Property(XFAField.class, "lineWidth", "getLineWidth", "setLineWidth", XFAFieldParams.lineWidth, false, false));
            this.put("multipleSelection", new Property(XFAField.class, "multipleSelection", "getMultipleSelection", "setMultipleSelection", XFAFieldParams.multipleSelection, false, false));
            this.put("password", new Property(XFAField.class, "password", "getPassword", null, null, false, false));
            this.put("defaultValue", new Property(XFAField.class, "defaultValue", "getDefaultValue", null, null, false, false));
            this.put("valueAsString", new Property(XFAField.class, "valueAsString", "getValueAsString", null, null, false, false));
            this.put("commitOnSelChange", new Property(XFAField.class, "commitOnSelChange", null, "setCommitOnSelChange", XFAFieldParams.commitOnSelChange, false, false));
            this.put("fgColor", new Property(XFAField.class, "fgColor", "getFgColor", "setFgColor", XFAFieldParams.fgColor, false, false));
            this.put("highlight", new Property(XFAField.class, "highlight", "getHighlight", "setHighlight", XFAFieldParams.highlight, false, false));
            this.put("textSize", new Property(XFAField.class, "textSize", "getTextSize", "setTextSize", XFAFieldParams.textSize, false, false));
            this.put("textFont", new Property(XFAField.class, "textFont", "getTextFont", "setTextFont", XFAFieldParams.textFont, false, false));
            this.put("doc", new Property(XFAField.class, "doc", "getDoc", null, null, false, false));
            this.put("editable", new Property(XFAField.class, "editable", "getEditable", "setEditable", XFAFieldParams.editable, false, false));
            this.put("borderStyle", new Property(XFAField.class, "borderStyle", "getBorderStyle", "setBorderStyle", XFAFieldParams.borderStyle, false, false));
            this.put("print", new Property(XFAField.class, "print", "getPrint", "setPrint", XFAFieldParams.print, false, false));
            this.put("value", new Property(XFAField.class, "value", "getValue", null, null, false, false));
            this.put("type", new Property(XFAField.class, "type", "getType", null, null, false, false));
            this.put("charLimit", new Property(XFAField.class, "charLimit", "getCharLimit", "setCharLimit", XFAFieldParams.charLimit, false, false));
            this.put("textColor", new Property(XFAField.class, "textColor", "getTextColor", "setTextColor", XFAFieldParams.textColor, false, false));
            this.put("readonly", new Property(XFAField.class, "readonly", "getReadonly", "setReadonly", XFAFieldParams.readonly, false, false));
            this.put("bgColor", new Property(XFAField.class, "bgColor", "getBgColor", "setBgColor", XFAFieldParams.bgColor, false, false));
            this.put("display", new Property(XFAField.class, "display", "getDisplay", "setDisplay", XFAFieldParams.display, false, false));
            this.put("currentValueIndices", new Property(XFAField.class, "currentValueIndices", "getCurrentValueIndices", "setCurrentValueIndices", XFAFieldParams.currentValueIndices, false, false));
            this.put("commitOnSelChange", new Property(XFAField.class, "commitOnSelChange", "getCommitOnSelChange", null, null, false, false));
            this.put("userName", new Property(XFAField.class, "userName", "getUserName", null, null, false, false));
            this.put("hidden", new Property(XFAField.class, "hidden", "getHidden", "setHidden", XFAFieldParams.hidden, false, false));
            this.put("richText", new Property(XFAField.class, "richText", "getRichText", "setRichText", XFAFieldParams.richText, false, false));
            this.put("required", new Property(XFAField.class, "required", "getRequired", "setRequired", XFAFieldParams.required, false, false));
            this.put("style", new Property(XFAField.class, "style", "getStyle", "setStyle", XFAFieldParams.style, false, false));
            this.put("borderWidth", new Property(XFAField.class, "borderWidth", "getBorderWidth", "setBorderWidth", XFAFieldParams.borderWidth, false, false));
            this.put("doNotScroll", new Property(XFAField.class, "doNotScroll", "getDoNotScroll", "setDoNotScroll", XFAFieldParams.doNotScroll, false, false));
            this.put("name", new Property(XFAField.class, "name", "getName", null, null, false, false));
            this.put("borderColor", new Property(XFAField.class, "borderColor", "getBorderColor", "setBorderColor", XFAFieldParams.borderColor, false, false));
            this.put("fillColor", new Property(XFAField.class, "fillColor", "getFillColor", "setFillColor", XFAFieldParams.fillColor, false, false));
        }
    });
    private static final long serialVersionUID = -387370036770203321L;
    private static final String[] gAlign = new String[]{"left", "center", "right"};
    private static final String[] gBorderStyle = new String[]{"solid", "dashed", "beveled", "inset", "underline"};
    private static final String[] gStyle = new String[]{"check", "circle", "cross", "diamond", "square", "star"};
    private static HashMap<JSUtils.ESTriggerType, String> valid = new HashMap();
    private static final int ESErrorInvalidRange = 1;
    private static final int ESErrorInvalidArgType = 2;
    private static final int ESErrorReference = 3;
    private static final int ESErrorMissingRequiredArg = 4;
    private static final int ESErrorNumberOfArgs = 5;
    private static final int ESErrorInvalidArgs = 6;
    private static final int ESErrorInvalidPropertyGet = 7;
    private static final int ESErrorInvalidPropertySet = 8;
    private static final int ESErrorOutOfMemory = 9;
    private static final int ESErrorNotSupported = 10;
    private static final int ESErrorNotSupportedHFT = 11;
    private static final int ESErrorNotAllowed = 12;
    private static final int ESErrorRaise = 13;
    private static final int ESErrorDeadObject = 14;
    private static final int ESErrorGeneral = 15;
    private static final int ESErrorHelp = 16;
    private static final int ESErrorUnsupportedValue = 17;
    private static final int ESErrorParamNum = 18;
    private static final int ESErrorParamName = 19;
    private static final int ESErrorNumArgs = 20;
    private static final int ESErrorHelpParam = 21;
    private static final int ESErrorIndent = 22;
    private static final String[] ESExceptionMap;
    private static final String PUSH_STR = "push";
    private static final String NONE_STR = "none";
    private static final String INVERT_STR = "invert";
    private static final String OUTLINE_STR = "outline";
    private PDFDocument pddoc;
    private String SOMPath;
    private int iWidget = -1;
    private int isRadioButton = -1;

    public Object get(String name, Scriptable start) {
        return super.get(name, start);
    }

    protected ScriptTable getScriptTable() {
        return scriptTable;
    }

    public XFAField() {
    }

    private XFAField(PDFDocument pddoc, String SOMPath) {
        this.pddoc = pddoc;
        this.setParentScope((Scriptable)JavaScriptHandler.getRegisteredInstance(pddoc).getDocLevelScope());
        this.SOMPath = SOMPath;
    }

    static XFAField create(PDFDocument pddoc, String path) {
        StringBuilder sPath;
        XFAField res = null;
        DocumentContext oDocContext = XFAField.getContext(pddoc);
        if (oDocContext != null && Utils.scrubFieldName(sPath = new StringBuilder(path)) && !(res = new XFAField(pddoc, sPath.toString())).initOK()) {
            res = null;
            int iWidget = Utils.separateFieldNameFromWidgetNum(sPath, '.');
            if (iWidget >= 0 && !(res = new XFAField(pddoc, sPath.toString())).initOK()) {
                res = null;
            }
        }
        return res;
    }

    public String getClassName() {
        return "XFAField";
    }

    public Object getAlignment() {
        Object jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        boolean bStatus = true;
        try {
            FormField oFormField;
            Element oUIChild = this.getUIChild();
            if (oUIChild != null && (oFormField = this.getNode(-1, -1, false)) != null) {
                if (oUIChild instanceof TextEdit || oUIChild instanceof DateTimeEdit || oUIChild.isSameClass(XFA.NUMERICEDITTAG) || oUIChild.isSameClass(XFA.PASSWORDEDITTAG)) {
                    Element oPara = oFormField.getElement(XFA.PARATAG, 0);
                    if (oPara != null) {
                        int hAlign = oPara.getEnum(XFA.HALIGNTAG);
                        int iAlignment = 0;
                        if (hAlign == 0x160001) {
                            iAlignment = 1;
                        } else if (hAlign == 1441794) {
                            iAlignment = 2;
                        }
                        jsv = gAlign[iAlignment & 3];
                    }
                } else {
                    bStatus = false;
                }
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(null, 7));
    }

    public void setAlignment(Object args) {
        int iAlignment;
        if (this.isObjectDead()) {
            this.throwException(args, 14);
        }
        String cAlign = ScriptRuntime.toString((Object)args);
        for (iAlignment = 0; iAlignment < gAlign.length && !gAlign[iAlignment].equals(cAlign); ++iAlignment) {
        }
        boolean bStatus = true;
        if (iAlignment >= gAlign.length) {
            bStatus = false;
        } else {
            try {
                FormField oFormField;
                Element oUIChild = this.getUIChild();
                if (oUIChild != null && (oFormField = this.getNode(-1, -1, false)) != null) {
                    if (oUIChild instanceof TextEdit || oUIChild instanceof DateTimeEdit || oUIChild.isSameClass(XFA.NUMERICEDITTAG) || oUIChild.isSameClass(XFA.PASSWORDEDITTAG)) {
                        Element oPara = oFormField.getElement(XFA.PARATAG, 0);
                        if (oPara != null) {
                            int hAlign = iAlignment == 1 ? 0x160001 : (iAlignment == 2 ? 1441794 : 0x160000);
                            oPara.setAttribute(hAlign, XFA.HALIGNTAG);
                        }
                    } else {
                        bStatus = false;
                    }
                }
            }
            catch (Exception ex) {
                bStatus = false;
            }
        }
        if (!bStatus) {
            this.throwException(args, 8);
        }
    }

    public Object getBorderColor() {
        Object[] jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        boolean bStatus = true;
        try {
            Element oBorderNode;
            FormField oFormField;
            Element oUIChild = this.getUIChild(-1, -1, true);
            if (oUIChild != null && (oFormField = this.getNode(-1, -1, true)) != null && (oBorderNode = oUIChild.isSameClass(XFA.BUTTONTAG) ? oFormField.getElement(XFA.BORDERTAG, 0) : oUIChild.getElement(XFA.BORDERTAG, 0)) != null) {
                boolean bColorDefault;
                com.adobe.xfa.template.formatting.Color oEdgeColor;
                Element oEdge = oBorderNode.peekElement(XFA.EDGETAG, false, 0);
                jsv = oEdge != null ? ((oEdgeColor = (com.adobe.xfa.template.formatting.Color)oEdge.peekElement(XFA.COLORTAG, bColorDefault = oUIChild.isSameClass(XFA.BUTTONTAG), 0)) != null ? ((List)Utils.getRGBColorObject(oEdgeColor.getRed(), oEdgeColor.getGreen(), oEdgeColor.getBlue())).toArray() : new Object[]{"T"}) : new Object[]{"T"};
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        if (!bStatus) {
            this.throwException(null, 7);
        }
        return jsv != null ? Context.getCurrentContext().newArray(this.getParentScope(), jsv) : null;
    }

    public void setBorderColor(Object args) {
        if (this.isObjectDead()) {
            this.throwException(args, 14);
        }
        if (!this.formModifyOkay(true)) {
            this.throwException(args, 12);
        }
        Color borC = null;
        try {
            Object[] arr = null;
            if (ScriptRuntime.isArrayObject((Object)args)) {
                arr = ScriptRuntime.getArrayElements((Scriptable)((Scriptable)args));
            }
            borC = Utils.unloadColor(arr);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (borC == null) {
            this.throwException(args, 8);
        }
        Object[] rgb = Utils.getRGBColorValue(borC);
        boolean bStatus = true;
        try {
            Element oBorder;
            FormField oFormField;
            Element oUIChild = this.getUIChild();
            if (oUIChild != null && (oFormField = this.getNode(-1, -1, false)) != null && (oBorder = oUIChild.isSameClass(XFA.BUTTONTAG) ? oFormField.getElement(XFA.BORDERTAG, 0) : oUIChild.getElement(XFA.BORDERTAG, 0)) != null) {
                Element oEdge;
                int i = 0;
                while ((oEdge = oBorder.peekElement(XFA.EDGETAG, false, i)) != null && (oEdge = oBorder.getElement(XFA.EDGETAG, i)) != null) {
                    com.adobe.xfa.template.formatting.Color xfaColor = (com.adobe.xfa.template.formatting.Color)oEdge.getElement(XFA.COLORTAG, 0);
                    xfaColor.setColor((int)((Double)rgb[1] * 255.0), (int)((Double)rgb[2] * 255.0), (int)((Double)rgb[3] * 255.0));
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        if (!bStatus) {
            this.throwException(args, 8);
        }
    }

    public Object getBorderStyle() {
        Object jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        boolean bStatus = true;
        try {
            Element oEdge;
            Element oBorderNode;
            FormField oFormField;
            Element oUIChild = this.getUIChild(-1, -1, true);
            if (oUIChild != null && (oFormField = this.getNode(-1, -1, true)) != null && (oBorderNode = oUIChild.isSameClass(XFA.BUTTONTAG) ? oFormField.getElement(XFA.BORDERTAG, 0) : oUIChild.getElement(XFA.BORDERTAG, 0)) != null && (oEdge = oBorderNode.getElement(XFA.EDGETAG, 0)) != null) {
                int eEdgeStroke = oEdge.getEnum(XFA.STROKETAG);
                int iStyle = 0;
                if (eEdgeStroke == 0x330006 || eEdgeStroke == 0x330004) {
                    iStyle = 2;
                } else if (eEdgeStroke == 0x330005 || eEdgeStroke == 0x330003) {
                    iStyle = 3;
                } else if (eEdgeStroke == 0x330001 || eEdgeStroke == 0x330002 || eEdgeStroke == 0x330007 || eEdgeStroke == 0x330008) {
                    iStyle = 0;
                    Measurement oBorderThickness = new Measurement(oEdge.getAttribute(XFA.THICKNESSTAG));
                    double dEdgeThickness = oBorderThickness.getValueAsUnit(0x3C0000);
                    if (dEdgeThickness > 0.0) {
                        iStyle = 1;
                    }
                } else {
                    iStyle = 0;
                }
                jsv = gBorderStyle[iStyle];
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(null, 7));
    }

    public void setBorderStyle(Object args) {
        int iStyle;
        if (this.isObjectDead()) {
            this.throwException(args, 14);
        }
        if (!this.formModifyOkay(true)) {
            this.throwException(args, 12);
        }
        String style = ScriptRuntime.toString((Object)args);
        for (iStyle = 0; iStyle < gBorderStyle.length && !gBorderStyle[iStyle].equalsIgnoreCase(style); ++iStyle) {
        }
        boolean bStatus = true;
        if (iStyle >= gBorderStyle.length) {
            bStatus = false;
        } else {
            try {
                Element oBorder;
                FormField oFormField;
                Element oUIChild = this.getUIChild();
                if (oUIChild != null && (oFormField = this.getNode(-1, -1, false)) != null && (oBorder = oUIChild.isSameClass(XFA.BUTTONTAG) ? oFormField.getElement(XFA.BORDERTAG, 0) : oUIChild.getElement(XFA.BORDERTAG, 0)) != null) {
                    Element oEdge;
                    int i = 0;
                    while ((oEdge = oBorder.peekElement(XFA.EDGETAG, false, i)) != null && (oEdge = oBorder.getElement(XFA.EDGETAG, i)) != null) {
                        int eEdgeStroke = iStyle == 2 ? 0x330006 : (iStyle == 3 ? 0x330005 : (iStyle == 1 ? 0x330001 : 0x330000));
                        oEdge.setAttribute(eEdgeStroke, XFA.STROKETAG);
                        ++i;
                    }
                }
            }
            catch (Exception ex) {
                bStatus = false;
            }
        }
        if (!bStatus) {
            this.throwException(args, 8);
        }
    }

    public Object getCharLimit() {
        Comparable<Boolean> jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        boolean bStatus = true;
        try {
            FormField oFormField;
            Element oUIChild = this.getUIChild();
            if (oUIChild != null && (oFormField = this.getNode(-1, -1, false)) != null) {
                if (oUIChild instanceof TextEdit || oUIChild instanceof DateTimeEdit || oUIChild.isSameClass(XFA.NUMERICEDITTAG) || oUIChild.isSameClass(XFA.PASSWORDEDITTAG)) {
                    int nMaxLen = 0;
                    if (oUIChild.isPropertySpecified(XFA.COMBTAG, true, 0)) {
                        Element oComb = (Element)oUIChild.getProperty(XFA.COMBTAG, 0);
                        Int oNumCells = (Int)oComb.getAttribute(XFA.NUMBEROFCELLSTAG);
                        nMaxLen = oNumCells.getValue();
                    } else {
                        Int oMaxChars;
                        Node oContent;
                        Element value = oFormField.getElement(XFA.VALUETAG, 0);
                        if (value != null && (oContent = value.getOneOfChild()) != null && oContent.isSameClass(XFA.TEXTTAG) && (oMaxChars = (Int)((Element)oContent).getAttribute(XFA.MAXCHARSTAG)) != null) {
                            nMaxLen = oMaxChars.getValue();
                        }
                    }
                    jsv = nMaxLen;
                } else {
                    bStatus = false;
                }
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(null, 7));
    }

    public void setCharLimit(Object args) {
        int jsn;
        if (this.isObjectDead()) {
            this.throwException(args, 14);
        }
        if (!this.formModifyOkay(true)) {
            this.throwException(args, 12);
        }
        if ((jsn = ScriptRuntime.toInt32((Object)args)) < 1) {
            this.throwException(args, 1);
        }
        boolean bStatus = false;
        try {
            FormField oFormField;
            Element oUIChild = this.getUIChild();
            if (oUIChild != null && (oFormField = this.getNode(-1, -1, false)) != null) {
                if (oUIChild instanceof DateTimeEdit || oUIChild.isSameClass(XFA.NUMERICEDITTAG)) {
                    bStatus = true;
                } else if (oUIChild instanceof TextEdit || oUIChild.isSameClass(XFA.PASSWORDEDITTAG)) {
                    if (oUIChild.isPropertySpecified(XFA.COMBTAG, true, 0)) {
                        Element oComb = (Element)oUIChild.getProperty(XFA.COMBTAG, 0);
                        oComb.setAttribute(new Int("numberOfCells", jsn), XFA.NUMBEROFCELLSTAG);
                        bStatus = true;
                    } else {
                        Element value = oFormField.getElement(XFA.VALUETAG, 0);
                        Element oContent = value.getElement(XFA.TEXTTAG, 0);
                        oContent.setAttribute(new Int("maxChars", jsn), XFA.MAXCHARSTAG);
                        bStatus = true;
                    }
                }
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        if (!bStatus) {
            this.throwException(null, 8);
        }
    }

    public Object getComb() {
        Boolean jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        boolean bStatus = false;
        try {
            Element oUIChild = this.getUIChild();
            if (oUIChild != null) {
                if (oUIChild instanceof TextEdit || oUIChild instanceof DateTimeEdit || oUIChild.isSameClass(XFA.NUMERICEDITTAG) || oUIChild.isSameClass(XFA.PASSWORDEDITTAG)) {
                    Element oComb;
                    boolean bCombField = false;
                    bCombField = oUIChild.isPropertySpecified(XFA.COMBTAG, true, 0) ? (oComb = (Element)oUIChild.getProperty(XFA.COMBTAG, 0)) != null : (oComb = oUIChild.peekElement(XFA.COMBTAG, false, 0)) != null;
                    jsv = bCombField;
                    bStatus = true;
                } else {
                    bStatus = false;
                }
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(null, 7));
    }

    public void setComb(Object args) {
        if (this.isObjectDead()) {
            this.throwException(args, 14);
        }
        if (!this.formModifyOkay(false)) {
            this.throwException(args, 12);
        }
        boolean bStatus = false;
        boolean bComb = ScriptRuntime.toBoolean((Object)args);
        try {
            Element oUIChild = this.getUIChild();
            if (oUIChild != null && (oUIChild instanceof TextEdit || oUIChild instanceof DateTimeEdit || oUIChild.isSameClass(XFA.NUMERICEDITTAG))) {
                Element oComb = oUIChild.peekElement(XFA.COMBTAG, false, 0);
                Model oModel = oUIChild.getModel();
                if (bComb && oComb == null) {
                    Element oCombNode = oModel.createElement(XFA.COMBTAG, null);
                    oUIChild.setProperty((Object)oCombNode, XFA.COMBTAG);
                    Element oBorderNode = oUIChild.getElement(XFA.BORDERTAG, 0);
                    if (oBorderNode != null) {
                        oBorderNode.setAttribute(0x170001, XFA.HANDTAG);
                    }
                } else if (!bComb && oComb != null) {
                    oComb.remove();
                    Element oBorderNode = oUIChild.getElement(XFA.BORDERTAG, 0);
                    if (oBorderNode != null) {
                        oBorderNode.removeAttr(null, "hand");
                    }
                }
                bStatus = true;
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        if (!bStatus) {
            this.throwException(args, 8);
        }
    }

    public Object getCommitOnSelChange() {
        Boolean jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        boolean bStatus = false;
        try {
            Element oUIChild = this.getUIChild();
            if (oUIChild != null && oUIChild.isSameClass(XFA.CHOICELISTTAG)) {
                boolean bCommitOnSelChange = false;
                int eCommitOnSelChange = oUIChild.getEnum(XFA.COMMITONTAG);
                bCommitOnSelChange = eCommitOnSelChange == 6619137;
                jsv = bCommitOnSelChange;
                bStatus = true;
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(null, 7));
    }

    public void setCommitOnSelChange(Object args) {
        if (this.isObjectDead()) {
            this.throwException(args, 14);
        }
        if (!this.formModifyOkay(true)) {
            this.throwException(args, 12);
        }
        boolean bStatus = false;
        boolean bCommitOnSelChange = ScriptRuntime.toBoolean((Object)args);
        try {
            Element oUIChild = this.getUIChild();
            if (oUIChild != null && oUIChild.isSameClass(XFA.CHOICELISTTAG)) {
                if (bCommitOnSelChange) {
                    oUIChild.setAttribute(6619137, XFA.COMMITONTAG);
                } else {
                    oUIChild.setAttribute(0x650000, XFA.COMMITONTAG);
                }
                bStatus = true;
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        if (!bStatus) {
            this.throwException(args, 8);
        }
    }

    public Object getCurrentValueIndices() {
        FormField oFormField;
        Comparable<Boolean> jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        boolean bStatus = false;
        Element oUIChild = this.getUIChild();
        if (oUIChild != null && (oFormField = this.getNode(-1, -1, false)) != null && oUIChild.isSameClass(XFA.CHOICELISTTAG)) {
            Field.ItemPair itemPair = new Field.ItemPair();
            oFormField.getItemLists(true, itemPair, false);
            Items oDisplayItem = itemPair.mDisplayItems;
            if (oDisplayItem == null) {
                jsv = -1;
            } else {
                ArrayList<String> oItemList = new ArrayList<String>();
                for (Node child = oDisplayItem.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                    if (child.isSameClass(XFA.TEXTTAG)) {
                        TextNode textNode = ((Element)child).getText(true, false, false);
                        oItemList.add(textNode != null ? textNode.getValue() : "");
                        continue;
                    }
                    oItemList.add("");
                }
                ArrayList<String> oSelList = new ArrayList<String>();
                if (oFormField.isPropertySpecified(XFA.VALUETAG, true, 0)) {
                    Element oValue = oFormField.getElement(XFA.VALUETAG, 0);
                    Node oValueContent = oValue.getOneOfChild();
                    if (oValueContent.isSameClass(XFA.TEXTTAG)) {
                        TextNode textNode = ((Element)oValueContent).getText(true, false, false);
                        oSelList.add(textNode != null ? textNode.getValue() : "");
                    } else if (oValueContent instanceof ExDataValue) {
                        ExDataValue oExData = (ExDataValue)oValueContent;
                        oExData.getValues(oSelList);
                    }
                }
                if (oSelList.size() <= 0) {
                    jsv = -1;
                } else if (oSelList.size() == 1) {
                    int iSel = oItemList.indexOf(oSelList.get(0));
                    jsv = iSel;
                } else {
                    Object[] jsvs = new Object[oSelList.size()];
                    for (int i = 0; i < oSelList.size(); ++i) {
                        int iSel = oItemList.indexOf(oSelList.get(i));
                        jsvs[i] = iSel;
                    }
                    jsv = Context.getCurrentContext().newArray(this.getParentScope(), jsvs);
                }
            }
            bStatus = true;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(null, 7));
    }

    public void setCurrentValueIndices(Object args) {
        if (this.isObjectDead()) {
            this.throwException(args, 14);
        }
        boolean jsbNotAllowed = false;
        boolean bStatus = false;
        Element oUIChild = this.getUIChild();
        if (oUIChild != null) {
            boolean bMultiSelect = XFAField.isMultipleSelect(oUIChild);
            if (!DocumentContext.AFPDDocFillerIsOK(this.getPDDoc())) {
                jsbNotAllowed = true;
            } else {
                FormField oFormField = this.getNode(-1, -1, false);
                if (oFormField != null && oUIChild.isSameClass(XFA.CHOICELISTTAG)) {
                    Field.ItemPair itemPair = new Field.ItemPair();
                    oFormField.getItemLists(true, itemPair, false);
                    if (itemPair.mDisplayItems == null) {
                        bStatus = false;
                    } else {
                        Object[] argArray;
                        bStatus = true;
                        Items oDisplayItem = itemPair.mDisplayItems;
                        int nDisplayItems = oDisplayItem.getXFAChildCount();
                        int[] indices = null;
                        if (args instanceof Number) {
                            indices = new int[]{ScriptRuntime.toInt32((Object)args)};
                            if (indices[0] < 0 || indices[0] > nDisplayItems) {
                                bStatus = false;
                            }
                        } else if (ScriptRuntime.isArrayObject((Object)args) && ((argArray = ScriptRuntime.getArrayElements((Scriptable)((Scriptable)args))).length == 1 || argArray.length > 1 && bMultiSelect)) {
                            indices = new int[argArray.length];
                            for (int i = 0; i < argArray.length; ++i) {
                                indices[i] = ScriptRuntime.toInt32((Object)argArray[i]);
                                if (indices[i] >= 0 && indices[i] <= nDisplayItems && (i <= 0 || indices[i] > indices[i - 1])) continue;
                                bStatus = false;
                            }
                        }
                        if (indices == null) {
                            bStatus = false;
                        }
                        if (bStatus) {
                            ArrayList<String> oItemList = new ArrayList<String>();
                            for (Node child = oDisplayItem.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                                if (child.isSameClass(XFA.TEXTTAG)) {
                                    TextNode textNode = ((Element)child).getText(true, false, false);
                                    oItemList.add(textNode != null ? textNode.getValue() : "");
                                    continue;
                                }
                                oItemList.add("");
                            }
                            Value oValue = (Value)oFormField.getElement(XFA.VALUETAG, 0);
                            if (indices != null && indices.length == 1) {
                                Element oValueContent = oValue.replaceContent(XFA.TEXTTAG);
                                if (oValueContent instanceof TextValue) {
                                    ((TextValue)oValueContent).setValue((String)oItemList.get(indices[0]));
                                }
                            } else if (indices != null && indices.length > 1) {
                                ArrayList<String> oSelList = new ArrayList<String>();
                                for (int i = 0; i < indices.length; ++i) {
                                    oSelList.add((String)oItemList.get(indices[i]));
                                }
                                ExDataValue oExData = (ExDataValue)oValue.replaceContent(XFA.EXDATATAG);
                                oExData.setAttribute(new StringAttr("contentType", "text/xml"), XFA.CONTENTTYPETAG);
                                oExData.setValue(oSelList);
                            } else {
                                TextNode oValueChild = new TextNode(null, null, "");
                                oValue.setOneOfChild(oValueChild);
                            }
                        }
                    }
                }
            }
        }
        if (jsbNotAllowed) {
            this.throwException(args, 12);
        }
        if (!bStatus) {
            this.throwException(args, 8);
        }
    }

    public Object getDefaultValue() {
        Object jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        boolean bStatus = true;
        try {
            Field oTemplateField;
            FormField oFormField;
            Element oUIChild = this.getUIChild();
            if (oUIChild != null && (oFormField = this.getNode(-1, -1, false)) != null && (oTemplateField = (Field)oFormField.getProto()) != null) {
                boolean iCheckBox = false;
                boolean iRadioButton = false;
                if (oUIChild.isSameClass(XFA.CHECKBUTTONTAG)) {
                    Element oGroup = oFormField.getXFAParent();
                    if (!(oGroup instanceof ExclGroup)) {
                        iCheckBox = true;
                    } else {
                        iRadioButton = true;
                    }
                }
                if (oUIChild instanceof TextEdit || iRadioButton || oUIChild.isSameClass(XFA.CHOICELISTTAG)) {
                    jsv = "";
                } else if (iCheckBox) {
                    Element oDisplayItem = oFormField.getElement(XFA.ITEMSTAG, 0);
                    if (oDisplayItem != null && oDisplayItem.getXFAChildCount() > 1) {
                        TextNode textNode = ((Element)oDisplayItem.getXFAChild(1)).getText(false, false, false);
                        jsv = textNode.toString();
                    }
                } else {
                    String sFieldValue = oTemplateField.getRawValue();
                    jsv = sFieldValue;
                }
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(null, 7));
    }

    public Object getDoNotScroll() {
        Boolean jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        boolean bStatus = false;
        try {
            Element oUIChild = this.getUIChild();
            if (oUIChild != null && (oUIChild instanceof TextEdit || oUIChild instanceof DateTimeEdit || oUIChild.isSameClass(XFA.NUMERICEDITTAG) || oUIChild.isSameClass(XFA.PASSWORDEDITTAG))) {
                int hScroll;
                int vScroll;
                TextEdit te;
                boolean bDoNotScroll = false;
                if (oUIChild instanceof TextEdit && (te = (TextEdit)oUIChild).getEnum(XFA.MULTILINETAG) == 0x40040001 && (vScroll = te.getEnum(XFA.VSCROLLPOLICYTAG)) == 7536642) {
                    bDoNotScroll = true;
                }
                if ((hScroll = oUIChild.getEnum(XFA.HSCROLLPOLICYTAG)) == 7536642) {
                    bDoNotScroll = true;
                }
                jsv = bDoNotScroll;
                bStatus = true;
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(null, 7));
    }

    public void setDoNotScroll(Object args) {
        if (this.isObjectDead()) {
            this.throwException(args, 14);
        }
        if (!this.formModifyOkay(true)) {
            this.throwException(args, 12);
        }
        boolean bStatus = false;
        boolean bDoNotScroll = ScriptRuntime.toBoolean((Object)args);
        try {
            Element oUIChild = this.getUIChild();
            if (oUIChild != null) {
                int scrollValue;
                int n = scrollValue = bDoNotScroll ? 7536642 : 7536641;
                if (oUIChild instanceof TextEdit || oUIChild instanceof DateTimeEdit || oUIChild.isSameClass(XFA.NUMERICEDITTAG) || oUIChild.isSameClass(XFA.PASSWORDEDITTAG)) {
                    TextEdit te;
                    if (oUIChild instanceof TextEdit && (te = (TextEdit)oUIChild).getEnum(XFA.MULTILINETAG) == 0x40040001) {
                        te.setAttribute(scrollValue, XFA.VSCROLLPOLICYTAG);
                    }
                    oUIChild.setAttribute(scrollValue, XFA.HSCROLLPOLICYTAG);
                    bStatus = true;
                }
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        if (!bStatus) {
            this.throwException(args, 8);
        }
    }

    public Object getDisplay() {
        Comparable<Boolean> jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        boolean bStatus = true;
        try {
            FormField oFormField = this.getNode(-1, -1, true);
            if (oFormField != null) {
                int nDisplay = this.getDisplayCode(oFormField);
                if (nDisplay == 3) {
                    nDisplay = 0;
                }
                jsv = nDisplay;
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(null, 7));
    }

    public void setDisplay(Object args) {
        if (this.isObjectDead()) {
            this.throwException(args, 14);
        }
        if (!this.formModifyOkay(true)) {
            this.throwException(args, 12);
        }
        boolean bStatus = true;
        int nDisplay = ScriptRuntime.toInt32((Object)args);
        if (nDisplay < 0 || nDisplay > 3) {
            this.throwException(args, 1);
        }
        try {
            FormField oFormField = this.getNode(-1, -1, false);
            if (oFormField != null) {
                FormUtils.setDisplayCode(oFormField, nDisplay);
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        if (!bStatus) {
            this.throwException(args, 8);
        }
    }

    public Object getDoc() {
        Doc jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        boolean bStatus = true;
        try {
            jsv = JavaScriptHandler.getRegisteredInstance(this.getPDDoc()).getDocLevelScope();
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(null, 7));
    }

    public Object getEditable() {
        Boolean jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        boolean bStatus = false;
        try {
            int eOpen;
            Element oUIChild = this.getUIChild();
            if (oUIChild != null && oUIChild.isSameClass(XFA.CHOICELISTTAG) && (eOpen = oUIChild.getEnum(XFA.OPENTAG)) != 0x230002 && eOpen != 0x230003) {
                boolean bEditable = Bool.getValue((EnumValue)oUIChild.getAttribute(XFA.TEXTENTRYTAG));
                jsv = bEditable;
                bStatus = true;
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(null, 7));
    }

    public void setEditable(Object args) {
        if (this.isObjectDead()) {
            this.throwException(args, 14);
        }
        if (!this.formModifyOkay(true)) {
            this.throwException(args, 12);
        }
        boolean bStatus = false;
        boolean bEditable = ScriptRuntime.toBoolean((Object)args);
        try {
            int eOpen;
            Element oUIChild = this.getUIChild();
            if (oUIChild != null && oUIChild.isSameClass(XFA.CHOICELISTTAG) && (eOpen = oUIChild.getEnum(XFA.OPENTAG)) != 0x230002 && eOpen != 0x230003) {
                oUIChild.setAttribute(bEditable ? 0x40040001 : 0x40040000, XFA.TEXTENTRYTAG);
                bStatus = true;
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        if (!bStatus) {
            this.throwException(args, 8);
        }
    }

    public Object getFillColor() {
        Object[] jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        boolean bStatus = true;
        try {
            FormField oFormField;
            Element oUIChild = this.getUIChild(-1, -1, true);
            if (oUIChild != null && (oFormField = this.getNode(-1, -1, true)) != null) {
                com.adobe.xfa.template.formatting.Color xfacolor;
                Element oFillNode;
                Element oBorderNode = oUIChild.isSameClass(XFA.BUTTONTAG) ? oFormField.getElement(XFA.BORDERTAG, 0) : oUIChild.getElement(XFA.BORDERTAG, 0);
                jsv = oBorderNode != null ? ((oFillNode = oBorderNode.peekElement(XFA.FILLTAG, false, 0)) != null ? ((xfacolor = (com.adobe.xfa.template.formatting.Color)oFillNode.peekElement(XFA.COLORTAG, false, 0)) != null ? ((List)Utils.getRGBColorObject(xfacolor.getRed(), xfacolor.getGreen(), xfacolor.getBlue())).toArray() : new Object[]{"T"}) : new Object[]{"T"}) : new Object[]{"T"};
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? Context.getCurrentContext().newArray(this.getParentScope(), jsv) : Boolean.valueOf(this.throwException(null, 7));
    }

    public Object getBgColor() {
        return this.getFillColor();
    }

    public void setBgColor(Object args) {
        this.setFillColor(args);
    }

    public void setFillColor(Object args) {
        if (this.isObjectDead()) {
            this.throwException(args, 14);
        }
        if (!this.formModifyOkay(true)) {
            this.throwException(args, 12);
        }
        Color bgC = null;
        try {
            Object[] arr = null;
            if (ScriptRuntime.isArrayObject((Object)args)) {
                arr = ScriptRuntime.getArrayElements((Scriptable)((Scriptable)args));
            }
            bgC = Utils.unloadColor(arr);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (bgC == null) {
            this.throwException(args, 8);
        }
        boolean bStatus = true;
        try {
            Element oBorderNode;
            FormField oFormField;
            Element oUIChild = this.getUIChild();
            if (oUIChild != null && (oFormField = this.getNode(-1, -1, false)) != null && (oBorderNode = oUIChild.isSameClass(XFA.BUTTONTAG) ? oFormField.getElement(XFA.BORDERTAG, 0) : oUIChild.getElement(XFA.BORDERTAG, 0)) != null) {
                Element oFillNode = oBorderNode.getElement(XFA.FILLTAG, 0);
                com.adobe.xfa.template.formatting.Color oColorNode = (com.adobe.xfa.template.formatting.Color)oFillNode.getElement(XFA.COLORTAG, 0);
                Object[] rgb = Utils.getRGBColorValue(bgC);
                if (rgb != null) {
                    oColorNode.setColor((int)((Double)rgb[1] * 255.0), (int)((Double)rgb[2] * 255.0), (int)((Double)rgb[3] * 255.0));
                }
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        if (!bStatus) {
            this.throwException(args, 8);
        }
    }

    public Object getHidden() {
        Boolean jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        boolean bStatus = true;
        try {
            FormField oFormField = this.getNode(-1, -1, true);
            if (oFormField != null) {
                int nDisplay = this.getDisplayCode(oFormField);
                boolean bHidden = nDisplay == 1 || nDisplay == 3;
                jsv = bHidden;
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(null, 7));
    }

    public void setHidden(Object args) {
        if (this.isObjectDead()) {
            this.throwException(args, 14);
        }
        if (!this.formModifyOkay(true)) {
            this.throwException(args, 12);
        }
        boolean bStatus = true;
        boolean bHidden = ScriptRuntime.toBoolean((Object)args);
        try {
            FormField oFormField = this.getNode(-1, -1, false);
            if (oFormField != null) {
                int nOldDisplay;
                int nNewDisplay = nOldDisplay = this.getDisplayCode(oFormField);
                if (bHidden) {
                    if (nOldDisplay == 0) {
                        nNewDisplay = 3;
                    } else if (nOldDisplay == 2) {
                        nNewDisplay = 1;
                    }
                } else if (nOldDisplay != 0) {
                    if (nOldDisplay == 1) {
                        nNewDisplay = 2;
                    } else if (nOldDisplay != 2) {
                        nNewDisplay = 0;
                    }
                }
                if (nNewDisplay != nOldDisplay) {
                    FormUtils.setDisplayCode(oFormField, nNewDisplay);
                }
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        if (!bStatus) {
            this.throwException(args, 8);
        }
    }

    public Object getHighlight() {
        Object jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        boolean bStatus = false;
        try {
            Element oUIChild = this.getUIChild();
            if (oUIChild != null && oUIChild.isPropertyValid(XFA.HIGHLIGHTTAG)) {
                int eHighLight = oUIChild.getEnum(XFA.HIGHLIGHTTAG);
                String cHighlight = 0x770000 == eHighLight ? NONE_STR : (0x770001 == eHighLight ? INVERT_STR : (0x770003 == eHighLight ? OUTLINE_STR : (0x770002 == eHighLight ? PUSH_STR : "")));
                jsv = cHighlight;
                bStatus = true;
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(null, 7));
    }

    public void setHighlight(Object args) {
        if (this.isObjectDead()) {
            this.throwException(args, 14);
        }
        if (!this.formModifyOkay(true)) {
            this.throwException(args, 12);
        }
        boolean bStatus = false;
        try {
            Element oUIChild = this.getUIChild();
            if (oUIChild != null && oUIChild.isPropertyValid(XFA.HIGHLIGHTTAG)) {
                String cBuf = ScriptRuntime.toString((Object)args);
                int eHighLight = 0x770002;
                if (cBuf.equals(INVERT_STR)) {
                    eHighLight = 0x770001;
                } else if (cBuf.equals(NONE_STR)) {
                    eHighLight = 0x770000;
                } else if (cBuf.equals(OUTLINE_STR)) {
                    eHighLight = 0x770003;
                } else if (cBuf.equals(PUSH_STR)) {
                    eHighLight = 0x770002;
                } else {
                    bStatus = false;
                }
                oUIChild.setAttribute(eHighLight, XFA.HIGHLIGHTTAG);
                bStatus = true;
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        if (!bStatus) {
            this.throwException(args, 8);
        }
    }

    public Object getBorderWidth() {
        return this.getLineWidth();
    }

    public void setBorderWidth(Object args) {
        this.setLineWidth(args);
    }

    public Object getLineWidth() {
        Comparable<Boolean> jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        boolean bStatus = true;
        try {
            Element oEdge;
            Element oBorderNode;
            Element oUIChild = this.getUIChild(-1, -1, true);
            FormField oFormField = this.getNode(-1, -1, true);
            if (oFormField != null && (oBorderNode = oUIChild.isSameClass(XFA.BUTTONTAG) ? oFormField.getElement(XFA.BORDERTAG, 0) : oUIChild.getElement(XFA.BORDERTAG, 0)) != null && (oEdge = oBorderNode.getElement(XFA.EDGETAG, 0)) != null) {
                Measurement oBorderThickness = new Measurement(oEdge.getAttribute(XFA.THICKNESSTAG));
                double dEdgeThickness = oBorderThickness.getValueAsUnit(0x3C0000);
                int nEdgeThickness = 0;
                if (dEdgeThickness <= 0.0) {
                    nEdgeThickness = 0;
                } else if (dEdgeThickness > 0.0 && dEdgeThickness < 1.5) {
                    nEdgeThickness = 1;
                } else if (dEdgeThickness > 1.5 && dEdgeThickness < 2.5) {
                    nEdgeThickness = 2;
                } else if (dEdgeThickness > 2.5) {
                    nEdgeThickness = 3;
                }
                jsv = nEdgeThickness;
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(null, 7));
    }

    public void setLineWidth(Object args) {
        if (this.isObjectDead()) {
            this.throwException(args, 14);
        }
        if (!this.formModifyOkay(true)) {
            this.throwException(args, 12);
        }
        int nWidth = ScriptRuntime.toInt32((Object)args);
        boolean bStatus = true;
        try {
            Element oBorder;
            FormField oFormField;
            Element oUIChild = this.getUIChild();
            if (oUIChild != null && (oFormField = this.getNode(-1, -1, false)) != null && (oBorder = oUIChild.isSameClass(XFA.BUTTONTAG) ? oFormField.getElement(XFA.BORDERTAG, 0) : oUIChild.getElement(XFA.BORDERTAG, 0)) != null) {
                Element oEdge;
                StringBuilder buf = new StringBuilder();
                buf.append(nWidth).append("pt");
                String sWidth = buf.toString();
                Measurement thickness = new Measurement(new UnitSpan(sWidth));
                int i = 0;
                while ((oEdge = oBorder.peekElement(XFA.EDGETAG, false, i)) != null && (oEdge = oBorder.getElement(XFA.EDGETAG, i)) != null) {
                    oEdge.setAttribute(thickness, XFA.THICKNESSTAG);
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        if (!bStatus) {
            this.throwException(args, 8);
        }
    }

    public Object getMultiline() {
        Boolean jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        boolean bStatus = false;
        try {
            Element oUIChild = this.getUIChild();
            if (oUIChild != null && (oUIChild instanceof TextEdit || oUIChild instanceof DateTimeEdit || oUIChild.isSameClass(XFA.NUMERICEDITTAG) || oUIChild.isSameClass(XFA.PASSWORDEDITTAG))) {
                boolean bMultiline = false;
                if (oUIChild.isPropertyValid(XFA.MULTILINETAG)) {
                    TextEdit te = (TextEdit)oUIChild;
                    bMultiline = Bool.getValue((EnumValue)te.getAttribute(XFA.MULTILINETAG));
                }
                jsv = bMultiline;
                bStatus = true;
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(null, 7));
    }

    public void setMultiline(Object args) {
        if (this.isObjectDead()) {
            this.throwException(args, 14);
        }
        if (!this.formModifyOkay(true)) {
            this.throwException(args, 12);
        }
        boolean bStatus = false;
        boolean bMultiline = ScriptRuntime.toBoolean((Object)args);
        try {
            Element oUIChild = this.getUIChild();
            if (oUIChild != null && (oUIChild instanceof TextEdit || oUIChild instanceof DateTimeEdit || oUIChild.isSameClass(XFA.NUMERICEDITTAG) || oUIChild.isSameClass(XFA.PASSWORDEDITTAG))) {
                if (oUIChild.isPropertyValid(XFA.MULTILINETAG)) {
                    TextEdit te = (TextEdit)oUIChild;
                    te.setAttribute(bMultiline ? 0x40040001 : 0x40040000, XFA.MULTILINETAG);
                }
                bStatus = true;
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        if (!bStatus) {
            this.throwException(args, 8);
        }
    }

    public Object getMultipleSelection() {
        Boolean jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        boolean bStatus = false;
        try {
            int eOpen;
            Element oUIChild = this.getUIChild();
            if (oUIChild != null && oUIChild.isSameClass(XFA.CHOICELISTTAG) && ((eOpen = oUIChild.getEnum(XFA.OPENTAG)) == 0x230003 || eOpen == 0x230002)) {
                boolean bMultiSelect = eOpen == 0x230003;
                jsv = bMultiSelect;
                bStatus = true;
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(null, 7));
    }

    public void setMultipleSelection(Object args) {
        if (this.isObjectDead()) {
            this.throwException(args, 14);
        }
        if (!this.formModifyOkay(true)) {
            this.throwException(args, 12);
        }
        boolean bStatus = false;
        try {
            int eOpen;
            boolean bMultipleSelection = ScriptRuntime.toBoolean((Object)args);
            Element oUIChild = this.getUIChild();
            if (oUIChild != null && oUIChild.isSameClass(XFA.CHOICELISTTAG) && ((eOpen = oUIChild.getEnum(XFA.OPENTAG)) == 0x230003 || eOpen == 0x230002)) {
                if (eOpen == 0x230003 && !bMultipleSelection) {
                    oUIChild.setAttribute(0x230002, XFA.OPENTAG);
                } else if (eOpen == 0x230002 && bMultipleSelection) {
                    oUIChild.setAttribute(0x230003, XFA.OPENTAG);
                }
                bStatus = true;
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        if (!bStatus) {
            this.throwException(args, 8);
        }
    }

    public Object getName() {
        String jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        boolean bStatus = true;
        try {
            jsv = this.getOrigName();
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(null, 7));
    }

    public Object getNumItems() {
        Comparable<Boolean> jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        boolean bStatus = false;
        try {
            FormField oFormField;
            Element oUIChild = this.getUIChild();
            if (oUIChild != null && (oFormField = this.getNode(-1, -1, false)) != null && oUIChild.isSameClass(XFA.CHOICELISTTAG)) {
                Field.ItemPair itemPair = new Field.ItemPair();
                oFormField.getItemLists(true, itemPair, false);
                Items oDisplayItem = itemPair.mDisplayItems;
                int nDisplayItems = 0;
                if (oDisplayItem != null) {
                    nDisplayItems = oDisplayItem.getXFAChildCount();
                }
                jsv = nDisplayItems;
                bStatus = true;
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(null, 7));
    }

    public Object getPassword() {
        Boolean jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        boolean bStatus = false;
        try {
            Element oUIChild = this.getUIChild();
            if (oUIChild != null && (oUIChild instanceof TextEdit || oUIChild instanceof DateTimeEdit || oUIChild.isSameClass(XFA.NUMERICEDITTAG) || oUIChild.isSameClass(XFA.PASSWORDEDITTAG))) {
                boolean bPassword = oUIChild.isSameClass(XFA.PASSWORDEDITTAG);
                jsv = bPassword;
                bStatus = true;
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(null, 7));
    }

    public Object getPrint() {
        Boolean jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        boolean bStatus = true;
        try {
            FormField oFormField = this.getNode(-1, -1, true);
            if (oFormField != null) {
                int nDisplay = this.getDisplayCode(oFormField);
                boolean bPrint = nDisplay == 0 || nDisplay == 3;
                jsv = bPrint;
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(null, 7));
    }

    public void setPrint(Object args) {
        if (this.isObjectDead()) {
            this.throwException(args, 14);
        }
        if (!this.formModifyOkay(true)) {
            this.throwException(args, 12);
        }
        boolean bStatus = true;
        boolean bPrint = ScriptRuntime.toBoolean((Object)args);
        try {
            FormField oFormField = this.getNode(-1, -1, false);
            if (oFormField != null) {
                int nOldDisplay;
                int nNewDisplay = nOldDisplay = this.getDisplayCode(oFormField);
                if (bPrint) {
                    if (nOldDisplay == 1) {
                        nNewDisplay = 3;
                    } else if (nOldDisplay == 2) {
                        nNewDisplay = 0;
                    }
                } else if (nOldDisplay == 0) {
                    nNewDisplay = 2;
                } else if (nOldDisplay != 1 && nOldDisplay != 2) {
                    nNewDisplay = 1;
                }
                if (nNewDisplay != nOldDisplay) {
                    FormUtils.setDisplayCode(oFormField, nNewDisplay);
                }
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        if (!bStatus) {
            this.throwException(args, 8);
        }
    }

    public Object getReadonly() {
        Boolean jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        boolean bStatus = true;
        try {
            FormField oFormField;
            Element oUIChild = this.getUIChild(-1, -1, true);
            if (oUIChild != null && (oFormField = this.getNode(-1, -1, true)) != null) {
                Element oGroup;
                int groupAccess = 65537;
                if (oUIChild.isSameClass(XFA.CHECKBUTTONTAG) && (oGroup = oFormField.getXFAParent()) instanceof ExclGroup) {
                    ExclGroup oExclGroup = (ExclGroup)oGroup;
                    groupAccess = oExclGroup.getRuntimeAccess(0);
                }
                boolean bIs2DBarcode = false;
                int eAccess = oFormField.getRuntimeAccess(0);
                boolean bReadonly = eAccess == 65538 || eAccess == 65536 || groupAccess == 65538 || groupAccess == 65536 || bIs2DBarcode;
                jsv = bReadonly;
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(null, 7));
    }

    public void setReadonly(Object args) {
        if (this.isObjectDead()) {
            this.throwException(args, 14);
        }
        if (!this.formModifyOkay(true)) {
            this.throwException(args, 12);
        }
        boolean bStatus = true;
        boolean bReadOnly = ScriptRuntime.toBoolean((Object)args);
        try {
            FormField oFormField = this.getNode(-1, -1, false);
            if (oFormField != null) {
                oFormField.setAttribute(bReadOnly ? 65538 : 65537, XFA.ACCESSTAG);
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        if (!bStatus) {
            this.throwException(args, 8);
        }
    }

    public Object getRequired() {
        Boolean jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        boolean bStatus = true;
        try {
            FormField oFormField;
            Element oUIChild = this.getUIChild(-1, -1, true);
            if (oUIChild != null && (oFormField = this.getNode(-1, -1, true)) != null) {
                if (oUIChild.isSameClass(XFA.BUTTONTAG)) {
                    bStatus = false;
                } else {
                    Element oValidate;
                    int nullTest;
                    Element oGroup;
                    int groupNullTest = 0x380000;
                    if (oUIChild.isSameClass(XFA.CHECKBUTTONTAG) && (oGroup = oFormField.getXFAParent()) instanceof ExclGroup) {
                        Element oValidate2 = oGroup.getElement(XFA.VALIDATETAG, 0);
                        groupNullTest = oValidate2.getEnum(XFA.NULLTESTTAG);
                    }
                    boolean bRequired = (nullTest = (oValidate = oFormField.getElement(XFA.VALIDATETAG, 0)).getEnum(XFA.NULLTESTTAG)) == 3670018 || groupNullTest == 3670018;
                    jsv = bRequired;
                }
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(null, 7));
    }

    public void setRequired(Object args) {
        if (this.isObjectDead()) {
            this.throwException(args, 14);
        }
        if (!this.formModifyOkay(true)) {
            this.throwException(args, 12);
        }
        boolean bStatus = true;
        boolean bRequired = ScriptRuntime.toBoolean((Object)args);
        try {
            FormField oFormField;
            Element oUIChild = this.getUIChild();
            if (oUIChild != null && (oFormField = this.getNode(-1, -1, false)) != null) {
                if (oUIChild.isSameClass(XFA.BUTTONTAG)) {
                    bStatus = false;
                } else {
                    Element oValidate = oFormField.getElement(XFA.VALIDATETAG, 0);
                    if (bRequired) {
                        oValidate.setAttribute(3670018, XFA.NULLTESTTAG);
                    } else {
                        oValidate.setAttribute(0x380000, XFA.NULLTESTTAG);
                    }
                }
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        if (!bStatus) {
            this.throwException(args, 8);
        }
    }

    public Object getRichText() {
        Boolean jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        boolean bStatus = false;
        try {
            Element oUIChild = this.getUIChild();
            if (oUIChild != null && (oUIChild instanceof TextEdit || oUIChild instanceof DateTimeEdit || oUIChild.isSameClass(XFA.NUMERICEDITTAG) || oUIChild.isSameClass(XFA.PASSWORDEDITTAG))) {
                Boolean bRichText = Boolean.FALSE;
                if (oUIChild instanceof TextEdit) {
                    bRichText = Bool.getValue((EnumValue)oUIChild.getAttribute(XFA.ALLOWRICHTEXTTAG));
                }
                jsv = (boolean)bRichText;
                bStatus = true;
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(null, 7));
    }

    public void setRichText(Object args) {
        if (this.isObjectDead()) {
            this.throwException(args, 14);
        }
        if (!this.formModifyOkay(true)) {
            this.throwException(args, 12);
        }
        boolean bStatus = false;
        boolean bRichText = ScriptRuntime.toBoolean((Object)args);
        try {
            Element oUIChild = this.getUIChild();
            if (oUIChild != null && (oUIChild instanceof TextEdit || oUIChild instanceof DateTimeEdit || oUIChild.isSameClass(XFA.NUMERICEDITTAG) || oUIChild.isSameClass(XFA.PASSWORDEDITTAG))) {
                if (oUIChild instanceof TextEdit) {
                    oUIChild.setAttribute(bRichText ? 0x40040001 : 0x40040000, XFA.ALLOWRICHTEXTTAG);
                }
                bStatus = true;
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        if (!bStatus) {
            this.throwException(args, 8);
        }
    }

    public Object getRotation() {
        Comparable<Boolean> jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        boolean bStatus = true;
        try {
            FormField oFormField = this.getNode(-1, -1, true);
            if (oFormField != null) {
                Rotate oRotate = new Rotate("rotate", oFormField.getAttribute(XFA.ROTATETAG).toString());
                int mnAngle = oRotate.getAngle().degrees();
                jsv = mnAngle;
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(null, 7));
    }

    public void setRotation(Object args) {
        if (this.isObjectDead()) {
            this.throwException(args, 14);
        }
        if (!this.formModifyOkay(true)) {
            this.throwException(args, 12);
        }
        boolean bStatus = true;
        try {
            FormField oFormField = this.getNode(-1, -1, false);
            if (oFormField != null) {
                int nRotation = ScriptRuntime.toInt32((Object)args);
                switch (nRotation) {
                    case 0: 
                    case 90: 
                    case 180: 
                    case 270: {
                        oFormField.setAttribute(new Rotate("rotate", new Angle(nRotation)), XFA.ROTATETAG);
                        break;
                    }
                    default: {
                        bStatus = false;
                    }
                }
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        if (!bStatus) {
            this.throwException(args, 8);
        }
    }

    public Object getStrokeColor() {
        return this.getBorderColor();
    }

    public void setStrokeColor(Object args) {
        this.setBorderColor(args);
    }

    public Object getStyle() {
        Object jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        boolean bStatus = false;
        try {
            FormField oFormField;
            Element oUIChild = this.getUIChild();
            if (oUIChild != null && (oFormField = this.getNode(-1, -1, false)) != null && oUIChild.isSameClass(XFA.CHECKBUTTONTAG) && oUIChild.isPropertyValid(XFA.MARKTAG)) {
                int eMark = oUIChild.getEnum(XFA.MARKTAG);
                int iIndex = -1;
                iIndex = eMark == 0x760000 ? 0 : (eMark == 7733249 ? 1 : (eMark == 7733250 ? 2 : (eMark == 7733251 ? 3 : (eMark == 7733252 ? 4 : (eMark == 7733253 ? 5 : 1)))));
                String cBuf = "";
                if (iIndex >= 0) {
                    cBuf = gStyle[iIndex];
                }
                jsv = cBuf;
                bStatus = true;
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(null, 7));
    }

    public void setStyle(Object args) {
        int iStyle;
        if (this.isObjectDead()) {
            this.throwException(args, 14);
        }
        if (!this.formModifyOkay(true)) {
            this.throwException(args, 12);
        }
        String cStyle = ScriptRuntime.toString((Object)args);
        for (iStyle = 0; iStyle < gStyle.length && !gStyle[iStyle].equals(cStyle); ++iStyle) {
        }
        boolean bStatus = false;
        try {
            Element oUIChild;
            if (iStyle < gStyle.length && (oUIChild = this.getUIChild()) != null && oUIChild.isSameClass(XFA.CHECKBUTTONTAG) && oUIChild.isPropertyValid(XFA.MARKTAG)) {
                int eMark = iStyle == 0 ? 0x760000 : (iStyle == 1 ? 7733249 : (iStyle == 2 ? 7733250 : (iStyle == 3 ? 7733251 : (iStyle == 4 ? 7733252 : 7733253))));
                oUIChild.setAttribute(eMark, XFA.MARKTAG);
                bStatus = true;
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        if (!bStatus) {
            this.throwException(args, 8);
        }
    }

    public Object getFgColor() {
        return this.getTextColor();
    }

    public void setFgColor(Object args) {
        this.setTextColor(args);
    }

    public Object getTextColor() {
        Object[] jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        boolean bStatus = true;
        try {
            FormField oFormField;
            Element oUIChild = this.getUIChild(-1, -1, true);
            if (oUIChild != null && (oFormField = this.getNode(-1, -1, true)) != null) {
                com.adobe.xfa.template.formatting.Color oColor;
                Element oFill;
                Element oFont = null;
                if (oUIChild.isSameClass(XFA.BUTTONTAG)) {
                    Element oCaption = oFormField.getElement(XFA.CAPTIONTAG, 0);
                    if (oCaption != null) {
                        oFont = oCaption.getElement(XFA.FONTTAG, 0);
                    }
                } else {
                    oFont = oFormField.getElement(XFA.FONTTAG, 0);
                }
                if (oFont != null && (oFill = oFont.getElement(XFA.FILLTAG, 0)) != null && (oColor = (com.adobe.xfa.template.formatting.Color)oFill.getElement(XFA.COLORTAG, 0)) != null) {
                    if (oColor.getRed() == 0 && oColor.getGreen() == 0 && oColor.getBlue() == 0) {
                        Object[] jsvs = new Object[]{"G", 0.0};
                        jsv = jsvs;
                    } else {
                        jsv = ((List)Utils.getRGBColorObject(oColor.getRed(), oColor.getGreen(), oColor.getBlue())).toArray();
                    }
                }
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? Context.getCurrentContext().newArray(this.getParentScope(), jsv) : Boolean.valueOf(this.throwException(null, 7));
    }

    public void setTextColor(Object args) {
        if (this.isObjectDead()) {
            this.throwException(args, 14);
        }
        if (!this.formModifyOkay(true)) {
            this.throwException(args, 12);
        }
        Color fgC = null;
        try {
            Object[] arr = null;
            if (ScriptRuntime.isArrayObject((Object)args)) {
                arr = ScriptRuntime.getArrayElements((Scriptable)((Scriptable)args));
            }
            fgC = Utils.unloadColor(arr);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (fgC == null) {
            this.throwException(args, 8);
        }
        boolean bStatus = true;
        try {
            FormField oFormField;
            Element oUIChild = this.getUIChild();
            if (oUIChild != null && (oFormField = this.getNode(-1, -1, false)) != null) {
                Element oFont = null;
                if (oUIChild.isSameClass(XFA.BUTTONTAG)) {
                    Element oCaption = oFormField.getElement(XFA.CAPTIONTAG, 0);
                    if (oCaption != null) {
                        oFont = oCaption.getElement(XFA.FONTTAG, 0);
                    }
                } else {
                    oFont = oFormField.getElement(XFA.FONTTAG, 0);
                }
                if (oFont != null) {
                    Element oFill = oFont.getElement(XFA.FILLTAG, 0);
                    com.adobe.xfa.template.formatting.Color oColor = (com.adobe.xfa.template.formatting.Color)oFill.getElement(XFA.COLORTAG, 0);
                    Object[] rgb = Utils.getRGBColorValue(fgC);
                    if (rgb != null) {
                        oColor.setColor((int)((Double)rgb[1] * 255.0), (int)((Double)rgb[2] * 255.0), (int)((Double)rgb[3] * 255.0));
                    }
                }
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        if (!bStatus) {
            this.throwException(args, 8);
        }
    }

    public Object getTextFont() {
        Object jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        boolean bStatus = true;
        try {
            FormField oFormField;
            Element oUIChild = this.getUIChild();
            if (oUIChild != null && (oFormField = this.getNode(-1, -1, false)) != null) {
                Element oFont = null;
                if (oUIChild.isSameClass(XFA.BUTTONTAG)) {
                    Element oCaption = oFormField.getElement(XFA.CAPTIONTAG, 0);
                    if (oCaption != null) {
                        oFont = oCaption.getElement(XFA.FONTTAG, 0);
                    }
                } else {
                    oFont = oFormField.getElement(XFA.FONTTAG, 0);
                }
                if (oFont != null) {
                    Attribute oTypefaceAttr = oFont.getAttribute(XFA.TYPEFACETAG);
                    jsv = oTypefaceAttr.toString();
                }
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(null, 7));
    }

    public void setTextFont(Object args) {
        if (this.isObjectDead()) {
            this.throwException(args, 14);
        }
        if (!this.formModifyOkay(true)) {
            this.throwException(args, 12);
        }
        boolean bStatus = true;
        try {
            FormField oFormField;
            Element oUIChild = this.getUIChild();
            if (oUIChild != null && (oFormField = this.getNode(-1, -1, false)) != null) {
                Element oFont = null;
                if (oUIChild.isSameClass(XFA.BUTTONTAG)) {
                    Element oCaption = oFormField.getElement(XFA.CAPTIONTAG, 0);
                    if (oCaption != null) {
                        oFont = oCaption.getElement(XFA.FONTTAG, 0);
                    }
                } else {
                    oFont = oFormField.getElement(XFA.FONTTAG, 0);
                }
                if (oFont != null) {
                    String fontName = ScriptRuntime.toString((Object)args);
                    StringAttr oTypefaceAttr = new StringAttr("typeface", fontName);
                    oFont.setAttribute(oTypefaceAttr, XFA.TYPEFACETAG);
                }
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        if (!bStatus) {
            this.throwException(args, 8);
        }
    }

    public Object getTextSize() {
        Comparable<Boolean> jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        boolean bStatus = true;
        try {
            FormField oFormField;
            Element oUIChild = this.getUIChild(-1, -1, true);
            if (oUIChild != null && (oFormField = this.getNode(-1, -1, true)) != null) {
                Element oFont = null;
                if (oUIChild.isSameClass(XFA.BUTTONTAG)) {
                    Element oCaption = oFormField.getElement(XFA.CAPTIONTAG, 0);
                    if (oCaption != null) {
                        oFont = oCaption.getElement(XFA.FONTTAG, 0);
                    }
                } else {
                    oFont = oFormField.getElement(XFA.FONTTAG, 0);
                }
                if (oFont != null) {
                    double dFontSize = new Measurement(oFont.getAttribute(XFA.SIZETAG)).getValueAsUnit(0x3C0000);
                    jsv = dFontSize;
                }
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(null, 7));
    }

    public void setTextSize(Object args) {
        if (this.isObjectDead()) {
            this.throwException(args, 14);
        }
        if (!this.formModifyOkay(true)) {
            this.throwException(args, 12);
        }
        boolean bStatus = true;
        try {
            FormField oFormField;
            double textSize = ScriptRuntime.toNumber((Object)args);
            Element oUIChild = this.getUIChild();
            if (oUIChild != null && (oFormField = this.getNode(-1, -1, false)) != null) {
                Element oFont = null;
                if (oUIChild.isSameClass(XFA.BUTTONTAG)) {
                    Element oCaption = oFormField.getElement(XFA.CAPTIONTAG, 0);
                    if (oCaption != null) {
                        oFont = oCaption.getElement(XFA.FONTTAG, 0);
                    }
                } else {
                    oFont = oFormField.getElement(XFA.FONTTAG, 0);
                }
                if (oFont != null) {
                    StringBuilder buf = new StringBuilder();
                    buf.append(textSize).append("pt");
                    String sWidth = buf.toString();
                    oFont.setAttribute(new Measurement(new UnitSpan(sWidth)), XFA.SIZETAG);
                }
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        if (!bStatus) {
            this.throwException(args, 8);
        }
    }

    public Object getType() {
        Object jsv = null;
        boolean bStatus = true;
        try {
            FormField oFormField;
            Element oUIChild = this.getUIChild(-1, -1, true);
            if (oUIChild != null && (oFormField = this.getNode(-1, -1, true)) != null) {
                int eOpen;
                Element oGroup;
                String estr = oUIChild instanceof TextEdit || oUIChild instanceof DateTimeEdit || oUIChild.isSameClass(XFA.NUMERICEDITTAG) || oUIChild.isSameClass(XFA.PASSWORDEDITTAG) ? "text" : (oUIChild.isSameClass(XFA.CHECKBUTTONTAG) ? ((oGroup = oFormField.getXFAParent()) instanceof ExclGroup ? "radiobutton" : "checkbox") : (oUIChild.isSameClass(XFA.CHOICELISTTAG) ? ((eOpen = oUIChild.getEnum(XFA.OPENTAG)) == 0x230002 || eOpen == 0x230003 ? "listbox" : "combobox") : (oUIChild.isSameClass(XFA.BUTTONTAG) ? "button" : "")));
                jsv = estr;
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(null, 7));
    }

    public Object getUserName() {
        Object jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        boolean bStatus = true;
        try {
            String sText;
            LayoutNode oLayoutNode;
            AcroFormLayout oLayout;
            DocumentContext oDocContext;
            FormField oFormField = this.getNode(-1, -1, false);
            if (oFormField != null && (oDocContext = XFAField.getContext(this.getPDDoc())) != null && (oLayout = oDocContext.getAcroFormLayout()) != null && (oLayoutNode = FormUtils.findRootXFALayoutNodeForFormNode(oLayout, oFormField)) != null && (sText = FormUtils.getToolTipText(oLayoutNode)) != null) {
                jsv = sText;
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(null, 7));
    }

    public Object getValue() {
        Object jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        boolean bStatus = true;
        try {
            FormField oFormField = this.getNode(-1, 0, true);
            if (oFormField != null) {
                String sFieldValue = oFormField.getRawValue();
                jsv = sFieldValue;
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(null, 7));
    }

    public Object getValueAsString() {
        String jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        boolean bStatus = true;
        try {
            FormField oFormField = this.getNode(-1, 0, true);
            if (oFormField != null) {
                jsv = oFormField.getRawValue();
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(null, 7));
    }

    public Object clear() {
        return this.clearItems();
    }

    public Object clearItems() {
        Boolean jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(null, 14);
        }
        if (!this.formModifyOkay(true)) {
            return this.throwException(null, 12);
        }
        boolean bStatus = false;
        try {
            FormField oFormField;
            Element oUIChild = this.getUIChild();
            if (oUIChild != null && (oFormField = this.getNode(-1, -1, false)) != null && oUIChild.isSameClass(XFA.CHOICELISTTAG)) {
                boolean bMultiSelect;
                int eOpen = oUIChild.getEnum(XFA.OPENTAG);
                boolean bl = bMultiSelect = eOpen == 0x230003;
                if (!bMultiSelect) {
                    Field.ItemPair itemPair = new Field.ItemPair();
                    oFormField.getItemLists(false, itemPair, true);
                    Items oDisplayItem = itemPair.mDisplayItems;
                    Items oSaveItem = itemPair.mSaveItems;
                    if (oDisplayItem != null) {
                        int i;
                        for (i = oDisplayItem.getXFAChildCount(); i > 0; --i) {
                            oDisplayItem.removeChild(oDisplayItem.getXFAChild(i - 1));
                        }
                        for (i = oSaveItem.getXFAChildCount(); i > 0; --i) {
                            oSaveItem.removeChild(oSaveItem.getXFAChild(i - 1));
                        }
                    }
                }
                bStatus = true;
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(null, 15));
    }

    public Object deleteItemAt(Object args) {
        Boolean jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(args, 14);
        }
        if (!this.formModifyOkay(true)) {
            return this.throwException(args, 12);
        }
        boolean bStatus = false;
        try {
            FormField oFormField;
            int nIdx = -1;
            if (args instanceof NativeObject) {
                NativeObject obj = (NativeObject)args;
                Object value = obj.get("nIdx", (Scriptable)obj);
                nIdx = value == Scriptable.NOT_FOUND ? -1 : ScriptRuntime.toInt32((Object)value);
            } else if (args != Undefined.instance) {
                nIdx = ScriptRuntime.toInt32((Object)args);
            }
            Element oUIChild = this.getUIChild();
            if (oUIChild != null && (oFormField = this.getNode(-1, -1, false)) != null && oUIChild.isSameClass(XFA.CHOICELISTTAG)) {
                boolean bMultiSelect;
                int eOpen = oUIChild.getEnum(XFA.OPENTAG);
                boolean bl = bMultiSelect = eOpen == 0x230003;
                if (!bMultiSelect) {
                    Field.ItemPair itemPair = new Field.ItemPair();
                    oFormField.getItemLists(false, itemPair, true);
                    Items oDisplayItem = itemPair.mDisplayItems;
                    Items oSaveItem = itemPair.mSaveItems;
                    if (oDisplayItem != null) {
                        if (nIdx < oDisplayItem.getXFAChildCount()) {
                            oDisplayItem.removeChild(oDisplayItem.getXFAChild(nIdx));
                        }
                        if (nIdx < oSaveItem.getXFAChildCount()) {
                            oSaveItem.removeChild(oSaveItem.getXFAChild(nIdx));
                        }
                    }
                }
                bStatus = true;
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(args, 15));
    }

    public Object getItemAt(Object args, Object exportValue) {
        FormField oFormField;
        Object jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(args, 14);
        }
        boolean bStatus = false;
        int nIdx = 0;
        boolean bExportValue = true;
        if (args == Undefined.instance) {
            this.throwException(args, 6);
        } else if (args instanceof NativeObject) {
            NativeObject obj = (NativeObject)args;
            Object value = obj.get("nIdx", (Scriptable)obj);
            if (value == Scriptable.NOT_FOUND) {
                this.throwException(args, 6);
            }
            nIdx = ScriptRuntime.toInt32((Object)args);
            value = obj.get("bExportValue", (Scriptable)obj);
            bExportValue = value == Scriptable.NOT_FOUND ? true : ScriptRuntime.toBoolean((Object)value);
        } else {
            nIdx = ScriptRuntime.toInt32((Object)args);
            bExportValue = ScriptRuntime.toBoolean((Object)exportValue);
        }
        Element oUIChild = this.getUIChild();
        if (oUIChild != null && (oFormField = this.getNode(-1, -1, false)) != null && oUIChild.isSameClass(XFA.CHOICELISTTAG)) {
            Field.ItemPair itemPair = new Field.ItemPair();
            oFormField.getItemLists(true, itemPair, false);
            Items oDisplayItem = itemPair.mDisplayItems;
            Items oSaveItem = itemPair.mSaveItems;
            Items oItem = bExportValue && oSaveItem != null ? oSaveItem : oDisplayItem;
            if (oItem != null) {
                TextNode textNode;
                int nItems = oItem.getXFAChildCount();
                if (nIdx >= nItems) {
                    nIdx = nItems - 1;
                }
                jsv = nIdx >= 0 && nIdx < nItems && oItem.getXFAChild(nIdx).isSameClass(XFA.TEXTTAG) ? ((textNode = ((Element)oItem.getXFAChild(nIdx)).getText(true, false, false)) != null ? textNode.getValue() : "") : "";
            }
            bStatus = true;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(args, 15));
    }

    public void insertItemAt(Object args, Object export, Object idx) {
        FormField oFormField;
        if (this.isObjectDead()) {
            this.throwException(args, 14);
        }
        if (!this.formModifyOkay(true)) {
            this.throwException(args, 12);
        }
        boolean bStatus = false;
        int nIdx = 0;
        String cName = null;
        String cExport = null;
        if (args instanceof String) {
            cName = (String)args;
            cExport = export == Undefined.instance ? cName : ScriptRuntime.toString((Object)export);
            nIdx = idx == Undefined.instance ? 0 : ScriptRuntime.toInt32((Object)idx);
        } else if (args instanceof NativeObject) {
            NativeObject obj = (NativeObject)args;
            Object value = obj.get("cName", (Scriptable)obj);
            if (value == Scriptable.NOT_FOUND) {
                this.throwException(args, 6);
            }
            cName = ScriptRuntime.toString((Object)value);
            value = obj.get("cExport", (Scriptable)obj);
            cExport = value == Scriptable.NOT_FOUND ? cName : ScriptRuntime.toString((Object)value);
            value = obj.get("nIdx", (Scriptable)obj);
            nIdx = value == Scriptable.NOT_FOUND ? 0 : ScriptRuntime.toInt32((Object)value);
        } else {
            this.throwException(args, 6);
        }
        Element oUIChild = this.getUIChild();
        if (oUIChild != null && (oFormField = this.getNode(-1, -1, false)) != null && oUIChild.isSameClass(XFA.CHOICELISTTAG)) {
            boolean bMultiSelect;
            int eOpen = oUIChild.getEnum(XFA.OPENTAG);
            boolean bl = bMultiSelect = eOpen == 0x230003;
            if (!bMultiSelect) {
                Field.ItemPair itemPair = new Field.ItemPair();
                oFormField.getItemLists(false, itemPair, true);
                Items oDisplayItem = itemPair.mDisplayItems;
                Items oSaveItem = itemPair.mSaveItems;
                if (oDisplayItem != null) {
                    NodeList oDisplayItems = oDisplayItem.getNodes();
                    int nDisplayItems = oDisplayItems.length();
                    boolean bDuplicate = false;
                    for (int i = 0; i < nDisplayItems; ++i) {
                        String str;
                        if (!oDisplayItems.item(i).isSameClass(XFA.TEXTTAG)) continue;
                        TextNode textNode = ((Element)oDisplayItems.item(i)).getText(true, false, false);
                        String string = str = textNode != null ? textNode.getValue() : "";
                        if (!args.equals(str)) continue;
                        bDuplicate = true;
                        break;
                    }
                    NodeList oSaveItems = oSaveItem.getNodes();
                    if (!bDuplicate) {
                        TextValue oDisplayValue = (TextValue)oFormField.getModel().createElement(XFA.TEXTTAG, null);
                        oDisplayValue.setValue(cName);
                        TextValue oSaveValue = (TextValue)oFormField.getModel().createElement(XFA.TEXTTAG, null);
                        oSaveValue.setValue(cExport);
                        if (nIdx >= 0 && nIdx < nDisplayItems) {
                            oDisplayItems.insert(oDisplayValue, oDisplayItems.item(nIdx));
                            oSaveItems.insert(oSaveValue, oSaveItems.item(nIdx));
                        } else {
                            oDisplayItems.append(oDisplayValue);
                            oSaveItems.append(oSaveValue);
                        }
                    }
                }
            }
            bStatus = true;
        }
        if (!bStatus) {
            this.throwException(args, 15);
        }
    }

    public Object isBoxChecked(Object args) {
        Boolean jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(args, 14);
        }
        boolean bStatus = false;
        try {
            boolean bNumOptional;
            int nWidget = -1;
            boolean bl = bNumOptional = this.getWidgetNum() != -1;
            if (args == Undefined.instance) {
                if (!bNumOptional) {
                    return this.throwException(args, 6);
                }
            } else if (args instanceof NativeObject) {
                NativeObject obj = (NativeObject)args;
                Object value = obj.get("nWidget", (Scriptable)obj);
                if (value == Scriptable.NOT_FOUND) {
                    if (!bNumOptional) {
                        return this.throwException(args, 6);
                    }
                } else {
                    nWidget = ScriptRuntime.toInt32((Object)value);
                }
            } else {
                nWidget = ScriptRuntime.toInt32((Object)args);
            }
            if (!bNumOptional && nWidget < -1) {
                return this.throwException(args, 6);
            }
            Element oUIChild = this.getUIChild(nWidget, -1, false);
            FormField oFormField = this.getNode(nWidget, -1, false);
            if (oFormField != null && oUIChild != null && oUIChild.isSameClass(XFA.CHECKBUTTONTAG)) {
                boolean bIsChecked = false;
                boolean iCheckBox = false;
                Element oGroup = oFormField.getXFAParent();
                if (!(oGroup instanceof ExclGroup)) {
                    iCheckBox = true;
                }
                if (iCheckBox) {
                    Node oDisplay;
                    Element oDisplayItem = oFormField.getElement(XFA.ITEMSTAG, 0);
                    if (oDisplayItem != null && (oDisplay = oDisplayItem.getFirstXFAChild()) instanceof Element) {
                        TextNode textNode = ((Element)oDisplay).getText(true, false, false);
                        String sOnValue = textNode != null ? textNode.getValue() : "";
                        String svalue = oFormField.getRawValue();
                        bIsChecked = sOnValue.equals(svalue);
                    }
                } else {
                    String svalue = oFormField.getRawValue();
                    bIsChecked = "1".equals(svalue);
                }
                jsv = bIsChecked;
                bStatus = true;
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(args, 15));
    }

    public Object isDefaultChecked(Object args) {
        Boolean jsv = null;
        if (this.isObjectDead()) {
            return this.throwException(args, 14);
        }
        boolean bStatus = false;
        try {
            boolean bNumOptional;
            int nWidget = -1;
            boolean bl = bNumOptional = this.getWidgetNum() != -1;
            if (args == Undefined.instance) {
                if (!bNumOptional) {
                    return this.throwException(args, 6);
                }
            } else if (args instanceof NativeObject) {
                NativeObject obj = (NativeObject)args;
                Object value = obj.get("nWidget", (Scriptable)obj);
                if (value == Scriptable.NOT_FOUND) {
                    if (!bNumOptional) {
                        return this.throwException(args, 6);
                    }
                } else {
                    nWidget = ScriptRuntime.toInt32((Object)value);
                }
            } else {
                nWidget = ScriptRuntime.toInt32((Object)args);
            }
            if (!bNumOptional && nWidget < -1) {
                return this.throwException(args, 6);
            }
            FormField oFormField = this.getNode(nWidget, -1, false);
            Element oUIChild = this.getUIChild(nWidget, -1, false);
            if (oFormField != null && oUIChild != null && oUIChild.isSameClass(XFA.CHECKBUTTONTAG)) {
                boolean bIsDefaultChecked = false;
                jsv = bIsDefaultChecked;
                bStatus = true;
            }
        }
        catch (Exception ex) {
            bStatus = false;
        }
        return bStatus ? jsv : Boolean.valueOf(this.throwException(args, 15));
    }

    public void setFocus() {
        if (this.isObjectDead()) {
            this.throwException(null, 14);
        }
    }

    public void setItems(Object args) {
        if (this.isObjectDead()) {
            this.throwException(args, 14);
        }
        if (!this.formModifyOkay(true)) {
            this.throwException(args, 12);
        }
        boolean bStatus = false;
        NativeArray oArray = null;
        if (args instanceof NativeArray) {
            oArray = (NativeArray)args;
        } else if (args instanceof NativeObject) {
            NativeObject obj = (NativeObject)args;
            Object value = obj.get("oArray", (Scriptable)obj);
            if (!(value instanceof NativeArray)) {
                this.throwException(args, 6);
            }
            oArray = (NativeArray)value;
        } else {
            this.throwException(args, 6);
        }
        if (oArray != null) {
            FormField oFormField;
            Element oUIChild;
            int nLen;
            if (oArray.getLength() > Integer.MAX_VALUE) {
                this.throwException(args, 6);
            }
            if ((nLen = (int)oArray.getLength()) == 0) {
                this.throwException(args, 6);
            }
            if ((oUIChild = this.getUIChild()) != null && (oFormField = this.getNode(-1, -1, false)) != null && oUIChild.isSameClass(XFA.CHOICELISTTAG)) {
                boolean bMultiSelect;
                int eOpen = oUIChild.getEnum(XFA.OPENTAG);
                boolean bl = bMultiSelect = eOpen == 0x230003;
                if (!bMultiSelect) {
                    Field.ItemPair itemPair = new Field.ItemPair();
                    oFormField.getItemLists(false, itemPair, true);
                    Items oDisplayItem = itemPair.mDisplayItems;
                    Items oSaveItem = itemPair.mSaveItems;
                    if (oDisplayItem != null) {
                        Value oValue;
                        Element oValueContent;
                        int i;
                        for (i = oDisplayItem.getXFAChildCount(); i > 0; --i) {
                            oDisplayItem.removeChild(oDisplayItem.getXFAChild(i - 1));
                        }
                        for (i = oSaveItem.getXFAChildCount(); i > 0; --i) {
                            oSaveItem.removeChild(oSaveItem.getXFAChild(i - 1));
                        }
                        String sFirst = null;
                        NodeList oDisplayItems = oDisplayItem.getNodes();
                        NodeList oSaveItems = oSaveItem.getNodes();
                        for (int i2 = 0; i2 < nLen; ++i2) {
                            Object value = oArray.get(i2, (Scriptable)oArray);
                            if (value instanceof NativeArray) {
                                NativeArray subArray = (NativeArray)value;
                                if (subArray.getLength() != 2L) continue;
                                for (int j = 0; j < 2; ++j) {
                                    String sText = ScriptRuntime.toString((Object)subArray.get(j, (Scriptable)subArray));
                                    TextValue oValue2 = (TextValue)oFormField.getModel().createElement(XFA.TEXTTAG, null);
                                    oValue2.setValue(sText);
                                    if (j == 0) {
                                        if (i2 == 0) {
                                            sFirst = sText;
                                        }
                                        oDisplayItems.append(oValue2);
                                        continue;
                                    }
                                    oSaveItems.append(oValue2);
                                }
                                continue;
                            }
                            String sText = ScriptRuntime.toString((Object)value);
                            TextValue oValue3 = (TextValue)oFormField.getModel().createElement(XFA.TEXTTAG, null);
                            if (i2 == 0) {
                                sFirst = sText;
                            }
                            oValue3.setValue(sText);
                            oDisplayItems.append(oValue3);
                            TextValue oValue2 = (TextValue)oFormField.getModel().createElement(XFA.TEXTTAG, null);
                            oValue2.setValue(sText);
                            oSaveItems.append(oValue2);
                        }
                        if (oDisplayItems.length() > 1 && (oValueContent = (oValue = (Value)oFormField.getElement(XFA.VALUETAG, 0)).replaceContent(XFA.TEXTTAG)) instanceof TextNode) {
                            ((TextNode)((Object)oValueContent)).setValue(sFirst, true, false);
                        }
                    }
                }
                bStatus = true;
            }
        }
        if (!bStatus) {
            this.throwException(args, 8);
        }
    }

    private boolean initOK() {
        return this.getXFANode(-1, -1, false) != null;
    }

    private Node getWidgetNode(DocumentContext oDocContext, String SOMPath, int iWidgetNum) {
        StringBuilder somPath = new StringBuilder(SOMPath);
        somPath.append(".#field[").append(iWidgetNum).append(']');
        return oDocContext.getFieldXFANode(somPath.toString());
    }

    private Node getXFANode(int iArgWidget, int iForceWidget, boolean bGetCurSel) {
        Node xfanode = null;
        DocumentContext oDocContext = XFAField.getContext(this.pddoc);
        if (oDocContext != null) {
            if (this.isRadioButton == -1) {
                this.isRadioButton = this.iWidget != -1 ? 1 : (this.getWidgetNode(oDocContext, this.SOMPath, 0) != null ? 1 : 0);
            }
            if (this.isRadioButton != 0) {
                int iWidgetNum;
                int n = iWidgetNum = this.iWidget != -1 ? this.iWidget : iArgWidget;
                if (iForceWidget != -1) {
                    iWidgetNum = iForceWidget;
                }
                if (bGetCurSel && this.iWidget == -1) {
                    xfanode = oDocContext.getFieldXFANode(this.SOMPath);
                    if (xfanode != null) {
                        for (Node oChild = xfanode.getFirstXFAChild(); oChild != null; oChild = oChild.getNextXFASibling()) {
                            boolean bIsChecked;
                            if (!(oChild instanceof FormField)) continue;
                            FormField oField = (FormField)oChild;
                            String svalue = oField.getRawValue();
                            boolean bl = bIsChecked = svalue != null;
                            if (!bIsChecked) continue;
                            xfanode = oChild;
                            break;
                        }
                    }
                } else if (iWidgetNum == -1) {
                    xfanode = oDocContext.getFieldXFANode(this.SOMPath);
                } else {
                    xfanode = this.getWidgetNode(oDocContext, this.SOMPath, iWidgetNum);
                    if (xfanode == null && this.iWidget == -1) {
                        xfanode = this.getWidgetNode(oDocContext, this.SOMPath, 0);
                    }
                }
            } else {
                xfanode = oDocContext.getFieldXFANode(this.SOMPath);
            }
        }
        return xfanode;
    }

    private PDFDocument getPDDoc() {
        return this.pddoc;
    }

    private int getWidgetNum() {
        return this.iWidget;
    }

    private FormField getNode(int iArgWidget, int iForceWidget, boolean bGetCurSel) {
        FormField xfanode = null;
        Node oNode = this.getXFANode(iArgWidget, iForceWidget, bGetCurSel);
        if (oNode instanceof FormField) {
            xfanode = (FormField)oNode;
        }
        return xfanode;
    }

    private String getOrigName() {
        if (this.iWidget == -1) {
            return this.SOMPath;
        }
        StringBuilder buf = new StringBuilder(this.SOMPath);
        buf.append('.').append(this.iWidget);
        return buf.toString();
    }

    private boolean formModifyOkay(boolean bCheckXFA) {
        JavaScriptHandler jsHandler = JavaScriptHandler.getRegisteredInstance(this.pddoc);
        try {
            if (!jsHandler.isFormModifyOk()) {
                Doc topLevel = jsHandler.getDocLevelScope();
                EventObject event = null;
                if (topLevel == null || (event = (EventObject)((Object)topLevel.get("event", (Scriptable)topLevel))) == null) {
                    return false;
                }
                DocumentContext docContext = DocumentContext.find(this.pddoc, true, null);
                return JSUtils.esIsOperationAllowed((DocumentContext)docContext, (EventObject)event, valid, (boolean)true);
            }
        }
        catch (PDFUnableToCompleteOperationException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private boolean isObjectDead() {
        return false;
    }

    private boolean throwException(Object args, int esError) {
        String error = "";
        if (1 <= esError && esError <= 22) {
            error = ESExceptionMap[esError];
        }
        throw new EvaluatorException(error);
    }

    private int getDisplayCode(FormField oFormField) {
        AcroFormLayout oLayout;
        DocumentContext oDocContext = XFAField.getContext(this.getPDDoc());
        if (oDocContext != null && (oLayout = oDocContext.getAcroFormLayout()) != null) {
            return FormUtils.getDisplayCode(oLayout, oFormField);
        }
        return 0;
    }

    private Element getUIChild() {
        return this.getUIChild(-1, -1, false);
    }

    private Element getUIChild(int nWidget, int iForceWidget, boolean bGetCurSel) {
        UI oUIChild;
        Element res = null;
        FormField oFormField = this.getNode(nWidget, iForceWidget, bGetCurSel);
        if (oFormField != null && (oUIChild = (UI)oFormField.getElement(XFA.UITAG, 0)) != null) {
            res = oUIChild.getUIElement(false);
        }
        return res;
    }

    private static DocumentContext getContext(PDFDocument pdd) {
        DocumentContext oDocContext = DocumentContext.find(pdd, false, null);
        if (oDocContext != null && DocumentContext.isXFADoc(pdd) != null && oDocContext.isDocAGMRendered()) {
            return oDocContext;
        }
        return null;
    }

    private static boolean isMultipleSelect(Node oUIChild) {
        boolean bMultiSelect = false;
        if (oUIChild != null && oUIChild.isSameClass(XFA.CHOICELISTTAG)) {
            int eOpen = ((Element)oUIChild).getEnum(XFA.OPENTAG);
            bMultiSelect = eOpen == 0x230003;
        }
        return bMultiSelect;
    }

    static {
        valid.put(JSUtils.ESTriggerType.ESTRIGGERTYPE_DOC_STR, null);
        valid.put(JSUtils.ESTriggerType.ESTRIGGERTYPE_PAGE_STR, null);
        valid.put(JSUtils.ESTriggerType.ESTRIGGERTYPE_BOOKMARK_STR, null);
        valid.put(JSUtils.ESTriggerType.ESTRIGGERTYPE_LINK_STR, null);
        valid.put(JSUtils.ESTriggerType.ESTRIGGERTYPE_FIELD_STR, null);
        valid.put(JSUtils.ESTriggerType.ESTRIGGERTYPE_SCREENANNOT_STR, null);
        valid.put(JSUtils.ESTriggerType.ESTRIGGERTYPE_MEDIAPLAYER_STR, null);
        valid.put(JSUtils.ESTriggerType.AVTRIGGERTYPE_Annot_STR, null);
        valid.put(JSUtils.ESTriggerType.ESTRIGGERTYPE_OCG_STR, null);
        valid.put(null, null);
        ESExceptionMap = new String[]{"", "RangeError: Invalid argument value.", "TypeError: Invalid argument type.", "ReferenceError: Variable not defined.", "MissingArgError: Missing required argument.", "NumberOfArgsError: Invalid number of arguments.", "InvalidArgsError: Invalid arguments.", "InvalidGetError: Get not possible, invalid or unknown.", "InvalidSetError: Set not possible, invalid or unknown.", "OutOfMemoryError: Out of memory.", "NotSupportedError: Not supported in this Acrobat configuration.", "NotSupportedHFTError: Functionality not available as a necessary plug-in is not loaded.", "NotAllowedError: Security settings prevent access to this property or method.", "RaiseError: Acrobat Raise.", "DeadObjectError: Object is dead.", "GeneralError: Operation failed.", "HelpError: Help.", "UnsupportedValueError: Value is unsupported.", "ParamNumError: Parameter %ld.", "ParamNameError: Parameter %s.", "NumArgsError: Expected %ld parameters", "HelpParamError: %s%s\n", "IndentError:  "};
    }
}

