/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.manipulations.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosCloneMgr;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNameDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTree;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestination;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestinationExplicit;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFDestinationNamed;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFNamedDestinations;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.manipulations.impl.PDFPageWrapperSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;

public class PMMNamedDestinations {
    private static final char PERIOD = '.';
    private PDFDocument inDoc;
    private CosCloneMgr cloneHandler;
    private PDFNamedDestinations destTree = null;
    private CosDictionary dests = null;
    private TreeMap<ASString, ASString> mapDestsNames;
    private ASString suffix;
    private boolean combine;

    public PMMNamedDestinations(PDFDocument doc, CosCloneMgr clonehandler, boolean combining) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFNameDictionary names;
        this.cloneHandler = clonehandler;
        this.inDoc = doc;
        this.dests = null;
        this.destTree = null;
        if (doc.requireCatalog().getCosDictionary().containsKey(ASName.k_Dests)) {
            this.dests = (CosDictionary)doc.requireCatalog().getCosDictionary().get(ASName.k_Dests);
        }
        if ((names = doc.requireCatalog().getNameDictionary()) != null) {
            this.destTree = names.getNamedDestinations();
        }
        this.combine = combining;
        this.mapDestsNames = null;
        this.suffix = null;
    }

    public void deleteNamedDestinations(PDFPageWrapperSet pageWrapperSet) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Iterator<NamedDestinationsEntry> destIterator = this.getIterator();
        if (destIterator == null) {
            return;
        }
        while (destIterator.hasNext()) {
            NamedDestinationsEntry curEntry = destIterator.next();
            PDFDestination curDest = curEntry.getValue();
            if (curDest == null || !pageWrapperSet.contains(curDest.getPage())) continue;
            destIterator.remove();
        }
    }

    private Iterator<NamedDestinationsEntry> getIterator() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.destTree == null && this.dests == null) {
            return null;
        }
        return new PDFNamedDestinationIterator(this.destTree, this.dests);
    }

    public boolean containsName(ASString destName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean hasName = false;
        if (this.destTree != null) {
            boolean bl = hasName = this.destTree.getEntry(destName) != null;
            if (hasName) {
                return hasName;
            }
        }
        if (this.dests != null) {
            hasName = this.dests.containsKey(destName);
        }
        return hasName;
    }

    private ASString getNewDestName(ASString destName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASString newName = destName;
        ASString match = null;
        if (this.combine) {
            if (this.mapDestsNames == null) {
                this.mapDestsNames = new TreeMap();
                this.suffix = PMMNamedDestinations.calculateSuffix(this.getIterator());
            } else {
                match = this.findDestName(destName, this.mapDestsNames);
            }
            if (match != null) {
                return this.mapDestsNames.get(match);
            }
            newName = newName.concat(this.suffix);
            this.mapDestsNames.put(destName, newName);
        }
        return newName;
    }

    private static ASString calculateSuffix(Iterator<NamedDestinationsEntry> treeIter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int suffix = -1;
        if (treeIter == null) {
            return null;
        }
        while (treeIter.hasNext()) {
            NamedDestinationsEntry entry = treeIter.next();
            ASString srcName = entry.getKey();
            int periodPos = srcName.lastIndexOf(46);
            if (periodPos < 0) continue;
            try {
                int suffixNum;
                ASString suffixBytes = srcName.substring(periodPos + 1);
                if (suffixBytes == null || (suffixNum = new ASNumber(suffixBytes).intValue()) < 0) continue;
                suffix = Math.max(suffix, suffixNum);
            }
            catch (Exception exp) {}
        }
        StringBuilder suffixBuf = new StringBuilder();
        suffixBuf.append('.');
        suffixBuf.append(Integer.toString(++suffix));
        return new ASString(suffixBuf.toString());
    }

    private ASString findDestName(ASString name, Map<ASString, ?> allDests) {
        return allDests.containsKey(name) ? name : null;
    }

    public static PDFDestination cloneDestination(PDFDestination srcDest, PMMNamedDestinations curDests, Map<ASString, PDFDestinationNamed> allDests, Map<PDFPage, PDFPage> mapPages) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (srcDest == null) {
            return null;
        }
        PDFDestination clonedDest = null;
        ASString destName = srcDest.getName();
        clonedDest = destName == null ? curDests.cloneExplicitDestination(srcDest, mapPages) : curDests.cloneNamedDestination((PDFDestinationNamed)srcDest, destName, allDests, mapPages);
        return clonedDest;
    }

    private PDFDestinationNamed cloneNamedDestination(PDFDestinationNamed srcDest, ASString destName, Map<ASString, PDFDestinationNamed> allDests, Map<PDFPage, PDFPage> mapPages) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASString newDestName = this.getNewDestName(destName);
        ASString match = this.findDestName(newDestName, allDests);
        if (match != null) {
            return allDests.get(match);
        }
        PDFDestinationNamed cloned = null;
        try {
            PDFDestinationExplicit explicitDest = (PDFDestinationExplicit)this.cloneExplicitDestination(srcDest.getExplicitDestination(), mapPages);
            cloned = !this.combine && srcDest.getPDFDocument() == this.inDoc ? srcDest : PDFDestinationNamed.newInstance(this.inDoc, newDestName, explicitDest);
        }
        catch (PDFInvalidParameterException exp) {
            throw new PDFInvalidDocumentException("Invalid named destination", exp);
        }
        allDests.put(newDestName, cloned);
        return cloned;
    }

    private PDFDestination cloneExplicitDestination(PDFDestination srcDest, Map<PDFPage, PDFPage> mapPages) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (srcDest == null) {
            return null;
        }
        CosArray cosDest = srcDest.getCosArray();
        CosArray cloned = this.inDoc.getCosDocument().createCosArray();
        CosObject cosPage = cosDest.get(0);
        if (cosPage.getType() != 1) {
            if (mapPages != null) {
                PDFPage clonedPage = mapPages.get(srcDest.getPage());
                cosPage = clonedPage != null ? clonedPage.getCosObject() : this.inDoc.getCosDocument().createCosNull();
            }
        } else {
            cosPage = this.inDoc.getCosDocument().createCosNumeric(((CosNumeric)cosPage).numberValue());
        }
        cloned.add(cosPage);
        for (int arrayInd = 1; arrayInd < cosDest.size(); ++arrayInd) {
            cloned.add(this.cloneHandler.clone(cosDest.get(arrayInd)));
        }
        return PDFDestination.getInstance(cloned);
    }

    private class PDFNamedDestinationIterator
    implements Iterator {
        private Iterator<PDFTree.Entry> treeIterator;
        private Iterator<ASName> destsIterator;
        private int whichIterator;
        private static final int TREE_ITERATOR = 0;
        private static final int DESTS_ITERATOR = 1;
        private static final int NO_ITERATOR = 2;

        private PDFNamedDestinationIterator(PDFNamedDestinations destTree, CosDictionary dests) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            this.treeIterator = destTree != null ? destTree.iterator() : null;
            this.destsIterator = dests != null ? dests.keyIterator() : null;
            this.whichIterator = 0;
            if (this.treeIterator == null) {
                this.whichIterator = 1;
            }
            if (this.destsIterator == null && this.whichIterator != 0) {
                this.whichIterator = 2;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.whichIterator == 2) {
                return false;
            }
            switch (this.whichIterator) {
                case 0: {
                    if (this.treeIterator == null) {
                        return false;
                    }
                    if (this.treeIterator.hasNext()) {
                        return true;
                    }
                    this.whichIterator = 1;
                    return this.hasNext();
                }
                case 1: {
                    if (this.destsIterator == null) {
                        return false;
                    }
                    if (this.destsIterator.hasNext()) {
                        return true;
                    }
                    this.whichIterator = 2;
                }
            }
            return false;
        }

        public NamedDestinationsEntry next() {
            if (this.whichIterator == 0 && this.treeIterator != null) {
                PDFTree.Entry nextItem = this.treeIterator.next();
                try {
                    return new NamedDestinationsEntry((ASString)nextItem.getKey(), (PDFDestination)nextItem.getValue());
                }
                catch (PDFException e) {
                    NoSuchElementException newException = new NoSuchElementException("Error during PDFNamedDestinationIterator.next().");
                    newException.initCause(e);
                    throw newException;
                }
            }
            if (this.whichIterator == 1 && this.destsIterator != null) {
                ASName nextItem = this.destsIterator.next();
                NamedDestinationsEntry retItem = null;
                try {
                    retItem = new NamedDestinationsEntry(new ASString(nextItem.getBytes()), PDFDestination.getInstance(PMMNamedDestinations.this.dests.get(nextItem)));
                }
                catch (PDFException e) {
                    NoSuchElementException newException = new NoSuchElementException("Error during PDFNamedDestinationIterator.next().");
                    newException.initCause(e);
                    throw newException;
                }
                return retItem;
            }
            return null;
        }

        @Override
        public void remove() {
            switch (this.whichIterator) {
                case 0: {
                    if (this.treeIterator == null) break;
                    this.treeIterator.remove();
                    break;
                }
                case 1: {
                    if (this.destsIterator == null) break;
                    this.destsIterator.remove();
                    break;
                }
            }
        }
    }

    public class NamedDestinationsEntry {
        private ASString key;
        private PDFDestination value;

        protected NamedDestinationsEntry(ASString key, PDFDestination value) {
            this.key = key;
            this.value = value;
        }

        public ASString getKey() {
            return this.key;
        }

        public PDFDestination getValue() {
            return this.value;
        }
    }
}

