/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa;

import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAContentErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAErrorCode;
import java.util.ArrayList;

public class PDFAErrorSetContent
extends PDFAErrorSet {
    public PDFAErrorSetContent() {
        super(PDFAContentErrorCode.class);
    }

    public PDFAErrorSetContent(PDFAErrorCode errorCode) {
        this();
        this.addErrorCode(errorCode);
    }

    public boolean operatorNotAllowed() {
        return this.errorCodeSet(PDFAContentErrorCode.operatorNotAllowed);
    }

    public boolean renderingIntentValueNotAllowed() {
        return this.errorCodeSet(PDFAContentErrorCode.renderingIntentValueNotAllowed);
    }

    public boolean deviceDependentColorUsed() {
        return this.errorCodeSet(PDFAContentErrorCode.deviceDependentColorUsed);
    }

    public boolean optionalContentUsed() {
        return this.errorCodeSet(PDFAContentErrorCode.optionalContentUsed);
    }

    public boolean interpolationNotAllowed() {
        return this.errorCodeSet(PDFAContentErrorCode.interpolationNotAllowed);
    }

    public boolean inlineImageUsesLZWDecodeFilter() {
        return this.errorCodeSet(PDFAContentErrorCode.inlineImageUsesLZWDecodeFilter);
    }

    public boolean integerNumberFormatIncorrect() {
        return this.errorCodeSet(PDFAContentErrorCode.integerNumberFormatIncorrect);
    }

    public boolean realNumberFormatIncorrect() {
        return this.errorCodeSet(PDFAContentErrorCode.realNumberFormatIncorrect);
    }

    public boolean nameLengthIncorrect() {
        return this.errorCodeSet(PDFAContentErrorCode.nameLengthIncorrect);
    }

    public boolean arrayLengthIncorrect() {
        return this.errorCodeSet(PDFAContentErrorCode.arrayLengthIncorrect);
    }

    public boolean dictionarySizeIncorrect() {
        return this.errorCodeSet(PDFAContentErrorCode.dictionarySizeIncorrect);
    }

    public boolean stringLengthIncorrect() {
        return this.errorCodeSet(PDFAContentErrorCode.stringLengthIncorrect);
    }

    @Override
    public boolean pdfGeneralFailure() {
        return this.errorCodeSet(PDFAContentErrorCode.pdfGeneralFailure);
    }

    @Override
    public String toString() {
        ArrayList<String> violations = new ArrayList<String>(10);
        if (this.pdfGeneralFailure()) {
            violations.add("pdf general failure");
        }
        if (this.operatorNotAllowed()) {
            violations.add("operator not allowed");
        }
        if (this.renderingIntentValueNotAllowed()) {
            violations.add("ri value not permitted");
        }
        if (this.deviceDependentColorUsed()) {
            violations.add("device-dependent color used not backed by output intent or default color space");
        }
        if (this.optionalContentUsed()) {
            violations.add("optional content (via DP or BDC operator) encountered");
        }
        if (this.interpolationNotAllowed()) {
            violations.add("interpolation now allowed for images");
        }
        if (this.inlineImageUsesLZWDecodeFilter()) {
            violations.add("inline image uses LZWDecode filter");
        }
        if (this.integerNumberFormatIncorrect()) {
            violations.add("Implementation Limits - integer number size out of bounds");
        }
        if (this.realNumberFormatIncorrect()) {
            violations.add("Implementation Limits - real number size out of bounds");
        }
        if (this.nameLengthIncorrect()) {
            violations.add("Implementation Limits - name length exceeds size 127");
        }
        if (this.arrayLengthIncorrect()) {
            violations.add("Implementation Limits - array length exceeds 8191");
        }
        if (this.dictionarySizeIncorrect()) {
            violations.add("Implementation Limits - dictionary size exceeds 4095");
        }
        if (this.stringLengthIncorrect()) {
            violations.add("Implementation Limits - string byte length exceeds 65535");
        }
        return super.toString() + " " + violations;
    }
}

