/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa;

import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAPageErrorCode;
import java.util.ArrayList;

public class PDFAErrorSetPage
extends PDFAErrorSet {
    public PDFAErrorSetPage() {
        super(PDFAPageErrorCode.class);
    }

    public PDFAErrorSetPage(PDFAErrorCode errorCode) {
        this();
        this.addErrorCode(errorCode);
    }

    public boolean nonUnityUserUnits() {
        return this.errorCodeSet(PDFAPageErrorCode.nonUnityUserUnits);
    }

    public boolean actionLaunchPresent() {
        return this.errorCodeSet(PDFAPageErrorCode.actionLaunchNotAllowed);
    }

    public boolean actionSoundPresent() {
        return this.errorCodeSet(PDFAPageErrorCode.actionSoundNotAllowed);
    }

    public boolean actionMoviePresent() {
        return this.errorCodeSet(PDFAPageErrorCode.actionMovieNotAllowed);
    }

    public boolean actionResetFormNotPresent() {
        return this.errorCodeSet(PDFAPageErrorCode.actionResetFormNotAllowed);
    }

    public boolean actionImportDataPresent() {
        return this.errorCodeSet(PDFAPageErrorCode.actionImportDataNotAllowed);
    }

    public boolean actionJavaScriptPresent() {
        return this.errorCodeSet(PDFAPageErrorCode.actionJavaScriptNotAllowed);
    }

    public boolean actionSetStatePresent() {
        return this.errorCodeSet(PDFAPageErrorCode.actionSetStateNotAllowed);
    }

    public boolean actionNoOpPresent() {
        return this.errorCodeSet(PDFAPageErrorCode.actionNoOpNotAllowed);
    }

    public boolean namedActionNotAllowed() {
        return this.errorCodeSet(PDFAPageErrorCode.namedActionNotAllowed);
    }

    public boolean transparencyGroupNotAllowed() {
        return this.errorCodeSet(PDFAPageErrorCode.transparencyGroupNotAllowed);
    }

    public boolean objectXMPMetadataInvalid() {
        return this.errorCodeSet(PDFAPageErrorCode.objectXMPMetadataInvalid);
    }

    public boolean additionalActionsNotAllowed() {
        return this.actionImportDataPresent() || this.actionJavaScriptPresent() || this.actionLaunchPresent() || this.actionMoviePresent() || this.actionNoOpPresent() || this.actionResetFormNotPresent() || this.actionSetStatePresent() || this.actionSoundPresent() || this.namedActionNotAllowed();
    }

    @Override
    public boolean pdfGeneralFailure() {
        return this.errorCodeSet(PDFAPageErrorCode.pdfGeneralFailure);
    }

    public static PDFAPageErrorCode getErrorCode(ASName subtype) {
        if (subtype == ASName.k_Launch) {
            return PDFAPageErrorCode.actionLaunchNotAllowed;
        }
        if (subtype == ASName.k_Sound) {
            return PDFAPageErrorCode.actionSoundNotAllowed;
        }
        if (subtype == ASName.k_Movie) {
            return PDFAPageErrorCode.actionMovieNotAllowed;
        }
        if (subtype == ASName.k_ResetForm) {
            return PDFAPageErrorCode.actionResetFormNotAllowed;
        }
        if (subtype == ASName.k_ImportData) {
            return PDFAPageErrorCode.actionImportDataNotAllowed;
        }
        if (subtype == ASName.k_JavaScript) {
            return PDFAPageErrorCode.actionJavaScriptNotAllowed;
        }
        String typeString = subtype.asString();
        if ("set-state".equalsIgnoreCase(typeString) || "setstate".equalsIgnoreCase(typeString)) {
            return PDFAPageErrorCode.actionSetStateNotAllowed;
        }
        if ("no-op".equalsIgnoreCase(typeString) || "nop".equalsIgnoreCase(typeString)) {
            return PDFAPageErrorCode.actionNoOpNotAllowed;
        }
        return null;
    }

    @Override
    public String toString() {
        ArrayList<String> violations = new ArrayList<String>();
        if (this.pdfGeneralFailure()) {
            violations.add("pdf general failure");
        }
        if (this.nonUnityUserUnits()) {
            violations.add("UserUnits not set to 1.0");
        }
        if (this.actionLaunchPresent()) {
            violations.add("action launch not allowed");
        }
        if (this.actionSoundPresent()) {
            violations.add("action sound not allowed");
        }
        if (this.actionMoviePresent()) {
            violations.add("action movie not allowed");
        }
        if (this.actionResetFormNotPresent()) {
            violations.add("action resetform not allowed");
        }
        if (this.actionImportDataPresent()) {
            violations.add("action import data not allowed");
        }
        if (this.actionJavaScriptPresent()) {
            violations.add("action javascript not allowed");
        }
        if (this.actionSetStatePresent()) {
            violations.add("action set state not allowed");
        }
        if (this.actionNoOpPresent()) {
            violations.add("action no-op not allowed");
        }
        if (this.additionalActionsNotAllowed()) {
            violations.add("Document contains Additional Actions");
        }
        if (this.namedActionNotAllowed()) {
            violations.add("Named actions other than NextPage, PrevPage, FirstPage, and LastPage shall not be permitted");
        }
        if (this.transparencyGroupNotAllowed()) {
            violations.add("A Group object with an S key with a value of Transparency shall not be included in a page dictionary");
        }
        if (this.objectXMPMetadataInvalid()) {
            violations.add("Object XMP metadata is not valid");
        }
        return super.toString() + " " + violations;
    }
}

