/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAXMPSchema;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.SchemaCollector;
import com.adobe.internal.pdftoolkit.xml.XMLUtils;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;

public class PDFAExternalSchemas {
    @Deprecated
    private Map<String, PDFAXMPSchema> externalSchemas = new HashMap<String, PDFAXMPSchema>();

    public void addExternalSchema(InputStream schemaStream) throws PDFConfigurationException, PDFInvalidXMLException {
        Map<String, PDFAXMPSchema> schemas = this.extractSchemas(schemaStream, false);
        this.externalSchemas.putAll(schemas);
    }

    private Map<String, PDFAXMPSchema> extractSchemas(InputStream schemaStream, boolean badSchemas) throws PDFConfigurationException, PDFInvalidXMLException {
        SchemaCollector collector;
        try {
            collector = new SchemaCollector(badSchemas);
            InputSource source = new InputSource(schemaStream);
            Source inputXML = XMLUtils.createSource(source, (XMLFilter)collector, false, true);
            Result outputXML = XMLUtils.createNullResult();
            XMLUtils.transformToXML(inputXML, outputXML, true);
        }
        catch (SAXException e) {
            throw new PDFConfigurationException("Unable to set namespace features on XML Reader.", e);
        }
        catch (TransformerException e) {
            throw new PDFInvalidXMLException("Supplied XMP Schema was invalid.", e);
        }
        return collector.getSchemas();
    }

    public Map<String, PDFAXMPSchema> getSchemas() {
        return Collections.unmodifiableMap(this.externalSchemas);
    }
}

