/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.rasterizer.impl;

import com.adobe.internal.pdftoolkit.graphicsDOM.GraphicsState;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterBlendingContext;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;

class RasterBlendingComposite
implements Composite {
    private float alpha;
    private GraphicsState.BlendingMode mode;

    public RasterBlendingComposite(GraphicsState.BlendingMode mode, float alpha) {
        this.mode = mode;
        this.alpha = alpha;
    }

    @Override
    public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
        return new RasterBlendingContext(this);
    }

    public float getAlpha() {
        return this.alpha;
    }

    public GraphicsState.BlendingMode getMode() {
        return this.mode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RasterBlendingComposite)) {
            return false;
        }
        RasterBlendingComposite rasterBlendingComposite = (RasterBlendingComposite)obj;
        return this.mode == rasterBlendingComposite.mode && this.alpha == rasterBlendingComposite.alpha;
    }
}

