/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.rasterizer.impl;

import com.adobe.internal.pdftoolkit.graphicsDOM.ContentItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentItemsList;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentPathItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentType;
import com.adobe.internal.pdftoolkit.graphicsDOM.DocumentContext;
import com.adobe.internal.pdftoolkit.graphicsDOM.GraphicsState;
import com.adobe.internal.pdftoolkit.graphicsDOM.PathPainting;
import com.adobe.internal.pdftoolkit.graphicsDOM.ShadingPattern;
import com.adobe.internal.pdftoolkit.graphicsDOM.TextState;
import com.adobe.internal.pdftoolkit.graphicsDOM.XObject;
import com.adobe.internal.pdftoolkit.graphicsDOM.utils.GraphicsUtils;
import com.adobe.internal.pdftoolkit.services.rasterizer.RasterCallBackInterface;
import com.adobe.internal.pdftoolkit.services.rasterizer.RasterizationOptions;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.PDFToRasterConverter;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterAxialShading;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterContentImageItem;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterContentItem;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterCoonsPatchMeshesShading;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterDocumentContext;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterFunctionBasedShading;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterGraphicsState;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterRadialShading;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterTilingContext;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterTilingPatternOptimizer;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterXobject;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class RasterContentPathItem
extends ContentPathItem<RasterGraphicsState>
implements RasterContentItem {
    private ContentType type = ContentType.Path;
    boolean textWithNoPattern = false;
    private static double smallCurveThreshold = 1.0;
    static int BUFFEREDIMAGE_MAX_PIXELS = 16000000;
    static double DEFAULT_SCALE_DOWN_FACTOR = 0.25;
    private static Set<XObject> usedSoftMask;

    public RasterContentPathItem(RasterGraphicsState graphicsState, int id) {
        super(graphicsState, id);
    }

    public RasterContentPathItem(RasterGraphicsState graphicsState, int id, ContentType type) {
        this(graphicsState, id);
        this.type = type;
    }

    @Override
    public void writeToDisplayArea(DocumentContext context) {
        RasterDocumentContext rasterDocumentContext = (RasterDocumentContext)context;
        RasterizationOptions options = rasterDocumentContext.getOptions();
        if (this.type == ContentType.Path && options != null && options.getCallBackManager() != null && !options.getCallBackManager().processPath(rasterDocumentContext.getGraphics2d(), this)) {
            return;
        }
        GeneralPath currentPath = this.getPath();
        AffineTransform transform = new AffineTransform();
        if (rasterDocumentContext.getIsScaled()) {
            double widthScalingFactor = rasterDocumentContext.getWidthScalingFactor();
            double heightScalingFactor = rasterDocumentContext.getHeightScalingFactor();
            transform.scale(widthScalingFactor, heightScalingFactor);
        }
        if (this.getTransformationMatrix() != null) {
            transform.concatenate(new AffineTransform(this.getTransformationMatrix().getValues()));
        }
        currentPath.transform(transform);
        super.writeToDisplayArea(context);
        if (!(rasterDocumentContext instanceof RasterTilingContext) || !((RasterTilingContext)rasterDocumentContext).getIsFlipTilingPattern()) {
            rasterDocumentContext.getTransformedPath(currentPath, rasterDocumentContext.getPageHeight());
        }
        this.render(rasterDocumentContext, currentPath, transform);
        this.notifyCallBackManager(rasterDocumentContext, currentPath, transform);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void render(RasterDocumentContext rasterDocumentContext, GeneralPath currentPath, AffineTransform transform) {
        ShadingPattern<? extends GraphicsState, ? extends TextState, ? extends ContentItem<? extends GraphicsState>> shadingObj;
        BufferedImage image;
        String key;
        RasterGraphicsState graphicsState = (RasterGraphicsState)this.getGState();
        PathPainting pathPainting = this.getPathPaintingType();
        boolean fill = pathPainting.isFill();
        boolean stroke = pathPainting.isStroke();
        Graphics2D graphics2d = rasterDocumentContext.getGraphics2d();
        Composite originalComposite = graphics2d.getComposite();
        GraphicsState.BlendingMode blendingMode = rasterDocumentContext.getBlendingMode();
        int width = rasterDocumentContext.getWidth();
        int height = rasterDocumentContext.getPageHeight();
        if (fill) {
            this.setBlendingMode(graphics2d, graphicsState, rasterDocumentContext, graphicsState.getFillColorValues(), blendingMode);
            key = graphicsState.getFillShadingPatternName();
            if (key != null && !graphicsState.getLoadedShadingPatterns().isEmpty()) {
                if (!this.getIsShadingPresent()) {
                    image = null;
                    int scaleFactor = 1;
                    GeneralPath origPath = new GeneralPath(currentPath);
                    while (currentPath.getBounds().getHeight() * currentPath.getBounds().getWidth() > (double)BUFFEREDIMAGE_MAX_PIXELS) {
                        scaleFactor = (int)((double)scaleFactor * (1.0 / DEFAULT_SCALE_DOWN_FACTOR));
                        currentPath.transform(new AffineTransform(DEFAULT_SCALE_DOWN_FACTOR, 0.0, 0.0, DEFAULT_SCALE_DOWN_FACTOR, 0.0, 0.0));
                    }
                    image = this.applyshading(currentPath, graphicsState, rasterDocumentContext, key, true, scaleFactor);
                    AffineTransform origTransform = transform;
                    transform.scale(scaleFactor, scaleFactor);
                    graphics2d.clip(origPath);
                    if (image != null) {
                        graphics2d.drawRenderedImage(image, transform);
                    }
                    transform = origTransform;
                    currentPath = origPath;
                } else {
                    shadingObj = graphicsState.getLoadedShadingPatterns().get(graphicsState.getFillShadingPatternName());
                    if (shadingObj != null) {
                        if (shadingObj instanceof RasterRadialShading) {
                            ((RasterRadialShading)shadingObj).setCTM(this.getTransformationMatrix());
                        } else if (shadingObj instanceof RasterCoonsPatchMeshesShading) {
                            ((RasterCoonsPatchMeshesShading)shadingObj).setCTM(this.getTransformationMatrix());
                        }
                        shadingObj.writeToDisplayArea(rasterDocumentContext);
                    }
                }
            } else if (graphicsState.getFillTilingPatternName() != null) {
                this.fillWithPattern(rasterDocumentContext, currentPath);
            } else if (graphicsState.getGraphicsStateSoftMask() != null) {
                BufferedImage tempBackground = new BufferedImage(width, height, 2);
                Graphics2D tempG2d = tempBackground.createGraphics();
                tempG2d.drawImage(rasterDocumentContext.getImage(), null, (int)graphics2d.getTransform().getTranslateX(), (int)graphics2d.getTransform().getTranslateY());
                this.copyGraphics2DAttributes(tempG2d, graphics2d);
                tempG2d.fill(currentPath);
                BufferedImage xObjectForm = new BufferedImage(rasterDocumentContext.getImage().getWidth(), rasterDocumentContext.getImage().getHeight(), 2);
                RasterXobject sMask = (RasterXobject)graphicsState.getGraphicsStateSoftMask();
                BufferedImage oldImage = rasterDocumentContext.getImage();
                Graphics2D oldGraphics2d = rasterDocumentContext.getGraphics2d();
                graphicsState.setGraphicsStateSoftMask(null);
                graphicsState.setCachedSoftMask(null);
                try {
                    Graphics2D maskGraphics2d = xObjectForm.createGraphics();
                    rasterDocumentContext.setGraphics2d(maskGraphics2d);
                    rasterDocumentContext.setIsGSSoftMask(true);
                    ContentItemsList sMaskCIList = sMask.getContentItems();
                    Iterator ciListIter = sMaskCIList.iterator();
                    while (ciListIter.hasNext()) {
                        Object ciObject = ciListIter.next();
                        if (!(ciObject instanceof RasterContentImageItem)) continue;
                        RasterContentImageItem imageItem = (RasterContentImageItem)ciObject;
                        imageItem.setIsSoftMaskImage(true);
                    }
                    RasterContentPathItem.writeToDisplayAreaForSoftMask(sMask, rasterDocumentContext);
                }
                finally {
                    rasterDocumentContext.setIsGSSoftMask(false);
                    rasterDocumentContext.setGraphics2d(oldGraphics2d);
                    rasterDocumentContext.setImage(oldImage);
                }
                this.applySoftMask(tempBackground, xObjectForm, rasterDocumentContext);
                graphicsState.setGraphicsStateSoftMask(sMask);
                graphicsState.setCachedSoftMask(sMask);
            } else {
                graphics2d.fill(currentPath);
            }
        }
        graphics2d.setComposite(originalComposite);
        if (stroke) {
            this.setBlendingMode(graphics2d, graphicsState, rasterDocumentContext, graphicsState.getStrokeColorValues(), blendingMode);
            this.setLineWidthForStroke(graphics2d, rasterDocumentContext.getHeightScalingFactor());
            key = graphicsState.getStrokeShadingPatternName();
            if (key != null && !graphicsState.getLoadedShadingPatterns().isEmpty()) {
                if (!this.getIsShadingPresent()) {
                    image = this.applyshading(currentPath, graphicsState, rasterDocumentContext, key, false, 1);
                    graphics2d.clip(currentPath);
                    if (image != null) {
                        graphics2d.drawRenderedImage(image, transform);
                    }
                } else {
                    shadingObj = graphicsState.getLoadedShadingPatterns().get(graphicsState.getFillShadingPatternName());
                    if (shadingObj != null) {
                        if (shadingObj instanceof RasterRadialShading) {
                            ((RasterRadialShading)shadingObj).setCTM(this.getTransformationMatrix());
                        } else if (shadingObj instanceof RasterCoonsPatchMeshesShading) {
                            ((RasterCoonsPatchMeshesShading)shadingObj).setCTM(this.getTransformationMatrix());
                        }
                        shadingObj.writeToDisplayArea(rasterDocumentContext);
                    }
                }
            } else if (graphicsState.getStrokeTilingPatternName() != null) {
                this.strokeWithPattern(rasterDocumentContext, currentPath);
            } else {
                currentPath = this.getPoints(currentPath, width, height);
                graphics2d.draw(currentPath);
            }
        }
        graphics2d.setComposite(originalComposite);
    }

    protected static void writeToDisplayAreaForSoftMask(RasterXobject sMask, RasterDocumentContext rasterDocumentContext) {
        if (usedSoftMask == null) {
            usedSoftMask = new HashSet<XObject>();
        }
        if (rasterDocumentContext.getIsScaled()) {
            if (usedSoftMask.contains(sMask)) {
                rasterDocumentContext.setIsScale(false);
                sMask.writeToDisplayArea(rasterDocumentContext);
                rasterDocumentContext.setIsScale(true);
            } else {
                usedSoftMask.add(sMask);
                sMask.writeToDisplayArea(rasterDocumentContext);
            }
        } else {
            sMask.writeToDisplayArea(rasterDocumentContext);
        }
    }

    private void applySoftMask(BufferedImage tempBackground, BufferedImage xObjectForm, RasterDocumentContext rasterDocumentContext) {
        int[] pixels = ((DataBufferInt)tempBackground.getRaster().getDataBuffer()).getData();
        int[] smaskPixels = ((DataBufferInt)xObjectForm.getRaster().getDataBuffer()).getData();
        int height = rasterDocumentContext.getPageHeight();
        int width = rasterDocumentContext.getWidth();
        for (int index = 0; index < height * width; ++index) {
            int red = this.adjustRange(pixels[index] >> 16 & 0xFF);
            int green = this.adjustRange(pixels[index] >> 8 & 0xFF);
            int blue = this.adjustRange(pixels[index] & 0xFF);
            pixels[index] = smaskPixels[index] << 24 | red << 16 | green << 8 | blue;
        }
        Composite origComp = rasterDocumentContext.getGraphics2d().getComposite();
        rasterDocumentContext.getGraphics2d().setComposite(AlphaComposite.SrcOver);
        rasterDocumentContext.getGraphics2d().drawImage(tempBackground, null, 0, 0);
        rasterDocumentContext.getGraphics2d().setComposite(origComp);
    }

    private int adjustRange(int color) {
        if (color < 0) {
            color += 255;
        }
        return color;
    }

    private void copyGraphics2DAttributes(Graphics2D tempG2d, Graphics2D graphics2d) {
        tempG2d.setBackground(graphics2d.getBackground());
        tempG2d.setColor(graphics2d.getColor());
        tempG2d.setStroke(graphics2d.getStroke());
        tempG2d.setPaint(graphics2d.getPaint());
        tempG2d.setClip(graphics2d.getClip());
        tempG2d.setRenderingHints(graphics2d.getRenderingHints());
        tempG2d.setComposite(graphics2d.getComposite());
        tempG2d.setFont(graphics2d.getFont());
        tempG2d.setTransform(graphics2d.getTransform());
    }

    private GeneralPath getPoints(GeneralPath originalPath, int width, int height) {
        GeneralPath modifiedPath = new GeneralPath();
        double[] coords = new double[6];
        Point point = new Point();
        int maxAttr = Math.max(width, height);
        if (maxAttr >= 20000) {
            smallCurveThreshold = 6.0;
        } else if (maxAttr >= 10000) {
            smallCurveThreshold = 4.0;
        } else if (maxAttr >= 5000) {
            smallCurveThreshold = 2.0;
        }
        MaxCoordinates maxCoordinates = new MaxCoordinates();
        PathIterator pi = originalPath.getPathIterator(null);
        while (!pi.isDone()) {
            Point2D currentPoint = modifiedPath.getCurrentPoint();
            if (currentPoint != null) {
                point.x = (int)currentPoint.getX();
                point.y = (int)currentPoint.getY();
            }
            switch (pi.currentSegment(coords)) {
                case 0: {
                    modifiedPath.moveTo(coords[0], coords[1]);
                    maxCoordinates.xMax = coords[0];
                    maxCoordinates.yMax = coords[1];
                    break;
                }
                case 1: {
                    modifiedPath.lineTo(coords[0], coords[1]);
                    break;
                }
                case 3: {
                    if (this.isSmallCurve(coords, maxCoordinates)) {
                        if (this.isSignificantlySmallCurve(point, maxCoordinates.xMax, maxCoordinates.yMax, height, width)) break;
                        modifiedPath.lineTo(coords[4], coords[5]);
                        break;
                    }
                    modifiedPath.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 2: {
                    if (this.isSmallCurve(coords, maxCoordinates)) {
                        if (this.isSignificantlySmallCurve(point, maxCoordinates.xMax, maxCoordinates.yMax, height, width)) break;
                        modifiedPath.lineTo(coords[2], coords[3]);
                        break;
                    }
                    modifiedPath.quadTo(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 4: {
                    modifiedPath.closePath();
                }
            }
            pi.next();
        }
        return modifiedPath;
    }

    private boolean isSignificantlySmallCurve(Point point, double xMax, double yMax, int height, int width) {
        return Math.abs((int)xMax) - point.x < 1 && Math.abs((int)yMax - point.y) < 1 && point.x <= width && point.y <= height;
    }

    private boolean isSmallCurve(double[] coords, MaxCoordinates max) {
        double xMin = coords[0];
        double yMin = coords[1];
        max.xMax = coords[0];
        max.yMax = coords[1];
        for (int i = 2; i < coords.length; i += 2) {
            xMin = xMin < coords[i] ? xMin : coords[i];
            max.xMax = max.xMax > coords[i] ? max.xMax : coords[i];
            yMin = yMin < coords[i + 1] ? yMin : coords[i + 1];
            max.yMax = max.yMax > coords[i + 1] ? max.yMax : coords[i + 1];
        }
        return max.xMax - xMin < smallCurveThreshold && max.yMax - yMin < smallCurveThreshold;
    }

    private void notifyCallBackManager(RasterDocumentContext rasterDocumentContext, GeneralPath currentPath, AffineTransform transform) {
        if (rasterDocumentContext instanceof RasterTilingContext) {
            return;
        }
        RasterCallBackInterface manager = rasterDocumentContext.getOptions().getCallBackManager();
        if (manager != null) {
            if (this.type == ContentType.Path) {
                manager.drawnPath(transform, currentPath, this, rasterDocumentContext.getLoadedTilingPatternsTiles());
            } else if (this.type == ContentType.Text) {
                manager.drawnText(transform, currentPath, this, rasterDocumentContext.getLoadedTilingPatternsTiles());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BufferedImage applyshading(GeneralPath currentPath, RasterGraphicsState graphicsState, RasterDocumentContext context, String key, boolean fill, int scaleFactor) {
        ShadingPattern<? extends GraphicsState, ? extends TextState, ? extends ContentItem<? extends GraphicsState>> shadingObj = graphicsState.getLoadedShadingPatterns().get(key);
        if (shadingObj == null) {
            return null;
        }
        double[] matrix = shadingObj.getMatrix();
        Rectangle bounds = currentPath.getBounds();
        AffineTransform transform = null;
        Graphics2D graphics2d = context.getGraphics2d();
        int width = bounds.width;
        int height = bounds.height;
        if (width <= 0) return null;
        if (height <= 0) {
            return null;
        }
        BufferedImage image = null;
        Graphics g2 = null;
        try {
            if (shadingObj == null) return image;
            switch (shadingObj.getShadingType()) {
                case Axial: {
                    RasterAxialShading axialShading = (RasterAxialShading)shadingObj;
                    AffineTransform transform1 = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, context.getPageHeight());
                    AffineTransform scaleTransform = new AffineTransform();
                    scaleTransform.scale(context.getWidthScalingFactor(), context.getHeightScalingFactor());
                    currentPath.transform(new AffineTransform(scaleFactor, 0.0f, 0.0f, scaleFactor, 0.0f, 0.0f));
                    currentPath.transform(transform1);
                    try {
                        currentPath.transform(scaleTransform.createInverse());
                    }
                    catch (NoninvertibleTransformException e) {
                        e.printStackTrace();
                    }
                    axialShading.setCurrentPath(currentPath);
                    if (!fill) {
                        axialShading.setStroke(true);
                    }
                    axialShading.writeToDisplayArea(context);
                    BufferedImage e = null;
                    return e;
                }
                case Radial: {
                    currentPath.transform(new AffineTransform(scaleFactor, 0.0f, 0.0f, scaleFactor, 0.0f, 0.0f));
                    transform = matrix != null ? new AffineTransform(matrix[0], matrix[2], matrix[1], matrix[3], matrix[4], (double)context.getPageHeight() - matrix[5]) : new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                    RasterRadialShading radialShading = (RasterRadialShading)shadingObj;
                    transform.scale(scaleFactor, scaleFactor);
                    radialShading.postProcessing(bounds.height, bounds.width, graphics2d, currentPath, transform, context.getPageHeight(), fill);
                    BufferedImage transform1 = null;
                    return transform1;
                }
                case FunctionBased: {
                    RasterFunctionBasedShading functionBasedShading = (RasterFunctionBasedShading)shadingObj;
                    image = new BufferedImage(width, height, 2);
                    g2 = image.createGraphics();
                    g2 = functionBasedShading.postProcessing(bounds.height, bounds.width, (Graphics2D)g2, fill);
                    return image;
                }
                case CoonsPatchMeshes: {
                    RasterCoonsPatchMeshesShading coonsPatchMeshesShading = (RasterCoonsPatchMeshesShading)shadingObj;
                    if (matrix != null) {
                        double[] shadingMatrix = coonsPatchMeshesShading.getMatrix();
                        int h = (int)coonsPatchMeshesShading.getCoordDecode()[1].getY();
                        int w = (int)coonsPatchMeshesShading.getCoordDecode()[0].getY();
                        bounds = new Rectangle((int)shadingMatrix[4], (int)((double)context.getPageHeight() - (shadingMatrix[5] + (double)h)), w, h);
                    }
                    graphics2d = coonsPatchMeshesShading.applyCoonsPatchMeshes(graphics2d, bounds, fill);
                    return image;
                }
            }
            return image;
        }
        finally {
            if (g2 != null) {
                g2.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillWithPattern(RasterDocumentContext context, GeneralPath currentPath) {
        Shape origClipPath = context.getGraphics2d().getClip();
        AffineTransform affineTransform = new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, (double)context.getPageHeight());
        GeneralPath transformedCurrentPath = (GeneralPath)currentPath.clone();
        transformedCurrentPath.transform(affineTransform);
        Area clipPath = ((RasterGraphicsState)this.getGState()).getClipPath();
        try {
            Area currentClipPath = null;
            if (clipPath != null) {
                clipPath.transform(affineTransform);
                currentClipPath = new Area(clipPath);
                currentClipPath.intersect(new Area(currentPath));
            } else {
                currentClipPath = new Area(currentPath);
            }
            context.getGraphics2d().setClip(currentClipPath);
            RasterTilingPatternOptimizer.paintWithPattern(context, transformedCurrentPath.getBounds2D(), (RasterGraphicsState)this.getGState());
        }
        finally {
            context.getGraphics2d().setClip(origClipPath);
            if (clipPath != null) {
                clipPath.transform(affineTransform);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void strokeWithPattern(RasterDocumentContext context, GeneralPath currentPath) {
        Shape origClipPath = context.getGraphics2d().getClip();
        String fillTilingPatternName = ((RasterGraphicsState)this.getGState()).getFillTilingPatternName();
        AffineTransform affineTransform = new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, (double)context.getPageHeight());
        GeneralPath transformedCurrentPath = (GeneralPath)currentPath.clone();
        transformedCurrentPath.transform(affineTransform);
        Area clipPath = ((RasterGraphicsState)this.getGState()).getClipPath();
        try {
            Area newClipPath = new Area(new BasicStroke((float)((RasterGraphicsState)this.getGState()).getLineWidth(), ((RasterGraphicsState)this.getGState()).getLineCap().getValue(), ((RasterGraphicsState)this.getGState()).getLineJoin().getValue()).createStrokedShape(currentPath));
            Area currentClipPath = null;
            if (clipPath != null) {
                clipPath.transform(affineTransform);
                currentClipPath = new Area(clipPath);
                currentClipPath.intersect(newClipPath);
            } else {
                currentClipPath = newClipPath;
            }
            context.getGraphics2d().setClip(currentClipPath);
            ((RasterGraphicsState)this.getGState()).setFillTilingPatternName(((RasterGraphicsState)this.getGState()).getStrokeTilingPatternName());
            RasterTilingPatternOptimizer.paintWithPattern(context, transformedCurrentPath.getBounds2D(), (RasterGraphicsState)this.getGState());
        }
        finally {
            context.getGraphics2d().setClip(origClipPath);
            ((RasterGraphicsState)this.getGState()).setFillTilingPatternName(fillTilingPatternName);
            if (clipPath != null) {
                clipPath.transform(affineTransform);
            }
        }
    }

    private void setBlendingMode(Graphics2D graphics2d, RasterGraphicsState graphicsState, RasterDocumentContext rasterDocumentContext, double[] values, GraphicsState.BlendingMode blendingMode) {
        if (values != null) {
            graphics2d.setColor(new Color(GraphicsUtils.toARGB(values, graphicsState.getNonStrokeAlpha()), true));
        }
        if (blendingMode != GraphicsState.BlendingMode.NORMAL) {
            double alpha = rasterDocumentContext.getNonStrokeAlpha();
            if (values != null) {
                graphics2d.setColor(new Color(GraphicsUtils.toARGB(values, alpha), true));
            }
            if (PDFToRasterConverter.getSupportedBlendingModes().contains((Object)blendingMode)) {
                graphics2d.setComposite(graphicsState.getComposite(blendingMode, (float)((RasterGraphicsState)this.getGState()).getNonStrokeAlpha()));
            }
        } else {
            blendingMode = ((RasterGraphicsState)this.getGState()).getBlendingMode();
            if (blendingMode != GraphicsState.BlendingMode.NORMAL) {
                double alpha = ((RasterGraphicsState)this.getGState()).getNonStrokeAlpha();
                if (values != null) {
                    graphics2d.setColor(new Color(GraphicsUtils.toARGB(values, alpha), true));
                }
                if (PDFToRasterConverter.getSupportedBlendingModes().contains((Object)blendingMode)) {
                    graphics2d.setComposite(graphicsState.getComposite(blendingMode, (float)((RasterGraphicsState)this.getGState()).getNonStrokeAlpha()));
                }
            }
        }
    }

    private void setLineWidthForStroke(Graphics2D graphics2d, double scale) {
        float[] dashArray = new float[((RasterGraphicsState)this.getGState()).getDashArray().length];
        double[] srcDashArray = ((RasterGraphicsState)this.getGState()).getDashArray();
        for (int i = 0; i < srcDashArray.length; ++i) {
            dashArray[i] = (float)srcDashArray[i];
        }
        BasicStroke s = null;
        s = dashArray != null && dashArray.length > 0 ? new BasicStroke((float)((double)((float)((RasterGraphicsState)this.getGState()).getLineWidth()) * scale), ((RasterGraphicsState)this.getGState()).getLineCap().getValue(), ((RasterGraphicsState)this.getGState()).getLineJoin().getValue(), (float)((RasterGraphicsState)this.getGState()).getMiterLimit(), dashArray, ((RasterGraphicsState)this.getGState()).getDashPhase()) : new BasicStroke((float)((double)((float)((RasterGraphicsState)this.getGState()).getLineWidth()) * scale), ((RasterGraphicsState)this.getGState()).getLineCap().getValue(), ((RasterGraphicsState)this.getGState()).getLineJoin().getValue(), (float)((RasterGraphicsState)this.getGState()).getMiterLimit());
        graphics2d.setStroke(s);
    }

    class MaxCoordinates {
        private double xMax;
        private double yMax;

        MaxCoordinates() {
        }
    }
}

