/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.rasterizer.impl;

import com.adobe.internal.pdftoolkit.graphicsDOM.ContentItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.GraphicsState;
import com.adobe.internal.pdftoolkit.graphicsDOM.TextState;
import com.adobe.internal.pdftoolkit.graphicsDOM.TilingPattern;
import com.adobe.internal.pdftoolkit.graphicsDOM.utils.GraphicsUtils;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterDocumentContext;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterGraphicsState;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterTilingContext;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.util.HashMap;

public class RasterTilingPatternOptimizer {
    private boolean isSmallPixelArea = false;
    private Color singlePixelColor = null;
    private HashMap<Integer, BufferedImage> tileStore = new HashMap();
    private TilingPattern<? extends GraphicsState, ? extends TextState, ? extends ContentItem<? extends GraphicsState>> tilingPattern;
    private Rectangle2D patternVirtualRect;
    private RasterDocumentContext context;
    private Rectangle2D virtualRect;
    private RasterGraphicsState graphicsState;
    private Graphics2D graphics2d;
    private BufferedImage singleTile;
    private Integer OPTIMIZATION_THRESHOLD_AREA = 5000;
    private boolean isOptimizeTilingPattern;
    private String tilingPatternName;

    RasterTilingPatternOptimizer(RasterDocumentContext context, Rectangle2D virtualRect, RasterGraphicsState graphicsState) {
        this.context = context;
        this.virtualRect = virtualRect;
        this.graphicsState = graphicsState;
        this.tilingPatternName = graphicsState.getFillTilingPatternName();
    }

    static BufferedImage paintWithPattern(RasterDocumentContext context, Rectangle2D virtualRect, RasterGraphicsState graphicsState) {
        RasterTilingPatternOptimizer optimizer = new RasterTilingPatternOptimizer(context, virtualRect, graphicsState);
        optimizer.initialization();
        return optimizer.drawTilingPattern();
    }

    private void initialization() {
        this.tilingPattern = this.graphicsState.getLoadedTilingPatterns().get(this.tilingPatternName);
        if (this.tilingPattern != null) {
            this.patternVirtualRect = ((GraphicsState)this.tilingPattern.getGState()).getClipPath().getBounds2D();
        }
        this.graphics2d = this.context.getGraphics2d();
        this.isSmallPixelArea = false;
        this.singlePixelColor = null;
        this.isOptimizeTilingPattern = false;
    }

    private BufferedImage drawTilingPattern() {
        if (this.tilingPattern == null) {
            return null;
        }
        double[] tilingBbox = this.tilingPattern.getBBox();
        this.createSingleTile(this.tilingPatternName);
        if (this.virtualRect == null) {
            return this.singleTile;
        }
        int[] posBounds = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
        double[] clipBounds = GraphicsUtils.getClipBounds(this.tilingPattern, this.virtualRect, this.patternVirtualRect, posBounds);
        int rowCount = posBounds[3] - posBounds[1];
        int columnCount = posBounds[2] - posBounds[0];
        if (rowCount * columnCount > this.OPTIMIZATION_THRESHOLD_AREA) {
            // empty if block
        }
        if (this.isSmallPixelArea) {
            this.graphics2d.setColor(this.singlePixelColor);
            this.graphics2d.fill(this.virtualRect);
            return null;
        }
        if (this.isOptimizeTilingPattern) {
            BufferedImage image = this.storeIntermediateBufferedImages(this.singleTile, rowCount, columnCount, posBounds);
            double[] XY = GraphicsUtils.placeCell(posBounds[0], posBounds[1], this.tilingPattern);
            AffineTransform transform = new AffineTransform();
            double translateY = XY[1] + this.tilingPattern.getPhase()[1] + tilingBbox[1];
            double translateX = XY[0] + this.tilingPattern.getPhase()[0] - tilingBbox[0];
            transform.translate(translateX, (double)this.context.getPageHeight() - translateY);
            this.placeTile(this.isSmallPixelArea, this.graphics2d, this.singlePixelColor, transform, image);
        } else {
            for (int i = posBounds[1]; i < posBounds[3]; ++i) {
                for (int j = posBounds[0]; j < posBounds[2]; ++j) {
                    double[] XY = GraphicsUtils.placeCell(j, i, this.tilingPattern);
                    if (!(XY[0] >= clipBounds[0]) || !(XY[1] >= clipBounds[1]) || !(XY[0] <= clipBounds[2]) || !(XY[1] <= clipBounds[3])) continue;
                    AffineTransform transform = new AffineTransform();
                    double translateY = XY[1] + this.tilingPattern.getPhase()[1] - tilingBbox[1];
                    double translateX = XY[0] + this.tilingPattern.getPhase()[0] - tilingBbox[0];
                    transform.translate(translateX, (double)this.context.getPageHeight() - translateY);
                    this.placeTile(this.isSmallPixelArea, this.graphics2d, this.singlePixelColor, transform, this.singleTile);
                }
            }
        }
        return this.singleTile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage storeIntermediateBufferedImages(BufferedImage singleTile, int rowCount, int columnCount, int[] posBounds) {
        this.tileStore.put(1, singleTile);
        double[] tilingBbox = this.tilingPattern.getBBox();
        try {
            BufferedImage image;
            double[] xStep = this.tilingPattern.getXStep();
            this.createSingleRow(rowCount, (int)(tilingBbox[2] - tilingBbox[0]), Math.abs(xStep[0] * 2.0));
            BufferedImage row = this.tileStore.get(rowCount);
            this.tileStore.clear();
            BufferedImage singleRow = new BufferedImage(row.getWidth(), row.getHeight(), 2);
            if (xStep[1] != 0.0) {
                Graphics2D g2 = singleRow.createGraphics();
                AffineTransform affineTransform = new AffineTransform();
                g2.drawImage(row, affineTransform, null);
                affineTransform.translate(xStep[0], xStep[1]);
                g2.drawImage(row, affineTransform, null);
            }
            this.tileStore.put(1, singleRow);
            double[] yStep = this.tilingPattern.getYStep();
            this.createColomn(columnCount, (int)(tilingBbox[3] - tilingBbox[1]), row.getWidth(), Math.abs(yStep[1]));
            BufferedImage bufferedImage = image = this.tileStore.get(columnCount);
            return bufferedImage;
        }
        finally {
            this.tileStore.clear();
        }
    }

    private double createColomn(int columnCount, int tileHeight, int colomnWidth, double yShift) {
        int sqrt = (int)Math.sqrt(columnCount);
        if (this.tileStore.containsKey(sqrt)) {
            yShift = this.createColomnBufferedImage(columnCount, sqrt, tileHeight, yShift, colomnWidth);
        } else {
            yShift = this.createColomn(sqrt, tileHeight, colomnWidth, yShift);
            yShift = this.createColomnBufferedImage(columnCount, sqrt, tileHeight, yShift, colomnWidth);
        }
        return yShift;
    }

    private double createColomnBufferedImage(int columnCount, int sqrt, int tileHeight, double yShift, int colomnWidth) {
        int scaleCount = columnCount / sqrt;
        int remainderTiles = columnCount - scaleCount * sqrt;
        BufferedImage tile = this.tileStore.get(sqrt);
        BufferedImage newTile = new BufferedImage(colomnWidth, (int)Math.ceil((double)columnCount / (double)sqrt * yShift * (double)scaleCount), 2);
        Graphics2D graphics2d = newTile.createGraphics();
        for (int i = 0; i < scaleCount; ++i) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(0.0, yShift * (double)i);
            graphics2d.drawImage(tile, affineTransform, null);
        }
        this.fillRemainingTilesInColumn(graphics2d, remainderTiles, yShift * (double)scaleCount, columnCount, sqrt, scaleCount, yShift);
        this.tileStore.put(columnCount, newTile);
        return yShift * (double)scaleCount;
    }

    private void fillRemainingTilesInColumn(Graphics2D graphics2d, int remainderTiles, double totalYShift, int rowCount, int sqrt, int scaleCount, double newYShift) {
        if (remainderTiles > 0) {
            int newsqrt = (int)Math.sqrt(sqrt);
            newYShift /= (double)sqrt;
            if (remainderTiles >= newsqrt) {
                int newScaleCount = remainderTiles / newsqrt;
                BufferedImage tile = this.tileStore.get(newsqrt);
                for (int i = 0; i < newScaleCount; ++i) {
                    AffineTransform affineTransform = new AffineTransform();
                    affineTransform.translate(0.0, totalYShift + newYShift * (double)i);
                    graphics2d.drawImage(tile, affineTransform, null);
                }
                remainderTiles -= newScaleCount * newsqrt;
                totalYShift += newYShift * (double)newScaleCount;
            }
            this.fillRemainingTilesInColumn(graphics2d, remainderTiles, totalYShift, rowCount, newsqrt, sqrt / newsqrt, newYShift);
        }
    }

    private double createSingleRow(int rowCount, int tileWidth, double xShift) {
        int sqrt = (int)Math.sqrt(rowCount);
        if (this.tileStore.containsKey(sqrt)) {
            xShift = this.createRowBufferedImage(rowCount, sqrt, tileWidth, xShift);
        } else {
            xShift = this.createSingleRow(sqrt, tileWidth, xShift);
            xShift = this.createRowBufferedImage(rowCount, sqrt, tileWidth, xShift);
        }
        return xShift;
    }

    private double createRowBufferedImage(int rowCount, int sqrt, int tileWidth, double xShift) {
        int scaleCount = rowCount / sqrt;
        int remainderTiles = rowCount - scaleCount * sqrt;
        BufferedImage tile = this.tileStore.get(sqrt);
        BufferedImage newTile = new BufferedImage((int)Math.ceil((double)rowCount / (double)sqrt * xShift), (int)Math.ceil(tile.getHeight()), 2);
        Graphics2D graphics2d = newTile.createGraphics();
        for (int i = 0; i < scaleCount; ++i) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(xShift * (double)i, 0.0);
            graphics2d.drawImage(tile, affineTransform, null);
        }
        this.fillRemainingTilesInRow(graphics2d, remainderTiles, xShift * (double)scaleCount, rowCount, sqrt, scaleCount, xShift);
        this.tileStore.put(rowCount, newTile);
        return xShift * (double)scaleCount;
    }

    private void fillRemainingTilesInRow(Graphics2D graphics2d, int remainderTiles, double totalxShift, int rowCount, int sqrt, int scaleCount, double newXShift) {
        if (remainderTiles > 0) {
            int newsqrt = (int)Math.sqrt(sqrt);
            newXShift /= (double)sqrt;
            if (remainderTiles >= newsqrt) {
                int newScaleCount = remainderTiles / newsqrt;
                BufferedImage tile = this.tileStore.get(newsqrt);
                for (int i = 0; i < newScaleCount; ++i) {
                    AffineTransform affineTransform = new AffineTransform();
                    affineTransform.translate(totalxShift + newXShift * (double)i, 0.0);
                    graphics2d.drawImage(tile, affineTransform, null);
                }
                remainderTiles -= newScaleCount * newsqrt;
                totalxShift += newXShift * (double)newScaleCount;
            }
            this.fillRemainingTilesInRow(graphics2d, remainderTiles, totalxShift, rowCount, newsqrt, sqrt / newsqrt, newXShift);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage createSingleTile(String name) {
        double[] tilingBbox = this.tilingPattern.getBBox();
        HashMap<String, BufferedImage> loadedTilingPatternsTiles = this.context.getLoadedTilingPatternsTiles();
        double heightScalingFactor = this.context.getHeightScalingFactor();
        double widthScalingFactor = this.context.getWidthScalingFactor();
        if (loadedTilingPatternsTiles != null && loadedTilingPatternsTiles.containsKey(name)) {
            this.singleTile = loadedTilingPatternsTiles.get(name);
        } else {
            double width = this.patternVirtualRect.getWidth() * widthScalingFactor;
            double height = this.patternVirtualRect.getHeight() * heightScalingFactor;
            int tileWidth = width < 1.0 ? 1 : GraphicsUtils.rint(width);
            int tileHeight = height < 1.0 ? 1 : GraphicsUtils.rint(height);
            RasterTilingContext tilingContext = new RasterTilingContext();
            if (tileHeight <= 1 && tileWidth <= 1) {
                this.isSmallPixelArea = true;
                this.singlePixelColor = new Color(GraphicsUtils.toARGB(((GraphicsState)this.tilingPattern.getGState()).getFillColorValues(), this.graphicsState.getNonStrokeAlpha()), true);
                return null;
            }
            this.singleTile = new BufferedImage(tileWidth, tileHeight, 2);
            tilingContext.setHeight(tileHeight);
            try {
                AffineTransform xform = new AffineTransform();
                Graphics2D g2 = this.singleTile.createGraphics();
                double[] scale = this.tilingPattern.getScale();
                xform.translate(-this.patternVirtualRect.getX(), -this.patternVirtualRect.getY());
                xform.scale(scale[0], scale[1]);
                if (scale[0] == -1.0 || scale[1] == -1.0 || tilingBbox[0] != 0.0 || tilingBbox[1] != 0.0) {
                    tilingContext.setIsFlipTilingPattern(true);
                }
                tilingContext.setWidthScalingFactor(widthScalingFactor);
                tilingContext.setHeightScalingFactor(heightScalingFactor);
                if (this.patternVirtualRect.getY() >= 0.0) {
                    g2.transform(xform);
                }
                tilingContext.setGraphics2d(g2);
                this.tilingPattern.writeToDisplayArea(tilingContext);
            }
            finally {
                this.context.setGraphics2d(this.graphics2d);
                loadedTilingPatternsTiles.put(name, this.singleTile);
                tilingContext.setIsFlipTilingPattern(false);
            }
        }
        return this.singleTile;
    }

    private void placeTile(boolean isSinglePixel, Graphics2D graphics2d, Color singlePixelColor, AffineTransform transform, BufferedImage singleTile) {
        if (isSinglePixel) {
            graphics2d.setColor(singlePixelColor);
            graphics2d.fillRect(GraphicsUtils.rint(transform.getTranslateX()), GraphicsUtils.rint(transform.getTranslateY()), 1, 1);
        } else {
            try {
                graphics2d.drawImage(singleTile, transform, null);
            }
            catch (RasterFormatException e) {
                // empty catch block
            }
        }
    }
}

