/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.readingorder;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.textextraction.TextExtractor;
import com.adobe.internal.pdftoolkit.services.textextraction.Word;
import com.adobe.internal.pdftoolkit.services.textextraction.WordsIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LayoutModeTextExtractor {
    private PDFDocument pdfDoc;
    private PDFFontSet fontSet;
    private int charcountInLine = 0;
    public static String NEWLINE_STRING = System.getProperty("line.separator");
    private static double NEWLINE_THRESHOLD = 0.95;
    private static double SPACE_MAX_THRESHOLD = 2.0;

    public static LayoutModeTextExtractor newInstance(PDFDocument pdfDoc, PDFFontSet clientFontSet) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        return new LayoutModeTextExtractor(pdfDoc, clientFontSet);
    }

    private LayoutModeTextExtractor(PDFDocument pdfDoc, PDFFontSet clientFontSet) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        this.pdfDoc = pdfDoc;
        this.fontSet = clientFontSet;
    }

    public WordsIterator getWordsIterator() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, IOException {
        return new DocumentWordsIterator();
    }

    public WordsIterator getWordsIterator(PDFPage page, int pageIndex) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        List<Word> words = null;
        words = this.convertPDFtoLayoutText(page, pageIndex);
        return new WordListIterator(words);
    }

    public List<Word> convertPDFtoLayoutText(PDFPage page, int pageIndex) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        Word word;
        TextExtractor extractor = TextExtractor.newInstance(this.pdfDoc, this.fontSet, false);
        WordsIterator wordsIter = extractor.getROTEWordsIterator(page, pageIndex);
        ASCoordinate prevWTopLeft = null;
        Word prevWord = null;
        double chw = this.findSmallestAverageCharWidthInPage(wordsIter) * 1.5;
        wordsIter = extractor.getROTEWordsIterator(page, pageIndex);
        ArrayList<Word> words = new ArrayList<Word>();
        if (wordsIter.hasNext()) {
            word = wordsIter.next();
            this.startSpace(words, word, chw);
            prevWTopLeft = this.writeText(words, prevWTopLeft, prevWord, word, chw);
            prevWord = word;
        }
        while (wordsIter.hasNext()) {
            word = wordsIter.next();
            prevWTopLeft = this.writeText(words, prevWTopLeft, prevWord, word, chw);
            prevWord = word;
        }
        words.add(new Word(null, NEWLINE_STRING, prevWord.getPageNumber()));
        return words;
    }

    private double findSmallestAverageCharWidthInPage(WordsIterator wordsIter) throws PDFInvalidDocumentException, PDFSecurityException, PDFIOException, PDFFontException {
        double smallestChW = Double.MAX_VALUE;
        while (wordsIter.hasNext()) {
            Word word = wordsIter.next();
            double chw = word.avgWidth();
            if (!(chw < smallestChW)) continue;
            smallestChW = chw;
        }
        return smallestChW;
    }

    private ASCoordinate writeText(List<Word> writer, ASCoordinate prevWTopLeft, Word prevWord, Word word, double chw) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASCoordinate wtopLeft = word.topLeft();
        if (prevWord != null) {
            double widthDelta = word.topLeft().x() - prevWord.bottomRight().x();
            double heightDelta = prevWord.bottomRight().y() - word.topLeft().y();
            double numOfNewLine = heightDelta / word.charHeight();
            if (prevWTopLeft != null && (wtopLeft.x() - prevWTopLeft.x() <= 0.0 || numOfNewLine > 2.0)) {
                if (writer != null) {
                    StringBuilder multipleNewLines = new StringBuilder("");
                    int i = 1;
                    while ((double)i < numOfNewLine) {
                        multipleNewLines.append(NEWLINE_STRING);
                        ++i;
                    }
                    writer.add(new Word(null, multipleNewLines.toString(), prevWord.getPageNumber()));
                    if (numOfNewLine > NEWLINE_THRESHOLD && numOfNewLine <= 1.0) {
                        writer.add(new Word(null, NEWLINE_STRING, prevWord.getPageNumber()));
                    } else if (numOfNewLine <= NEWLINE_THRESHOLD && wtopLeft.x() - prevWTopLeft.x() <= 0.0) {
                        writer.add(new Word(null, NEWLINE_STRING, prevWord.getPageNumber()));
                    }
                    this.startSpace(writer, word, chw);
                }
            } else if (writer != null) {
                double widthWithCurrentFont = widthDelta / word.charWidth();
                if (widthWithCurrentFont <= SPACE_MAX_THRESHOLD) {
                    writer.add(new Word(null, " ", prevWord.getPageNumber()));
                    ++this.charcountInLine;
                } else if (widthWithCurrentFont > 2.0) {
                    double currentXcharCount = word.topLeft().x() / chw;
                    double numOfSpaces = currentXcharCount - (double)this.charcountInLine;
                    int i = 1;
                    while ((double)i < numOfSpaces) {
                        writer.add(new Word(null, " ", prevWord.getPageNumber()));
                        ++this.charcountInLine;
                        ++i;
                    }
                }
            }
        }
        if (writer != null) {
            writer.add(word);
            this.charcountInLine += word.toString().length();
        }
        return wtopLeft;
    }

    private void startSpace(List<Word> writer, Word word, double chw) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double startMargin = word.topLeft().x() / chw;
        this.charcountInLine = 0;
        int i = 1;
        while ((double)i < startMargin) {
            writer.add(new Word(null, " ", word.getPageNumber()));
            ++this.charcountInLine;
            ++i;
        }
    }

    static class WordListIterator
    implements WordsIterator {
        Iterator<Word> wordsIter;

        WordListIterator(List<Word> wordList) {
            this.wordsIter = wordList.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.wordsIter.hasNext();
        }

        @Override
        public Word next() {
            return this.wordsIter.next();
        }
    }

    private class DocumentWordsIterator
    implements WordsIterator {
        private int pageIndex = 0;
        Iterator<?> pagesIter;
        WordsIterator wordsIter;

        DocumentWordsIterator() throws PDFInvalidDocumentException, PDFSecurityException, PDFIOException, PDFFontException {
            this.pagesIter = LayoutModeTextExtractor.this.pdfDoc.requirePages().iterator();
            if (this.pagesIter.hasNext()) {
                PDFPage page = (PDFPage)this.pagesIter.next();
                ++this.pageIndex;
                this.wordsIter = LayoutModeTextExtractor.this.getWordsIterator(page, this.pageIndex);
            }
        }

        @Override
        public boolean hasNext() throws PDFInvalidDocumentException, PDFSecurityException, PDFIOException, PDFFontException {
            if (this.wordsIter.hasNext()) {
                return true;
            }
            if (this.pagesIter.hasNext()) {
                while (this.pagesIter.hasNext() && !this.wordsIter.hasNext()) {
                    PDFPage page = (PDFPage)this.pagesIter.next();
                    ++this.pageIndex;
                    this.wordsIter = LayoutModeTextExtractor.this.getWordsIterator(page, this.pageIndex);
                    if (!this.wordsIter.hasNext()) continue;
                    return this.wordsIter.hasNext();
                }
                return false;
            }
            return false;
        }

        @Override
        public Word next() throws PDFInvalidDocumentException, PDFSecurityException, PDFIOException, PDFFontException {
            if (this.hasNext()) {
                return this.wordsIter.next();
            }
            return null;
        }
    }
}

