/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.sanitization;

import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveIncrementalOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveLinearOptions;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.sanitization.SanitizationHandler;
import com.adobe.internal.pdftoolkit.services.sanitization.SanitizationOptions;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.CosObjectsSanitizer;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.DefaultSanitizationHandler;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.PageSanitizer;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.PostSanitizer;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.RootSanitizer;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.SanitizationContext;
import java.util.Iterator;

public class SanitizationService {
    private SanitizationService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PDFDocument sanitizeDocument(PDFDocument pdfDoc, SanitizationOptions options, ByteWriter writer) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        if (options == null) {
            throw new PDFInvalidParameterException("Sanitization options can't be null.");
        }
        if (options.getPDFFontSet() == null) {
            throw new PDFInvalidParameterException("PDF font set can't be null.");
        }
        if (writer == null) {
            throw new PDFInvalidParameterException("Bytewriter can't be null.");
        }
        SanitizationService.validateSaveOptions(options);
        SanitizationContext context = new SanitizationContext(options);
        if (options.getHandler() == null) {
            options.registerHandler((SanitizationHandler)new DefaultSanitizationHandler());
        }
        try {
            RootSanitizer.sanitize((PDFDocument)pdfDoc, (SanitizationContext)context);
            CosObjectsSanitizer.sanitize((PDFDocument)pdfDoc, (SanitizationContext)context);
            Iterator<PDFPage> pageItr = pdfDoc.requirePages().iterator();
            while (pageItr.hasNext()) {
                PageSanitizer.sanitize((PDFPage)pageItr.next(), (SanitizationContext)context);
            }
        }
        finally {
            PostSanitizer.sanitize((PDFDocument)pdfDoc, (SanitizationContext)context);
        }
        pdfDoc.save(writer, options.getSaveOptions());
        return pdfDoc;
    }

    private static void validateSaveOptions(SanitizationOptions options) throws PDFInvalidParameterException {
        if (options.getSaveOptions() == null) {
            throw new PDFInvalidParameterException("PDF save options can't be null.");
        }
        if (options.getSaveOptions() instanceof PDFSaveIncrementalOptions) {
            throw new PDFInvalidParameterException("Document can't be saved incrementally after sanitization.");
        }
        if (options.getSaveOptions() instanceof PDFSaveLinearOptions) {
            options.getSaveOptions().setObjectCompressionMode(1);
        }
    }
}

