/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.textextraction.impl;

class CharacterTypeRange {
    static final int WORD_BREAK = 1;
    static final int WHITESPACE = 2;
    static final int PUNCTUATION = 4;
    static final int COMMA = 8;
    static final int HYPHEN = 16;
    static final int PERIOD = 32;
    static final int DIGIT = 64;
    static final int LETTER = 128;
    static final int UPPERCASE = 256;
    static final int SOFT_HYPHEN = 512;
    static final int LIGATURE = 1024;
    static final int DIACRITIC = 2048;
    char rangeStart;
    char rangeEnd;
    private int type;

    CharacterTypeRange(char rangeStart, char rangeEnd, int type) {
        this.rangeStart = rangeStart;
        this.rangeEnd = rangeEnd;
        this.type = type;
    }

    boolean contains(char c) {
        return c >= this.rangeStart && c <= this.rangeEnd;
    }

    boolean isWordBreak() {
        return (this.type & 1) != 0;
    }

    boolean isPunctuation() {
        return (this.type & 4) != 0;
    }

    boolean isDiacritic() {
        return (this.type & 0x800) != 0;
    }

    boolean isWhitespace() {
        return (this.type & 2) != 0;
    }

    boolean isComma() {
        return (this.type & 8) != 0;
    }

    boolean isHyphen() {
        return (this.type & 0x10) != 0;
    }

    boolean isPeriod() {
        return (this.type & 0x20) != 0;
    }

    boolean isDigit() {
        return (this.type & 0x40) != 0;
    }

    boolean isLetter() {
        return (this.type & 0x80) != 0;
    }

    boolean isUppercase() {
        return (this.type & 0x100) != 0;
    }

    boolean isSoftHyphen() {
        return (this.type & 0x200) != 0;
    }

    boolean isLigature() {
        return (this.type & 0x400) != 0;
    }
}

