/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.textextraction.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.services.textextraction.impl.CharacterTypeRange;
import java.util.ArrayList;

class CharacterTypeTable {
    private ArrayList<CharacterTypeRange> charTypeTable;

    CharacterTypeTable(ArrayList<CharacterTypeRange> charTypeTable) {
        this.charTypeTable = charTypeTable;
    }

    private CharacterTypeRange findCharacterType(char c) {
        int start = 0;
        int end = this.charTypeTable.size() - 1;
        int mid = 0;
        while (start <= end) {
            mid = (start + end) / 2;
            CharacterTypeRange midItem = this.charTypeTable.get(mid);
            if (c <= midItem.rangeEnd && c >= midItem.rangeStart) {
                return midItem;
            }
            if (c < midItem.rangeStart && c < midItem.rangeEnd) {
                end = mid - 1;
                continue;
            }
            if (c > midItem.rangeStart && c > midItem.rangeEnd) {
                start = mid + 1;
                continue;
            }
            throw new PDFRuntimeException("Ranges for chartypes either overlap or are not in ascending order.");
        }
        return null;
    }

    boolean isWordBreak(char c) {
        CharacterTypeRange charType = this.findCharacterType(c);
        if (charType != null) {
            return charType.isWordBreak();
        }
        return false;
    }

    boolean isPunctuation(char c) {
        CharacterTypeRange charType = this.findCharacterType(c);
        if (charType != null) {
            return charType.isPunctuation();
        }
        return false;
    }

    boolean isDiacritic(char c) {
        CharacterTypeRange charType = this.findCharacterType(c);
        if (charType != null) {
            return charType.isDiacritic();
        }
        return false;
    }

    boolean isWhitespace(char c) {
        return c >= '\u0001' && c <= '\u001f' || c == ' ' || c == '\u00a0' || c >= '\u2000' && c <= '\u200f' || c >= '\u2028' && c <= '\u202f' || c >= '\u206a' && c <= '\u206f';
    }

    boolean isComma(char c) {
        CharacterTypeRange charType = this.findCharacterType(c);
        if (charType != null) {
            return charType.isComma();
        }
        return false;
    }

    boolean isHyphen(char c) {
        CharacterTypeRange charType = this.findCharacterType(c);
        if (charType != null) {
            return charType.isHyphen();
        }
        return false;
    }

    boolean isPeriod(char c) {
        CharacterTypeRange charType = this.findCharacterType(c);
        if (charType != null) {
            return charType.isPeriod();
        }
        return false;
    }

    boolean isDigit(char c) {
        CharacterTypeRange charType = this.findCharacterType(c);
        if (charType != null) {
            return charType.isDigit();
        }
        return false;
    }

    boolean isLetter(char c) {
        CharacterTypeRange charType = this.findCharacterType(c);
        if (charType != null) {
            return charType.isLetter();
        }
        return false;
    }

    boolean isUppercase(char c) {
        CharacterTypeRange charType = this.findCharacterType(c);
        if (charType != null) {
            return charType.isUppercase();
        }
        return false;
    }

    boolean isSoftHyphen(char c) {
        CharacterTypeRange charType = this.findCharacterType(c);
        if (charType != null) {
            return charType.isSoftHyphen();
        }
        return false;
    }

    boolean isLigature(char c) {
        CharacterTypeRange charType = this.findCharacterType(c);
        if (charType != null) {
            return charType.isLigature();
        }
        return false;
    }
}

