/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.textextraction.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.content.processor.PDFCharacter;
import com.adobe.internal.pdftoolkit.services.textextraction.impl.CharacterTypeRange;
import com.adobe.internal.pdftoolkit.services.textextraction.impl.CharacterTypeTable;
import com.adobe.internal.pdftoolkit.services.textextraction.impl.WordafierModel;
import java.util.ArrayList;

class WordafierImpl
extends WordafierModel {
    private static final ArrayList<CharacterTypeRange> charTypes = new ArrayList();
    CharacterTypeTable charTypeTable = new CharacterTypeTable(charTypes);

    WordafierImpl() {
    }

    @Override
    boolean isWordBreak(PDFCharacter pdeChar, PDFCharacter nextChar) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pdeChar.getUnicodeString().length() == 0) {
            return false;
        }
        return this.charTypeTable.isWordBreak(pdeChar.getUnicodeString().charAt(0));
    }

    @Override
    boolean isPunctuation(PDFCharacter pdeChar, PDFCharacter nextChar) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pdeChar.getUnicodeString().length() == 0) {
            return false;
        }
        return this.charTypeTable.isPunctuation(pdeChar.getUnicodeString().charAt(0));
    }

    @Override
    boolean isDiacritic(PDFCharacter pdeChar, PDFCharacter nextChar) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.charTypeTable.isDiacritic(pdeChar.getUnicodeString().charAt(0));
    }

    @Override
    boolean isWhitespace(PDFCharacter pdeChar) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String str = pdeChar.getUnicodeString();
        if (str.length() == 0) {
            return false;
        }
        char c = str.charAt(0);
        return this.charTypeTable.isWhitespace(c);
    }

    @Override
    boolean isComma(PDFCharacter pdeChar) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.charTypeTable.isComma(pdeChar.getUnicodeString().charAt(0));
    }

    @Override
    boolean isHyphen(PDFCharacter pdeChar) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.charTypeTable.isHyphen(pdeChar.getUnicodeString().charAt(0));
    }

    @Override
    boolean isPeriod(PDFCharacter pdeChar) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.charTypeTable.isPeriod(pdeChar.getUnicodeString().charAt(0));
    }

    @Override
    boolean isDigit(PDFCharacter pdeChar) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pdeChar.getUnicodeString().length() == 0) {
            return false;
        }
        return this.charTypeTable.isDigit(pdeChar.getUnicodeString().charAt(0));
    }

    @Override
    boolean isLetter(PDFCharacter pdeChar) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pdeChar.getUnicodeString().length() == 0) {
            return false;
        }
        return this.charTypeTable.isLetter(pdeChar.getUnicodeString().charAt(0));
    }

    @Override
    boolean isUppercase(PDFCharacter pdeChar) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.charTypeTable.isUppercase(pdeChar.getUnicodeString().charAt(0));
    }

    @Override
    boolean isSoftHyphen(PDFCharacter pdeChar) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.charTypeTable.isSoftHyphen(pdeChar.getUnicodeString().charAt(0));
    }

    @Override
    boolean isLigature(PDFCharacter pdeChar) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.charTypeTable.isLigature(pdeChar.getUnicodeString().charAt(0));
    }

    static {
        charTypes.add(new CharacterTypeRange('\u0001', '\u001f', 3));
        charTypes.add(new CharacterTypeRange(' ', ' ', 3));
        charTypes.add(new CharacterTypeRange('!', '$', 5));
        charTypes.add(new CharacterTypeRange('%', '%', 4));
        charTypes.add(new CharacterTypeRange('&', '+', 5));
        charTypes.add(new CharacterTypeRange(',', ',', 13));
        charTypes.add(new CharacterTypeRange('-', '-', 21));
        charTypes.add(new CharacterTypeRange('.', '.', 37));
        charTypes.add(new CharacterTypeRange('/', '/', 5));
        charTypes.add(new CharacterTypeRange('0', '9', 64));
        charTypes.add(new CharacterTypeRange(':', '@', 5));
        charTypes.add(new CharacterTypeRange('A', 'Z', 384));
        charTypes.add(new CharacterTypeRange('[', '`', 5));
        charTypes.add(new CharacterTypeRange('a', 'z', 128));
        charTypes.add(new CharacterTypeRange('{', '~', 5));
        charTypes.add(new CharacterTypeRange('\u00a0', '\u00a0', 2));
        charTypes.add(new CharacterTypeRange('\u00ad', '\u00ad', 516));
        charTypes.add(new CharacterTypeRange('\u00c0', '\u00d6', 128));
        charTypes.add(new CharacterTypeRange('\u00d8', '\u00f6', 128));
        charTypes.add(new CharacterTypeRange('\u00f8', '\u02b8', 128));
        charTypes.add(new CharacterTypeRange('\u0300', '\u036f', 128));
        charTypes.add(new CharacterTypeRange('\u0391', '\u0588', 128));
        charTypes.add(new CharacterTypeRange('\u0590', '\u05af', 128));
        charTypes.add(new CharacterTypeRange('\u05b0', '\u05c2', 2176));
        charTypes.add(new CharacterTypeRange('\u05c3', '\u060f', 128));
        charTypes.add(new CharacterTypeRange('\u0610', '\u0615', 2176));
        charTypes.add(new CharacterTypeRange('\u0616', '\u064a', 128));
        charTypes.add(new CharacterTypeRange('\u064b', '\u0652', 2176));
        charTypes.add(new CharacterTypeRange('\u0653', '\u065e', 2048));
        charTypes.add(new CharacterTypeRange('\u0670', '\u0670', 2048));
        charTypes.add(new CharacterTypeRange('\u0660', '\u0669', 64));
        charTypes.add(new CharacterTypeRange('\u066a', '\u066d', 5));
        charTypes.add(new CharacterTypeRange('\u0671', '\u06d5', 128));
        charTypes.add(new CharacterTypeRange('\u06d6', '\u06dc', 2176));
        charTypes.add(new CharacterTypeRange('\u06dd', '\u06de', 128));
        charTypes.add(new CharacterTypeRange('\u06df', '\u06e8', 2176));
        charTypes.add(new CharacterTypeRange('\u06e9', '\u06e9', 128));
        charTypes.add(new CharacterTypeRange('\u06ea', '\u06ed', 2176));
        charTypes.add(new CharacterTypeRange('\u06ee', '\u06f9', 128));
        charTypes.add(new CharacterTypeRange('\u0900', '\u1fff', 128));
        charTypes.add(new CharacterTypeRange('\u2000', '\u200f', 3));
        charTypes.add(new CharacterTypeRange('\u2010', '\u2010', 21));
        charTypes.add(new CharacterTypeRange('\u2011', '\u2011', 20));
        charTypes.add(new CharacterTypeRange('\u2012', '\u2027', 5));
        charTypes.add(new CharacterTypeRange('\u2028', '\u202f', 3));
        charTypes.add(new CharacterTypeRange('\u2030', '\u204d', 5));
        charTypes.add(new CharacterTypeRange('\u206a', '\u206f', 3));
        charTypes.add(new CharacterTypeRange('\u2070', '\u209f', 128));
        charTypes.add(new CharacterTypeRange('\u20a0', '\u20cf', 64));
        charTypes.add(new CharacterTypeRange('\u20d0', '\u20ff', 128));
        charTypes.add(new CharacterTypeRange('\u2190', '\u23ff', 5));
        charTypes.add(new CharacterTypeRange('\u3021', '\u3029', 64));
        charTypes.add(new CharacterTypeRange('\u302a', '\u302f', 128));
        charTypes.add(new CharacterTypeRange('\u3031', '\u3035', 128));
        charTypes.add(new CharacterTypeRange('\u3099', '\u309c', 4));
        charTypes.add(new CharacterTypeRange('\u3100', '\u318f', 128));
        charTypes.add(new CharacterTypeRange('\u3371', '\u3376', 1152));
        charTypes.add(new CharacterTypeRange('\u3380', '\u33dd', 1152));
        charTypes.add(new CharacterTypeRange('\uac00', '\ud7af', 128));
        charTypes.add(new CharacterTypeRange('\ufb00', '\ufb06', 1152));
        charTypes.add(new CharacterTypeRange('\ufb1f', '\ufb1f', 1152));
        charTypes.add(new CharacterTypeRange('\ufb20', '\ufbe7', 128));
        charTypes.add(new CharacterTypeRange('\ufbea', '\ufbf8', 1152));
        charTypes.add(new CharacterTypeRange('\ufbfc', '\ufbff', 128));
        charTypes.add(new CharacterTypeRange('\ufc00', '\ufdfd', 1152));
        charTypes.add(new CharacterTypeRange('\ufe70', '\ufef4', 128));
        charTypes.add(new CharacterTypeRange('\ufef5', '\ufefc', 1152));
        charTypes.add(new CharacterTypeRange('\uff01', '\uff0b', 5));
        charTypes.add(new CharacterTypeRange('\uff0c', '\uff0c', 13));
        charTypes.add(new CharacterTypeRange('\uff0d', '\uff0d', 21));
        charTypes.add(new CharacterTypeRange('\uff0e', '\uff0e', 13));
        charTypes.add(new CharacterTypeRange('\uff0f', '\uff0f', 5));
        charTypes.add(new CharacterTypeRange('\uff10', '\uff19', 64));
        charTypes.add(new CharacterTypeRange('\uff1a', '\uff20', 5));
        charTypes.add(new CharacterTypeRange('\uff21', '\uff3a', 384));
        charTypes.add(new CharacterTypeRange('\uff40', '\uff40', 5));
        charTypes.add(new CharacterTypeRange('\uff41', '\uff5a', 128));
        charTypes.add(new CharacterTypeRange('\uff5b', '\uff5e', 5));
    }
}

