/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.form;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosNull;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOMService;
import com.adobe.internal.pdftoolkit.services.xfa.XFAService;
import com.adobe.internal.pdftoolkit.services.xfa.form.Utils;
import com.adobe.xfa.AppModel;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.EnumAttr;
import com.adobe.xfa.EnumType;
import com.adobe.xfa.EnumValue;
import com.adobe.xfa.Node;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.data.DataModel;
import com.adobe.xfa.data.DataModelFactory;
import com.adobe.xfa.data.DataNode;
import com.adobe.xfa.service.storage.PacketHandler;
import com.adobe.xfa.service.storage.XMLStorage;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.ut.BooleanHolder;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.Storage;
import com.adobe.xfa.ut.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class CosDocument
implements PacketHandler {
    public AppModel moAppModel;
    protected boolean mbIsReady;
    protected boolean mbModifyData;
    protected boolean mbSavePDFOnly;
    protected Document moDomDoc;
    protected String msConfigLocale;
    protected Storage<String> msConfigSubmitUrl;
    protected DataModelFactory moDataModelFactory;
    private String msPDFProducerMetaData;
    private String msXAPCreatorToolMetaData;
    private String msPackets;
    private PDFDocument mpdDoc;
    String[] gPacketsData = new String[]{"datasets"};
    String[] gPacketsAllowNone = new String[]{"template", "config", "sourceSet", "connectionSet", "stylesheet", "datasets", "xfdf", "localeSet", "form"};
    String[] gPacketsDefault = new String[]{"template", "config", "sourceSet", "connectionSet", "stylesheet", "xfdf", "localeSet", "dataDescription"};
    String[] gPacketsCommentsAndDefault = new String[]{"template", "config", "sourceSet", "connectionSet", "stylesheet", "localeSet", "dataDescription"};
    String[] gPacketsXFAKey = new String[]{"template", "config", "sourceSet", "connectionSet", "stylesheet", "datasets", "form"};
    String[] gPacketsXFAKey2_5 = new String[]{"template", "datasets", "form"};

    public CosDocument(PDFDocument pdDoc) {
        this.mpdDoc = pdDoc;
        this.mbIsReady = false;
        this.moAppModel = XFADOMService.isXFADOMCreated(pdDoc) ? XFADOMService.getXFADOMFromCache(pdDoc).getAppModel() : new AppModel(null);
        this.msPackets = "";
        this.msConfigLocale = "";
        this.msConfigSubmitUrl = new Storage();
    }

    boolean initialize() {
        return this.initialize(true);
    }

    public com.adobe.internal.pdftoolkit.core.cos.CosDocument getCosDocument() {
        return this.mpdDoc.getCosDocument();
    }

    boolean initialize(boolean bAddTemplate) {
        this.mbModifyData = true;
        this.mbSavePDFOnly = false;
        this.mbIsReady = false;
        if (this.moAppModel == null) {
            this.moAppModel = new AppModel(null);
        }
        return true;
    }

    void initXFAData() {
        this.initialize();
        this.moAppModel.newDOM();
        this.setReady(true);
    }

    boolean loadAppModelFromDoc() {
        TemplateModel oTemplateModel;
        XMLStorage xml = new XMLStorage();
        Document oDomDoc = this.getDocument();
        if (oDomDoc == null) {
            ByteArrayOutputStream oMemOutStream = new ByteArrayOutputStream();
            if (!CosDocument.getXFAStream(this.mpdDoc, oMemOutStream)) {
                return false;
            }
            ByteArrayInputStream oMemStream = new ByteArrayInputStream(oMemOutStream.toByteArray());
            try {
                oMemOutStream.close();
                oMemOutStream = null;
                xml.loadXDP(this.moAppModel, oMemStream, (PacketHandler)this, (Object)this, false);
                oMemStream.close();
                oMemStream = null;
            }
            catch (IOException ignored) {}
        } else {
            oDomDoc.clearIdMap();
            xml.loadXDP(this.moAppModel, oDomDoc, (PacketHandler)this, (Object)this, false);
        }
        this.updateLegacyInfo(this.moAppModel);
        String[] xdpPackets = this.gPacketsXFAKey;
        if (this.moAppModel != null && (oTemplateModel = TemplateModel.getTemplateModel(this.moAppModel, false)) != null && oTemplateModel.getOriginalXFAVersion() >= 25) {
            xdpPackets = this.gPacketsXFAKey2_5;
        }
        this.populateOriginalStreams(true, xdpPackets, false);
        this.moAppModel.clearErrorList();
        return true;
    }

    void updateLegacyInfo(AppModel oAppModel) {
        try {
            int nVersion;
            String sNS;
            TemplateModel oTemplateModel = TemplateModel.getTemplateModel(oAppModel, false);
            if (oTemplateModel != null && StringUtils.isEmpty(sNS = oTemplateModel.getOriginalVersion(false)) && (nVersion = oTemplateModel.getOriginalXFAVersion()) == 21) {
                String sProducer = this.getPDFProducerMetaData();
                String sCreator = this.getXAPCreatorToolMetaData();
                int nFoundAt = -1;
                if (sCreator != null) {
                    nFoundAt = sCreator.indexOf("Adobe Designer 7.0");
                }
                int nFoundAt2 = -1;
                if (sProducer != null) {
                    nFoundAt2 = sProducer.indexOf("Adobe PDF Library 7.0");
                }
                if (nFoundAt >= 0 || nFoundAt2 >= 0) {
                    oTemplateModel.setLegacySetting(AppModel.XFA_LEGACY_POSITIONING, false);
                    oTemplateModel.setLegacySetting(AppModel.XFA_LEGACY_EVENTMODEL, false);
                }
            }
        }
        catch (ExFull exFull) {
            // empty catch block
        }
    }

    void initMetaData() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            CosDictionary coDict = this.getCosDocument().getRoot();
            CosObject coMetaData = coDict.get(ASName.k_Metadata);
            if (!(coMetaData instanceof CosStream)) {
                return;
            }
            ((CosStream)coMetaData).copyStream(os, true);
            String sMetaData = os.toString("UTF-8");
            String sPDFProducerBeginTag = "<pdf:Producer>";
            int nFoundBegin = sMetaData.indexOf(sPDFProducerBeginTag);
            int nFoundEnd = sMetaData.indexOf("</pdf:Producer>", nFoundBegin);
            if (nFoundBegin >= 0) {
                int nStartPos = nFoundBegin + "<pdf:Producer>".length();
                this.msPDFProducerMetaData = sMetaData.substring(nStartPos, nFoundEnd);
            } else {
                this.msPDFProducerMetaData = "";
            }
            String sXAPCreatorToolBeginTag = "<xap:CreatorTool>";
            String sXMPCreatorToolBeginTag = "<xmp:CreatorTool>";
            nFoundBegin = sMetaData.indexOf(sXAPCreatorToolBeginTag);
            if (nFoundBegin >= 0 && (nFoundEnd = sMetaData.indexOf("</xap:CreatorTool>", nFoundBegin)) >= 0) {
                int nStartPos = nFoundBegin + sXAPCreatorToolBeginTag.length();
                this.msXAPCreatorToolMetaData = sMetaData.substring(nStartPos, nFoundEnd);
            } else {
                nFoundBegin = sMetaData.indexOf(sXMPCreatorToolBeginTag);
                if (nFoundBegin >= 0 && (nFoundEnd = sMetaData.indexOf("</xmp:CreatorTool>", nFoundBegin)) >= 0) {
                    int nStartPos = nFoundBegin + sXAPCreatorToolBeginTag.length();
                    this.msXAPCreatorToolMetaData = sMetaData.substring(nStartPos, nFoundEnd);
                } else {
                    this.msXAPCreatorToolMetaData = "";
                }
            }
        }
        catch (PDFException e) {
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("encoding not supported.", e);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {}
        }
    }

    String getPDFProducerMetaData() {
        this.initMetaData();
        return this.msPDFProducerMetaData;
    }

    String getXAPCreatorToolMetaData() {
        this.initMetaData();
        return this.msXAPCreatorToolMetaData;
    }

    public void setReady(boolean bReady) {
        this.mbIsReady = bReady;
    }

    public boolean isReady() {
        return this.mbIsReady;
    }

    public String getSubmitUrl(boolean bCertified) {
        DataModel oDataModel = DataModel.getDataModel(this.moAppModel, false, false);
        int nSubmitIndex = 0;
        if (oDataModel != null) {
            Node oValue;
            Element oXFAData;
            String aNS = "http://ns.adobe.com/server-context-data/";
            String aVariables = "variables";
            String aSubmitUrlIndex = "submitUrlIndex";
            for (Node oDataModelChild = oDataModel.getFirstXMLChild(); oDataModelChild != null; oDataModelChild = oDataModelChild.getNextXMLSibling()) {
                if (!(oDataModelChild instanceof DataNode) || !aNS.equals(((DataNode)oDataModelChild).getNS()) || !aVariables.equals(oDataModelChild.getName())) continue;
                for (Node oVariablesChild = oDataModelChild.getFirstXMLChild(); oVariablesChild != null; oVariablesChild = oVariablesChild.getNextXMLSibling()) {
                    String sSubmitString;
                    if (!aSubmitUrlIndex.equals(oVariablesChild.getName()) || !(oVariablesChild instanceof DataNode) || !aNS.equals(((DataNode)oVariablesChild).getNS()) || oVariablesChild.getClassTag() != XFA.DATAVALUETAG || (nSubmitIndex = StringUtils.safeNumber(sSubmitString = ((DataNode)oVariablesChild).getValue())) < 0 || nSubmitIndex >= this.msConfigSubmitUrl.size()) continue;
                    return (String)this.msConfigSubmitUrl.get(nSubmitIndex);
                }
            }
            if (this.msConfigSubmitUrl.size() == 0 && !bCertified && (oXFAData = oDataModel.getAliasNode()) != null && (oValue = oXFAData.locateChildByName("FSTARGETURL_", 0)) != null && oValue.getClassTag() == XFA.DATAVALUETAG) {
                return ((DataNode)oValue).getValue();
            }
        }
        if (this.msConfigSubmitUrl.size() > 0) {
            return (String)this.msConfigSubmitUrl.get(0);
        }
        return "";
    }

    public Document getDocument() {
        return this.moDomDoc;
    }

    public void setDocument(Document newDomDoc) {
        this.moDomDoc = newDomDoc;
    }

    public static boolean getXFAStream(PDFDocument pdDoc, ByteArrayOutputStream oMemStream) {
        try {
            return XFAService.getFullStream(pdDoc, oMemStream);
        }
        catch (PDFException e) {
            throw new ExFull(e);
        }
    }

    public static CosObject getXFACosObject(PDFDocument pdDoc) {
        com.adobe.internal.pdftoolkit.core.cos.CosDocument coDoc = pdDoc.getCosDocument();
        CosNull coNull = coDoc.createCosNull();
        try {
            CosObject coDict = coDoc.getRoot().get(ASName.k_AcroForm);
            if (!(coDict instanceof CosDictionary)) {
                return coNull;
            }
            CosObject coXFAKey = ((CosDictionary)coDict).get(ASName.k_XFA);
            if (!(coXFAKey instanceof CosStream) && !(coXFAKey instanceof CosArray)) {
                return coNull;
            }
            return coXFAKey;
        }
        catch (PDFException e) {
            return coNull;
        }
    }

    public static boolean isXFADoc(PDFDocument pdDoc, Document oNewDataDoc, Document oAcroformDoc, boolean bAlert, boolean bSkipRegenCallback) {
        return CosDocument.isXFADoc(pdDoc, oNewDataDoc, oAcroformDoc, bAlert, bSkipRegenCallback, false);
    }

    public static void isProperXFAPacket(String aNodeName, BooleanHolder bTemplateFound, BooleanHolder bConfigFound, BooleanHolder bSourcSetFound, BooleanHolder bConnectionSetFound, BooleanHolder bDataSetsFound, BooleanHolder bLocaleSetFound, BooleanHolder bFormFound, BooleanHolder bFoundDup) {
        if (aNodeName.equals("template")) {
            if (bTemplateFound.value) {
                bFoundDup.value = true;
            }
            bTemplateFound.value = true;
        } else if (aNodeName.equals("config")) {
            if (bConfigFound.value) {
                bFoundDup.value = true;
            }
            bConfigFound.value = true;
        } else if (aNodeName.equals("sourceSet")) {
            if (bSourcSetFound.value) {
                bFoundDup.value = true;
            }
            bSourcSetFound.value = true;
        } else if (aNodeName.equals("connectionSet")) {
            if (bConnectionSetFound.value) {
                bFoundDup.value = true;
            }
            bConnectionSetFound.value = true;
        } else if (aNodeName.equals("localeSet")) {
            if (bLocaleSetFound.value) {
                bFoundDup.value = true;
            }
            bLocaleSetFound.value = true;
        } else if (aNodeName.equals("form")) {
            if (bFormFound.value) {
                bFoundDup.value = true;
            }
            bFormFound.value = true;
        } else if (aNodeName.equals("datasets")) {
            if (bDataSetsFound.value) {
                bFoundDup.value = true;
            }
            bDataSetsFound.value = true;
        }
    }

    public static boolean isXFADoc(PDFDocument pdDoc, Document oNewDataDoc, Document oAcroformDoc, boolean bAlert, boolean bSkipRegenCallback, boolean xfaDocLoaded) {
        CosObject coXFAKey = CosDocument.getXFACosObject(pdDoc);
        if (coXFAKey instanceof CosNull) {
            return false;
        }
        if (!xfaDocLoaded) {
            ByteArrayOutputStream oMemOutStream = new ByteArrayOutputStream();
            if (!CosDocument.getXFAStream(pdDoc, oMemOutStream)) {
                return false;
            }
            ByteArrayInputStream oMemStream = new ByteArrayInputStream(oMemOutStream.toByteArray());
            try {
                oMemOutStream.close();
                oMemOutStream = null;
                oNewDataDoc.load(oMemStream, null, true);
                oMemStream.close();
                oMemStream = null;
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        BooleanHolder bTemplateFound = new BooleanHolder(false);
        BooleanHolder bConfigFound = new BooleanHolder(false);
        BooleanHolder bSourcSetFound = new BooleanHolder(false);
        BooleanHolder bConnectionSetFound = new BooleanHolder(false);
        BooleanHolder bDataSetsFound = new BooleanHolder(false);
        BooleanHolder bLocaleSetFound = new BooleanHolder(false);
        BooleanHolder bFormFound = new BooleanHolder(false);
        BooleanHolder bFoundDup = new BooleanHolder(false);
        for (Node oXDP = oNewDataDoc.getFirstXMLChild(); oXDP != null; oXDP = oXDP.getNextXMLSibling()) {
            if (!(oXDP instanceof Element) || !AppModel.isXFANode((Element)oXDP)) continue;
            for (Node oXFAPacket = oXDP.getFirstXMLChild(); oXFAPacket != null; oXFAPacket = oXFAPacket.getNextXMLSibling()) {
                Node oAcroformData;
                String aNodeName = oXFAPacket.getName();
                CosDocument.isProperXFAPacket(aNodeName, bTemplateFound, bConfigFound, bSourcSetFound, bConnectionSetFound, bDataSetsFound, bLocaleSetFound, bFormFound, bFoundDup);
                if (aNodeName.equals("datasets") && oAcroformDoc != null && !bFoundDup.value && (oAcroformData = oXFAPacket.getFirstXMLChild()).getName().equals("AcroformData")) {
                    throw new ExFull(ResId.UNSUPPORTED_OPERATION);
                }
                if (!bFoundDup.value) continue;
                if (bAlert) {
                    MsgFormatPos oMessage = new MsgFormatPos(ResId.DuplicateModelLoadException);
                    oMessage.format(aNodeName);
                    throw new ExFull(oMessage);
                }
                return false;
            }
        }
        return bTemplateFound.value;
    }

    void populateOriginalStreams(boolean bFromMemory, String[] xdpPackets, boolean bOverWrite) {
    }

    @Override
    public void filterPackets(Node oPacket, Object oData) {
        CosDocument oCosDoc = (CosDocument)oData;
        if (oPacket instanceof Element) {
            boolean bPacketsSpecified;
            Element oPacketNode = (Element)oPacket;
            String sPacketList = oCosDoc.getPacketList();
            String sPacketName = oPacketNode.getName();
            boolean bl = bPacketsSpecified = !StringUtils.isEmpty(sPacketList) && !"*".equals(sPacketList);
            if ("stylesheet".equals(sPacketName)) {
                oPacketNode.getOwnerDocument().declareXFAId(oPacketNode.getNS(), "id");
                oPacketNode.getOwnerDocument().indexSubtree(oPacketNode, false);
            }
            if (sPacketName.equals("config") && (!bPacketsSpecified || sPacketList.indexOf("config") >= 0)) {
                oCosDoc.setDataLoadOptions(oPacketNode);
                oCosDoc.setLocaleOptions(oPacketNode);
                oCosDoc.setSubmitOptions(oPacketNode);
                oCosDoc.setVersionControlOptions(oPacketNode);
            } else if (bPacketsSpecified && sPacketList.indexOf(sPacketName) == -1) {
                oPacketNode.getXFAParent().removeChild(oPacketNode);
            }
        }
    }

    String getPacketList() {
        return this.msPackets;
    }

    void setDataLoadOptions(Node oConfig) {
        if (oConfig != null) {
            Node oData;
            Node oCommon;
            assert ("config".equals(oConfig.getName()));
            Node oProto = Utils.getChildNodeByName(oConfig, "acrobat", "");
            if (oProto == null) {
                oProto = Utils.getChildNodeByName(oConfig, "agent", "acrobat");
            }
            if (oProto != null && (oCommon = Utils.getChildNodeByName(oProto, "common", "")) != null && (oData = Utils.getChildNodeByName(oCommon, "data", "")) != null) {
                StringBuilder sExclNS = new StringBuilder();
                for (Node oCurNode = oData.getFirstXMLChild(); oCurNode != null; oCurNode = oCurNode.getNextXMLSibling()) {
                    Integer lNum;
                    String aName = oCurNode.getName();
                    if ("transform".equals(aName)) {
                        Attribute oRefAttr;
                        String sRefAttrVal = null;
                        if (oCurNode instanceof Element && (oRefAttr = ((Element)oCurNode).getAttribute(XFA.REFTAG)) != null) {
                            sRefAttrVal = oRefAttr.getAttrValue();
                        }
                        String sOptionName = "data_transform";
                        StringBuilder sTransformation = new StringBuilder();
                        if (sRefAttrVal != null) {
                            sTransformation.append(XFA.REFTAG).append("='").append(sRefAttrVal).append("' ");
                        }
                        for (Node oOperationChild = oCurNode.getFirstXMLChild(); oOperationChild != null; oOperationChild = oOperationChild.getNextXMLSibling()) {
                            String sOperationName = oOperationChild.getName();
                            Node oText = oOperationChild.getFirstXMLChild();
                            String sOperationVal = null;
                            if (oText instanceof TextNode) {
                                sOperationVal = ((TextNode)oText).getValue();
                            }
                            if (StringUtils.isEmpty(sOperationVal)) continue;
                            sTransformation.append(sOperationName).append("='").append(sOperationVal).append("' ");
                        }
                        StringUtils.trim(sTransformation);
                        this.moDataModelFactory.setOption(sOptionName, sTransformation.toString(), false);
                        continue;
                    }
                    String sValue = null;
                    Node oText = oCurNode.getFirstXMLChild();
                    if (oText instanceof TextNode) {
                        sValue = ((TextNode)oText).getValue();
                    }
                    if (StringUtils.isEmpty(sValue)) continue;
                    if ("excludeNS".equals(aName)) {
                        if (sExclNS.length() != 0) {
                            sExclNS.append(' ');
                        }
                        sExclNS.append(sValue);
                        this.moDataModelFactory.setOption(aName, sExclNS.toString(), false);
                        continue;
                    }
                    if ("attributes".equals(aName) || "record".equals(aName) || "startNode".equals(aName)) {
                        this.moDataModelFactory.setOption(aName, sValue, false);
                        continue;
                    }
                    if (!"adjustData".equals(aName) || (lNum = StringUtils.number(sValue)) == null) continue;
                    this.mbModifyData = lNum != 0;
                }
            }
        }
    }

    void setLocaleOptions(Node oConfig) {
        if (oConfig != null) {
            String sValue;
            Node oText;
            Node oLocale;
            Node oCommon;
            assert ("config".equals(oConfig.getName()));
            Node oProto = Utils.getChildNodeByName(oConfig, "acrobat", "");
            if (oProto == null) {
                oProto = Utils.getChildNodeByName(oConfig, "agent", "acrobat");
            }
            if (oProto != null && (oCommon = Utils.getChildNodeByName(oProto, "common", "")) != null && (oLocale = Utils.getChildNodeByName(oCommon, "locale", "")) != null && (oText = oLocale.getFirstXFAChild()) instanceof TextNode && oText.getNextXMLSibling() == null && !StringUtils.isEmpty(sValue = ((TextNode)oText).getValue())) {
                this.msConfigLocale = sValue;
            }
        }
    }

    void setSubmitOptions(Node oConfig) {
        if (oConfig != null) {
            assert ("config".equals(oConfig.getName()));
            Node oProto = Utils.getChildNodeByName(oConfig, "acrobat", "");
            if (oProto == null) {
                oProto = Utils.getChildNodeByName(oConfig, "agent", "acrobat");
            }
            Node oSubmitUrl = null;
            if (oProto != null) {
                oSubmitUrl = Utils.getChildNodeByName(oProto, "submitUrl", "");
            }
            if (oSubmitUrl == null && (oProto = Utils.getChildNodeByName(oConfig, "present", "")) != null) {
                oSubmitUrl = Utils.getChildNodeByName(oProto, "submitUrl", "");
            }
            while (oSubmitUrl != null) {
                Node oChild;
                if ("submitUrl".equals(oSubmitUrl.getName()) && (oChild = oSubmitUrl.getFirstXMLChild()) instanceof TextNode) {
                    String sValue = ((TextNode)oChild).getValue();
                    this.msConfigSubmitUrl.add(sValue);
                }
                oSubmitUrl = oSubmitUrl.getNextXMLSibling();
            }
        }
    }

    void setVersionControlOptions(Node oConfig) {
        AppModel oApp = this.moAppModel;
        oApp.setSourceBelow(0x7D0000);
        if (oConfig != null) {
            Node oVC;
            Node oCommon;
            assert ("config".equals(oConfig.getName()));
            Node oProto = Utils.getChildNodeByName(oConfig, "acrobat", "");
            if (oProto == null) {
                oProto = Utils.getChildNodeByName(oConfig, "agent", "acrobat");
            }
            if (oProto != null && (oCommon = Utils.getChildNodeByName(oProto, "common", "")) != null && (oVC = Utils.getChildNodeByName(oCommon, "versionControl", "")) instanceof Element) {
                EnumValue eValue;
                String sValue;
                Attribute oAttr = ((Element)oVC).getAttribute(XFA.SOURCEBELOWTAG);
                if (oAttr != null) {
                    sValue = oAttr.getAttrValue();
                    eValue = EnumValue.getEnum(XFA.SOURCEBELOWTAG, EnumAttr.getEnum(EnumType.SOURCEBELOW_TYPE, sValue));
                    oApp.setSourceBelow(eValue.getInt());
                }
                if ((oAttr = ((Element)oVC).getAttribute(XFA.SOURCEABOVETAG)) != null) {
                    sValue = oAttr.getAttrValue();
                    eValue = EnumValue.getEnum(XFA.SOURCEABOVETAG, EnumAttr.getEnum(EnumType.SOURCEABOVE_TYPE, sValue));
                    oApp.setSourceAbove(eValue.getInt());
                }
            }
        }
    }
}

