/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.form;

import com.adobe.internal.pdftoolkit.services.xfa.form.DocumentContext;
import com.adobe.internal.pdftoolkit.services.xfa.form.Protocol;
import com.adobe.internal.pdftoolkit.services.xfa.form.ProtocolContext;
import com.adobe.internal.pdftoolkit.services.xfa.form.XFAPlugin;
import com.adobe.xfa.AppModel;
import com.adobe.xfa.Arg;
import com.adobe.xfa.formcalc.CalcException;
import com.adobe.xfa.formcalc.CalcParser;
import com.adobe.xfa.formcalc.CalcSymbol;
import com.adobe.xfa.formcalc.ProtocolHost;
import com.adobe.xfa.scripthandler.formcalc.FormCalcScriptHandler;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;
import java.util.EnumSet;

public class FormCalcScriptHandler
extends com.adobe.xfa.scripthandler.formcalc.FormCalcScriptHandler {
    private FormCalcParser moParser;
    private DocumentContext moDocContext;

    public FormCalcScriptHandler(DocumentContext oDocContext) {
        super(oDocContext.moAppModel);
        this.moDocContext = oDocContext;
    }

    @Override
    public com.adobe.xfa.scripthandler.formcalc.FormCalcScriptHandler clone() {
        return new FormCalcScriptHandler(this.moDocContext);
    }

    @Override
    public void executeOrSyntaxCheck(String script, Arg returnCode, int reason, boolean syntaxCheckOnly, String locale) {
        if (!this.moDocContext.getAllowFormUpdate() || !this.moDocContext.getProcessingOptions().scriptExecutionEnabled()) {
            if (reason == 2) {
                returnCode.setBool(true);
            } else if (reason == 16) {
                returnCode.setBool(false);
            } else {
                ExFull oEx = new ExFull(ResId.OPERATION_CANCELLED);
                returnCode.setException(oEx);
            }
            return;
        }
        CalcParser oParser = this.getParser(false);
        if (oParser == null) {
            TemplateModel oTemplateModel;
            oParser = this.getParser(true);
            oParser.setProtocolHost((ProtocolHost)((Object)oParser));
            if (this.moDocContext.moAppModel != null && (oTemplateModel = this.moDocContext.getTemplateModel()) != null) {
                EnumSet<CalcParser.LegacyVersion> uLegacyScripting = EnumSet.of(CalcParser.LegacyVersion.CUR_SCRIPTING);
                if (oTemplateModel.getLegacySetting(AppModel.XFA_LEGACY_V30_SCRIPTING)) {
                    uLegacyScripting.add(CalcParser.LegacyVersion.V30_SCRIPTING);
                }
                if (oTemplateModel.getLegacySetting(AppModel.XFA_LEGACY_V32_SCRIPTING)) {
                    uLegacyScripting.add(CalcParser.LegacyVersion.V32_SCRIPTING);
                }
                oParser.setLegacyScripting(uLegacyScripting);
            }
        }
        super.executeOrSyntaxCheck(script, returnCode, reason, syntaxCheckOnly, locale);
        String sReturnMessage = this.getReturnMessage();
        if (!StringUtils.isEmpty(sReturnMessage)) {
            MsgFormatPos oMessage = new MsgFormatPos(ResId.SCRIPT_EXCEPTION);
            oMessage.format(sReturnMessage);
            return;
        }
        this.moDocContext.contentChanged(true);
    }

    @Override
    protected CalcParser getParser(boolean bForceCreation) {
        if (this.moParser == null) {
            if (bForceCreation) {
                this.moParser = new FormCalcParser(this.moDocContext, this);
            } else {
                return null;
            }
        }
        return this.moParser;
    }

    public static class FormCalcParser
    extends FormCalcScriptHandler.FormCalcParser
    implements ProtocolHost {
        private static final boolean DISALLOW_FILE_URLS = true;
        private DocumentContext moDocContext;

        public FormCalcParser(DocumentContext oDocContext, FormCalcScriptHandler oScriptHandler) {
            super(oDocContext.moAppModel, oScriptHandler);
            this.moDocContext = oDocContext;
        }

        @Override
        public CalcSymbol getUrl(String url) throws CalcException {
            if (StringUtils.findNoCase(url, "file:/", 0) == 0) {
                MsgFormatPos oErr = new MsgFormatPos(ResId.UNSUPPORTED_OPERATION);
                oErr.format("file:/");
                return new CalcSymbol(oErr.toString(), true, 0, 0);
            }
            return super.getUrl(url);
        }

        @Override
        public CalcSymbol putUrl(String url, String data, String enc) throws CalcException {
            if (StringUtils.findNoCase(url, "file:/", 0) == 0) {
                MsgFormatPos oErr = new MsgFormatPos(ResId.UNSUPPORTED_OPERATION);
                oErr.format("file:/");
                return new CalcSymbol(oErr.toString(), true, 0, 0);
            }
            return super.putUrl(url, data, enc);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CalcSymbol postUrl(String url, String soapHeader, String data, String contentType, String enc) throws CalcException {
            Protocol oProtocol = this.moDocContext != null ? XFAPlugin.getProtocol(this.moDocContext.mpdDoc) : null;
            ProtocolContext oProtocolContext = this.moDocContext == null ? null : new ProtocolContext(oProtocol, this.moDocContext.mpdDoc);
            try {
                CalcSymbol calcSymbol = super.postUrl(url, soapHeader, data, contentType, enc);
                return calcSymbol;
            }
            finally {
                if (oProtocolContext != null) {
                    oProtocolContext.destroy();
                }
            }
        }
    }
}

