/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.form;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOM;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOMService;
import com.adobe.internal.pdftoolkit.services.xfa.XFAProcessingOptions;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.Proto;
import com.adobe.xfa.ScriptHandler;
import com.adobe.xfa.XFA;
import com.adobe.xfa.form.FormModel;
import com.adobe.xfa.template.containers.ExclGroup;
import com.adobe.xfa.template.containers.Field;
import com.adobe.xfa.template.containers.Subform;
import java.util.ArrayList;
import java.util.List;

public class XFAFormModel {
    PDFDocument pdfDoc;

    public XFAFormModel(PDFDocument pdfDoc) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.pdfDoc = pdfDoc;
        XFAProcessingOptions xfaOptions = XFADOMService.getXFAProcessingOptions(pdfDoc);
        PDFInteractiveForm mForm = pdfDoc.getInteractiveForm();
        if (mForm == null) {
            throw new PDFInvalidParameterException("No acroform entry present in supplied document");
        }
        XFADOM xfaDom = this.getXFADOM(pdfDoc);
        if (xfaDom == null) {
            throw new PDFInvalidParameterException("Cannot create an XML DOM for the supplied document");
        }
        if (xfaOptions.createFormDOMEnabled() && !xfaDom.formModelExists()) {
            xfaDom.createFormModel();
        }
    }

    public void remerge() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        XFADOM xfaDom = this.getXFADOM(this.pdfDoc);
        xfaDom.getFormModel().remerge();
    }

    public void recalculate() {
        throw new PDFUnsupportedFeatureException("Not implemented yet");
    }

    public void executeScript(String scriptText, String scriptLanguage, ScriptHandler scriptHandlerToUse) {
        throw new PDFUnsupportedFeatureException("Not implemented yet");
    }

    public void reset() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        XFADOM xfaDom = this.getXFADOM(this.pdfDoc);
        if (xfaDom.getFormModel() != null) {
            xfaDom.getFormModel().reset();
        }
    }

    public void remove() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        XFADOM xfaDom = this.getXFADOM(this.pdfDoc);
        if (xfaDom.getFormModel() != null) {
            xfaDom.getAppModel().getNodes().remove(xfaDom.getDataModel());
            xfaDom.getAppModel().getNodes().remove(xfaDom.getFormModel());
        }
    }

    public void reApplyXFAPermissions() {
        throw new PDFUnsupportedFeatureException("Not implemented yet");
    }

    public List<String> getSubmitURLS() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<String> submitTargets = null;
        FormModel formModel = XFADOMService.ensureXFADOMCreated(this.pdfDoc).getFormModel();
        if (formModel != null) {
            submitTargets = new ArrayList<String>();
            this.findSubmitTargets(formModel.getFirstXFAChild(), submitTargets);
        }
        return submitTargets;
    }

    private void findSubmitTargets(Node node, List<String> submitTargets) {
        boolean peek = true;
        boolean returnDefault = false;
        for (Node childNode = node.getFirstXFAChild(); childNode != null; childNode = childNode.getNextXFASibling()) {
            Attribute targetAttr;
            Element submitNode;
            if (!(childNode instanceof Field) && !(childNode instanceof Proto) && !(childNode instanceof Subform) && !(childNode instanceof ExclGroup)) continue;
            Element eventNode = ((Element)childNode).getElement(XFA.EVENTTAG, peek, 0, returnDefault, false);
            if (eventNode != null && (submitNode = eventNode.getElement(XFA.SUBMITTAG, peek, 0, returnDefault, false)) != null && (targetAttr = submitNode.getAttribute(XFA.TARGETTAG, peek, false)) != null) {
                submitTargets.add(targetAttr.getAttrValue());
            }
            if (!(childNode instanceof Field)) {
                this.findSubmitTargets(childNode, submitTargets);
            }
            if (childNode.getClassTag() != XFA.DRAWTAG) continue;
            this.findSubmitTargets(childNode, submitTargets);
        }
    }

    private XFADOM getXFADOM(PDFDocument pdfDoc) throws PDFCosParseException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return XFADOMService.ensureXFADOMCreated(pdfDoc);
    }
}

