/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xmp;

import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.xmp.XMPException;
import com.adobe.internal.xmp.XMPMeta;
import com.adobe.internal.xmp.XMPMetaFactory;
import com.adobe.internal.xmp.XMPSchemaRegistry;
import com.adobe.internal.xmp.options.ParseOptions;
import com.adobe.internal.xmp.options.SerializeOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.WeakHashMap;

public class XMPMetaFactoryMonitor {
    private static Map<PDFDocument, Map<String, String>> docVsNameSpaces = new WeakHashMap<PDFDocument, Map<String, String>>();
    private static PDFDocument currentDoc = null;
    private static XMPMetaFactoryMonitor instance = null;

    private XMPMetaFactoryMonitor() {
    }

    @Deprecated
    public static synchronized XMPMetaFactoryMonitor getInstance(PDFDocument pdfDoc) {
        if (pdfDoc != null) {
            XMPMetaFactoryMonitor.setDoc(pdfDoc);
        }
        return XMPMetaFactoryMonitor.getMonitor();
    }

    private static void setDoc(PDFDocument pdfDoc) {
        if (currentDoc == null) {
            XMPMetaFactory.reset();
            if (docVsNameSpaces.containsKey(pdfDoc)) {
                XMPMetaFactoryMonitor.pushNStoSchemaRegistry(pdfDoc);
            }
            currentDoc = pdfDoc;
            return;
        }
        if (pdfDoc.equals(currentDoc)) {
            return;
        }
        Map nameSpacesofCurrentDoc = XMPMetaFactory.getSchemaRegistry().getNamespaces();
        docVsNameSpaces.put(currentDoc, nameSpacesofCurrentDoc);
        XMPMetaFactory.reset();
        if (docVsNameSpaces.get(pdfDoc) == null) {
            currentDoc = pdfDoc;
            return;
        }
        XMPMetaFactoryMonitor.pushNStoSchemaRegistry(pdfDoc);
        currentDoc = pdfDoc;
    }

    private static void pushNStoSchemaRegistry(PDFDocument pdfDoc) {
        for (Map.Entry<String, String> nsEntry : docVsNameSpaces.get(pdfDoc).entrySet()) {
            String namespace = nsEntry.getKey();
            if (XMPMetaFactory.getSchemaRegistry().getNamespacePrefix(namespace) != null) continue;
            try {
                XMPMetaFactory.getSchemaRegistry().registerNamespace(namespace, nsEntry.getValue());
            }
            catch (XMPException e) {
                System.out.println("Exception in using XMP " + e.getMessage());
            }
        }
    }

    private static XMPMetaFactoryMonitor getMonitor() {
        if (instance == null) {
            instance = new XMPMetaFactoryMonitor();
        }
        return instance;
    }

    @Deprecated
    public XMPSchemaRegistry getSchemaRegistry() {
        return XMPMetaFactory.getSchemaRegistry();
    }

    public static synchronized XMPSchemaRegistry getSchemaRegistry(PDFDocument doc) {
        XMPMetaFactoryMonitor.setDoc(doc);
        return XMPMetaFactory.getSchemaRegistry();
    }

    @Deprecated
    public XMPMeta parse(InputStream in, ParseOptions options) throws XMPException {
        return XMPMetaFactory.parse(in, options);
    }

    public static synchronized XMPMeta parse(InputStream in, ParseOptions options, PDFDocument doc) throws XMPException {
        XMPMetaFactoryMonitor.setDoc(doc);
        return XMPMetaFactory.parse(in, options);
    }

    @Deprecated
    public XMPMeta parseFromString(String packet, ParseOptions options) throws XMPException {
        return XMPMetaFactory.parseFromString(packet, options);
    }

    public static synchronized XMPMeta parseFromString(String packet, ParseOptions options, PDFDocument doc) throws XMPException {
        XMPMetaFactoryMonitor.setDoc(doc);
        return XMPMetaFactory.parseFromString(packet, options);
    }

    @Deprecated
    public XMPMeta parseFromBuffer(byte[] buffer, ParseOptions options) throws XMPException {
        return XMPMetaFactory.parseFromBuffer(buffer, options);
    }

    public static synchronized XMPMeta parseFromBuffer(byte[] buffer, ParseOptions options, PDFDocument doc) throws XMPException {
        XMPMetaFactoryMonitor.setDoc(doc);
        return XMPMetaFactory.parseFromBuffer(buffer, options);
    }

    @Deprecated
    public void serialize(XMPMeta xmp, OutputStream out, SerializeOptions options) throws XMPException {
        XMPMetaFactory.serialize(xmp, out, options);
    }

    public static synchronized void serialize(XMPMeta xmp, OutputStream out, SerializeOptions options, PDFDocument doc) throws XMPException {
        XMPMetaFactoryMonitor.setDoc(doc);
        XMPMetaFactory.serialize(xmp, out, options);
    }

    @Deprecated
    public byte[] serializeToBuffer(XMPMeta xmp, SerializeOptions options) throws XMPException {
        return XMPMetaFactory.serializeToBuffer(xmp, options);
    }

    public static synchronized byte[] serializeToBuffer(XMPMeta xmp, SerializeOptions options, PDFDocument doc) throws XMPException {
        XMPMetaFactoryMonitor.setDoc(doc);
        return XMPMetaFactory.serializeToBuffer(xmp, options);
    }

    @Deprecated
    public String serializeToString(XMPMeta xmp, SerializeOptions options) throws XMPException {
        return XMPMetaFactory.serializeToString(xmp, options);
    }

    public static synchronized String serializeToString(XMPMeta xmp, SerializeOptions options, PDFDocument doc) throws XMPException {
        XMPMetaFactoryMonitor.setDoc(doc);
        return XMPMetaFactory.serializeToString(xmp, options);
    }

    @Deprecated
    public void reset() {
        XMPMetaFactory.reset();
    }

    public static synchronized void reset(PDFDocument doc) {
        XMPMetaFactoryMonitor.setDoc(doc);
        XMPMetaFactory.reset();
    }

    @Deprecated
    public synchronized void clear() {
        docVsNameSpaces.remove(currentDoc);
        currentDoc = null;
    }

    public static synchronized void clear(PDFDocument doc) {
        XMPMetaFactoryMonitor.setDoc(doc);
        docVsNameSpaces.remove(currentDoc);
        currentDoc = null;
    }
}

