/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xobjhandler;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.IO;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.io.stream.StreamManager;
import com.adobe.internal.pdftoolkit.core.cos.CosCloneMgr;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidContentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.ContentReader;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.content.OperandStack;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentModifier;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFExtGStateMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRotation;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFGroupAttributes;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectMap;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureArtifact;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.pieceinfo.compoundtype.PDFCompoundTypeInfo;
import com.adobe.internal.pdftoolkit.services.xobjhandler.XObjectApplyOptions;
import com.adobe.internal.pdftoolkit.services.xobjhandler.XObjectContentType;
import com.adobe.internal.pdftoolkit.services.xobjhandler.XObjectUseOptions;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;

public class PageContentXObject {
    private PageContentXObject() {
    }

    public static void applyPageContent(PDFPage pdfPage, PDFPage layPage, XObjectApplyOptions applyOptions, XObjectUseOptions useOptions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFDocument pdfDocument = pdfPage.getPDFDocument();
        PDFXObjectForm pdfXObjectForm = PageContentXObject.generateContentXObject(pdfDocument, layPage, useOptions);
        if (applyOptions == null) {
            applyOptions = new XObjectApplyOptions();
        }
        if (useOptions == null) {
            useOptions = new XObjectUseOptions();
        }
        applyOptions.applyXObjectForm(pdfPage, pdfXObjectForm, useOptions);
    }

    public static PDFXObjectForm generateContentXObject(PDFDocument pdfDocument, PDFPage pdfPage, XObjectUseOptions useOptions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosCloneMgr cosCloneMgr = new CosCloneMgr(pdfDocument.getCosDocument());
        return PageContentXObject.generateContentXObject(pdfDocument, pdfPage, cosCloneMgr, useOptions);
    }

    public static PDFXObjectForm generateContentXObject(PDFDocument pdfDocument, PDFPage pdfPage, CosCloneMgr cosCloneMgr, XObjectUseOptions useOptions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        InputByteStream contents;
        PDFGroupAttributes clonedPDFGroup;
        PDFResources clonedPDFResources;
        ASMatrix pageRotationMatrix;
        PDFRotation pageRotation;
        PDFRectangle pageCropBox;
        block26: {
            ASMatrix alignmentMatrix;
            ASRectangle clipBox;
            pageCropBox = pdfPage.getArtBox();
            if (useOptions != null && (clipBox = useOptions.getClipBox()) != null) {
                pageCropBox = PDFRectangle.newInstance(pdfDocument, clipBox);
            }
            double pageCropWidth = pageCropBox.width();
            double pageCropHeight = pageCropBox.height();
            pageRotation = pdfPage.getRotation();
            if (pageRotation == PDFRotation.ROTATE_90) {
                pageRotationMatrix = new ASMatrix(0.0, -1.0, 1.0, 0.0, 0.0, 0.0);
                alignmentMatrix = new ASMatrix(1.0, 0.0, 0.0, 1.0, -pageCropWidth, 0.0);
            } else if (pageRotation == PDFRotation.ROTATE_180) {
                pageRotationMatrix = new ASMatrix(-1.0, 0.0, 0.0, -1.0, 0.0, 0.0);
                alignmentMatrix = new ASMatrix(1.0, 0.0, 0.0, 1.0, -pageCropWidth, -pageCropHeight);
            } else if (pageRotation == PDFRotation.ROTATE_270) {
                pageRotationMatrix = new ASMatrix(0.0, 1.0, -1.0, 0.0, 0.0, 0.0);
                alignmentMatrix = new ASMatrix(1.0, 0.0, 0.0, 1.0, 0.0, -pageCropHeight);
            } else {
                pageRotationMatrix = new ASMatrix(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
                alignmentMatrix = new ASMatrix(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
            }
            pageRotationMatrix = alignmentMatrix.concat(pageRotationMatrix);
            PDFResources pdfPageResources = pdfPage.getResources();
            clonedPDFResources = null;
            if (pdfPageResources != null) {
                CosDictionary cosPageResources = pdfPageResources.getCosDictionary();
                CosDictionary clonedPageResources = null;
                clonedPageResources = pdfDocument != pdfPage.getPDFDocument() ? (CosDictionary)cosCloneMgr.clone(cosPageResources) : cosPageResources.copy();
                clonedPDFResources = PDFResources.getInstance(clonedPageResources);
            }
            PDFGroupAttributes pdfPageGroup = pdfPage.getGroup();
            clonedPDFGroup = null;
            if (pdfPageGroup != null) {
                CosDictionary cosPageGroup = pdfPageGroup.getCosDictionary();
                CosDictionary clonedPageGroup = null;
                clonedPageGroup = pdfDocument != pdfPage.getPDFDocument() ? (CosDictionary)cosCloneMgr.clone(cosPageGroup) : cosPageGroup.copy();
                clonedPDFGroup = PDFGroupAttributes.getInstance(clonedPageGroup);
            }
            contents = pdfPage.getContents() != null ? pdfPage.getContents().getContents() : null;
            try {
                if (contents == null || pdfDocument == pdfPage.getPDFDocument()) break block26;
                StreamManager streamManager = pdfDocument.getCosDocument().getStreamManager();
                OutputByteStream clonedContents = streamManager.getOutputByteStreamEncryptedDocument(ByteWriterFactory.Fixed.FIXED, contents.length());
                try {
                    IO.copy(contents, clonedContents);
                }
                catch (IOException e) {
                    throw new PDFIOException(e);
                }
                finally {
                    if (contents != null) {
                        contents.close();
                    }
                }
                contents = clonedContents.closeAndConvert();
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
        PDFXObjectForm pdfXObjectForm = PDFXObjectForm.newInstance(pdfDocument, pageCropBox, clonedPDFResources, contents);
        pdfXObjectForm.setMatrix(pageRotationMatrix.getValues());
        PDFXObjectForm returnXObj = null;
        if (pageRotation.getValue() != 0) {
            ContentWriter writer = ContentWriter.newInstance(pdfDocument);
            writer.write(InstructionFactory.newGSave());
            writer.write(pdfXObjectForm);
            writer.write(InstructionFactory.newGRestore());
            Content newContent = writer.close();
            PDFRectangle wrapBBox = PDFRectangle.newInstance(pdfDocument, pageCropBox.getRectangle().transform(pageRotationMatrix));
            PDFXObjectForm pdfWrapXObjectForm = PDFXObjectForm.newInstance(pdfDocument, wrapBBox.normalized(pdfDocument), newContent.getResources(), newContent.getContentStream());
            pdfWrapXObjectForm.setMatrix(ASMatrix.createIdentityMatrix().getValues());
            returnXObj = pdfWrapXObjectForm;
        } else {
            returnXObj = pdfXObjectForm;
        }
        if (clonedPDFGroup != null) {
            returnXObj.setGroupAttributes(clonedPDFGroup);
        } else {
            PDFGroupAttributes newGroup = PDFGroupAttributes.newInstance(pdfDocument);
            newGroup.setSubType(ASName.k_Transparency);
            newGroup.setKnockout(true);
            returnXObj.setGroupAttributes(newGroup);
        }
        if (useOptions != null) {
            if (useOptions.hasOptionalContent()) {
                try {
                    useOptions.applyOptionalContent(returnXObj);
                }
                catch (PDFInvalidParameterException e) {
                    throw new PDFInvalidDocumentException(e);
                }
            }
            if (useOptions.hasContentType()) {
                useOptions.getContentType().applyPieceInfo(returnXObj);
            }
        }
        return returnXObj;
    }

    private static void clearContentBuffer(Instruction[] instruction, ASName[] operator2, int sequanceLength) {
        int i;
        int instructionBufferLength = instruction.length;
        for (i = 0; i < sequanceLength; ++i) {
            if (instruction[i] != null) {
                try {
                    instruction[i].close();
                }
                catch (PDFIOException e) {
                    // empty catch block
                }
            }
            instruction[i] = null;
            operator2[i] = null;
        }
        for (i = sequanceLength - 1; i < instructionBufferLength - 1; ++i) {
            instruction[i] = instruction[i + 1];
            operator2[i] = operator2[i + 1];
        }
        instruction[instructionBufferLength - 1] = null;
        operator2[instructionBufferLength - 1] = null;
    }

    private static boolean processInstruction(Instruction[] instruction, ASName[] operator2, HashSet deletedXObjects, HashSet usedXObjects, HashSet deletedExtGStates, HashSet usedExtGStates, ContentWriter writer) throws PDFInvalidContentException, PDFIOException {
        boolean instructionProcessed = false;
        if (instruction[0] != null) {
            instructionProcessed = true;
            if (operator2[0] == ASName.k_Do) {
                OperandStack xObj = instruction[0].getOperands();
                ASName xobjName = xObj.peekName();
                deletedXObjects.remove(xobjName);
                usedXObjects.add(xobjName);
            } else if (operator2[0] == ASName.k_gs) {
                OperandStack gState = instruction[0].getOperands();
                ASName gsName = gState.peekName();
                deletedExtGStates.remove(gsName);
                usedExtGStates.add(gsName);
            }
            writer.write(instruction[0]);
        }
        PageContentXObject.clearContentBuffer(instruction, operator2, 1);
        return instructionProcessed;
    }

    public static boolean removeAppliedContent(PDFPage pdfPage, XObjectContentType objType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean includeMarkedContentOnly = false;
        return PageContentXObject.removeAppliedContent(pdfPage, objType, includeMarkedContentOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean removeAppliedContent(PDFPage pdfPage, XObjectContentType objType, boolean includeMarkedContentOnly) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Content content = Content.newInstance(pdfPage);
        PDFXObjectMap pdfXObjMap = content.getResources().getXObjectMap();
        if (pdfXObjMap == null) {
            if (!includeMarkedContentOnly) return false;
            if (objType == XObjectContentType.Background) return PageContentXObject.removeArtifactAsMarkedContent(pdfPage, objType);
            if (objType == XObjectContentType.Header) return PageContentXObject.removeArtifactAsMarkedContent(pdfPage, objType);
            if (objType == XObjectContentType.Footer) return PageContentXObject.removeArtifactAsMarkedContent(pdfPage, objType);
            if (objType == XObjectContentType.Watermark) return PageContentXObject.removeArtifactAsMarkedContent(pdfPage, objType);
            if (objType != XObjectContentType.BatesN) return false;
            return PageContentXObject.removeArtifactAsMarkedContent(pdfPage, objType);
        }
        PDFExtGStateMap pdfGSMap = content.getResources().getExtGStateMap();
        HashSet<ASName> deletedXObjects = new HashSet<ASName>();
        HashSet<ASName> deletedExtGStates = new HashSet<ASName>();
        HashSet usedXObjects = new HashSet();
        HashSet usedExtGStates = new HashSet();
        boolean xobjFound = false;
        ASName objTypeName = objType.getValue();
        PDFDocument pdfDocument = pdfPage.getPDFDocument();
        ContentWriter writer = ContentWriter.newInstance(pdfDocument);
        Instruction[] instruction = new Instruction[8];
        ASName[] operator2 = new ASName[8];
        for (int i = 0; i < 8; ++i) {
            instruction[i] = null;
            operator2[i] = null;
        }
        int instructionBufferCount = 0;
        ContentReader reader = null;
        Instruction nextInstruction = null;
        try {
            reader = ContentReader.newInstance(content);
            try {
                while (reader.hasNext() || instructionBufferCount > 0) {
                    nextInstruction = reader.next();
                    if (nextInstruction != null) {
                        instruction[7] = nextInstruction;
                        ++instructionBufferCount;
                        operator2[7] = instruction[7].getOperator();
                    }
                    OperandStack gsOperand = null;
                    OperandStack doOperands = null;
                    int sequanceLength = 0;
                    boolean contentFound = false;
                    if (operator2[0] == ASName.k_BDC && operator2[1] == ASName.k_q && operator2[2] == ASName.k_cm && operator2[3] == ASName.k_g && operator2[4] == ASName.k_gs && operator2[5] == ASName.k_Do && operator2[6] == ASName.k_Q && operator2[7] == ASName.k_EMC) {
                        contentFound = true;
                        gsOperand = instruction[4].getOperands();
                        doOperands = instruction[5].getOperands();
                        sequanceLength = 8;
                    } else if (operator2[0] == ASName.k_BDC && operator2[1] == ASName.k_q && operator2[2] == ASName.k_cm && operator2[3] == ASName.k_gs && operator2[4] == ASName.k_Do && operator2[5] == ASName.k_Q && operator2[6] == ASName.k_EMC) {
                        contentFound = true;
                        gsOperand = instruction[3].getOperands();
                        doOperands = instruction[4].getOperands();
                        sequanceLength = 7;
                    } else if (operator2[0] == ASName.k_BDC && operator2[1] == ASName.k_q && operator2[2] == ASName.k_gs && operator2[3] == ASName.k_Do && operator2[4] == ASName.k_Q && operator2[5] == ASName.k_EMC) {
                        contentFound = true;
                        gsOperand = instruction[2].getOperands();
                        doOperands = instruction[3].getOperands();
                        sequanceLength = 6;
                    } else if (operator2[0] == ASName.k_q && operator2[1] == ASName.k_cm && operator2[2] == ASName.k_gs && operator2[3] == ASName.k_Do && operator2[4] == ASName.k_Q) {
                        contentFound = true;
                        gsOperand = instruction[2].getOperands();
                        doOperands = instruction[3].getOperands();
                        sequanceLength = 5;
                    } else if (operator2[0] == ASName.k_q && operator2[1] == ASName.k_cm && operator2[2] == ASName.k_gs && operator2[3] == ASName.k_Tw && operator2[4] == ASName.k_Do && operator2[5] == ASName.k_Q) {
                        contentFound = true;
                        gsOperand = instruction[2].getOperands();
                        doOperands = instruction[4].getOperands();
                        sequanceLength = 6;
                    } else if (operator2[0] == ASName.k_q && operator2[1] == ASName.k_gs && operator2[2] == ASName.k_Do && operator2[3] == ASName.k_Q) {
                        contentFound = true;
                        gsOperand = instruction[1].getOperands();
                        doOperands = instruction[2].getOperands();
                        sequanceLength = 4;
                    }
                    if (contentFound) {
                        ASName gsName = gsOperand.peekName();
                        ASName xobjName = doOperands.peekName();
                        PDFXObject pdfXObj = pdfXObjMap.get(xobjName);
                        if (pdfXObj != null & gsName != null) {
                            ASName contentType;
                            PDFCompoundTypeInfo xObjInfo;
                            if (pdfXObj instanceof PDFXObjectForm && (xObjInfo = PDFCompoundTypeInfo.getInstance((PDFXObjectForm)pdfXObj)) != null && (contentType = xObjInfo.getType()) != null && contentType.equals(objTypeName)) {
                                xobjFound = true;
                                if (!usedXObjects.contains(xobjName)) {
                                    deletedXObjects.add(xobjName);
                                }
                                if (!usedExtGStates.contains(gsName)) {
                                    deletedExtGStates.add(gsName);
                                }
                                PageContentXObject.clearContentBuffer(instruction, operator2, sequanceLength);
                                instructionBufferCount -= sequanceLength;
                                continue;
                            }
                        } else {
                            PageContentXObject.clearContentBuffer(instruction, operator2, sequanceLength);
                            instructionBufferCount -= sequanceLength;
                            continue;
                        }
                    }
                    if (!PageContentXObject.processInstruction(instruction, operator2, deletedXObjects, usedXObjects, deletedExtGStates, usedExtGStates, writer)) continue;
                    --instructionBufferCount;
                }
            }
            finally {
                int i = 0;
                while (true) {
                    if (i >= instruction.length) {
                    }
                    if (instruction[i] != null) {
                        try {
                            instruction[i].close();
                        }
                        catch (PDFIOException e) {}
                    }
                    ++i;
                }
            }
            if (!xobjFound) return xobjFound;
            Content newContent = writer.close();
            writer = null;
            pdfPage.setContents(newContent.getContents());
            if (!pdfPage.dictionaryContains(ASName.k_Resources)) return xobjFound;
            for (ASName deletedXObject : deletedXObjects) {
                pdfXObjMap.removeValue(deletedXObject);
            }
            Iterator deletedExtGStatesIterator = deletedExtGStates.iterator();
            while (deletedExtGStatesIterator.hasNext() && pdfGSMap != null) {
                ASName deletedExtGState = (ASName)deletedExtGStatesIterator.next();
                pdfGSMap.removeValue(deletedExtGState);
            }
            if (pdfXObjMap.isEmpty()) {
                pdfPage.getResources().removeValue(ASName.k_XObject);
            } else {
                pdfPage.getResources().setXObjectMap(pdfXObjMap);
            }
            if (pdfGSMap == null || pdfGSMap != null && pdfGSMap.isEmpty()) {
                pdfPage.getResources().removeValue(ASName.k_ExtGState);
                return xobjFound;
            }
            pdfPage.getResources().setExtGStateMap(pdfGSMap);
            return xobjFound;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
    }

    private static boolean removeArtifactAsMarkedContent(PDFPage page, XObjectContentType contentType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName artifactType = null;
        ASName artifactSubtype = null;
        if (contentType == XObjectContentType.Background) {
            artifactType = PDFStructureArtifact.k_Background;
        } else if (contentType == XObjectContentType.Header || contentType == XObjectContentType.Footer || contentType == XObjectContentType.Watermark || contentType == XObjectContentType.BatesN) {
            artifactType = PDFStructureArtifact.k_Pagination;
            artifactSubtype = contentType.getValue();
        } else {
            return false;
        }
        try {
            return ContentModifier.removeArtifactAsMarkedContent(page, artifactType, artifactSubtype);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException(e);
        }
    }
}

