/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class SkipXMLPIOutputStream
extends OutputStream {
    private OutputStream mParentStream;
    private byte[] mPIBytes;
    private byte[] mBytes;
    private boolean mChecked;
    private boolean mSkip;
    private int mBufPos;
    private static final String XMLPISTR = "<?xml";
    private static final int PIEND = 62;

    public SkipXMLPIOutputStream(OutputStream parentStream) throws UnsupportedEncodingException {
        this.mParentStream = parentStream;
        this.mBufPos = 0;
        this.mChecked = false;
        this.mSkip = false;
        this.mPIBytes = XMLPISTR.getBytes("UTF-8");
        this.mBytes = new byte[5];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            if (!this.mChecked) {
                this.flush();
            }
        }
        finally {
            this.mParentStream.close();
        }
    }

    @Override
    public void flush() throws IOException {
        this.mParentStream.flush();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int byteCnt = off;
        while (!this.mChecked && len > 0) {
            this.write(b[byteCnt++]);
            --len;
        }
        if (byteCnt < len) {
            this.mParentStream.write(b, byteCnt, len);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.mChecked) {
            if (this.mSkip) {
                if (b == 62) {
                    this.mChecked = true;
                }
            } else if (this.mBufPos >= 5) {
                this.mSkip = true;
            } else if (b == this.mPIBytes[this.mBufPos]) {
                this.mBytes[this.mBufPos++] = (byte)b;
            } else {
                this.mChecked = true;
                if (this.mBufPos > 0) {
                    this.write(this.mBytes, 0, this.mBufPos);
                } else {
                    this.mParentStream.write(b);
                }
            }
        } else {
            this.mParentStream.write(b);
        }
    }
}

