/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xml;

import com.adobe.internal.pdftoolkit.xml.XMLUtils;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class XMLElemContentReplacer
implements XMLReader {
    ContentHandler mOutputHandler;
    final String requestedPacketInXML;
    InputStream mNewData;
    boolean tagToReplaceExists;
    int numElemToReplaceOccurences = 0;

    public XMLElemContentReplacer(String requestedPacketInXML, InputStream newData) {
        this.mNewData = newData;
        this.requestedPacketInXML = requestedPacketInXML;
        this.tagToReplaceExists = false;
        this.numElemToReplaceOccurences = 0;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.mOutputHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        this.mOutputHandler.startDocument();
        InputStream xfaStream = input.getByteStream();
        if (xfaStream != null) {
            SAXParser saxParser;
            XMLCopyHandler xmlCopier = new XMLCopyHandler();
            try {
                saxParser = XMLUtils.getNonValidatingSaxParser();
            }
            catch (ParserConfigurationException e) {
                throw new SAXException(" SAX Parser configuration exception" + e.getMessage(), e);
            }
            saxParser.parse(xfaStream, (DefaultHandler)xmlCopier);
        }
        this.mOutputHandler.endDocument();
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.mOutputHandler = handler;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    class XMLCopyHandler
    extends DefaultHandler {
        private boolean insideElementToReplace;
        Attributes originalElemAttrs = new AttributesImpl();

        XMLCopyHandler() {
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void setDocumentLocator(Locator l) {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
            if (!XMLElemContentReplacer.this.tagToReplaceExists) {
                throw new SAXException("The tag " + XMLElemContentReplacer.this.requestedPacketInXML + " is not present in the xml. Cannot replace it's contents");
            }
        }

        @Override
        public void startElement(String namespaceURI, String sName, String qName, Attributes elemAttrs) throws SAXException {
            if (qName.equals(XMLElemContentReplacer.this.requestedPacketInXML)) {
                if (XMLElemContentReplacer.this.numElemToReplaceOccurences == 0) {
                    this.insideElementToReplace = true;
                }
                XMLElemContentReplacer.this.tagToReplaceExists = true;
                this.originalElemAttrs = new AttributesImpl(elemAttrs);
                ++XMLElemContentReplacer.this.numElemToReplaceOccurences;
            }
            if (!this.insideElementToReplace && !qName.equals(XMLElemContentReplacer.this.requestedPacketInXML)) {
                XMLElemContentReplacer.this.mOutputHandler.startElement(namespaceURI, sName, qName, elemAttrs);
            }
        }

        @Override
        public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
            if (qName.equals(XMLElemContentReplacer.this.requestedPacketInXML)) {
                if (this.insideElementToReplace) {
                    SAXParser saxParser;
                    this.insideElementToReplace = false;
                    XMLElemContentReplacer.this.mOutputHandler.startElement(namespaceURI, "", XMLElemContentReplacer.this.requestedPacketInXML, this.originalElemAttrs);
                    XMLCopyHandler xfaCopyHandler = new XMLCopyHandler();
                    try {
                        saxParser = XMLUtils.getNonValidatingSaxParser();
                    }
                    catch (ParserConfigurationException e) {
                        throw new SAXException(" SAX Parser configuration exception" + e.getMessage(), e);
                    }
                    try {
                        saxParser.parse(XMLElemContentReplacer.this.mNewData, (DefaultHandler)xfaCopyHandler);
                    }
                    catch (IOException ex) {
                        throw new SAXException(" IO exception when creating new nodes" + ex.getMessage(), ex);
                    }
                    XMLElemContentReplacer.this.mOutputHandler.endElement(namespaceURI, "", XMLElemContentReplacer.this.requestedPacketInXML);
                    this.originalElemAttrs = null;
                }
                --XMLElemContentReplacer.this.numElemToReplaceOccurences;
            } else if (!this.insideElementToReplace) {
                XMLElemContentReplacer.this.mOutputHandler.endElement(namespaceURI, sName, qName);
            }
        }

        @Override
        public void characters(char[] buf, int offset, int len) throws SAXException {
            if (!this.insideElementToReplace) {
                XMLElemContentReplacer.this.mOutputHandler.characters(buf, offset, len);
            }
        }

        @Override
        public void ignorableWhitespace(char[] buf, int offset, int len) throws SAXException {
            if (!this.insideElementToReplace) {
                XMLElemContentReplacer.this.mOutputHandler.ignorableWhitespace(buf, offset, len);
            }
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            if (!this.insideElementToReplace) {
                XMLElemContentReplacer.this.mOutputHandler.processingInstruction(target, data);
            }
        }
    }
}

