/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xml;

import com.adobe.internal.pdftoolkit.xml.XMLCopierBase;
import com.adobe.internal.pdftoolkit.xml.XMLElement;
import com.adobe.internal.pdftoolkit.xml.XMLNamespaceUsage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLElementsRemover
extends XMLCopierBase {
    protected boolean inReplaceElement;
    protected int copyLevel;
    protected Map<String, XMLNamespaceUsage> invalidNamespaceUsageMap;
    protected Set<? extends XMLNamespaceUsage> invalidNamespaceUsageSet;
    protected HashSet<XMLElement> elements;

    public XMLElementsRemover(XMLReader parent, HashSet<XMLElement> elements, Set<? extends XMLNamespaceUsage> invalidNamespaceUsageSet) {
        super(parent, true);
        this.elements = elements;
        this.invalidNamespaceUsageSet = invalidNamespaceUsageSet;
        if (invalidNamespaceUsageSet != null) {
            this.invalidNamespaceUsageMap = new HashMap<String, XMLNamespaceUsage>();
            for (XMLNamespaceUsage xMLNamespaceUsage : invalidNamespaceUsageSet) {
                this.invalidNamespaceUsageMap.put(xMLNamespaceUsage.getURI(), xMLNamespaceUsage);
            }
        }
    }

    @Override
    protected int preElementStart(String namespaceURI, String simpleName) throws SAXException {
        if (this.inReplaceElement) {
            return -1;
        }
        if (this.elements.contains(new XMLElement(namespaceURI, simpleName)) || this.removeElementForNameSpaceUsage(namespaceURI, simpleName)) {
            this.copyLevel = this.xmlTreeDepth;
            this.inReplaceElement = true;
            return 0;
        }
        return -1;
    }

    @Override
    protected int postElementEnd(String namespaceURI, String simpleName) throws SAXException {
        XMLNamespaceUsage usage;
        if (this.inReplaceElement && this.invalidNamespaceUsageMap != null && (usage = this.invalidNamespaceUsageMap.get(namespaceURI)) != null && usage.getElements().contains(simpleName)) {
            this.invalidNamespaceUsageSet.remove(usage);
        }
        if (this.xmlTreeDepth == this.copyLevel && this.inReplaceElement && (this.elements.contains(new XMLElement(namespaceURI, simpleName)) || this.removeElementForNameSpaceUsage(namespaceURI, simpleName))) {
            this.succeeded = true;
            this.inReplaceElement = false;
            return 1;
        }
        return -1;
    }

    protected boolean removeElementForNameSpaceUsage(String namespaceURI, String simpleName) {
        XMLNamespaceUsage usage;
        if (this.invalidNamespaceUsageMap != null && (usage = this.invalidNamespaceUsageMap.get(namespaceURI)) != null) {
            return usage.getElements().contains(simpleName);
        }
        return false;
    }
}

