/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.xml;

import com.adobe.internal.pdftoolkit.xml.XMLUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class XMLNamespaceValidator
extends XMLFilterImpl {
    protected boolean succeeded = true;
    private boolean ignoreTrailingSlashes;
    private Map<String, String> prefixMap = new HashMap<String, String>();
    private Map<String, String> uriMap = new HashMap<String, String>();
    private Map<String, InvalidUsage> invalidPrefixes;
    private Map<String, InvalidUsage> invalidNamespaces;

    public XMLNamespaceValidator(XMLReader parent, boolean ignoreTrailingSlashes) {
        super(parent);
        this.ignoreTrailingSlashes = ignoreTrailingSlashes;
        this.initialize();
    }

    public XMLNamespaceValidator(XMLReader parent) {
        this(parent, false);
    }

    public XMLNamespaceValidator(boolean ignoreTrailingSlashes) {
        this.ignoreTrailingSlashes = ignoreTrailingSlashes;
        this.initialize();
    }

    public XMLNamespaceValidator() {
        this(false);
    }

    private void initialize() {
        this.invalidPrefixes = new HashMap<String, InvalidUsage>();
        this.invalidNamespaces = new HashMap<String, InvalidUsage>();
        this.succeeded = true;
    }

    public boolean ignoreTrailingSlashes() {
        return this.ignoreTrailingSlashes;
    }

    public void addNamespaceAndPrefix(String uri, String prefix) {
        this.addNamespace(uri, prefix);
        this.addPrefix(prefix, uri);
    }

    public void addNamespace(String uri, String prefix) {
        this.uriMap.put(this.ignoreTrailingSlashes ? XMLUtils.stripTrailingCharacter(uri, '/') : uri, prefix);
    }

    public void addPrefix(String prefix, String uri) {
        this.prefixMap.put(prefix, this.ignoreTrailingSlashes ? XMLUtils.stripTrailingCharacter(uri, '/') : uri);
    }

    public boolean succeeded() {
        return this.succeeded;
    }

    public InvalidUsage[] getInvalidPrefixes() {
        Set<Map.Entry<String, InvalidUsage>> entrySet = this.invalidPrefixes.entrySet();
        return this.entrySetToInvalidUsageArray(entrySet);
    }

    public InvalidUsage[] getInvalidNamespaces() {
        Set<Map.Entry<String, InvalidUsage>> entrySet = this.invalidNamespaces.entrySet();
        return this.entrySetToInvalidUsageArray(entrySet);
    }

    private InvalidUsage[] entrySetToInvalidUsageArray(Set entrySet) {
        int size = entrySet.size();
        InvalidUsage[] array = new InvalidUsage[size];
        if (size == 0) {
            return array;
        }
        Iterator iter = entrySet.iterator();
        for (int i = 0; i < size; ++i) {
            array[i] = (InvalidUsage)((Map.Entry)iter.next()).getValue();
        }
        return array;
    }

    public void reset() {
        this.initialize();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        String correctPrefix;
        super.startPrefixMapping(prefix, uri);
        uri = this.ignoreTrailingSlashes ? XMLUtils.stripTrailingCharacter(uri, '/') : uri;
        String correctURI = this.prefixMap.get(prefix);
        if (correctURI != null && !correctURI.equals(uri)) {
            this.succeeded = false;
            InvalidUsage invalid = this.invalidPrefixes.get(prefix);
            if (invalid == null) {
                invalid = new InvalidUsage(prefix, correctURI);
                invalid.addIncorrectMatch(uri);
                this.invalidPrefixes.put(prefix, invalid);
            } else {
                invalid.addIncorrectMatch(uri);
            }
        }
        if ((correctPrefix = this.uriMap.get(uri)) != null && !correctPrefix.equals(prefix)) {
            this.succeeded = false;
            InvalidUsage invalid = this.invalidNamespaces.get(uri);
            if (invalid == null) {
                invalid = new InvalidUsage(uri, correctPrefix);
                invalid.addIncorrectMatch(prefix);
                this.invalidNamespaces.put(uri, invalid);
            } else {
                invalid.addIncorrectMatch(prefix);
            }
        }
    }

    public class InvalidUsage {
        private final String base;
        private final String correctMatch;
        private Set incorrectMatches;

        protected InvalidUsage(String base, String correctMatch) {
            this.base = base;
            this.correctMatch = correctMatch;
            this.incorrectMatches = new HashSet();
        }

        protected void addIncorrectMatch(String incorrectMatch) {
            this.incorrectMatches.add(incorrectMatch);
        }

        public String getBase() {
            return this.base;
        }

        public String getCorrectMatch() {
            return this.correctMatch;
        }

        public String[] getIncorrectMatches() {
            String[] array = new String[this.incorrectMatches.size()];
            return this.incorrectMatches.toArray(array);
        }

        public String toString() {
            return "[" + this.base + ", " + this.correctMatch + "]";
        }
    }
}

