/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.social.integrations.livefyre.commerce;

import com.adobe.granite.crypto.CryptoException;
import com.adobe.social.integrations.livefyre.commerce.LivefyreProduct;
import com.adobe.social.integrations.livefyre.commerce.LivefyreProductAPI;
import com.adobe.social.integrations.livefyre.commerce.LivefyreProductFolder;
import com.adobe.social.integrations.livefyre.commerce.LivefyreProductPage;
import com.adobe.social.integrations.livefyre.config.api.LivefyreConfig;
import com.adobe.social.integrations.livefyre.config.api.LivefyreConfigProvider;
import com.adobe.social.integrations.livefyre.http.LivefyreHttpService;
import com.day.cq.commons.Externalizer;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.SearchResult;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.livefyre.Livefyre;
import com.livefyre.core.Network;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.http.osgi.services.HttpClientBuilderFactory;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.json.JSONObject;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class LivefyreCollectionsWatcher
implements EventListener {
    @Reference
    private ResourceResolverFactory resolverFactory;
    private ResourceResolver commerceBackendResolver;
    private ResourceResolver damResolver;
    private ResourceResolver contentAuthorResolver;
    private static final Logger LOG = LoggerFactory.getLogger(LivefyreCollectionsWatcher.class);
    private static final String SUB_SERVICE_COMMERCE_BACKEND = "livefyre-commerce-be-service";
    private static final String COMMERCE_COLLECTIONS_BASE_PATH = "/var/commerce/collections";
    private static final String LIVEFYRE_COLLECTIONS_BASE_PATH = "/etc/livefyre/commerce/collections";
    private static final String LIVEFYRE_ASSET_WRITER = "livefyre-asset-writer";
    private static final String LIVEFYRE_CONTENT_AUTHOR = "livefyre-communities-user-admin";
    private static Map<String, Object> backendServiceAuthInfo = new HashMap<String, Object>();
    private static Map<String, Object> contentAuthorServiceAuthInfo;
    private static Map<String, Object> damServiceAuthInfo;
    private Set<String> watchedCollections;
    String networkName;
    Network network;
    LivefyreProductAPI api;
    @Reference
    private LivefyreConfigProvider livefyreConfigProvider;
    @Reference
    private QueryBuilder builder;
    @Reference
    private LivefyreHttpService livefyreHttpService;
    @Reference
    private HttpClientBuilderFactory httpClientBuilderFactory;

    @Activate
    void activate(ComponentContext context) {
        try {
            this.commerceBackendResolver = this.resolverFactory.getServiceResourceResolver(backendServiceAuthInfo);
            this.damResolver = this.resolverFactory.getServiceResourceResolver(damServiceAuthInfo);
            this.contentAuthorResolver = this.resolverFactory.getServiceResourceResolver(contentAuthorServiceAuthInfo);
            Session s = this.commerceBackendResolver.adaptTo(Session.class);
            s.getWorkspace().getObservationManager().addEventListener((EventListener)this, 31, COMMERCE_COLLECTIONS_BASE_PATH, true, null, null, false);
            this.rehydrateWatchedCollections(s);
        }
        catch (LoginException e) {
            LOG.error("Exception while observing enablement resource replication.", e);
        }
        catch (UnsupportedRepositoryOperationException e) {
            LOG.error("Exception while observing enablement resource replication.", e);
        }
        catch (RepositoryException e) {
            LOG.error("Exception while observing enablement resource replication.", e);
        }
    }

    @Deactivate
    void deactivate() {
        if (this.commerceBackendResolver == null) {
            return;
        }
        Session s = this.commerceBackendResolver.adaptTo(Session.class);
        try {
            s.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
            Node livefyreCollections = JcrUtils.getOrCreateByPath("/etc/livefyre/commerce/collections/watchedCollections", "nt:unstructured", s);
            String[] list = this.watchedCollections.toArray(new String[this.watchedCollections.size()]);
            livefyreCollections.setProperty("collections", list);
        }
        catch (UnsupportedRepositoryOperationException e) {
            throw new IllegalStateException("Exception while removing observation of enablement resource replication.", e);
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Exception while removing observation of enablement resource replication.", e);
        }
    }

    public void onEvent(EventIterator events) {
        this.network = this.getLivefyreNetwork();
        if (this.network == null) {
            return;
        }
        this.networkName = this.network.getNetworkName();
        this.api = new LivefyreProductAPI(this.network, this.commerceBackendResolver, this.damResolver);
        String url = "https://" + this.network.getNetworkName() + ".quill.fyre.co/api/v4/urn:livefyre:" + this.network.getNetworkName() + ".fyre.co:products/";
        String token = this.network.buildLivefyreToken();
        while (events.hasNext()) {
            Event event = events.nextEvent();
            String path = null;
            String identifier = null;
            try {
                path = event.getPath();
                identifier = event.getIdentifier();
            }
            catch (RepositoryException e) {
                LOG.error("Cannot get event information", e);
                continue;
            }
            if (path == null || identifier == null) continue;
            if (1 == event.getType()) {
                if (!this.isProductPath(path)) continue;
                for (String trackedCollectionsPath : this.watchedCollections) {
                    if (!path.contains(trackedCollectionsPath)) continue;
                    this.syncProduct(identifier);
                }
                continue;
            }
            if (2 == event.getType()) {
                JSONObject data;
                JSONObject response;
                if (!this.isProductPath(identifier) && (response = this.livefyreHttpService.sendPOSTRequestGetJSON(this.httpClientBuilderFactory, url, token, data = this.api.deleteFolder(identifier))) != null) {
                    this.watchedCollections.remove(identifier);
                }
                for (String trackedCollectionsPath : this.watchedCollections) {
                    if (!path.contains(trackedCollectionsPath)) continue;
                    this.removeProduct(identifier, new String[]{trackedCollectionsPath});
                }
                continue;
            }
            if (4 == event.getType()) {
                if (path.contains("livefyre-checkbox")) {
                    this.watchedCollections.add(identifier);
                    this.addAllProducts(identifier);
                }
            } else if (8 == event.getType()) {
                if (path.contains("livefyre-checkbox")) {
                    this.watchedCollections.remove(identifier);
                    this.api.deleteFolder(identifier);
                }
            } else if (16 == event.getType() && path.contains("jcr:title")) {
                this.syncFolder(identifier);
            }
            this.updateWatchedCollections();
        }
    }

    private void syncFolder(String identifier) {
        Node collectionNode = this.commerceBackendResolver.getResource(identifier).adaptTo(Node.class);
        LivefyreProductFolder collectionFolder = new LivefyreProductFolder(collectionNode, this.networkName, null);
        this.api.addFolder(collectionFolder);
    }

    private String getPagePrefix(String path) {
        Node collectionNode = this.commerceBackendResolver.getResource(path).adaptTo(Node.class);
        String pagePrefix = "";
        try {
            pagePrefix = collectionNode.getProperty("livefyre-page-prefix").getString();
        }
        catch (RepositoryException e) {
            LOG.error("Cannot get livefyre page prefix from collection node", e);
        }
        return pagePrefix;
    }

    private void removeProduct(String identifier, String[] roots) {
        String url = "https://" + this.network.getNetworkName() + ".quill.fyre.co/api/v4/urn:livefyre:" + this.network.getNetworkName() + ".fyre.co:products/";
        String token = this.network.buildLivefyreToken();
        JSONObject data = this.api.deleteProduct(this.getProductId(identifier), roots);
        JSONObject response = this.livefyreHttpService.sendPOSTRequestGetJSON(this.httpClientBuilderFactory, url, token, data);
    }

    private void syncProduct(String identifier) {
        Node collectionProductNode = this.commerceBackendResolver.getResource(identifier).adaptTo(Node.class);
        try {
            Node collectionNode = collectionProductNode.getParent().getParent();
            LivefyreProductFolder collectionFolder = new LivefyreProductFolder(collectionNode, this.networkName, null);
            String realProductPath = collectionProductNode.getProperty("sling:resource").getString();
            Resource productResource = this.contentAuthorResolver.getResource(realProductPath);
            String collectionSearchPrefix = this.getPagePrefix(collectionNode.getPath());
            if ("commerce/components/product".equals(productResource.getResourceType())) {
                Node productNode = productResource.adaptTo(Node.class);
                Node parentNode = productNode.getParent();
                LivefyreProductFolder parent = new LivefyreProductFolder(parentNode, this.networkName, collectionFolder);
                LivefyreProduct commerceLivefyreProduct = new LivefyreProduct(this.getProductId(identifier), this.queryProductPages(productResource, collectionSearchPrefix), productResource, parent, null, collectionFolder);
                JSONObject data = this.api.addProduct(commerceLivefyreProduct);
                String url = "https://" + this.network.getNetworkName() + ".quill.fyre.co/api/v4/urn:livefyre:" + this.network.getNetworkName() + ".fyre.co:products/";
                String token = this.network.buildLivefyreToken();
                JSONObject jSONObject = this.livefyreHttpService.sendPOSTRequestGetJSON(this.httpClientBuilderFactory, url, token, data);
            }
        }
        catch (PathNotFoundException e) {
            LOG.error("Cannot add Livefyre product/folder", e);
        }
        catch (RepositoryException e) {
            LOG.error("Cannot add Livefyre product/folder", e);
        }
    }

    private boolean isProductPath(String path) {
        return path.contains("sling:members") && !path.endsWith("sling:members");
    }

    private void updateWatchedCollections() {
        Session s = this.commerceBackendResolver.adaptTo(Session.class);
        String[] list = this.watchedCollections.toArray(new String[this.watchedCollections.size()]);
        try {
            Node livefyreCollections = JcrUtils.getOrCreateByPath("/etc/livefyre/commerce/collections/watchedCollections", "nt:unstructured", s);
            livefyreCollections.setProperty("collections", list);
            s.save();
        }
        catch (RepositoryException e) {
            LOG.error("Cannot add local list to node", e);
        }
    }

    private void addAllProducts(String collectionPath) {
        Session s = this.commerceBackendResolver.adaptTo(Session.class);
        try {
            Node collectionNode = s.getNode(collectionPath);
            this.api.addFolder(new LivefyreProductFolder(collectionNode, this.networkName, null));
            Node slingMembersNode = collectionNode.getNode("sling:members");
            NodeIterator nodeIterator = slingMembersNode.getNodes();
            while (nodeIterator.hasNext()) {
                Node child = (Node)nodeIterator.next();
                this.syncProduct(child.getPath());
            }
        }
        catch (RepositoryException e) {
            LOG.error("Cannot add products from collection " + collectionPath, e);
        }
    }

    private String getProductId(String path) {
        String[] chunks = path.split("/");
        String commerceProductId = chunks[chunks.length - 1];
        return commerceProductId;
    }

    private Network getLivefyreNetwork() {
        List<LivefyreConfig> configs = this.livefyreConfigProvider.getAllConfigs();
        Network livefyreNetwork = null;
        if (configs.isEmpty()) {
            return livefyreNetwork;
        }
        LivefyreConfig lfConfig = configs.get(0);
        try {
            livefyreNetwork = Livefyre.getNetwork((String)lfConfig.getNetworkName(), (String)lfConfig.getNetworkKey());
        }
        catch (CryptoException e) {
            LOG.error("Cannot get Livefyre config. Configure cloud service.");
        }
        return livefyreNetwork;
    }

    private void rehydrateWatchedCollections(Session s) {
        this.watchedCollections = new HashSet<String>();
        Node livefyreCollections = null;
        try {
            Value[] collectionsList;
            livefyreCollections = JcrUtils.getOrCreateByPath("/etc/livefyre/commerce/collections/watchedCollections", "nt:unstructured", s);
            for (Value value : collectionsList = livefyreCollections.getProperty("collections").getValues()) {
                this.watchedCollections.add(value.getString());
            }
            s.save();
        }
        catch (PathNotFoundException e) {
            try {
                livefyreCollections.setProperty("collections", new String[0]);
                s.save();
            }
            catch (RepositoryException e1) {
                LOG.error("Logception...", e1);
            }
        }
        catch (RepositoryException e) {
            LOG.error("Cannot get watched collections node", e);
        }
    }

    private LivefyreProductPage queryProductPages(Resource productResource, String path) {
        LivefyreProductPage page = new LivefyreProductPage("", Locale.US);
        ResourceResolver serviceResolver = null;
        try {
            serviceResolver = this.getServiceResolver("livefyre-commerce-fe-service");
        }
        catch (LoginException e) {
            LOG.error("Cannot get resource to sync", e);
            return page;
        }
        Session session = serviceResolver.adaptTo(Session.class);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("path", path);
        map.put("type", "cq:PageContent");
        map.put("property", "cq:productMaster");
        map.put("property.value", productResource.getPath());
        Query query = this.builder.createQuery(PredicateGroup.create(map), session);
        query.setStart(0L);
        query.setHitsPerPage(20L);
        SearchResult result = query.getResult();
        for (Hit hit : result.getHits()) {
            String validPagePath;
            String pageContentPath = null;
            try {
                pageContentPath = hit.getPath();
            }
            catch (RepositoryException e) {
                LOG.error("Cannot get search result hit path", e);
                continue;
            }
            Resource pageContentResource = serviceResolver.getResource(pageContentPath);
            if (pageContentResource == null) continue;
            Page productPage = this.getProductPage(pageContentResource);
            String string = validPagePath = productPage != null ? productPage.getPath() + ".html" : null;
            if (validPagePath == null) continue;
            Externalizer externalizer = serviceResolver.adaptTo(Externalizer.class);
            String pageURL = externalizer.authorLink(serviceResolver, validPagePath);
            page.setUrl(pageURL);
            page.setLocale(productPage.getLanguage(false));
            break;
        }
        return page;
    }

    private Page getProductPage(Resource productResource) {
        PageManager pm = productResource.getResourceResolver().adaptTo(PageManager.class);
        Page page = pm.getContainingPage(productResource.getPath());
        return page;
    }

    private ResourceResolver getServiceResolver(String serviceName) throws LoginException {
        HashMap<String, Object> authenticationInfo = new HashMap<String, Object>();
        authenticationInfo.put("sling.service.subservice", serviceName);
        return this.resolverFactory.getServiceResourceResolver(authenticationInfo);
    }

    static {
        backendServiceAuthInfo.put("sling.service.subservice", SUB_SERVICE_COMMERCE_BACKEND);
        contentAuthorServiceAuthInfo = new HashMap<String, Object>();
        contentAuthorServiceAuthInfo.put("sling.service.subservice", LIVEFYRE_CONTENT_AUTHOR);
        damServiceAuthInfo = new HashMap<String, Object>();
        damServiceAuthInfo.put("sling.service.subservice", LIVEFYRE_ASSET_WRITER);
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    protected void bindLivefyreConfigProvider(LivefyreConfigProvider livefyreConfigProvider) {
        this.livefyreConfigProvider = livefyreConfigProvider;
    }

    protected void unbindLivefyreConfigProvider(LivefyreConfigProvider livefyreConfigProvider) {
        if (this.livefyreConfigProvider == livefyreConfigProvider) {
            this.livefyreConfigProvider = null;
        }
    }

    protected void bindBuilder(QueryBuilder queryBuilder) {
        this.builder = queryBuilder;
    }

    protected void unbindBuilder(QueryBuilder queryBuilder) {
        if (this.builder == queryBuilder) {
            this.builder = null;
        }
    }

    protected void bindLivefyreHttpService(LivefyreHttpService livefyreHttpService) {
        this.livefyreHttpService = livefyreHttpService;
    }

    protected void unbindLivefyreHttpService(LivefyreHttpService livefyreHttpService) {
        if (this.livefyreHttpService == livefyreHttpService) {
            this.livefyreHttpService = null;
        }
    }

    protected void bindHttpClientBuilderFactory(HttpClientBuilderFactory httpClientBuilderFactory) {
        this.httpClientBuilderFactory = httpClientBuilderFactory;
    }

    protected void unbindHttpClientBuilderFactory(HttpClientBuilderFactory httpClientBuilderFactory) {
        if (this.httpClientBuilderFactory == httpClientBuilderFactory) {
            this.httpClientBuilderFactory = null;
        }
    }
}

