/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.social.integrations.livefyre.commerce;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.Product;
import com.adobe.cq.commerce.common.AbstractJcrProduct;
import com.adobe.social.integrations.livefyre.commerce.LivefyreProductFolder;
import com.adobe.social.integrations.livefyre.commerce.LivefyreProductPage;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.sling.api.resource.Resource;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LivefyreProduct
extends AbstractJcrProduct {
    private static final Logger LOG = LoggerFactory.getLogger(LivefyreProduct.class);
    LivefyreProduct parentProduct;
    LivefyreProductFolder parentFolder;
    LivefyreProductFolder root;
    List<LivefyreProduct> variants;
    List<String> variantAxis;
    String id;
    LivefyreProductPage page;
    Resource resource;

    public LivefyreProduct(String id, LivefyreProductPage page, Resource resource, LivefyreProductFolder parentFolder, LivefyreProduct parentProduct, LivefyreProductFolder root) {
        super(resource);
        this.resource = resource;
        this.parentProduct = parentProduct;
        this.parentFolder = parentFolder;
        this.id = id;
        this.page = page;
        this.root = root;
        this.variants = this.convertVariants();
        this.variantAxis = new ArrayList<String>();
        Iterator<String> varientAxisIter = this.getVariantAxes();
        while (varientAxisIter.hasNext()) {
            this.variantAxis.add(varientAxisIter.next());
        }
    }

    @Override
    public String getSKU() {
        try {
            return super.getBaseProduct().getSKU();
        }
        catch (CommerceException e) {
            LOG.error("Cannot get base product SKU", e);
            return null;
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public JSONObject getLivefyreProductAsJSON(String networkName) {
        JSONObject productJSON = new JSONObject();
        try {
            List<String> tags;
            productJSON.put("id", this.id);
            productJSON.put("title", this.getTitle());
            productJSON.put("description", this.getDescription());
            productJSON.put("sku", this.getSKU());
            productJSON.put("summary", this.getProperty("summary", String.class));
            productJSON.put("features", this.getProperty("features", String.class));
            if (this.page != null) {
                productJSON.put("url", this.page.getUrl());
            }
            productJSON.put("enabled", true);
            if (this.parentFolder != null && this.root != null) {
                productJSON.put("parentId", "urn:livefyre:" + networkName + ".fyre.co:productRoot=" + this.root.getId() + ":product=" + this.parentFolder.getId());
            }
            if (this.parentProduct != null && this.root != null) {
                productJSON.put("parentId", "urn:livefyre:" + networkName + ".fyre.co:productRoot=" + this.root.getId() + ":product=" + this.parentProduct.getId());
            }
            String lastModified = this.getProperty("jcr:lastModified", String.class);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
            try {
                long lastModifiedEpoch = df.parse(lastModified).getTime() / 1000L;
                productJSON.put("modifiedAt", lastModifiedEpoch);
            }
            catch (ParseException e) {
                LOG.error("Cannot get product dates");
            }
            if (!this.variants.isEmpty()) {
                productJSON.put("hasChildren", true);
            }
            if (this.root != null) {
                productJSON.put("rootId", "urn:livefyre:" + networkName + ".fyre.co:productRoot=" + this.root.getId());
            }
            if (!(tags = this.getTags()).isEmpty()) {
                productJSON.put("tags", tags);
            }
            JSONArray attributes = new JSONArray();
            for (int i = 0; i < this.variantAxis.size(); ++i) {
                String variantName = this.variantAxis.get(i);
                String variantValue = this.getProperty(variantName, String.class);
                if (variantValue == null || variantValue == "") continue;
                attributes.put(new JSONObject().put("type", variantName));
                attributes.put(new JSONObject().put("value", variantValue));
            }
            if (attributes.length() > 0) {
                productJSON.put("attributes", attributes);
            }
        }
        catch (JSONException e) {
            LOG.error("Cannot create product JSON.", e);
        }
        return productJSON;
    }

    public List<String> getTags() {
        Node productNode = this.resource.adaptTo(Node.class);
        ArrayList<String> tags = new ArrayList<String>();
        try {
            Value[] tagsValueList;
            for (Value value : tagsValueList = productNode.getProperty("cq:tags").getValues()) {
                tags.add(value.getString());
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return tags;
    }

    public LivefyreProductFolder getParentFolder() {
        return this.parentFolder;
    }

    public List<LivefyreProduct> convertVariants() {
        ArrayList<LivefyreProduct> livefyreVariants = new ArrayList<LivefyreProduct>();
        try {
            if (this.getPath() != this.getBaseProduct().getPath()) {
                return livefyreVariants;
            }
        }
        catch (CommerceException e) {
            LOG.error("Cannot get base product", e);
            return livefyreVariants;
        }
        Iterator<Product> commerceVariants = null;
        try {
            commerceVariants = this.getVariants();
        }
        catch (CommerceException e) {
            LOG.error("Cannot get variants from Commerce Product", e);
            return livefyreVariants;
        }
        while (commerceVariants.hasNext()) {
            Product variant = commerceVariants.next();
            if (variant.getPath() == this.getPath()) continue;
            Resource variantResource = variant.adaptTo(Resource.class);
            LivefyreProduct livefyreVariant = new LivefyreProduct(variant.getSKU(), this.page, variantResource, null, this, this.root);
            livefyreVariants.add(livefyreVariant);
        }
        return livefyreVariants;
    }

    public String getIdAsURN(String networkName, String rootId) {
        return "urn:livefyre:" + networkName + ".fyre.co:productRoot=" + rootId + ":product=" + this.getId();
    }
}

