/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.social.integrations.livefyre.commerce;

import com.adobe.social.integrations.livefyre.commerce.LivefyreProduct;
import com.adobe.social.integrations.livefyre.commerce.LivefyreProductFolder;
import com.adobe.social.integrations.livefyre.http.LivefyreHttpService;
import com.day.cq.commons.Externalizer;
import com.day.cq.dam.api.Asset;
import com.day.cq.wcm.resource.details.AssetDetails;
import com.livefyre.core.Network;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LivefyreProductAPI {
    Network network;
    private static final Logger LOG = LoggerFactory.getLogger(LivefyreProductAPI.class);
    ResourceResolver commerceResolver;
    ResourceResolver damResolver;
    @Reference
    LivefyreHttpService livefyreHttpService;
    private MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager(){
        {
            this.getParams().setConnectionTimeout(60000);
            this.getParams().setSoTimeout(60000);
        }
    };

    LivefyreProductAPI(Network network, ResourceResolver commerceResolver, ResourceResolver damResolver) {
        this.network = network;
        this.commerceResolver = commerceResolver;
        this.damResolver = damResolver;
    }

    public JSONObject addProduct(LivefyreProduct product) {
        JSONArray products = new JSONArray();
        String networkName = this.network.getNetworkName();
        JSONObject livefyreProductJSON = product.getLivefyreProductAsJSON(networkName);
        products.put(livefyreProductJSON);
        for (LivefyreProductFolder parent = product.getParentFolder(); parent != null; parent = parent.getParent()) {
            products.put(parent.getLivefyreProductFolderAsJSON(networkName));
        }
        for (int i = 0; i < product.variants.size(); ++i) {
            LivefyreProduct variant = product.variants.get(i);
            JSONObject variantJSON = variant.getLivefyreProductAsJSON(networkName);
            try {
                variantJSON.put("oembed", this.getImage(variant));
            }
            catch (JSONException e) {
                LOG.error("Cannot get image data for product add");
            }
            products.put(variantJSON);
        }
        try {
            livefyreProductJSON.put("oembed", this.getImage(product));
        }
        catch (JSONException e) {
            LOG.error("Cannot get image data for product add");
        }
        JSONObject data = new JSONObject();
        try {
            data.put("products", products);
        }
        catch (JSONException e) {
            LOG.error("Cannot create product data for Livefyre");
            return null;
        }
        return data;
    }

    public JSONObject addFolder(LivefyreProductFolder folder) {
        JSONArray products = new JSONArray();
        String networkName = this.network.getNetworkName();
        JSONObject livefyreProductFolderJSON = folder.getLivefyreProductFolderAsJSON(networkName);
        products.put(livefyreProductFolderJSON);
        JSONObject data = new JSONObject();
        try {
            data.put("products", products);
        }
        catch (JSONException e) {
            LOG.error("Cannot create product data for Livefyre");
            return null;
        }
        return data;
    }

    public JSONObject updateProduct(LivefyreProduct product, Value[] rootIds) {
        JSONArray products = new JSONArray();
        String networkName = this.network.getNetworkName();
        JSONObject livefyreProductJSON = product.getLivefyreProductAsJSON(networkName);
        JSONObject data = new JSONObject();
        for (int i = 0; i < rootIds.length; ++i) {
            String rootId = null;
            try {
                rootId = rootIds[i].getString();
            }
            catch (RepositoryException e) {
                continue;
            }
            try {
                livefyreProductJSON.put("id", product.getIdAsURN(this.network.getNetworkName(), rootId));
            }
            catch (JSONException e) {
                LOG.error("Cannot get id data for product add");
                continue;
            }
            try {
                livefyreProductJSON.put("oembed", this.getImage(product));
            }
            catch (JSONException e) {
                LOG.error("Cannot get image data for product add");
            }
            products.put(livefyreProductJSON);
            for (int j = 0; j < product.variants.size(); ++j) {
                LivefyreProduct variant = product.variants.get(j);
                JSONObject variantJSON = variant.getLivefyreProductAsJSON(networkName);
                try {
                    variantJSON.put("id", variant.getIdAsURN(this.network.getNetworkName(), rootId));
                    variantJSON.put("oembed", this.getImage(variant));
                }
                catch (JSONException e) {
                    LOG.error("Cannot build variant information", e);
                    continue;
                }
                products.put(variantJSON);
            }
        }
        try {
            data.put("products", products);
        }
        catch (JSONException e) {
            LOG.error("Cannot put products into post data array");
        }
        return data;
    }

    public JSONObject deleteProduct(String productId, String[] rootIds) {
        JSONObject data = new JSONObject();
        ArrayList<String> products = new ArrayList<String>();
        try {
            for (int i = 0; i < rootIds.length; ++i) {
                String productURN = "urn:livefyre:" + this.network.getNetworkName() + ".fyre.co:productRoot=" + rootIds[i] + ":product=" + productId;
                products.add(productURN);
                data.put("delete", products);
            }
        }
        catch (JSONException e) {
            LOG.error("Cannot build JSON to delete product");
            return data;
        }
        return data;
    }

    public JSONObject deleteFolder(String id) {
        JSONObject data = new JSONObject();
        JSONArray ids = new JSONArray();
        try {
            String folderURN = "urn:livefyre:" + this.network.getNetworkName() + ".fyre.co:productRoot=" + id;
            ids.put(folderURN);
            data.put("delete", ids);
        }
        catch (JSONException e) {
            LOG.error("Cannot get folder ids", e);
        }
        return data;
    }

    private JSONObject getImage(LivefyreProduct product) {
        JSONObject oEmbed = new JSONObject();
        List<Resource> assets = product.getAssets();
        for (int i = 0; i < assets.size(); ++i) {
            Resource assetResource = assets.get(i);
            if (!"commerce/components/product/image".equals(assetResource.getResourceType())) continue;
            Resource imageResource = assetResource;
            String fileReference = (String)((Object)imageResource.getValueMap().get("fileReference", String.class));
            Resource imageAssetResource = this.damResolver.getResource(fileReference);
            if (fileReference == "" || imageAssetResource == null) continue;
            AssetDetails assetDetails = new AssetDetails(imageAssetResource);
            Asset imageAsset = imageAssetResource.adaptTo(Asset.class);
            Externalizer externalizer = this.damResolver.adaptTo(Externalizer.class);
            if (assetDetails == null || imageAsset == null || externalizer == null) continue;
            try {
                oEmbed.put("link", externalizer.authorLink(this.damResolver, imageAsset.getPath()));
                oEmbed.put("type", 1);
                oEmbed.put("title", imageAsset.getName());
                oEmbed.put("url", externalizer.authorLink(this.damResolver, imageAsset.getPath()));
                oEmbed.put("provider_name", "aem");
                if (assetDetails == null) break;
                oEmbed.put("width", assetDetails.getWidth());
                oEmbed.put("height", assetDetails.getHeight());
                oEmbed.put("description", assetDetails.getDescription());
            }
            catch (JSONException e) {
                LOG.error("Cannot generate image oEmbed", e);
            }
            catch (RepositoryException e) {
                LOG.error("Cannot generate image oEmbed", e);
            }
            break;
        }
        return oEmbed;
    }
}

