/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.social.integrations.livefyre.commerce;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LivefyreProductFolder {
    private static final Logger LOG = LoggerFactory.getLogger(LivefyreProductFolder.class);
    String title;
    String path;
    String id;
    LivefyreProductFolder parent;
    LivefyreProductFolder root;

    public LivefyreProductFolder(Node node, String network, LivefyreProductFolder root) {
        try {
            this.title = this.getTitle(node);
            this.path = node.getPath();
            this.id = node.getPath();
            this.root = root;
            Node parentNode = node.getParent();
            this.parent = null;
            if (parentNode != null && !"/var/commerce/products".equals(parentNode.getPath()) && !"/var/commerce/collections".equals(parentNode.getPath())) {
                this.parent = new LivefyreProductFolder(parentNode, network, root);
            }
        }
        catch (RepositoryException e) {
            LOG.error("Cannot get product's parent node: ", e);
        }
    }

    public JSONObject getLivefyreProductFolderAsJSON(String networkName) {
        JSONObject folder = new JSONObject();
        try {
            folder.put("isFolder", true);
            folder.put("title", this.title);
            folder.put("id", this.id);
            if (this.parent == null) {
                if (this.root != null) {
                    this.parent = this.root;
                    folder.put("parentId", "urn:livefyre:" + networkName + ".fyre.co:productRoot=" + this.parent.getId());
                }
            } else {
                folder.put("parentId", "urn:livefyre:" + networkName + ".fyre.co:productRoot=" + this.root.getId() + ":product=" + this.parent.getId());
            }
            if (this.root != null) {
                folder.put("rootId", "urn:livefyre:" + networkName + ".fyre.co:productRoot=" + this.root.getId());
            }
        }
        catch (JSONException e) {
            LOG.error("Cannot create Livefyre folder", e);
        }
        return folder;
    }

    public String getId() {
        return this.id;
    }

    public LivefyreProductFolder getParent() {
        return this.parent;
    }

    public String getTitle(Node node) throws RepositoryException {
        try {
            return node.getProperty("jcr:title").getString();
        }
        catch (RepositoryException repositoryException) {
            try {
                return node.getName();
            }
            catch (RepositoryException repositoryException2) {
                try {
                    String[] temp = node.getPath().split("/");
                    String name = temp[temp.length - 1];
                    node.setProperty("jcr:title", name);
                    node.getSession().save();
                }
                catch (RepositoryException e) {
                    throw new RepositoryException("Cannot get a name for node", (Throwable)e);
                }
                return "";
            }
        }
    }
}

