/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.social.integrations.livefyre.commerce;

import com.adobe.granite.crypto.CryptoException;
import com.adobe.social.integrations.livefyre.commerce.LivefyreProduct;
import com.adobe.social.integrations.livefyre.commerce.LivefyreProductAPI;
import com.adobe.social.integrations.livefyre.config.api.LivefyreConfig;
import com.adobe.social.integrations.livefyre.config.api.LivefyreConfigProvider;
import com.adobe.social.integrations.livefyre.http.LivefyreHttpService;
import com.day.cq.search.QueryBuilder;
import com.livefyre.Livefyre;
import com.livefyre.core.Network;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.http.osgi.services.HttpClientBuilderFactory;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.json.JSONObject;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class LivefyreProductsWatcher
implements EventListener {
    @Reference
    private ResourceResolverFactory resolverFactory;
    private ResourceResolver commerceBackendResolver;
    private ResourceResolver damResolver;
    private static final Logger LOG = LoggerFactory.getLogger(LivefyreProductsWatcher.class);
    private static final String SUB_SERVICE_COMMERCE = "livefyre-commerce-be-service";
    private static final String COMMERCE_PRODUCTS_PATH = "/etc/commerce/products";
    private static final String LIVEFYRE_ASSET_WRITER = "livefyre-asset-writer";
    private static final String LIVEFYRE_CONTENT_AUTHOR = "livefyre-communities-user-admin";
    private static final String LIVEFYRE_COLLECTIONS_BASE_PATH = "/etc/livefyre/commerce/collections";
    @Reference
    private LivefyreConfigProvider livefyreConfigProvider;
    @Reference
    private QueryBuilder builder;
    @Reference
    private LivefyreHttpService livefyreHttpService;
    @Reference
    private HttpClientBuilderFactory httpClientBuilderFactory;
    private static Map<String, Object> backendServiceAuthInfo = new HashMap<String, Object>();
    private static Map<String, Object> contentAuthorServiceAuthInfo;
    private static Map<String, Object> damServiceAuthInfo;
    String networkName;
    LivefyreProductAPI api;

    @Activate
    void activate(ComponentContext context) {
        try {
            this.commerceBackendResolver = this.resolverFactory.getServiceResourceResolver(backendServiceAuthInfo);
            this.damResolver = this.resolverFactory.getServiceResourceResolver(damServiceAuthInfo);
            this.resolverFactory.getServiceResourceResolver(contentAuthorServiceAuthInfo);
            Session s = this.commerceBackendResolver.adaptTo(Session.class);
            s.getWorkspace().getObservationManager().addEventListener((EventListener)this, 18, COMMERCE_PRODUCTS_PATH, true, null, null, false);
        }
        catch (LoginException e) {
            LOG.error("Exception while observing enablement resource replication.", e);
            return;
        }
        catch (UnsupportedRepositoryOperationException e) {
            LOG.error("Exception while observing enablement resource replication.", e);
            return;
        }
        catch (RepositoryException e) {
            LOG.error("Exception while observing enablement resource replication.", e);
            return;
        }
    }

    @Deactivate
    void deactivate() {
        if (this.commerceBackendResolver != null) {
            Session s = this.commerceBackendResolver.adaptTo(Session.class);
            try {
                s.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
            }
            catch (UnsupportedRepositoryOperationException e) {
                throw new IllegalStateException("Exception while removing observation of enablement resource replication.", e);
            }
            catch (RepositoryException e) {
                throw new IllegalStateException("Exception while removing observation of enablement resource replication.", e);
            }
        }
    }

    public void onEvent(EventIterator events) {
        Network network = this.getLivefyreNetwork();
        if (network == null) {
            return;
        }
        this.networkName = network.getNetworkName();
        String url = "https://" + this.networkName + ".quill.fyre.co/api/v4/urn:livefyre:" + this.networkName + ".fyre.co:products/";
        this.api = new LivefyreProductAPI(network, this.commerceBackendResolver, this.damResolver);
        while (events.hasNext()) {
            try {
                Event event = events.nextEvent();
                String path = event.getPath();
                String identifier = event.getIdentifier();
                if (path == null || identifier == null) {
                    return;
                }
                if (event.getType() == 16) {
                    Resource productResource = this.commerceBackendResolver.getResource(identifier);
                    if (path.contains("jcr:lastModified") || productResource == null) {
                        return;
                    }
                    this.handleProductUpdate(productResource);
                }
                if (event.getType() != 2) continue;
                this.handleProductDelete(identifier);
            }
            catch (RepositoryException e) {
                LOG.error("RepositoryException: " + (Object)((Object)e));
            }
        }
    }

    private void handleProductDelete(String identifier) {
        String url = "https://" + this.networkName + ".quill.fyre.co/api/v4/urn:livefyre:" + this.networkName + ".fyre.co:products/";
        try {
            Node livefyreCollections = this.commerceBackendResolver.getResource("/etc/livefyre/commerce/collections/watchedCollections").adaptTo(Node.class);
            Value[] rootList = livefyreCollections.getProperty("collections").getValues();
            String[] stringValues = new String[rootList.length];
            for (int i = 0; i < rootList.length; ++i) {
                stringValues[i] = rootList[i].getString();
            }
            JSONObject data = this.api.deleteProduct(this.getProductId(identifier), stringValues);
            this.livefyreHttpService.sendPOSTRequestGetJSON(this.httpClientBuilderFactory, url, this.getLivefyreNetwork().buildLivefyreToken(), data);
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    private void handleProductUpdate(Resource productResource) {
        String url = "https://" + this.networkName + ".quill.fyre.co/api/v4/urn:livefyre:" + this.networkName + ".fyre.co:products/";
        if ("commerce/components/product/image".equals(productResource.getResourceType())) {
            productResource = productResource.getParent();
        }
        if ("commerce/components/product".equals(productResource.getResourceType())) {
            LivefyreProduct commerceLivefyreProduct = new LivefyreProduct(this.getProductId(productResource.getPath()), null, productResource, null, null, null);
            try {
                Node livefyreCollections = this.commerceBackendResolver.getResource("/etc/livefyre/commerce/collections/watchedCollections").adaptTo(Node.class);
                Value[] rootList = livefyreCollections.getProperty("collections").getValues();
                JSONObject data = this.api.updateProduct(commerceLivefyreProduct, rootList);
                this.livefyreHttpService.sendPOSTRequestGetJSON(this.httpClientBuilderFactory, url, this.getLivefyreNetwork().buildLivefyreToken(), data);
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
    }

    private String getProductId(String path) {
        String[] chunks = path.split("/");
        String commerceProductId = chunks[chunks.length - 1];
        return commerceProductId;
    }

    private Network getLivefyreNetwork() {
        List<LivefyreConfig> configs = this.livefyreConfigProvider.getAllConfigs();
        Network livefyreNetwork = null;
        if (!configs.isEmpty()) {
            LivefyreConfig lfConfig = configs.get(0);
            try {
                livefyreNetwork = Livefyre.getNetwork((String)lfConfig.getNetworkName(), (String)lfConfig.getNetworkKey());
            }
            catch (CryptoException e) {
                LOG.error("Cannot get Livefyre config. Configure cloud service.");
            }
        }
        return livefyreNetwork;
    }

    static {
        backendServiceAuthInfo.put("sling.service.subservice", SUB_SERVICE_COMMERCE);
        contentAuthorServiceAuthInfo = new HashMap<String, Object>();
        contentAuthorServiceAuthInfo.put("sling.service.subservice", LIVEFYRE_CONTENT_AUTHOR);
        damServiceAuthInfo = new HashMap<String, Object>();
        damServiceAuthInfo.put("sling.service.subservice", LIVEFYRE_ASSET_WRITER);
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    protected void bindLivefyreConfigProvider(LivefyreConfigProvider livefyreConfigProvider) {
        this.livefyreConfigProvider = livefyreConfigProvider;
    }

    protected void unbindLivefyreConfigProvider(LivefyreConfigProvider livefyreConfigProvider) {
        if (this.livefyreConfigProvider == livefyreConfigProvider) {
            this.livefyreConfigProvider = null;
        }
    }

    protected void bindBuilder(QueryBuilder queryBuilder) {
        this.builder = queryBuilder;
    }

    protected void unbindBuilder(QueryBuilder queryBuilder) {
        if (this.builder == queryBuilder) {
            this.builder = null;
        }
    }

    protected void bindLivefyreHttpService(LivefyreHttpService livefyreHttpService) {
        this.livefyreHttpService = livefyreHttpService;
    }

    protected void unbindLivefyreHttpService(LivefyreHttpService livefyreHttpService) {
        if (this.livefyreHttpService == livefyreHttpService) {
            this.livefyreHttpService = null;
        }
    }

    protected void bindHttpClientBuilderFactory(HttpClientBuilderFactory httpClientBuilderFactory) {
        this.httpClientBuilderFactory = httpClientBuilderFactory;
    }

    protected void unbindHttpClientBuilderFactory(HttpClientBuilderFactory httpClientBuilderFactory) {
        if (this.httpClientBuilderFactory == httpClientBuilderFactory) {
            this.httpClientBuilderFactory = null;
        }
    }
}

