/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.stock.apis;

import com.adobe.stock.config.StockConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

final class ApiUtils {
    private static final String X_API_KEY = "x-api-key";
    private static final String X_PRODUCT = "x-product";
    private static final String X_PRODUCT_LOCATION = "x-product-location";
    private static final String X_REQUEST_ID = "x-request-id";
    private static final String AUTHORIZATION = "Authorization";
    private static final String BEARER = "Bearer ";

    private ApiUtils() {
    }

    static Map<String, String> generateCommonAPIHeaders(StockConfig config, String accessToken) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (config.getApiKey() != null) {
            headers.put(X_API_KEY, config.getApiKey());
        }
        if (config.getProduct() != null) {
            headers.put(X_PRODUCT, config.getProduct());
        }
        if (config.getProductLocation() != null) {
            headers.put(X_PRODUCT_LOCATION, config.getProductLocation());
        }
        if (accessToken != null) {
            headers.put(AUTHORIZATION, BEARER + accessToken);
        }
        String requestID = UUID.randomUUID().toString();
        headers.put(X_REQUEST_ID, requestID);
        return headers;
    }
}

