/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.stock.apis;

import com.adobe.stock.apis.Dimension;
import com.adobe.stock.exception.StockException;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

final class DownSampleUtil {
    static final int LONGEST_SIDE_MAXIMUM = 23000;
    static final int LONGEST_SIDE_DOWNSAMPLE_TO = 1000;

    private DownSampleUtil() {
    }

    private static Dimension calculateResizeParameters(int originalWidth, int originalHeight) throws StockException {
        Dimension dimension = new Dimension();
        if (Math.max(originalWidth, originalHeight) > 23000) {
            throw new StockException("Image is too large for visual search!");
        }
        float aspectRatio = (float)originalWidth / (float)originalHeight;
        if (originalWidth > originalHeight) {
            if (originalWidth > 1000) {
                dimension.setWidth(1000);
                dimension.setHeight((int)(1000.0f / aspectRatio));
            }
        } else if (originalHeight > 1000) {
            dimension.setWidth((int)(1000.0f * aspectRatio));
            dimension.setHeight(1000);
        }
        if (dimension.getHeight() == 0) {
            dimension.setHeight(originalHeight);
        }
        if (dimension.getWidth() == 0) {
            dimension.setWidth(originalWidth);
        }
        return dimension;
    }

    static byte[] downSampleImageUtil(byte[] sourceImage) throws IOException, StockException {
        if (sourceImage == null) {
            throw new StockException("Image cannot be null");
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        ByteArrayInputStream stream = null;
        try {
            stream = new ByteArrayInputStream(sourceImage);
            BufferedImage src = ImageIO.read(stream);
            int width = src.getWidth();
            int height = src.getHeight();
            if (Math.max(width, height) < 1000) {
                byte[] byArray = sourceImage;
                return byArray;
            }
            Dimension dimension = DownSampleUtil.calculateResizeParameters(width, height);
            Image img = src.getScaledInstance(dimension.getWidth(), dimension.getHeight(), 4);
            width = img.getWidth(null);
            height = img.getHeight(null);
            BufferedImage buffered = DownSampleUtil.toBufferedImage(img);
            byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)buffered, "jpg", byteArrayOutputStream);
            byteArrayOutputStream.flush();
        }
        catch (IOException e) {
            throw new StockException("Could not downsample the given image");
        }
        finally {
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
            if (stream != null) {
                ((InputStream)stream).close();
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static BufferedImage toBufferedImage(Image img) {
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 1);
        Graphics2D g2 = bimage.createGraphics();
        boolean x = false;
        while (!x) {
            x = g2.drawImage(img, 0, 0, null);
        }
        g2.dispose();
        return bimage;
    }
}

