/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.stock.apis;

import com.adobe.stock.exception.StockException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;

final class JsonUtils {
    private static ObjectMapper sMapper;

    private JsonUtils() {
    }

    private static ObjectMapper getMapper() {
        if (sMapper == null) {
            sMapper = new ObjectMapper();
        }
        return sMapper;
    }

    static Object parseJson(Class<?> objClass, String jsonString) throws StockException {
        Object obj = null;
        try {
            obj = JsonUtils.getMapper().readValue(jsonString, objClass);
        }
        catch (JsonParseException e) {
            throw new StockException("Could not parse the given json string");
        }
        catch (IOException e) {
            throw new StockException("Could not map the given json string to response object");
        }
        return obj;
    }

    static String parseObjectToJson(Object obj) throws StockException {
        JsonUtils.getMapper().enable(SerializationFeature.INDENT_OUTPUT);
        String jsonString = "";
        try {
            jsonString = JsonUtils.getMapper().writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new StockException("Could not parse the given object to JSON");
        }
        return jsonString;
    }
}

