/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.stock.apis;

import com.adobe.stock.apis.ApiUtils;
import com.adobe.stock.apis.HttpUtils;
import com.adobe.stock.apis.JsonUtils;
import com.adobe.stock.apis.LicenseAPIHelpers;
import com.adobe.stock.config.StockConfig;
import com.adobe.stock.enums.AssetPurchaseState;
import com.adobe.stock.exception.StockException;
import com.adobe.stock.models.LicensePurchaseDetails;
import com.adobe.stock.models.LicenseRequest;
import com.adobe.stock.models.LicenseResponse;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;

public final class License {
    private StockConfig mConfig;
    private static final String ACCESS_TOKEN_PARAM = "token";

    public License(StockConfig config) throws StockException {
        if (config == null) {
            throw new StockException("Config can't be null");
        }
        this.mConfig = new StockConfig().setApiKey(config.getApiKey()).setProduct(config.getProduct()).setTargetEnvironment(config.getTargetEnvironment()).setProductLocation(config.getProductLocation());
    }

    public LicenseResponse getContentInfo(LicenseRequest request, String accessToken) throws StockException {
        LicenseAPIHelpers.validateLicenseQueryParams(request, accessToken, false);
        String requestURL = LicenseAPIHelpers.createLicenseApiUrl(this.mConfig.getEndpoints().getLicenseContentInfoEndpoint(), request);
        Map<String, String> headers = ApiUtils.generateCommonAPIHeaders(this.mConfig, accessToken);
        String responseString = HttpUtils.doGet(requestURL, headers);
        LicenseResponse reponse = (LicenseResponse)JsonUtils.parseJson(LicenseResponse.class, responseString);
        return reponse;
    }

    public LicenseResponse getContentLicense(LicenseRequest request, String accessToken) throws StockException {
        String responseString = "";
        LicenseAPIHelpers.validateLicenseQueryParams(request, accessToken, true);
        String requestURL = LicenseAPIHelpers.createLicenseApiUrl(this.mConfig.getEndpoints().getLicenseContentLicenseEndpoint(), request);
        Map<String, String> headers = ApiUtils.generateCommonAPIHeaders(this.mConfig, accessToken);
        if (LicenseAPIHelpers.getLicenseApiHttpMethod(request) == "GET") {
            responseString = HttpUtils.doGet(requestURL, headers);
        } else {
            String jsonString = JsonUtils.parseObjectToJson(request);
            responseString = HttpUtils.doPost(requestURL, headers, jsonString.getBytes(StandardCharsets.UTF_8), ContentType.APPLICATION_JSON);
        }
        LicenseResponse reponse = (LicenseResponse)JsonUtils.parseJson(LicenseResponse.class, responseString);
        return reponse;
    }

    public LicenseResponse getMemberProfile(LicenseRequest request, String accessToken) throws StockException {
        LicenseAPIHelpers.validateLicenseQueryParams(request, accessToken, false);
        String requestURL = LicenseAPIHelpers.createLicenseApiUrl(this.mConfig.getEndpoints().getLicenseMemberProfileEndpoint(), request);
        Map<String, String> headers = ApiUtils.generateCommonAPIHeaders(this.mConfig, accessToken);
        String responseString = HttpUtils.doGet(requestURL, headers);
        LicenseResponse reponse = (LicenseResponse)JsonUtils.parseJson(LicenseResponse.class, responseString);
        return reponse;
    }

    public void abandonLicense(LicenseRequest request, String accessToken) throws StockException {
        LicenseAPIHelpers.validateLicenseQueryParams(request, accessToken, true);
        String requestURL = LicenseAPIHelpers.createLicenseApiUrl(this.mConfig.getEndpoints().getLicenseMemberAbandonEndpoint(), request);
        Map<String, String> headers = ApiUtils.generateCommonAPIHeaders(this.mConfig, accessToken);
        String responseString = HttpUtils.doGet(requestURL, headers);
        if (!responseString.equals(String.valueOf(204))) {
            throw new StockException("Stock API returned with an error");
        }
    }

    public URI getDownloadUri(LicenseRequest request, String accessToken) throws StockException {
        LicenseAPIHelpers.validateLicenseQueryParams(request, accessToken, true);
        LicenseResponse contentInfo = this.getContentInfo(request, accessToken);
        if (contentInfo == null) {
            throw new StockException("Could not find the licensing information for the asset");
        }
        LicensePurchaseDetails purchaseDetails = contentInfo.getContent(request.getContentId().toString()).getPurchaseDetails();
        if (purchaseDetails == null || purchaseDetails.getPurchaseState() == null) {
            throw new StockException("Could not find the purchase details for the asset");
        }
        if (!purchaseDetails.getPurchaseState().equals((Object)AssetPurchaseState.PURCHASED)) {
            boolean canBuy;
            LicenseResponse memberProfile = this.getMemberProfile(request, accessToken);
            if (memberProfile.getEntitlement() == null) {
                throw new StockException("Could not find the available licenses for the user");
            }
            if (memberProfile.getPurchaseOptions() == null) {
                throw new StockException("Could not find the user purchasing options for the asset");
            }
            boolean bl = canBuy = memberProfile.getEntitlement().getQuota() != 0 || memberProfile.getPurchaseOptions().getPurchaseState().equals((Object)AssetPurchaseState.OVERAGE);
            if (canBuy) {
                throw new StockException("Content not licensed but have enough quota or overage plan, so first buy the license");
            }
            throw new StockException("Content not licensed and you do not have enough quota or overage plan");
        }
        LicenseResponse contentLicense = this.getContentLicense(request, accessToken);
        purchaseDetails = contentLicense.getContent(request.getContentId().toString()).getPurchaseDetails();
        if (purchaseDetails == null || purchaseDetails.getUrl() == null) {
            throw new StockException("Could not find the purchase details for the asset");
        }
        try {
            URIBuilder uriBuilder = new URIBuilder(purchaseDetails.getUrl());
            uriBuilder.addParameter(ACCESS_TOKEN_PARAM, accessToken);
            return uriBuilder.build();
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            throw new StockException("Asset URL returned from Stock API is not valid");
        }
    }

    public String downloadAsset(LicenseRequest request, String accessToken) throws StockException {
        URI assetUrl = this.getDownloadUri(request, accessToken);
        try {
            Map<String, String> headers = ApiUtils.generateCommonAPIHeaders(this.mConfig, accessToken);
            String url = assetUrl.toURL().toString();
            String s3url = HttpUtils.resolveDownloadUrl(url, headers);
            return s3url;
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new StockException("Asset URL returned from Stock API is not valid");
        }
    }
}

