/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.stock.apis;

import com.adobe.stock.apis.ApiUtils;
import com.adobe.stock.apis.HttpUtils;
import com.adobe.stock.apis.JsonUtils;
import com.adobe.stock.apis.SearchCategoryAPIHelpers;
import com.adobe.stock.config.StockConfig;
import com.adobe.stock.exception.StockException;
import com.adobe.stock.models.SearchCategoryRequest;
import com.adobe.stock.models.StockFileCategory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public final class SearchCategory {
    private StockConfig mConfig;

    public SearchCategory(StockConfig config) throws StockException {
        if (config == null) {
            throw new StockException("Config can't be null");
        }
        this.mConfig = new StockConfig().setApiKey(config.getApiKey()).setProduct(config.getProduct()).setTargetEnvironment(config.getTargetEnvironment()).setProductLocation(config.getProductLocation());
    }

    public StockFileCategory getCategory(SearchCategoryRequest request) throws StockException {
        if (request == null) {
            throw new StockException("Request can't be null");
        }
        SearchCategoryAPIHelpers.validateSearchCategoryQueryParams(request);
        String requestURL = SearchCategoryAPIHelpers.createSearchCategoryApiUrl(this.mConfig.getEndpoints().getSearchCategoryEndpoint(), request);
        Map<String, String> headers = ApiUtils.generateCommonAPIHeaders(this.mConfig, null);
        String responseString = HttpUtils.doGet(requestURL, headers);
        StockFileCategory category = (StockFileCategory)JsonUtils.parseJson(StockFileCategory.class, responseString);
        return category;
    }

    public ArrayList<StockFileCategory> getCategoryTree(SearchCategoryRequest request) throws StockException {
        if (request == null) {
            throw new StockException("Request can't be null");
        }
        String requestURL = SearchCategoryAPIHelpers.createSearchCategoryApiUrl(this.mConfig.getEndpoints().getSearchCategoryTreeEndpoint(), request);
        Map<String, String> headers = ApiUtils.generateCommonAPIHeaders(this.mConfig, null);
        String responseString = HttpUtils.doGet(requestURL, headers);
        StockFileCategory[] searchResponse = (StockFileCategory[])JsonUtils.parseJson(StockFileCategory[].class, responseString);
        ArrayList<StockFileCategory> categoryList = new ArrayList<StockFileCategory>(Arrays.asList(searchResponse));
        return categoryList;
    }
}

