/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.stock.apis;

import com.adobe.stock.annotations.SearchParamURLMapperInternal;
import com.adobe.stock.exception.StockException;
import com.adobe.stock.models.SearchCategoryRequest;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.client.utils.URIBuilder;

final class SearchCategoryAPIHelpers {
    private SearchCategoryAPIHelpers() {
    }

    static void validateSearchCategoryQueryParams(SearchCategoryRequest request) throws StockException {
        if (request.getCategoryId() == null) {
            throw new StockException("Category id must be present in the search request");
        }
    }

    static String createSearchCategoryApiUrl(String endPoint, SearchCategoryRequest request) throws StockException {
        try {
            new URI(endPoint).toURL();
            URIBuilder uriBuilder = new URIBuilder(endPoint);
            for (Field field : request.getClass().getDeclaredFields()) {
                SearchParamURLMapperInternal paramAnnotation;
                field.setAccessible(true);
                if (field.get(request) == null || (paramAnnotation = field.getAnnotation(SearchParamURLMapperInternal.class)) == null) continue;
                uriBuilder.setParameter(paramAnnotation.value(), field.get(request).toString());
            }
            String url = uriBuilder.toString();
            return url;
        }
        catch (IllegalAccessException | IllegalArgumentException | NullPointerException | MalformedURLException | URISyntaxException e) {
            throw new StockException("Could not create the search request url");
        }
    }
}

