/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.stock.apis;

import com.adobe.stock.apis.ModelsUtil;
import com.adobe.stock.apis.SearchFilesAPIHelpers;
import com.adobe.stock.config.StockConfig;
import com.adobe.stock.enums.ResultColumn;
import com.adobe.stock.exception.StockException;
import com.adobe.stock.models.SearchFilesRequest;
import com.adobe.stock.models.SearchFilesResponse;
import java.util.Arrays;
import java.util.List;

public final class SearchFiles {
    public static final int SEARCH_FILES_RETURN_ERROR = -1;
    private static final int DEFAULT_SEARCH_FILES_LIMIT = 32;
    private StockConfig mConfig;
    private String mAccessToken;
    private SearchFilesRequest mRequest;
    private boolean mNBResultsPresent = true;
    private SearchFilesRequest mLastRequest;
    private boolean mApiInProgress;
    private SearchFilesResponse mResponse;
    private boolean mInitialInvalidState = true;

    public SearchFiles(StockConfig config, String accessToken, SearchFilesRequest request) throws StockException {
        if (config == null) {
            throw new StockException("config can't be null");
        }
        this.mConfig = new StockConfig().setApiKey(config.getApiKey()).setProduct(config.getProduct()).setTargetEnvironment(config.getTargetEnvironment()).setProductLocation(config.getProductLocation());
        if (request == null) {
            throw new StockException("request can't be null");
        }
        SearchFilesAPIHelpers.validateSearchFileQueryParams(request, accessToken);
        if (request.getResultColumns() == null) {
            this.mNBResultsPresent = true;
        } else {
            List<ResultColumn> list = Arrays.asList(request.getResultColumns());
            this.mNBResultsPresent = list.contains((Object)ResultColumn.NB_RESULTS);
        }
        this.mRequest = !this.mNBResultsPresent ? SearchFilesAPIHelpers.addResultColumnNBResults(request) : (SearchFilesRequest)ModelsUtil.deepClone(request);
        this.mAccessToken = accessToken;
        this.mApiInProgress = false;
        if (this.mRequest.getSearchParams().getLimit() == null) {
            this.mRequest.getSearchParams().setLimit(32);
        }
        if (this.mRequest.getSearchParams().getOffset() == null) {
            this.mRequest.getSearchParams().setOffset(0);
        }
    }

    private void storeSearchRequestState() {
        this.mLastRequest = this.mRequest;
    }

    private void revertToLastSearchRequestState() {
        if (this.mLastRequest != null) {
            this.mRequest = this.mLastRequest;
        }
        this.mLastRequest = null;
    }

    private void doOnSuccess(SearchFilesResponse response) {
        this.mResponse = response;
        this.mApiInProgress = false;
        if (this.mInitialInvalidState) {
            this.mInitialInvalidState = false;
        }
    }

    private void doOnError() {
        this.revertToLastSearchRequestState();
        this.mApiInProgress = false;
    }

    private SearchFilesResponse doApiCall(SearchFilesRequest request) throws StockException {
        if (this.mApiInProgress) {
            throw new StockException("Some other search is already in progress!");
        }
        try {
            this.mApiInProgress = true;
            this.storeSearchRequestState();
            this.mRequest = request;
            SearchFilesResponse response = SearchFilesAPIHelpers.searchFiles(this.mConfig, this.mAccessToken, request);
            this.doOnSuccess(response);
        }
        catch (StockException e) {
            this.doOnError();
            throw e;
        }
        return this.getLastResponse();
    }

    public int totalSearchFiles() {
        if (!this.mInitialInvalidState && this.mResponse.getNbResults() != null) {
            return this.mResponse.getNbResults();
        }
        return -1;
    }

    public int totalSearchPages() {
        if (!this.mInitialInvalidState && this.mResponse.getNbResults() != null) {
            return (int)Math.ceil((double)this.mResponse.getNbResults().intValue() / (double)this.mRequest.getSearchParams().getLimit().intValue());
        }
        return -1;
    }

    public int currentSearchPageIndex() {
        if (!this.mInitialInvalidState && this.mResponse.getNbResults() != null) {
            int offset = this.mRequest.getSearchParams().getOffset();
            return (int)Math.ceil((double)offset / (double)this.mRequest.getSearchParams().getLimit().intValue());
        }
        return -1;
    }

    public SearchFilesResponse getLastResponse() {
        SearchFilesResponse userResponse = null;
        if (!this.mInitialInvalidState) {
            userResponse = (SearchFilesResponse)ModelsUtil.deepClone(this.mResponse);
            if (!this.mNBResultsPresent) {
                userResponse.setNbResults(null);
            }
        }
        return userResponse;
    }

    public SearchFilesResponse getNextResponse() throws StockException {
        SearchFilesRequest request = (SearchFilesRequest)ModelsUtil.deepClone(this.mRequest);
        if (!this.mInitialInvalidState) {
            int limit = request.getSearchParams().getLimit();
            int offset = request.getSearchParams().getOffset();
            request.getSearchParams().setOffset(offset + limit);
            if (this.mResponse.getNbResults() == null || request.getSearchParams().getOffset() >= this.mResponse.getNbResults()) {
                throw new StockException("No more search results available!");
            }
        }
        return this.doApiCall(request);
    }

    public SearchFilesResponse getPreviousResponse() throws StockException {
        try {
            SearchFilesRequest request = (SearchFilesRequest)ModelsUtil.deepClone(this.mRequest);
            int offset = request.getSearchParams().getOffset();
            request.getSearchParams().setOffset(offset - request.getSearchParams().getLimit());
            return this.doApiCall(request);
        }
        catch (IllegalArgumentException e) {
            throw new StockException("No more search results available!");
        }
        catch (StockException e) {
            throw e;
        }
    }

    public SearchFilesResponse getResponsePage(int pageIndex) throws StockException {
        SearchFilesRequest request = (SearchFilesRequest)ModelsUtil.deepClone(this.mRequest);
        int totalPages = this.totalSearchPages();
        if (pageIndex < 0 || totalPages != -1 && pageIndex >= totalPages) {
            throw new StockException("Page index out of bounds");
        }
        request.getSearchParams().setOffset(pageIndex * request.getSearchParams().getLimit());
        return this.doApiCall(request);
    }

    public void setAccessToken(String accessToken) throws StockException {
        SearchFilesAPIHelpers.validateSearchFileQueryParams(this.mRequest, accessToken);
        this.mAccessToken = accessToken;
    }
}

