/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.stock.apis;

import com.adobe.stock.annotations.SearchParamURLMapperInternal;
import com.adobe.stock.apis.ApiUtils;
import com.adobe.stock.apis.DownSampleUtil;
import com.adobe.stock.apis.HttpUtils;
import com.adobe.stock.apis.JsonUtils;
import com.adobe.stock.apis.ModelsUtil;
import com.adobe.stock.config.StockConfig;
import com.adobe.stock.enums.ResultColumn;
import com.adobe.stock.exception.StockException;
import com.adobe.stock.models.SearchFilesRequest;
import com.adobe.stock.models.SearchFilesResponse;
import com.adobe.stock.models.SearchParameters;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;

final class SearchFilesAPIHelpers {
    private static final String LOCALE = "locale";
    private static final String RESULT_COLUMNS = "result_columns[]";
    private static final String SEARCH_PARAMS_PREFIX = "search_parameters";

    private SearchFilesAPIHelpers() {
    }

    static SearchFilesRequest addResultColumnNBResults(SearchFilesRequest request) {
        SearchFilesRequest lReq = (SearchFilesRequest)ModelsUtil.deepClone(request);
        if (lReq.getResultColumns() != null) {
            ArrayList<ResultColumn> list = new ArrayList<ResultColumn>(Arrays.asList(lReq.getResultColumns()));
            list.add(ResultColumn.NB_RESULTS);
            lReq.setResultColumns(list.toArray(new ResultColumn[0]));
        }
        return lReq;
    }

    static void validateSearchFileQueryParams(SearchFilesRequest request, String accessToken) throws StockException {
        if (request.getSearchParams() == null) {
            throw new StockException("Search parameter must be present in the request object");
        }
        if (request.getResultColumns() != null && Arrays.asList(request.getResultColumns()).contains((Object)ResultColumn.IS_LICENSED) && accessToken == null) {
            throw new StockException("Access Token missing! Result Column 'is_licensed' requires authentication.");
        }
        if (request.getSearchParams().getSimilarImage() != null && request.getSearchParams().getSimilarImage().booleanValue() && request.getSimilarImage() == null) {
            throw new StockException("Image Data missing! Search parameter similar_image requires similar_image in query parameters");
        }
    }

    static String createSearchFilesApiUrl(String endpoint, SearchFilesRequest request) throws StockException {
        try {
            new URI(endpoint).toURL();
            URIBuilder uriBuilder = new URIBuilder(endpoint);
            if (!request.getLocale().isEmpty()) {
                uriBuilder.setParameter(LOCALE, request.getLocale());
            }
            SearchParameters searchParams = request.getSearchParams();
            for (Field field : searchParams.getClass().getDeclaredFields()) {
                SearchParamURLMapperInternal paramAnnotation;
                field.setAccessible(true);
                if (field.get(searchParams) == null || (paramAnnotation = field.getAnnotation(SearchParamURLMapperInternal.class)) == null) continue;
                String paramName = SEARCH_PARAMS_PREFIX + paramAnnotation.value();
                if (field.getType().isArray()) {
                    Object arrayObj = field.get(searchParams);
                    int length = Array.getLength(arrayObj);
                    for (int i = 0; i < length; ++i) {
                        uriBuilder.setParameter(paramName, Array.get(arrayObj, i).toString());
                    }
                    continue;
                }
                if (paramAnnotation.type().equals("boolean_integer")) {
                    Boolean bool = (Boolean)field.get(searchParams);
                    if (bool.booleanValue()) {
                        uriBuilder.setParameter(paramName, "1");
                        continue;
                    }
                    uriBuilder.setParameter(paramName, "0");
                    continue;
                }
                uriBuilder.setParameter(paramName, field.get(searchParams).toString());
            }
            ResultColumn[] resultColumns = request.getResultColumns();
            if (resultColumns != null) {
                for (int i = 0; i < Array.getLength(resultColumns); ++i) {
                    uriBuilder.addParameter(RESULT_COLUMNS, resultColumns[i].toString());
                }
            }
            String url = uriBuilder.toString();
            return url;
        }
        catch (IllegalAccessException | IllegalArgumentException | NullPointerException | MalformedURLException | URISyntaxException e) {
            throw new StockException("Could not create the search request url");
        }
    }

    static String getSearchFilesApiHttpMethod(SearchFilesRequest request) {
        String method = "GET";
        if (request.getSearchParams().getSimilarImage() != null && request.getSearchParams().getSimilarImage().booleanValue()) {
            method = "POST";
        }
        return method;
    }

    static SearchFilesResponse searchFiles(StockConfig config, String accessToken, SearchFilesRequest request) throws StockException {
        try {
            String httpMethod = SearchFilesAPIHelpers.getSearchFilesApiHttpMethod(request);
            String requestURL = SearchFilesAPIHelpers.createSearchFilesApiUrl(config.getEndpoints().getSearchFilesEndpoint(), request);
            Map<String, String> headers = ApiUtils.generateCommonAPIHeaders(config, accessToken);
            String responseString = null;
            if (httpMethod == "GET") {
                responseString = HttpUtils.doGet(requestURL, headers);
            } else {
                byte[] downSapmledImage = DownSampleUtil.downSampleImageUtil(request.getSimilarImage());
                responseString = HttpUtils.doMultiPart(requestURL, downSapmledImage, headers);
            }
            SearchFilesResponse searchResponse = (SearchFilesResponse)JsonUtils.parseJson(SearchFilesResponse.class, responseString);
            return searchResponse;
        }
        catch (StockException e) {
            throw e;
        }
        catch (IOException ex) {
            throw new StockException(-1, ex.getMessage());
        }
    }
}

