/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.stock.config;

import com.adobe.stock.config.Endpoints;
import com.adobe.stock.enums.Environment;
import com.adobe.stock.exception.StockException;

public final class StockConfig {
    private Environment mTargetEnvironment = Environment.STAGE;
    private Endpoints mEndpoints = new Endpoints(this.mTargetEnvironment);
    private String mApiKey;
    private String mProduct;
    private String mProductLocation;

    public boolean isConfigInitialized() {
        return this.mApiKey != null && this.mProduct != null;
    }

    public Environment getTargetEnvironment() {
        return this.mTargetEnvironment;
    }

    public StockConfig setTargetEnvironment(Environment targetEnvironment) throws StockException {
        if (targetEnvironment != null && targetEnvironment != this.mTargetEnvironment) {
            this.mTargetEnvironment = targetEnvironment;
            this.mEndpoints = new Endpoints(this.mTargetEnvironment);
        }
        return this;
    }

    public Endpoints getEndpoints() {
        return this.mEndpoints;
    }

    public String getApiKey() {
        return this.mApiKey;
    }

    public StockConfig setApiKey(String apiKey) throws StockException {
        if (apiKey == null) {
            throw new StockException("Api Key configuration can't be null!");
        }
        this.mApiKey = apiKey;
        return this;
    }

    public String getProduct() {
        return this.mProduct;
    }

    public StockConfig setProduct(String product) throws StockException {
        if (product == null) {
            throw new StockException("Product configuration can't be null!");
        }
        this.mProduct = product;
        return this;
    }

    public String getProductLocation() {
        return this.mProductLocation;
    }

    public StockConfig setProductLocation(String productLocation) {
        this.mProductLocation = productLocation;
        return this;
    }
}

