/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.stock.models;

import com.adobe.stock.annotations.SearchParamURLMapperInternal;
import com.adobe.stock.enums.AssetLicenseState;
import com.adobe.stock.enums.AssetPurchaseState;
import com.adobe.stock.models.LicenseReference;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;

public final class LicenseRequest {
    @SearchParamURLMapperInternal(value="content_id")
    private Integer mContentId;
    @SearchParamURLMapperInternal(value="license")
    private AssetLicenseState mLicenseState;
    @SearchParamURLMapperInternal(value="locale")
    private String mLocale;
    @SearchParamURLMapperInternal(value="state")
    private AssetPurchaseState mPurchaseState;
    @SearchParamURLMapperInternal(value="format")
    private String mFormat;
    @SearchParamURLMapperInternal(value="license_again")
    private Boolean mLicenseAgain;
    private LicenseReference[] mLicenseReference;

    @JsonIgnore
    public Integer getContentId() {
        return this.mContentId;
    }

    public LicenseRequest setContentId(int contentId) {
        if (contentId < 0) {
            throw new IllegalArgumentException("Should be a valid Content ID");
        }
        this.mContentId = contentId;
        return this;
    }

    @JsonIgnore
    public AssetLicenseState getLicenseState() {
        return this.mLicenseState;
    }

    public LicenseRequest setLicenseState(AssetLicenseState licenseState) {
        if (licenseState == null) {
            throw new IllegalArgumentException("License State cannot be null");
        }
        this.mLicenseState = licenseState;
        return this;
    }

    @JsonIgnore
    public String getLocale() {
        return this.mLocale;
    }

    public LicenseRequest setLocale(String locale) {
        if (locale == null || locale.trim().isEmpty()) {
            throw new IllegalArgumentException("Locale cannot be null or empty");
        }
        this.mLocale = locale;
        return this;
    }

    @JsonIgnore
    public AssetPurchaseState getPurchaseState() {
        return this.mPurchaseState;
    }

    public LicenseRequest setPurchaseState(AssetPurchaseState state) {
        if (state == null) {
            throw new IllegalArgumentException("Purchase state cannot be null");
        }
        this.mPurchaseState = state;
        return this;
    }

    @JsonIgnore
    public boolean getFormat() {
        return this.mFormat.equals("message_ccx");
    }

    public LicenseRequest setFormat(Boolean isSetformat) {
        if (isSetformat == null) {
            throw new IllegalArgumentException("Format can be set to true or false only.");
        }
        this.mFormat = isSetformat != false ? "message_ccx" : null;
        return this;
    }

    @JsonIgnore
    public Boolean getLicenseAgain() {
        return this.mLicenseAgain;
    }

    public LicenseRequest setLicenseAgain(Boolean licenseAgain) {
        if (licenseAgain == null) {
            throw new IllegalArgumentException("License again can be set to true or false only.");
        }
        this.mLicenseAgain = licenseAgain != false ? Boolean.valueOf(true) : null;
        return this;
    }

    @JsonGetter(value="cce_agency")
    public LicenseReference[] getLicenseReference() {
        if (this.mLicenseReference == null) {
            return null;
        }
        return (LicenseReference[])this.mLicenseReference.clone();
    }

    public LicenseRequest setLicenseReference(LicenseReference[] licenseReference) {
        if (licenseReference == null) {
            throw new IllegalArgumentException("LicenseReference array cannot be null");
        }
        this.mLicenseReference = (LicenseReference[])licenseReference.clone();
        return this;
    }
}

