/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.stock.models;

import com.adobe.stock.annotations.SearchParamURLMapperInternal;
import com.adobe.stock.enums.Asset3DType;
import com.adobe.stock.enums.AssetAge;
import com.adobe.stock.enums.AssetHasReleases;
import com.adobe.stock.enums.AssetOrientation;
import com.adobe.stock.enums.AssetPremiumCategory;
import com.adobe.stock.enums.AssetTemplateCategory;
import com.adobe.stock.enums.AssetTemplatesType;
import com.adobe.stock.enums.AssetThumbSize;
import com.adobe.stock.enums.AssetVideoDuration;
import com.adobe.stock.enums.AssetsOrder;

public final class SearchParameters {
    private static final int MAX_LIMIT = 64;
    private static final int MIN_LIMIT = 1;
    @SearchParamURLMapperInternal(value="[creator_id]")
    private Integer mCreator;
    @SearchParamURLMapperInternal(value="[media_id]")
    private Integer mMediaId;
    @SearchParamURLMapperInternal(value="[model_id")
    private Integer mModelId;
    @SearchParamURLMapperInternal(value="[serie_id")
    private Integer mSerieId;
    @SearchParamURLMapperInternal(value="[similar]")
    private Integer mSimilar;
    @SearchParamURLMapperInternal(value="[category]")
    private Integer mCategory;
    @SearchParamURLMapperInternal(value="[limit]")
    private Integer mLimit;
    @SearchParamURLMapperInternal(value="[offset]")
    private Integer mOffset;
    @SearchParamURLMapperInternal(value="[words]")
    private String mWords;
    @SearchParamURLMapperInternal(value="[similar_url")
    private String mSimilarURL;
    @SearchParamURLMapperInternal(value="[filters][colors]")
    private String mFilterColors;
    @SearchParamURLMapperInternal(value="[gallery_id]")
    private String mGalleryId;
    @SearchParamURLMapperInternal(value="[filters][area_pixels]")
    private Long mFilterAreaPixels;
    @SearchParamURLMapperInternal(value="[similar_image]", type="boolean_integer")
    private Boolean mSimilarImage;
    @SearchParamURLMapperInternal(value="[filters][content_type:photo]", type="boolean_integer")
    private Boolean mFilterContentTypePhoto;
    @SearchParamURLMapperInternal(value="[filters][content_type:illustration]", type="boolean_integer")
    private Boolean mFilterContentTypeIllustration;
    @SearchParamURLMapperInternal(value="[filters][content_type:vector]", type="boolean_integer")
    private Boolean mFilterContentTypeVector;
    @SearchParamURLMapperInternal(value="[filters][content_type:video]", type="boolean_integer")
    private Boolean mFilterContentTypeVideo;
    @SearchParamURLMapperInternal(value="[filters][content_type:template]", type="boolean_integer")
    private Boolean mFilterContentTypeTemplate;
    @SearchParamURLMapperInternal(value="[filters][content_type:3d]", type="boolean_integer")
    private Boolean mFilterContentType3D;
    @SearchParamURLMapperInternal(value="[filters][content_type:all]", type="boolean_integer")
    private Boolean mFilterContentTypeAll;
    @SearchParamURLMapperInternal(value="[filters][editorial]", type="boolean_integer")
    private Boolean mFilterEditorial;
    @SearchParamURLMapperInternal(value="[filters][offensive:2]", type="boolean_integer")
    private Boolean mFilterOffensive2;
    @SearchParamURLMapperInternal(value="[filters][isolated:on]", type="boolean_integer")
    private Boolean mFilterIsolatedOn;
    @SearchParamURLMapperInternal(value="[filters][panoramic:on]", type="boolean_integer")
    private Boolean mFilterPanoromicOn;
    @SearchParamURLMapperInternal(value="[filters][thumbnail_size]")
    private AssetThumbSize mThumbnailSize;
    @SearchParamURLMapperInternal(value="[filters][orientation]")
    private AssetOrientation mFilterOrientation;
    @SearchParamURLMapperInternal(value="[filters][age]")
    private AssetAge mFilterAge;
    @SearchParamURLMapperInternal(value="[filters][video_duration]")
    private AssetVideoDuration mFilterVideoDuration;
    @SearchParamURLMapperInternal(value="[filters][template_type_id][]")
    private AssetTemplatesType[] mFilterTemplateTypes;
    @SearchParamURLMapperInternal(value="[filters][3d_type_id][]")
    private Asset3DType[] mFilter3DTypeIds;
    @SearchParamURLMapperInternal(value="[filters][template_category_id][]")
    private AssetTemplateCategory[] mFilterTemplateCategoryIds;
    @SearchParamURLMapperInternal(value="[order]")
    private AssetsOrder mOrder;
    @SearchParamURLMapperInternal(value="[filters][premium]")
    private AssetPremiumCategory mFilterPremium;
    @SearchParamURLMapperInternal(value="[filters][has_releases]")
    private AssetHasReleases mFilterHasReleases;

    public Integer getCreatorId() {
        return this.mCreator;
    }

    public SearchParameters setCreatorId(int creatorId) {
        if (creatorId <= 0) {
            throw new IllegalArgumentException("Should be a valid creator Id");
        }
        this.mCreator = creatorId;
        return this;
    }

    public Integer getMediaId() {
        return this.mMediaId;
    }

    public SearchParameters setMediaId(int mediaId) {
        if (mediaId <= 0) {
            throw new IllegalArgumentException("Should be a valid Media Id");
        }
        this.mMediaId = mediaId;
        return this;
    }

    public Integer getModelId() {
        return this.mModelId;
    }

    public SearchParameters setModelId(int modelId) {
        if (modelId <= 0) {
            throw new IllegalArgumentException("Should be a valid Model Id");
        }
        this.mModelId = modelId;
        return this;
    }

    public Integer getSerieId() {
        return this.mSerieId;
    }

    public SearchParameters setSerieId(int serieId) {
        if (serieId <= 0) {
            throw new IllegalArgumentException("Should be a valid Series Id");
        }
        this.mSerieId = serieId;
        return this;
    }

    public Integer getSimilar() {
        return this.mSimilar;
    }

    public SearchParameters setSimilar(int similar) {
        if (similar <= 0) {
            throw new IllegalArgumentException("Should be a valid previous mediaId");
        }
        this.mSimilar = similar;
        return this;
    }

    public Integer getCategory() {
        return this.mCategory;
    }

    public SearchParameters setCategory(int category) {
        if (category <= 0) {
            throw new IllegalArgumentException("Should be a valid category");
        }
        this.mCategory = category;
        return this;
    }

    public Integer getLimit() {
        return this.mLimit;
    }

    public SearchParameters setLimit(int limit) {
        if (limit < 1 || limit > 64) {
            throw new IllegalArgumentException("Limit should be greator than 1 and less than 64");
        }
        this.mLimit = limit;
        return this;
    }

    public Integer getOffset() {
        return this.mOffset;
    }

    public SearchParameters setOffset(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset should be between 0 and MaxResults");
        }
        this.mOffset = offset;
        return this;
    }

    public String getWords() {
        return this.mWords;
    }

    public SearchParameters setWords(String words) {
        if (words == null || words.isEmpty()) {
            throw new IllegalArgumentException("Should not be blank or null values in kewywords field");
        }
        this.mWords = words;
        return this;
    }

    public String getSimilarURL() {
        return this.mSimilarURL;
    }

    public SearchParameters setSimilarURL(String similarURL) {
        if (similarURL == null || similarURL.isEmpty()) {
            throw new IllegalArgumentException("Should not be blank or null values in similarURL field");
        }
        this.mSimilarURL = similarURL;
        return this;
    }

    public String getFilterColors() {
        return this.mFilterColors;
    }

    public SearchParameters setFilterColors(String filterColors) {
        if (filterColors == null || filterColors.isEmpty()) {
            throw new IllegalArgumentException("Should not be blank or null values in filterColors field");
        }
        this.mFilterColors = filterColors;
        return this;
    }

    public String getGalleryId() {
        return this.mGalleryId;
    }

    public SearchParameters setGalleryId(String galleryId) {
        if (galleryId == null || galleryId.isEmpty()) {
            throw new IllegalArgumentException("Should not be blank or null values in galleryId field");
        }
        this.mGalleryId = galleryId;
        return this;
    }

    public Long getFilterAreaPixels() {
        return this.mFilterAreaPixels;
    }

    public SearchParameters setFilterAreaPixels(long filterAreaPixels) {
        if (filterAreaPixels < 0L) {
            throw new IllegalArgumentException("FilterAreaPixels should be greater than zero");
        }
        this.mFilterAreaPixels = filterAreaPixels;
        return this;
    }

    public Boolean getSimilarImage() {
        return this.mSimilarImage;
    }

    public SearchParameters setSimilarImage(Boolean similarImage) {
        if (similarImage == null) {
            throw new IllegalArgumentException("SimilarImage filter should be true or false");
        }
        this.mSimilarImage = similarImage;
        return this;
    }

    public Boolean getFilterContentTypePhoto() {
        return this.mFilterContentTypePhoto;
    }

    public SearchParameters setFilterContentTypePhoto(Boolean filterContentTypePhoto) {
        if (filterContentTypePhoto == null) {
            throw new IllegalArgumentException("ContentTypePhoto filter should be true or false");
        }
        this.mFilterContentTypePhoto = filterContentTypePhoto;
        return this;
    }

    public Boolean getFilterContentTypeIllustration() {
        return this.mFilterContentTypeIllustration;
    }

    public SearchParameters setFilterContentTypeIllustration(Boolean filterContentTypeIllustration) {
        if (filterContentTypeIllustration == null) {
            throw new IllegalArgumentException("Illustration filter should be true or false");
        }
        this.mFilterContentTypeIllustration = filterContentTypeIllustration;
        return this;
    }

    public Boolean getFilterContentTypeVector() {
        return this.mFilterContentTypeVector;
    }

    public SearchParameters setFilterContentTypeVector(Boolean filterContentTypeVector) {
        if (filterContentTypeVector == null) {
            throw new IllegalArgumentException("Vector filter should be true or false");
        }
        this.mFilterContentTypeVector = filterContentTypeVector;
        return this;
    }

    public Boolean getFilterContentTypeVideo() {
        return this.mFilterContentTypeVideo;
    }

    public SearchParameters setFilterContentTypeVideo(Boolean filterContentTypeVideo) {
        if (filterContentTypeVideo == null) {
            throw new IllegalArgumentException("Video filter should be true or false");
        }
        this.mFilterContentTypeVideo = filterContentTypeVideo;
        return this;
    }

    public Boolean getFilterContentTypeTemplate() {
        return this.mFilterContentTypeTemplate;
    }

    public SearchParameters setFilterContentTypeTemplate(Boolean filterContentTypeTemplate) {
        if (filterContentTypeTemplate == null) {
            throw new IllegalArgumentException("Template filter should be true or false");
        }
        this.mFilterContentTypeTemplate = filterContentTypeTemplate;
        return this;
    }

    public Boolean getFilterContentType3D() {
        return this.mFilterContentType3D;
    }

    public SearchParameters setFilterContentType3D(Boolean filterContentType3D) {
        if (filterContentType3D == null) {
            throw new IllegalArgumentException("3D filter should be true or false");
        }
        this.mFilterContentType3D = filterContentType3D;
        return this;
    }

    public Boolean getFilterContentTypeAll() {
        return this.mFilterContentTypeAll;
    }

    public SearchParameters setFilterContentTypeAll(Boolean filterContentTypeAll) {
        if (filterContentTypeAll == null) {
            throw new IllegalArgumentException("Type All filter should be true or false");
        }
        this.mFilterContentTypeAll = filterContentTypeAll;
        return this;
    }

    public Boolean getFilterEditorial() {
        return this.mFilterEditorial;
    }

    public SearchParameters setFilterEditorial(Boolean filterEditorial) {
        if (filterEditorial == null) {
            throw new IllegalArgumentException("Editorial filter should be OFF or ON");
        }
        this.mFilterEditorial = filterEditorial;
        return this;
    }

    public Boolean getFilterOffensive2() {
        return this.mFilterOffensive2;
    }

    public SearchParameters setFilterOffensive2(Boolean filterOffensive2) {
        if (filterOffensive2 == null) {
            throw new IllegalArgumentException("Offensive2 filter should be OFF or ON");
        }
        this.mFilterOffensive2 = filterOffensive2;
        return this;
    }

    public Boolean getFilterIsolatedOn() {
        return this.mFilterIsolatedOn;
    }

    public SearchParameters setFilterIsolatedOn(Boolean filterIsolatedOn) {
        if (filterIsolatedOn == null) {
            throw new IllegalArgumentException("Isolated filter should be OFF or ON");
        }
        this.mFilterIsolatedOn = filterIsolatedOn;
        return this;
    }

    public Boolean getFilterPanoromicOn() {
        return this.mFilterPanoromicOn;
    }

    public SearchParameters setFilterPanoromicOn(Boolean filterPanoromicOn) {
        if (filterPanoromicOn == null) {
            throw new IllegalArgumentException("Panoromic filter should be OFF or ON");
        }
        this.mFilterPanoromicOn = filterPanoromicOn;
        return this;
    }

    public AssetThumbSize getThumbnailSize() {
        return this.mThumbnailSize;
    }

    public SearchParameters setThumbnailSize(AssetThumbSize thumbnailSize) {
        if (thumbnailSize == null) {
            throw new IllegalArgumentException("Thumbnail size should not be null");
        }
        this.mThumbnailSize = thumbnailSize;
        return this;
    }

    public AssetOrientation getFilterOrientation() {
        return this.mFilterOrientation;
    }

    public SearchParameters setFilterOrientation(AssetOrientation filterOrientation) {
        if (filterOrientation == null) {
            throw new IllegalArgumentException("Orientation should not be null");
        }
        this.mFilterOrientation = filterOrientation;
        return this;
    }

    public AssetAge getFilterAge() {
        return this.mFilterAge;
    }

    public SearchParameters setFilterAge(AssetAge filterAge) {
        if (filterAge == null) {
            throw new IllegalArgumentException("Age should not be null");
        }
        this.mFilterAge = filterAge;
        return this;
    }

    public AssetVideoDuration getFilterVideoDuration() {
        return this.mFilterVideoDuration;
    }

    public SearchParameters setFilterVideoDuration(AssetVideoDuration filterVideoDuration) {
        if (filterVideoDuration == null) {
            throw new IllegalArgumentException("Video duration should not be null");
        }
        this.mFilterVideoDuration = filterVideoDuration;
        return this;
    }

    public AssetTemplatesType[] getFilterTemplateTypes() {
        if (this.mFilterTemplateTypes == null) {
            return null;
        }
        return (AssetTemplatesType[])this.mFilterTemplateTypes.clone();
    }

    public SearchParameters setFilterTemplateTypes(AssetTemplatesType[] filterTemplateTypes) {
        if (filterTemplateTypes == null) {
            throw new IllegalArgumentException("Template Types should not be null");
        }
        this.mFilterTemplateTypes = filterTemplateTypes;
        return this;
    }

    public Asset3DType[] getFilter3DTypeIds() {
        if (this.mFilter3DTypeIds == null) {
            return null;
        }
        return (Asset3DType[])this.mFilter3DTypeIds.clone();
    }

    public SearchParameters setFilter3DTypeIds(Asset3DType[] filter3dTypeIds) {
        if (filter3dTypeIds == null) {
            throw new IllegalArgumentException("3D Types should not be null");
        }
        this.mFilter3DTypeIds = filter3dTypeIds;
        return this;
    }

    public AssetTemplateCategory[] getFilterTemplateCategoryIds() {
        if (this.mFilterTemplateCategoryIds == null) {
            return null;
        }
        return (AssetTemplateCategory[])this.mFilterTemplateCategoryIds.clone();
    }

    public SearchParameters setFilterTemplateCategoryIds(AssetTemplateCategory[] filterTemplateCategoryIds) {
        if (filterTemplateCategoryIds == null) {
            throw new IllegalArgumentException("TemplateCategory Ids should not be null");
        }
        this.mFilterTemplateCategoryIds = filterTemplateCategoryIds;
        return this;
    }

    public AssetsOrder getOrder() {
        return this.mOrder;
    }

    public SearchParameters setOrder(AssetsOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("Orders should not be null");
        }
        this.mOrder = order;
        return this;
    }

    public AssetPremiumCategory getFilterPremium() {
        return this.mFilterPremium;
    }

    public SearchParameters setFilterPremium(AssetPremiumCategory filterPremium) {
        if (filterPremium == null) {
            throw new IllegalArgumentException("Premium Filters should not be null");
        }
        this.mFilterPremium = filterPremium;
        return this;
    }

    public AssetHasReleases getFilterHasReleases() {
        return this.mFilterHasReleases;
    }

    public SearchParameters setFilterHasReleases(AssetHasReleases filterHasReleases) {
        if (filterHasReleases == null) {
            throw new IllegalArgumentException("Filter Releases should not be null");
        }
        this.mFilterHasReleases = filterHasReleases;
        return this;
    }
}

