/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.dom;

import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.dom.AttrImpl;
import com.adobe.xfa.dom.DocumentImpl;
import com.adobe.xfa.dom.NamedNodeMapImpl;
import com.adobe.xfa.dom.NodeImpl;
import com.adobe.xfa.dom.NodeListImpl;
import com.adobe.xfa.dom.ParentNode;
import com.adobe.xfa.dom.QNameImpl;
import com.adobe.xfa.ut.StringUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

class ElementImpl
extends ParentNode
implements org.w3c.dom.Element {
    static final String ALL_NODES = "*";
    private final QNameImpl mQName = new QNameImpl(this.getXFAElement().getNS(), this.getXFAElement().getPrefix(), this.getXFAElement().getLocalName());
    private AttrImpl mFirstAttr;
    private AttrImpl mLastAttr;
    private int mAttrCount = -1;
    private NamedNodeMapImpl mAttrMap;

    ElementImpl(ParentNode parent, Element newElement) {
        super(parent, newElement);
        DocumentImpl doc = this.getDocument();
        if (parent == doc) {
            doc.setDocumentElement(this);
        }
    }

    @Override
    public String getAttribute(String name) {
        Attr attr = this.getAttributeNode(name);
        return attr == null ? null : attr.getValue();
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
        Attr attr = this.getAttributeNodeNS(namespaceURI, localName);
        return attr == null ? null : attr.getValue();
    }

    @Override
    public Attr getAttributeNode(String name) {
        this.populateAttrMap();
        Node result = this.mAttrMap.getNamedItem(name);
        if (result == null) {
            return null;
        }
        assert (result instanceof Attr);
        return (Attr)result;
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
        this.populateAttrMap();
        Node result = this.mAttrMap.getNamedItemNS(namespaceURI, localName);
        if (result == null) {
            return null;
        }
        assert (result instanceof Attr);
        return (Attr)result;
    }

    @Override
    public NodeList getElementsByTagName(String name) {
        name = name.intern();
        NodeListImpl childList = new NodeListImpl(0);
        this.addChildrenByTagName(name, childList);
        return childList;
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) throws DOMException {
        namespaceURI = namespaceURI.intern();
        localName = localName.intern();
        NodeListImpl childList = new NodeListImpl(0);
        this.addChildrenByTagNameNS(namespaceURI, localName, childList);
        return childList;
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    @Override
    public String getTagName() {
        return this.mQName.getQName();
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.getAttributeNode(name) != null;
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
        return this.getAttributeNodeNS(namespaceURI, localName) != null;
    }

    @Override
    public void removeAttribute(String name) throws DOMException {
        throw new DOMException(7, "");
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        throw new DOMException(7, "");
    }

    @Override
    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        throw new DOMException(7, "");
    }

    @Override
    public void setAttribute(String name, String newValue) throws DOMException {
        throw new DOMException(7, "");
    }

    @Override
    public void setAttributeNS(String namespaceURI, String localName, String newValue) throws DOMException {
        throw new DOMException(7, "");
    }

    @Override
    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        throw new DOMException(7, "");
    }

    @Override
    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        throw new DOMException(7, "");
    }

    @Override
    public void setIdAttribute(String name, boolean isId) throws DOMException {
        throw new DOMException(7, "");
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        throw new DOMException(7, "");
    }

    @Override
    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        throw new DOMException(7, "");
    }

    @Override
    public NamedNodeMap getAttributes() {
        this.fillAllAttrs();
        NamedNodeMapImpl namedNodeMap = new NamedNodeMapImpl(this.getXFAElement().getNumAttrs());
        namedNodeMap.addNodes(this.mFirstAttr);
        return namedNodeMap;
    }

    @Override
    public String getLocalName() {
        return this.mQName.getLocalName();
    }

    @Override
    public String getNamespaceURI() {
        return this.mQName.getNamespace();
    }

    @Override
    public String getNodeName() {
        return this.mQName.getQName();
    }

    @Override
    public short getNodeType() {
        return 1;
    }

    @Override
    public String getPrefix() {
        return this.mQName.getPrefix();
    }

    @Override
    public String getTextContent() throws DOMException {
        NodeImpl child;
        this.fillAllChildren();
        if (child == null) {
            return null;
        }
        StringBuilder resultBuilder = new StringBuilder();
        for (child = this.getFirstChildImpl(); child != null; child = child.getNext()) {
            String childContent;
            if (child instanceof Comment || child instanceof ProcessingInstruction || (childContent = child.getTextContent()) == null) continue;
            resultBuilder.append(childContent);
        }
        return resultBuilder.toString();
    }

    @Override
    public Object getUserData(String key) {
        return null;
    }

    @Override
    public boolean hasAttributes() {
        return this.getXFAElement().getNumAttrs() > 0;
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        return this.testDefaultNamespace(namespaceURI);
    }

    @Override
    public boolean isEqualNode(Node other) {
        int otherAttrCount;
        if (this == other) {
            return true;
        }
        if (!super.isEqualNode(other)) {
            return false;
        }
        if (!(other instanceof ElementImpl)) {
            return false;
        }
        ElementImpl otherElement = (ElementImpl)other;
        NamedNodeMap thisAttrs = this.getAttributes();
        NamedNodeMap otherAttrs = otherElement.getAttributes();
        int thisAttrCount = thisAttrs.getLength();
        if (thisAttrCount != (otherAttrCount = otherAttrs.getLength())) {
            return false;
        }
        for (int i = 0; i < thisAttrCount; ++i) {
            Node thisAttr = thisAttrs.item(i);
            Node otherAttr = null;
            String thisNS = thisAttr.getNamespaceURI();
            otherAttr = StringUtils.isEmpty(thisNS) ? otherAttrs.getNamedItem(thisAttr.getNodeName()) : otherAttrs.getNamedItemNS(thisNS, thisAttr.getLocalName());
            if (otherAttr == null) {
                return false;
            }
            if (thisAttr.isEqualNode(otherAttr)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        String result = this.doLookupNamespaceURI(prefix);
        return result;
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        String result = this.doLookupPrefix(namespaceURI, this);
        return result;
    }

    @Override
    public void normalize() {
    }

    @Override
    public void setNodeValue(String newValue) throws DOMException {
        throw new DOMException(7, "");
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        throw new DOMException(7, "");
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        throw new DOMException(7, "");
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return null;
    }

    String doLookupNamespaceURI(String prefix) {
        String result = null;
        if (prefix != null && (prefix = prefix.intern()) == this.mQName.getPrefix()) {
            result = this.mQName.getNamespace();
        }
        if (result == null) {
            ParentNode parent;
            this.fillAllAttrs();
            for (NodeImpl attrNode = this.mFirstAttr; attrNode != null; attrNode = attrNode.getNext()) {
                assert (attrNode instanceof AttrImpl);
                AttrImpl attr = attrNode;
                if ((!attr.isNamespaceAttr(2) || attr.getLocalName() != prefix) && (prefix != null || !attr.isNamespaceAttr(1))) continue;
                String value = ((NodeImpl)attrNode).getNodeValue();
                result = StringUtils.isEmpty(value) ? null : value;
                break;
            }
            if (result == null && (parent = this.getParent()) instanceof ElementImpl) {
                result = ((ElementImpl)parent).doLookupNamespaceURI(prefix);
            }
        }
        return result;
    }

    String doLookupPrefix(String namespaceURI, ElementImpl originalElement) {
        namespaceURI = namespaceURI.intern();
        String thisNS = this.mQName.getNamespace();
        String thisPrefix = this.mQName.getPrefix();
        if (!StringUtils.isEmpty(thisNS) && thisNS == namespaceURI && namespaceURI == originalElement.lookupNamespaceURI(thisPrefix)) {
            return thisPrefix;
        }
        this.fillAllAttrs();
        for (NodeImpl attrNode = this.mFirstAttr; attrNode != null; attrNode = attrNode.getNext()) {
            assert (attrNode instanceof AttrImpl);
            AttrImpl attr = attrNode;
            String attrLocalName = attr.getLocalName();
            if (!attr.isPopulated() || attr.getPrefix() != "xmlns" || !attr.getNodeValue().equals(namespaceURI) || this.lookupNamespaceURI(attrLocalName) != namespaceURI) continue;
            return attrLocalName;
        }
        ParentNode parent = this.getParent();
        if (parent instanceof ElementImpl) {
            return ((ElementImpl)parent).doLookupPrefix(namespaceURI, originalElement);
        }
        return null;
    }

    Iterator<AttrImpl> getNamespacesInScopeIterator() {
        return new NamespaceIterator(this);
    }

    @Override
    boolean testDefaultNamespace(String namespaceURI) {
        if (StringUtils.isEmpty(this.mQName.getPrefix())) {
            return namespaceURI == this.mQName.getNamespace();
        }
        this.fillAllAttrs();
        for (NodeImpl attrNode = this.mFirstAttr; attrNode != null; attrNode = attrNode.getNext()) {
            assert (attrNode instanceof AttrImpl);
            AttrImpl attr = attrNode;
            if (!attr.isNamespaceAttr(1)) continue;
            return namespaceURI.equals(((NodeImpl)attrNode).getNodeValue());
        }
        ParentNode parent = this.getParent();
        if (parent != null) {
            return parent.testDefaultNamespace(namespaceURI);
        }
        return false;
    }

    private final void fillAllAttrs() {
        if (this.mAttrCount >= 0) {
            return;
        }
        this.mAttrCount = this.getXFAElement().getNumAttrs();
        for (int i = 0; i < this.mAttrCount; ++i) {
            Attribute xfaAttr = this.getXFAElement().getAttr(i);
            AttrImpl newAttr = new AttrImpl(this, xfaAttr);
            if (newAttr.isNamespaceAttr(3)) {
                newAttr.populate();
            }
            newAttr.setPrev(this.mLastAttr);
            if (this.mFirstAttr == null) {
                this.mFirstAttr = newAttr;
            } else {
                this.mLastAttr.setNext(newAttr);
            }
            this.mLastAttr = newAttr;
        }
    }

    private void addChildrenByTagName(String name, NodeListImpl nodeList) {
        if (name == ALL_NODES || name == this.mQName.getQName()) {
            nodeList.addNode(this);
        }
        this.fillAllChildren();
        for (NodeImpl child = this.getFirstChildImpl(); child != null; child = child.getNext()) {
            if (!(child instanceof ElementImpl)) continue;
            ElementImpl childElement = (ElementImpl)child;
            childElement.addChildrenByTagName(name, nodeList);
        }
    }

    private void addChildrenByTagNameNS(String namespaceURI, String localName, NodeListImpl nodeList) {
        if (!(namespaceURI != ALL_NODES && this.mQName.getNamespace() != namespaceURI || localName != ALL_NODES && this.mQName.getLocalName() != localName)) {
            nodeList.addNode(this);
        }
        this.fillAllChildren();
        for (NodeImpl child = this.getFirstChildImpl(); child != null; child = child.getNext()) {
            if (!(child instanceof ElementImpl)) continue;
            ElementImpl childElement = (ElementImpl)child;
            childElement.addChildrenByTagNameNS(namespaceURI, localName, nodeList);
        }
    }

    private void populateAttrMap() {
        if (this.mAttrMap != null) {
            return;
        }
        this.mAttrMap = new NamedNodeMapImpl(this.getXFAElement().getNumAttrs());
        this.fillAllAttrs();
        for (NodeImpl attr = this.mFirstAttr; attr != null; attr = attr.getNext()) {
            this.mAttrMap.addNode(attr);
        }
    }

    private static class NamespaceIterator
    implements Iterator<AttrImpl> {
        private ElementImpl mElement;
        private AttrImpl mAttr;

        public NamespaceIterator(ElementImpl element) {
            this.mElement = element;
            this.mElement.fillAllAttrs();
            this.mAttr = this.scanToNextNamespaceAttributeInScope(this.mElement.mFirstAttr);
        }

        @Override
        public boolean hasNext() {
            return this.mAttr != null;
        }

        @Override
        public AttrImpl next() {
            if (this.mAttr == null) {
                throw new NoSuchElementException();
            }
            AttrImpl result = this.mAttr;
            this.mAttr = this.scanToNextNamespaceAttributeInScope(this.mAttr.getNext());
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private AttrImpl scanToNextNamespaceAttributeInScope(NodeImpl currentChild) {
            while (true) {
                for (NodeImpl attrNode = currentChild; attrNode != null; attrNode = attrNode.getNext()) {
                    AttrImpl attr;
                    if (!(attrNode instanceof AttrImpl) || !(attr = (AttrImpl)attrNode).isNamespaceAttr(3)) continue;
                    return attr;
                }
                ParentNode parent = this.mElement.getParent();
                if (!(parent instanceof ElementImpl)) break;
                this.mElement = (ElementImpl)parent;
                this.mElement.fillAllAttrs();
                currentChild = this.mElement.mFirstAttr;
            }
            return null;
        }
    }
}

